/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%W% %E%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  LOGEVENT.C
 *
 * DESCRIPTIVE NAME =  IBM2ADSK.ADD - Adapter Driver for ABIOS DASD Devices
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : ABIOS Debug Log Handler
 *
 *
*/#include <os2.h>
#include <devcmd.h>

#define INCL_INITRP_ONLY
#include <reqpkt.h>

#include <scb.h>
#include <abios.h>

#include <iorb.h>
#include <addcalls.h>

#include <dhcalls.h>

#include <adskcons.h>
#include <adsktype.h>
#include <adskpro.h>
#include <adskextn.h>
#include <log.h>

#if defined (LOGGING)

/*
 *  LogEvent - Logs events into the log buffer
 *
 * Entry:
 *
 *    cLogID    = ID number so we know what log entry this is
 *    cLidIndex = LID we're currently working with
 *    nLine     = line number where LogEvent(...) is found in the file
 *    nIntFlags = Current settings of IntFlags
 *    cLidCount = Count of operations pending on this LID
 *    cIntCount = Interrupting stages counter
 *    nParm1    = 1rd parameter from logger
 *    nParm2    = 2th parameter from logger
 *    nParm3    = 3th parameter from logger
 *    nParm4    = 4th parameter from logger
 *
 * At any time, you can use the debugger to dump _aloghistory to get the
 * 16-byte log entries.  _plogcurrent points to the head/tail of the log,
 * and an entry of FF's makes this easy to see.  Pass the output of the log
 * through XLATELOG.CMD, and it'll be almost human-readable.
 */
#define PLOGNEXT(p) ((p) >= &alogHistory[MAXLOGBUF-1] ? &alogHistory[0] : (p) + 1)

void
LogEvent( UCHAR  cLogID,
          UCHAR  cLidIndex,
          USHORT nLine,
          USHORT nIntFlags,
          UCHAR  cLidCount,
          UCHAR  cIntCount,
          USHORT nParm1,
          USHORT nParm2,
          USHORT nParm3,
          USHORT nParm4 )
{
    NPUSHORT plogTmp;
    USHORT nTmp;

    /* bump log ptr */
    _asm
    {
       pushf
       pop nTmp
       cli
    }
    plogCurrent = PLOGNEXT (plogCurrent);
    _asm
    {
       push nTmp
       popf
    }

    /*
     * set log info
     */

    plogCurrent->cLogID    = cLogID;
    plogCurrent->cLidIndex = cLidIndex;
    plogCurrent->nLine     = nLine;
    plogCurrent->nIntFlags = nIntFlags;
    plogCurrent->cLidCount = cLidCount;
    plogCurrent->cIntCount = cIntCount;
    plogCurrent->nParm1    = nParm1;
    plogCurrent->nParm2    = nParm2;
    plogCurrent->nParm3    = nParm3;
    plogCurrent->nParm4    = nParm4;

    _asm
    {
       pushf
       pop nTmp
       cli
    }
    (PLOG)plogTmp = PLOGNEXT (plogCurrent);
    _asm
    {
       push nTmp
       popf
    }
    for (nTmp = 0;nTmp < sizeof(LOG)/2;nTmp++,plogTmp++)
    {
       *plogTmp = 0xFFFF;
    }
/*    plogTmp->cLogID    = 0xFF;
    plogTmp->cLidIndex = 0xFF;
    plogTmp->nLine     = 0xFFFF;
    plogTmp->nIntFlags = 0xFFFF;
    plogTmp->cLidCount = 0xFF;
    plogTmp->cIntCount = 0xFF;
    plogTmp->nParm1    = 0xFFFF;
    plogTmp->nParm2    = 0xFFFF;
    plogTmp->nParm3    = 0xFFFF;
    plogTmp->nParm4    = 0xFFFF; */
}

#endif
