/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = src/dev/dasd/cdrom/ibm1s506/s506type.h, idskflt, c.basedd 99/01/18 */
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506TYPE.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Locally defined structures for this driver.
 *
 * Purpose:
 *
 *
*//*
 * Edit History for defect # 148406:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 5-15-95   Added changes from WDCIDEOS.ADD 1.01 changes made by Shishir
 *                 Shah. In this file this consisted of the DMA port values in
 *                 the controller and unit tables. Also added several bit defs
 *                 to support DMA. /jlh
 *
 * [002] 06-06-95  Add support for Bus Master IDE DMA. /jlh
 *      1) Add types for S506PCI.C functions to access PCI config. space.
 *      2) Add support for PCI Bus Master DMA (SFF-8038i)
 *
 * [003] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 *
 * [004] 10-03-95  Add passthru command and redefine ACBR_DMAIO. /jlh
 *
 * [005] 11-05-95  Add in DeviceCounters to store counters. /jlh
 *
 * [006] 11-29-95  Add define for PIIX3 slave timing register enable bit. /mol
 *                 Add BM_BaseAddress field in ATBL structure.  This field
 *                 is used to store PIIX bus master register base address.
 *
 * [007] 11-29-95 Added define for ACB flag to used to force PIO on next retry./mol
 *
 * [008] 01-19-96  Added switch to allow Bus Master DMA for ATAPI CD-ROM
 *                 devices. By default these devices do not perform DMA
 *                 even when they report they are capable of it. /jlh
 *
 * [009] 03-06-96  Add defines required for Micro House EzDrive support. /jlh
 *
*/
#include "rmcalls.h"                                                /*@V98451*/
#include "s506oem.h"                                                /*@V129765*/
#include "s506regs.h"                                               /*@V154814*/
#include "ata.h"                                        /*@V151345*//*@V129765*/

typedef struct _ACB  NEAR *NPACB, FAR *PACB;
typedef struct _UCB  NEAR *NPUCB;
typedef struct _ATBL NEAR *NPATBL;
typedef struct _UTBL NEAR *NPUTBL;
                                                                    /*AAAAAAAA*/

/* Begin [002.2] Physical Region Descriptor for SFF-8038i Bus Master DMA controllers */

/*----------------------------------*/
/* Physical Region Descriptor       */
/* --------------------------       */
/*                                  */
/* One per physical memory region.  */
/*                                  */
/*----------------------------------*/

typedef struct _PRD
{
  ULONG     MR_PhysicalBaseAddress;           /* memory region's physical base address */
  ULONG     ByteCountAndEOT;                  /* byte count and End of Table flag */
} PRD;

#define PRD_EOT_FLAG    0x80000000L           /* End of table indicator */

typedef struct _PRD  NEAR *NPPRD, FAR *PPRD;  /* typedef for pointers to PRD */

/* End [002.2] */

#ifdef BBR
#define MAX_BBR_SEQUENCES   10

// Structure to contain a     Block Sequence.
typedef struct _BBR_SEQUENCE
{
   ULONG           startBlock;   // first RBA of sequence to be reported bad
   USHORT          blockCount;   // number of blocks to report as bad
} BBR_SEQUENCE;
#endif

/*-------------------------------*/
/* Unit Control Block            */
/* ------------------            */
/*                               */
/* One per drive on controller.  */
/*                               */
/*-------------------------------*/

typedef struct _UCB
{
  /*-----------------------------------*/
  /* Associated Control Block Pointers */
  /*-----------------------------------*/
  NPACB            npACB;                                                            // 0x00
  ULONG            Flags;                                           /*@V149971*/     // 0x02
  USHORT           ReqFlags;                                                         // 0x06

  /*--------------------*/
  /* Unit Number (0/1)  */
  /*--------------------*/
  USHORT           UnitId;                                                           // 0x08
  USHORT           DiagStatus;                                                       // 0x0a

  /*------------------------------------------*/
  /* Physical/Logical Geometry for this drive */
  /*------------------------------------------*/
  GEOMETRY         LogGeom;                                                          // 0x0c
  GEOMETRY         PhysGeom;                                                         // 0x1c

  USHORT           WrtPreCmp;                                                        // 0x2c
  USHORT           SecPerBlk;                                                        // 0x2e

/* Begin [001] */

  /*------------------------------------------*/
  /*  Drive DMA Type Either B OR F            */
  /*------------------------------------------*/
  USHORT                                 DMAType;                                    // 0x30

/* End [001] */

  /* Begin [002.2] */

  /*------------------------*/
  /* DMA/PIO Timing Values  */
  /*------------------------*/
  UCHAR         CurDMAMode;                     /* Current DMA mode (0,1,2) */       // 0x32
  UCHAR         CurPIOMode;                     /* Current PIO mode (0,2,3,4) */     // 0x33
  UCHAR         InterfaceTiming;                /* interface timing mode (0,2,3,4) */// 0x34

  USHORT        UltraDMAMode;                   /* Ultra DMA Mode (Max Mode)  */     // 0x35
  USHORT        DMAMWordFlags;                  /* Bit 0=Mode 0 MW DMA        */     // 0x37
                                                /* Bit 1=Mode 1 MW DMA, etc.  */
  USHORT        AdvancedPIOModes;               /* Bit 0=Mode 3 PIO */               // 0x39
                                                /* Bit 1=Mode 4 PIO, */
  /* End [002.2] */
                                                                    /*@V151345*/
                                                                    /*@VVVVVVV*/
  /* Drive media status capabilities SRD */
  UCHAR         DriveCapability;                                                     // 0x3b
    #define FX_Media_Status_Enabled_Prev       0x01
    #define FX_MediaLockable                   0x02
    #define FX_PowerEjectable                  0x04
  /* current media status SRD */
  UCHAR         MediaStatus;                                                         // 0x3c
    #define FX_No_MediaPresent                 0x02
    #define FX_EjectPressed                    0x08
    #define FX_Mediachanged                    0x20
    #define FX_WriteProtect                    0x40
    #define FX_ReadProtect                     0x80                 /*@AAAAAAA*/
                                                                    /*@V151345*/

#ifdef ENABLE_COUNTERS                                              /* [005] */
 DeviceCountersData      DeviceCounters;                            /* [005] */      // 0x3d
#endif                                                              /* [005] */

  /*------------------------------------------*/
  /* Replacement UNITINFO from Filter ADD     */
  /*------------------------------------------*/
  PUNITINFO        pUnitInfo;                                                        // 0x7b

  HDEVICE       hDevice;                                            /*@V98451*/      // 0x8d
#ifdef BBR
  USHORT        BBRFlags;                                                            // 0x91
  USHORT        nBBRSequences;                                                       // 0x93
  BBR_SEQUENCE  BBRSequence[MAX_BBR_SEQUENCES];                                      // 0x95
#define BBRF_INT3           0x0001   // generate an INT3 when a fake BB is detected
#endif

} UCB;                                                                  // total size = 0xd1
                                                                    /*@V151345*/
/* Flags definitions */   /* Changed all Flag defs to ULONGs. */    /*@V149971*/
#define UCBF_ALLOCATED      0x00000001
#define UCBF_READY          0x00000002
#define UCBF_DIAG_FAILED    0x00000004
#define UCBF_SMSENABLED     0x00000008
#define UCBF_MULTIPLEMODE   0x00000010
#define UCBF_LBAMODE        0x00000020
#define UCBF_IDENTIFYFAIL   0x00000040
#define UCBF_NODASDSUPPORT  0x00000080
#define UCBF_ATAPIDEVICE    0x00000100                              /*@V87325*/
#define UCBF_ONTRACK        0x00000200                              /*@V108555*/
#define UCBF_DMAMODE        0x00000400  /* [001] DMA Enabled if 1 */
#define UCBF_DMASGMODE      0x00000800  /* [001] DMA Scatter/Gather if 1 */
#define UCBF_BM_DMA         0x00001000  /* [002.2] Bus Master DMA if 1 */
#define UCBF_EZDRIVEFBP     0x00002000  /* [009] Unit has floppy boot protection enabled */
                                                                    /*@AAAAAAA*/
                                                                    /*@V151345*/
#define UCBF_DISABLERESET   0x00004000  /* DISABLERETRY save */     /*@V185215*/
#define UCBF_MEDIASTATUS    0x00010000  /* SRD support for removable IDE disk */
#define UCBF_REMOVABLE      0x00020000  /* SRD support for removable IDE disk */

/* For docking support */                                           /*@V149971*/
#define UCBF_NOTPRESENT     0x00040000                              /*@V149971*/
#define UCBF_CONFIGCHANGE   0x00080000                              /*@V149971*/
#define UCBF_LOCKED         0x00100000                              /*@V149971*/
#define UCBF_CHANGED        0x00200000                              /*@V149971*/
#define UCBF_FORCE          0x00400000                              /*@V149971*/
#define UCBF_MEDIA_CHANGED  0x00800000                              /*@V157085*/

/* ReqFlags definitions */
#define UCBR_RECAL          0x8000
#define UCBR_SETPARAM       0x4000

/*----------------------------------------------------------*/      /*@V147576*/
/*                                                          */      /*@VVVVVVV*/
/* HWRESOURCE - List of ACBs sharing a hardware resources,  */
/*              one active per independent IDE Adapter.     */
/*                                                          */
/*----------------------------------------------------------*/

typedef struct _HWRESOURCE
{
  USHORT        Flags;
  /* The current owner of HW resources, 0=> no current owner           */
  NPACB         npOwnerACB;
  /* Head and tail of the ACB queue waiting to use this HWResource.    */
  /* These fields are manipulated only by Allocate and FreeHWResource. */
  /* The connecting pointer is the ACB field: npNextACB.               */
  NPACB         npHeadACB;
  NPACB         npFootACB;
  /* Pointer to the first ACB in a list of ACBs sharing this           */
  /* HWRESOURCE.  The connecting pointer is the ACB field: npNextACBX. */
  /* The list of ACBs sharing this resource is determined  at          */
  /* initialization.                                                   */
  NPACB         npFirstACBX;
  /* Forewarding ISR address to use when SUSPENDED                     */
  USHORT        (FAR *SuspendIRQaddr)();
} HWRESOURCE, NEAR *NPHWRESOURCE, FAR *PHWRESOURCE;

/* HWRESOURCE->Flags definitions */
                                                                    /*@AAAAAAA*/
#define HWRF_SUSPENDED     0x0001    /* HWRESOURCE is suspended */  /*@V147576*/



/*-------------------------------*/
/* Adapter Control Block         */
/* ---------------------         */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/


#define FI_MAX_REGS     12

typedef struct _ACB
{
  /*--------------------------------------*/
  /* IORB Queue for units on this adapter */
  /*--------------------------------------*/
  PIORBH        pHeadIORB;                                                           // 0x000
  PIORBH        pFootIORB;                                                           // 0x004
  PIORBH        pIORB;                                                               // 0x008

  /*---------------------------------------------------*/
  /* Controller Register addresses/contents, IRQ level */
  /*---------------------------------------------------*/
  USHORT        IOPorts[FI_MAX_REGS];                                                // 0x00c
  UCHAR         IORegs[FI_MAX_REGS];                                                 // 0x024
  USHORT        IOPendingMask;                                                       // 0x030

  USHORT        HWResourceIndex;    /* Index into HWResource[] */   /*@V147576*/     // 0x032
  NPACB         npNextACBX;      /* Next ACB on the HWRESOURCE */   /*@V147576*/     // 0x034
  NPACB         npNextACB;  /* Next ACB wanting the HWRESOURCE */   /*@V147576*/     // 0x036

  USHORT        Channel;                                           
  USHORT        IntLevel;                                                            // 0x038
  USHORT        SpuriousIRQ;                                                         // 0x03a
  USHORT        cResets;                                           /*@V77133*/       // 0x03c

  /*-----------------*/
  /* State Variables */
  /*-----------------*/
  USHORT        UseCount;                                                            // 0x03e
  USHORT        State;                                                               // 0x040
  USHORT        Flags;                                                               // 0x042
  USHORT        ReqFlags;                                                            // 0x044
  USHORT        ReqMask;                                                             // 0x046

  USHORT        UnitId;                                                              // 0x048
  NPUCB         npUCB;                                                               // 0x04a

  /*--------------------------------*/
  /* Current operation variables    */
  /*--------------------------------*/
  ULONG         StartRBA;                                                            // 0x04c
  ULONG         SecRemain;                                                           // 0x050
  ULONG         SecDone;                                                             // 0x054

  USHORT        SecReq;                                                              // 0x058
  USHORT        SecToGo;                                                             // 0x05a
  USHORT        SecPerInt;                                                           // 0x05c

  USHORT        DataErrorCnt;                                                        // 0x05e
  USHORT        BusyTimeoutCnt;                                      /*@V85057*/     // 0x060
  USHORT        IORBStatus;                                                          // 0x062
  USHORT        IORBError;                                                           // 0x064

  ADD_XFER_IO   IOSGPtrs;                                                            // 0x066

/* Begin [001] */

        /*---------------------------------*/
        /*              IDE DMA PORTS              */
        /*---------------------------------*/

  USHORT        DMAMode;                                                             // 0x080
  USHORT        DMAExtMode;                                                          // 0x082
  USHORT        DMAChannel;                                                          // 0x084
  USHORT        DMACountPort;                                                        // 0x086
  USHORT        DMAAddrPort;                                                         // 0x088
  USHORT        DMAAddrpagePort;                                                     // 0x08a
  USHORT        DMAModePort;                                                         // 0x08c
  USHORT        DMAChainMode;                                                        // 0x08e
  USHORT        DMAExtModePort;                                                      // 0x090
  USHORT        DMAMaskPort;                                                         // 0x092
  USHORT        DMAClrBytePtr;                                                       // 0x094
  USHORT        DMASGDCmdPort;                                                       // 0x096
  USHORT        DMASGDPtrPort;                                                       // 0x098

/* End [001] */

/* Begin [002.2] Add registers for PCI Bus Master DMA */

  USHORT        BMICOM;                     /* IDE Command Register */               // 0x09a
  USHORT        BMISTA;                     /* IDE Status Register */                // 0x09c
  USHORT        BMIDTP;                     /* IDE Descriptor Table Pointer */       // 0x09e

/* End [002.2] */

  /*--------------------------------*/
  /* Timer Flags/Values             */
  /*--------------------------------*/
  USHORT        TimerFlags;                                                          // 0x0a0

  ULONG         ElapsedTime;                                                         // 0x0a2
  ULONG         TimeOut;                                                             // 0x0a6

  /*----------------------*/
  /* Timer Loop Counters  */
  /*----------------------*/
  ULONG         DelayedResetInterval;                                                // 0x0aa
  ULONG         DelayedResetCtr;                                                     // 0x0ae
  ULONG         DelayedRetryInterval;                                                // 0x0b2
  ULONG         IRQTimeOut;                                                          // 0x0b6
  USHORT        (FAR *IRQEntry)( VOID );                             /*@V87325*/     // 0x0ba

  /*--------------------------------------------------*/
  /* Timer Handles                                    */
  /*                                                  */
  /* (Also update TIMERS_PER_ACB when adding timers)  */
  /*--------------------------------------------------*/
  ULONG         IRQTimerHandle;                                                      // 0x0be
  ULONG         RetryTimerHandle;                                                    // 0x0c2
  ULONG         ResetTimerHandle;                                                    // 0x0c6

  /*-------------------------------------------------*/
  /* Unit Control Blocks - Unit specific information */
  /*-------------------------------------------------*/
  USHORT        cUnits;                                                              // 0x0ca
  UCB           UnitCB[MAX_UNITS];                                                   // 0x0cc

  /*-------------------------------------------------*/             /*@V87325*/
  /* Pause Resume Support                            */             /*@V87325*/
  /*-------------------------------------------------*/             /*@V87325*/
  /* Pointer to the first and last suspend IORB for  */
  /* this ACB.  Only suspend requests are placed on  */
  /* this queue in SuspendIORBReq().                 */
  PIORB         pSuspendHead;                                                        // 0x272
  PIORB         pSuspendFoot;                                                        // 0x276
  /* Depending on the type suspend request, DC_SUSPEND_DEFERRED or     */
  /* DC_SUSPEND_IMMEDIATE, this field holds a count-down of IORBs to   */
  /* process in this driver before completing the suspend operation.   */
  USHORT        CountUntilSuspend;                                  /*@V87325*/      // 0x27a

  PCI_INFO      PCIInfo;                                            /*@V129765*/     // 0x27c

/* Begin [001] */

  /*--------------------------------------------------*/
  /*  Scatter Gather List for DMA transfers           */
  /* -------------------------------------------------*/

  ULONG         SGIOCount;                                                           // 0x298
  ULONG         IOCount;                                                             // 0x29c
  ULONG         physSGListAddr;                                                      // 0x2a0
  SCATGATENTRY  DMASGList[32];            /* 32 entries for each sglist */           // 0x2a4

/* End [001] */

/* Begin [002.2] Add support vars for PIIX */

  ULONG         BMDMA_SGList;               /* Bus Master DMA scatter/gather list */ // 0x324
  USHORT        BMDMA_SGListSize;           /* useable size of BMDMA_SGList */       // 0x328
  USHORT        BMDMA_SGListCount;          /* maximum descriptor useable */         // 0x32a
  SEL           BMDMA_GDT;                  /* GDT for BM S/G list */ /*@V159438*/   // 0x32c
  PPRD          pBMDMA_SGL;                 /* ptr to BM S/G list  */ /*@V159438*/   // 0x32e
  USHORT        PIIX_IDEtim;                /* setting for IDETIM in PIIX */         // 0x332
  USHORT        PIIX_SIDEtim;     /* setting for SLAVE IDETIM in PIIX *//*@V179942*/ // 0x334
  UCHAR         BM_CommandCode;             /* command for BMDMA controller */       // 0x336
  ULONG         BytesToTransfer;            /* total transfer length in bytes */     // 0x337

/* End [002.2] */

  IDENTIFYDATA            identifyBuf;      /* Removable media */   /*@V154814*/     // 0x33b
  IORB_ADAPTER_PASSTHRU   PTIORB;           /* [006] */             /*@V155162*/     // 0x53b
  PassThruATA             icp;              /* [006] */             /*@V155162*/     // 0x595
  USHORT                  AtInterrupt;      /* Internal nest */     /*@V162458*/     // 0x5a6

} ACB;                                                                  // total size = 0x5a8

#define TIMERS_PER_ACB  3

#define TIMER_POOL_SIZE  (sizeof(ADD_TIMER_POOL) +                        \
                           ((TIMERS_PER_ACB * MAX_ADAPTERS) - 0)          \
                             * sizeof(ADD_TIMER_DATA))

/* ACB->Flags values */

#define ACBF_INTERRUPT          0x8000
#define ACBF_WAITSTATE          0x4000
#define ACBF_CONFIGCHANGE       0x2000                              /*@V149971*/
#define ACBF_SM_ACTIVE          0x0800
#define ACBF_LBAMODE            0x0400
#define ACBF_MULTIPLEMODE       0x0200
#define ACBF_PS2IDEPORT         0x0100
#define ACBF_DISABLERESET       0x0080
#define ACBF_DISABLERETRY       0x0040
#define ACBF_DISKPARMRESET      0x0020
#define ACBF_IRQCLEAR           0x0010                              /*@V106915*/
#define ACBF_RESETDONE          0x0008      /* [001] Reset completed */
#define ACBF_DMASGMODE          0x0004      /* [001] DMA Scatter/Gather mode */

/* ACB->ReqFlags values */

#define ACBR_READ               0x0001
#define ACBR_WRITE              0x0002
#define ACBR_VERIFY             0x0004
#define ACBR_IDENTIFY           0x0008
#define ACBR_WRITEV             0x0010
#define ACBR_SETMULTIPLE        0x0020
#define ACBR_RESETCONTROLLER    0x0040
#define ACBR_SETLOGPARAM        0x0080
#define ACBR_PASSTHRU           0x0100      /* [004] Passthru command */      /*@V151345*/
#define ACBR_DMAIO              0x0200      /* [001][004] DMA Transfer this I/O */
#define ACBR_NONDATA            0x0400                                        /*@V151345*/
#define ACBR_BM_DMA_FORCEPIO    0x0800      /* [007] Force PIO xfer flag */   /*@V159438*/
// warning, warning, these two are predefined as top TWO BITS
#define ACBR_RECAL              UCBR_RECAL                                    /*@V151345*/
#define ACBR_SETPARAM           UCBR_SETPARAM                                 /*@V151345*/

#define ACBR_BLOCKIO            (ACBR_READ   | ACBR_WRITE | ACBR_VERIFY | \
                                 ACBR_WRITEV )
                                                                /*@V151345*/
#define ACBR_OTHERIO            (ACBR_RECAL | ACBR_SETPARAM | \
                                 ACBR_SETMULTIPLE | ACBR_RESETCONTROLLER    | \
                                 ACBR_SETLOGPARAM | ACBR_NONDATA)                /* [004] */

#define ACBR_MULTIPLEMODE       (ACBR_READ | ACBR_WRITE)


/* ACB->State values */

#define ACBS_START      0       /* Dispatch and start the IORB        @V147576*/
#define ACBS_RETRY      1       /* Calculate position on disk                 */
#define ACBS_INTERRUPT  2       /* Start verify portion of write              */
#define ACBS_DONE       3       /* I/O is done.                               */
#define ACBS_ERROR      4       /* Have an error                              */
#define ACBS_RESETCHECK 5       /*                                            */
#define ACBS_SUSPEND    6       /* Wait while another DD uses this HW @V147576*/


/* ACB->TimerFlags */
#define ACBT_BUSY       0x0001
#define ACBT_DRQ        0x0002
#define ACBT_IRQ        0x0004
#define ACBT_READY      0x0008
#define ACBT_RESETFAIL  0x0010                                       /*@V77133*/

/* Begin [002.2] */

/* ACB->PIIX_IDEtim values */

/*
 * These values are used to represent the bits stored in vars in ACB and
 * also map one-to-one with the PCI Bus Master registers. This one-to-one
 * mapping must not be affected.
 */

#define ACBX_IDETIM_MODE0       0x8000  /* mode 0 PIO timing */
#define ACBX_IDETIM_DTE1        0x0080  /* DMA fast timing only drive 1 */
#define ACBX_IDETIM_PPE1        0x0040  /* prefetct/posting enable drive 1 */
#define ACBX_IDETIM_IE1         0x0020  /* IORDY samply point drive 1 */
#define ACBX_IDETIM_TIME1       0x0010  /* fast timing select drive 1 */
#define ACBX_IDETIM_DTE0        0x0008  /* DMA fast timing only drive 0 */
#define ACBX_IDETIM_PPE0        0x0004  /* prefetct/posting enable drive 0 */
#define ACBX_IDETIM_IE0         0x0002  /* IORDY samply point drive 0 */
#define ACBX_IDETIM_TIME0       0x0001  /* fast timing select drive 0 */

#define ACBX_IDETIM_ITE1        0x4000  /* [006] PIIX3 slave timing enable */

#define ACBX_BMICOM_RW          0x08    /* Read when 0, write when 1 */
#define ACBX_BMICOM_START       0x01    /* Start when 1, stop when 0 */

#define ACBX_BMISTA_SIMPLEX     0x80    /* simplex DMA channels when 1 */
#define ACBX_BMISTA_D1DMA       0x40    /* drive 1 DMA capable */
#define ACBX_BMISTA_D0DMA       0x20    /* drive 0 DMA capable */
#define ACBX_BMISTA_INTERRUPT   0x04    /* IDE interrupt was detected */
#define ACBX_BMISTA_ERROR       0x02    /* transfer error detected */
#define ACBX_BMISTA_ACTIVE      0x01    /* Bus Master DMA active */

/* End [002.2] */


/*-------------------------------*/
/* Unit Table                    */
/* ----------                    */
/*                               */
/* One per unit (drive)          */
/*                               */
/*-------------------------------*/

typedef struct _UTBL
{
  USHORT        Flags;
  USHORT        Status;
  USHORT        DriveId;

  /*-----------------------*/
  /* Command Line Geometry */
  /*-----------------------*/
  GEOMETRY      CMDLogGeom;
  GEOMETRY      CMDPhysGeom;
  USHORT        CMDWrtPreCmp;

  /*-------------------*/                                           /*@V192176*/
  /* Identify Geometry */                                           /*@V192176*/
  /*-------------------*/                                           /*@V192176*/
  GEOMETRY      IDELogGeom;                                         /*@V192176*/
  GEOMETRY      IDEPhysGeom;                                        /*@V192176*/
  USHORT        IDEWrtPreCmp;                                       /*@V192176*/

  /*------------------------*/
  /* INT 13 FCN=08 Geometry */
  /*------------------------*/
  GEOMETRY      I13LogGeom;
  GEOMETRY      I13PhysGeom;
  USHORT        I13WrtPreCmp;

  /*------------------------*/                                      /*@V192176*/
  /* BPB Geometry           */                                      /*@V192176*/
  /*------------------------*/                                      /*@V192176*/
  GEOMETRY      BPBLogGeom;                                         /*@V192176*/
  GEOMETRY      BPBPhysGeom;                                        /*@V192176*/
  USHORT        BPBWrtPreCmp;                                       /*@V192176*/

  USHORT        TimeOut;

  /*------------------------*/                                       /*@V75103*/
  /* Model/Firmware Rev     */                                       /*@V75103*/
  /*------------------------*/                                       /*@V75103*/
  UCHAR         ModelNum[42];                                        /*@V75103*/
  UCHAR         FirmwareRN[10];                                      /*@V75103*/

  // Enhanced BIOS support                                          /*@V192176*/
  UCHAR         EBIOSVersion;                                       /*@V192176*/
  USHORT        EBIOSCapabilities;                                  /*@V192176*/
#ifdef BBR
  USHORT        BBRFlags;
  USHORT        nBBRSequences;
  BBR_SEQUENCE  BBRSequence[MAX_BBR_SEQUENCES];
#endif

} UTBL;

#define UTBF_CMDGEOMETRYVALID   0x8000
#define UTBF_I13GEOMETRYVALID   0x4000
#define UTBF_IDEGEOMETRYVALID   0x2000
#define UTBF_LBAMODEENABLED     0x1000
#define UTBF_SMSENABLED         0x0800
#define UTBF_FORCE              0x0200                              /*@V149971*/
#define UTBF_BPBGEOMETRYVALID   0x0100                              /*@V179486*/
#define UTBF_ATAPIDEVICE        0x0002                              /*@V93531*/
#define UTBF_NODASDSUPPORT      0x0001

#define UTS_OK                  0
#define UTS_NOT_PRESENT         1
#define UTS_READ_0_FAILED       2
#define UTS_NOT_READY           3                                    /*@V87325*/
#define UTS_NO_MASTER           4                                   /*@V108783*/


/*-------------------------------*/
/* Adapter Table                 */
/* -------------                 */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/

typedef struct _ATBL
{
  USHORT        BasePort;
  USHORT        StatusPort;                                         /*@V153620*/
  USHORT        Channel;                                            
  USHORT        IRQLevel;

  USHORT        Flags;
  USHORT        Status;

  PCI_INFO      PCIInfo;                                            /*@V129765*/
                                                                    /*VVVVVVVV*/
  /*
  ** Just in case you are wondering, the next field: npPCIDeviceMsg
  ** is not in the PCI_INFO struct because this pointer becomes
  ** invalid after initialization is complete and PCIInfo is wholly
  ** copied to the ACB for use at task and interrupt time.
  */                                                                /*AAAAAAAA*/
  NPSZ          npPCIDeviceMsg;                                     /*@V129765*/

  HADAPTER      hAdapter;                                           /*@V98451*/

  NPACB         npACB;

  USHORT        cUnits;
  UTBL          Unit[MAX_UNITS];

  UCHAR         ResourceBuf[sizeof(AHRESOURCE)+sizeof(HRESOURCE)*3]; /*@V98451*/

/* Begin [001] */

  USHORT        SysDMAType;
  USHORT        DMA_Channel;
  USHORT        DMA_Count_port;
  USHORT        DMA_Addr_port;
  USHORT        DMA_Addr_page_port;
  USHORT        DMA_Mode_port;
  USHORT        DMA_Chain_mode;
  USHORT        DMA_Ext_Mode_port;
  USHORT        DMA_Mask_port;
  USHORT        DMA_Clr_Byte_ptr;
  USHORT        DMA_SGD_Cmd_port;
  USHORT        DMA_SGD_Ptr_port;

/* End [001] */

/* Begin [002.2] */

  USHORT        BM_Overides;                /* Bus Master DMA switch overides */

/* End [002.2] */

  USHORT        BM_BaseAddress;           /*[006]*/

} ATBL;

#define ATBF_DISABLED           0x8000
#define ATBF_PS2IDEPORT         0x4000
#define ATBF_DISABLERESET       0x2000
#define ATBF_ATAPIPRESENT       0x1000                               /*@V93531*/
#define ATBF_IRQCLEAR           0x0800                              /*@V106915*/
#define ATBF_NOT_DPT            0x0400                              /*@V117508*/

#define ATBF_FORCE              0x0200                              /*@V149971*/
#define ATBF_PCMCIA             0x0100                              /*@V155162*/
#define ATBF_CONTROLSPECIFIC    0x0080                              /*@V153620*/
#define ATBF_NODASDSUPPORT      0x0008                              /*@V149971*/

#define ATBF_BM_DMA             0x0004      /* [002.2] Bus Master DMA mode */
#define ATBF_DMASG              0x0002      /* [001] Enable DMA scatter/gather */
#define ATBF_DMAMODEENABLED     0x0001      /* [001] Enable DMA transfers */

#define ATS_OK                  0
#define ATS_NOT_PRESENT         1
#define ATS_SKIPPED             2
#define ATS_SET_IRQ_FAILED      3
#define ATS_ALLOC_IRQ_FAILED    4                                    /*@V98451*/
#define ATS_ALLOC_IO_FAILED     5                                    /*@V98451*/
#define ATS_PCI_CONFIG_FAILED   6                                    /* [003] */

/* Begin [002.2] Bus Master DMA switch overide values */

#define ATBM_NOBM_UNIT1         0x8000      /* Force BM off for unit 1 */
#define ATBM_NOBM_UNIT0         0x4000      /* Force BM off for unit 0 */
#define ATBM_BM_UNIT1           0x2000      /* [008] Allow BM on for unit 1 */
#define ATBM_BM_UNIT0           0x1000      /* [008] Allow BM on for unit 0 */

/* End [002.2] */


/*-------------------------------*/
/* DriveType                     */
/* ---------                     */
/*                               */
/* One per Drive Type.           */
/*                               */
/*-------------------------------*/

typedef struct _DRIVETYPE
{
  USHORT        Cyl;
  USHORT        Head;
  USHORT        Sec;
  USHORT        WrtPreCmp;
} DRIVETYPE;

#define MAX_DRIVE_TYPES         48

/*-------------------------------*/
/* ACB Pointer Block             */
/* -----------------             */
/*                               */
/*                               */
/*                               */
/*-------------------------------*/

typedef struct _ACBPTRS
{
  NPACB         npACB;
  USHORT        (FAR *IRQHandler)();

  USHORT        IRQLevel;                                            /*@V87325*/
  USHORT        HWResourceIndex;   /* Index into HWResource */      /*@V147576*/

  USHORT        Reserved;                                           /*@V147576*/

} ACBPTRS;

#ifdef DEBUG                                                        /*@V159438*/
typedef struct _DEBUG_RECORD                                        /*@V159438*/
{                                                                   /*@V159438*/
   NPACB        npACB;                                              /*@V159438*/
   USHORT       IntLevel;                                           /*@V159438*/
   USHORT       UnitId;                                             /*@V159438*/
   USHORT       State;                                              /*@V159438*/
   USHORT       Flags;                                              /*@V159438*/
   USHORT       ReqFlags;                                           /*@V159438*/
   ULONG        StartRBA;                                           /*@V159438*/
   USHORT       SecReq;                                             /*@V159438*/
   USHORT       SecToGo;                                            /*@V159438*/
   PIORB        pIORB;                                              /*@V159438*/
   USHORT       CommandCode;                                        /*@V159438*/
   USHORT       CommandModifier;                                    /*@V159438*/
   USHORT       IORBStatus;                                         /*@V159438*/
   USHORT       IORBError;                                          /*@V159438*/
} DEBUG_RECORD;                                                     /*@V159438*/
#endif                                                              /*@V159438*/

