/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %W% %E% */
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506REGS.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Register equates for WD1003 type controllers.
 *
 * Purpose:
 *
 *
 *
 *
 *
*//*
 * Edit History for defect # 148406:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 05-10-95  Integrated changes Shishir Shah made to original 2.1 version
 *                 of IBM1S506 driver to implement block mode and slave DMA. In
 *                 this file it involved adding the definitions for the DMA
 *                 commands, definitions for the Double Word I/O, and IDE
 *                 capabilities words to the Identify data structure, bit
 *                 definitions for LBA and DMA mode support in word 49 in the
 *                 Identify data structure, and definitions for the DMA
 *                 controller mode register. /jlh
 * [002] 06-21-95  Add definition for Set Features and Set Transfer Mode
 *                 commands. /jlh
 *
 * [003] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 *
 * [004] 12-15-95  Add definition for FX_SMARTCMD. /jlh
*/

#ifndef __S506REGS_H__                                              /*@V154814*/
#define __S506REGS_H__                                              /*@V154814*/

/* Locations in ROM data area of fixed disk parameter tables on an AT  */

#define FDTAB_0      (0x0041 * 4)  /* First fixed disk  - Int 41H vector */
#define FDTAB_1      (0x0046 * 4)  /* Second fixed disk - Int 46H vector */

/* Hard disk controller commands */

#define FX_NORETRY   0x0001        /* do not perform retries on i/o           */
#define FX_ECC       0x0002        /* ECC mode during i/o                     */
#define FX_RECAL     0x0010        /* recalibrate                             */
#define FX_CREAD     0x0020        /* read                                    */
#define FX_CWRITE    0x0030        /* write                                   */
#define FX_VERIFY    0x0040        /* verify track.                           */
#define FX_SEEK      0x0070        /* seek track                      @V162789*/
#define FX_SETP      0x0091        /* Set parameters                          */
#define FX_CPQPWMODE 0x0098        /* Check if drive powered on               */
#define FX_CPWRMODE  0x00E5        /* Check if drive powered on               */
#define FX_IDENTIFY  0x00EC        /* Identify drive                          */
#define FX_CREADMUL  0x00C4        /* Read Multiple                           */
#define FX_CWRITEMUL 0x00C5        /* Write Multiple                          */
#define FX_SETMUL    0x00C6        /* Set Multiple Mode                       */
#define FX_DMAREAD   0x00C8        /* [001] DMA Read                          */
#define FX_DMAWRITE  0x00CA        /* [001] DMA Write                         */
#define FX_GET_MEDIA_STATUS 0x00DA /* get media status command   @V151345 SRD */
#define FX_LOCK_DOOR 0x00DE        /* lock drive door            @V151345 SRD */
#define FX_UNLOCK_DOOR 0x00DF      /* unlock drive door          @V151345 SRD */
#define FX_EJECT_MEDIA 0x00ED      /* eject media                @V151345 SRD */
#define FX_SETFEAT   0x00EF        /* [002] Set Features                      */
#define FX_SMARTCMD  0x00B0        /* [004] SMART command                     */
#define FX_ENABLE_MEDIA_STATUS 0x95  /* enable media status command @V151345 SRD */
#define FX_DISABLE_MEDIA_STATUS 0x31 /* disable media status command@151345  SRD */
#define FX_ACK_MEDIA_CHANGE     0xDB /* acknowledge media change */ /*@V157085*/


/* roman16: Definitions */ 
#define  FX_STANDBY  0x96  /*@roman16: IDE Adapter Command STANDBY */
#define  FX_STANDBY2  0x0E2 /*@roman16: IDE Adapter Command STANDBY (supported by older HDDs)*/
/* roman16: Definitions ends

/* ATAPI Protocol Unique Commands */                             /*@V87325*/
#define FX_ATAPI_RESET    0x0008    /* Reset ATAPI device          @V87325    */
#define FX_ATAPI_IDENTIFY 0x00A1    /* Identify ATAPI device       @V87325    */

/* Begin [002] Set Features subcommand codes */
#define FX_SETXFERMODE    0x0003    /* Set Transfer Mode                      */
#define FX_PIOMODE0       0x0001    /*    PIO Mode 0 without Flow Control     */
#define FX_PIOMODEX       0x0008    /*    PIO Mode x with Flow Control        */
#define FX_MWDMAMODEX     0x0020    /*    multiword DMA Mode x                */
#define FX_ULTRADMAMODEX  0x0040    /*   Ultra DMA Mode x - 2 1 0 *//*@V179942*/

/* End [002] */


/* Status bits */

#define FX_BUSY      0x0080        /* Status port busy bit                    */
#define FX_READY     0x0040        /* Status port ready bit                   */
#define FX_WRTFLT    0x0020        /* Write Fault                             */
#define FX_DRQ       0x0008        /* Data Request bit                        */
#define FX_ERROR     0x0001        /* Error status                            */

/* Device Control Register bits */

#define FX_nIEN      0x0002        /* Interrupt Enable (0=enable; 1=disable)  *//*@V157085*/
#define FX_SRST      0x0004        /* Soft Reset                              */
#define FX_DCRRes    0x0008        /* Device Control Reg - reserved bits      *//*@V157085*/

/* Error Register bits */

#define FX_AMNF      0x0001        /* Address Mark Not Found                  */
#define FX_TRK0      0x0002        /* Track 0 not found during Restore Cmd    */
#define FX_ABORT     0x0004        /* Aborted Command                         */
#define FX_MCR       0x0008        /* Media eject requested    @V151345 SRD   */
#define FX_IDNF      0x0010        /* ID Not Found                            */
#define FX_MC        0x0020        /* Media changed            @V151345 SRD   */
#define FX_ECCERROR  0x0040        /* Data ECC Error                          */
#define FX_WRT_PRT   0x0040        /* write protect            @V151345 SRD   */
#define FX_BADBLK    0x0080        /*     Block was detected in the ID field  */
#define FX_RD_PRT    0x0080        /* read protect             @V151345 SRD   */
#define FX_ICRC      0x0080        /* ULTRA DMA CRC error      @V179942       */

/* Error Register - Diagnostic Codes */

#define FX_DIAG_PASSED    0x0001   /* All drives passed                       */
#define FX_DIAG_FORMATTER 0x0002   /* Formatter device error                  */
#define FX_DIAG_BUFFER    0x0003   /* Sector buffer error                     */
#define FX_DIAG_ECC       0x0004   /* ECC circuitry error                     */
#define FX_DIAG_uP        0x0005   /* Controlling uP error                    */
#define FX_DIAG_DRIVE1    0x0080   /* Drive 1 failed flag - Select Drive 1    */

/* I/O ports for AT hard drives */

#define FX_PRIMARY   0x01F0        /* Default primary   ports                 */
#define FX_SECONDARY 0x0170        /* Default secondary ports                 */

#define FX_PDAT      0x01F0        /* read/write data                         */
#define FX_PWRP      0x01F1        /* write precompensation cyl register      */
#define FX_PERR      0x01F1        /* error register                          */
#define FX_PSECCNT   0x01F2        /* sector count register                   */
#define FX_PSECNUM   0x01F3        /* sector number register                  */
#define FX_PCYLL     0x01F4        /* cylinder register (low)                 */
#define FX_PCYLH     0x01F5        /* cylinder register (high)                */
#define FX_PDRHD     0x01F6        /* drive/head register                     */
#define FX_PCMD      0x01F7        /* command register                        */
#define FX_PSTAT     0x01F7        /* status register                         */
#define FX_RFDR      0x03F6        /* fixed disk register                     */

/* Array indices (IOPorts[] and IORegs[]) for I/O port address and contents   */

/* Output Regs */

#define FI_PDAT      0             /* read/write data                         */
#define FI_PWRP      1             /* write precompensation cyl register      */
#define FI_PSECCNT   2             /* sector count register                   */
#define FI_PSECNUM   3             /* sector number register                  */
#define FI_PCYLL     4             /* cylinder register (low)                 */
#define FI_PCYLH     5             /* cylinder register (high)                */
#define FI_PDRHD     6             /* drive/head register                     */
#define FI_PCMD      7             /* command register                        */
#define FI_RFDR      8             /* fixed disk register                     */

#define FM_PDAT    (1<< FI_PDAT   ) /* read/write data                        */
#define FM_PWRP    (1<< FI_PWRP   ) /* write precompensation cyl register     */
#define FM_PERR    (1<< FI_PERR   ) /* error register                         */
#define FM_PSECCNT (1<< FI_PSECCNT) /* sector count register                  */
#define FM_PSECNUM (1<< FI_PSECNUM) /* sector number register                 */
#define FM_PCYLL   (1<< FI_PCYLL  ) /* cylinder register (low)                */
#define FM_PCYLH   (1<< FI_PCYLH  ) /* cylinder register (high)               */
#define FM_PDRHD   (1<< FI_PDRHD  ) /* drive/head register                    */
#define FM_PCMD    (1<< FI_PCMD   ) /* command register                       */
#define FM_RFDR    (1<< FI_RFDR   ) /* fixed disk register                    */

/* Input Regs */

#define FI_PERR      9             /* error register                          */
#define FI_PSTAT    10             /* status register                         */


/* Interrupt control */

#define IRQ_FIXED_PRIMARY  0x000E  /* Fixed interrupt IRQ #                   */
#define IRQ_FIXED_SECONDARY 0x000F /* Second IDE interrupt IRQ #              */ /*@V149971*/


//                                                                  /*@V179486*/
// Boot Record Partiton Table Entry                                 /*@VVVVVVV*/
//
typedef struct _PARTITION_ADDRESS
{
   UCHAR             head;
   UCHAR             sector;
   UCHAR             cylinder;
} PARTITION_ADDRESS, *PPARTITION_ADDRESS;

typedef struct _PARTITION_TABLE_ENTRY
{
   UCHAR             bootIndicator;
   PARTITION_ADDRESS start;
   UCHAR             systemIndicator;
   PARTITION_ADDRESS end;
   ULONG             offset;
   ULONG             length;
} PARTITION_TABLE_ENTRY, *PPARTITION_TABLE_ENTRY;

// systemIndicator (partition type) definitions
#define BR_PARTTYPE_FAT01      0x01
#define BR_PARTTYPE_FAT12      0x04
#define BR_PARTTYPE_FAT16      0x06
#define BR_PARTTYPE_FAT16X     0x0E  //d_267584
#define BR_PARTTYPE_OS2IFS     0x07
#define BR_PARTTYPE_EXTENDED   0x05
#define BR_PARTTYPE_EXTENDEDX  0x0F  //d_267584
#define BR_PARTTYPE_ONTRACK    0x54                                 /*@V192176*/
#define BR_PARTTYPE_EZDRIVE    0x55                                 /*@V192176*/

//
// Master or Extended Boot Record
//
#define BR_PROGRAM_LENGTH       446
#define BR_MAX_PARTITIONS         4
#define BR_SIGNATURE         0xAA55

// Boundary Limits for drives
#define BR_MAX_SECTORSPERTRACK   63
#define BR_MAX_HEADS            255                                 /*@V182487*/
#define BR_MAX_PHYS_HEADS        16

typedef struct _BOOT_RECORD
{
   UCHAR                 program[BR_PROGRAM_LENGTH];
   PARTITION_TABLE_ENTRY partitionTable[BR_MAX_PARTITIONS];
   USHORT                signature;
} BOOT_RECORD, *PBOOT_RECORD;

//
// Partition or Extended Partition Boot Record
//
#define PBR_OEM_NAME_LENGTH       8
#define PBR_VOLUME_LABEL_LENGTH  11
#define PBR_PROGRAM_LENGTH      193
typedef struct _PARTITION_BOOT_RECORD
{
   UCHAR                 jumpNear[3];
   CHAR                  OEMNameAndVersion[PBR_OEM_NAME_LENGTH];
   USHORT                bytesPerSector;
   UCHAR                 sectorsPerCluster;
   USHORT                additionalBootSectors;
   UCHAR                 FATs;
   USHORT                maxRootDirectoryEntries;
   USHORT                totalSectors16;
   UCHAR                 mediaDescriptor;
   USHORT                sectorsPerFAT;
   USHORT                sectorsPerTrack;
   USHORT                heads;
   ULONG                 hiddenSectors;
   ULONG                 totalSectors32;
   UCHAR                 physicalDriveNumber;
   UCHAR                 reserved01;
   UCHAR                 signature;
   ULONG                 volumeSerialNumber;
   CHAR                  volumeLabel[PBR_VOLUME_LABEL_LENGTH];
   UCHAR                 reserved02[8];
   UCHAR                 program[PBR_PROGRAM_LENGTH];
   UCHAR                 reserved03[257];                           /*AAAAAAAA*/
} PARTITION_BOOT_RECORD, *PPARTITION_BOOT_RECORD;                   /*@V179486*/


/* Identify Data */

typedef struct _IDENTIFYDATA NEAR *NPIDENTIFYDATA, FAR *PIDENTIFYDATA;

typedef struct _IDENTIFYDATA
{
  USHORT        GeneralConfig;          /*  0 General configuration bits      */
  USHORT        TotalCylinders;         /*  1 Default Translation - Num cyl   */
  USHORT        Reserved;               /*  2 Reserved                        */
  USHORT        NumHeads;               /*  3                     - Num heads */
  USHORT        NumUnformattedbpt;      /*  4 Unformatted Bytes   - Per track */
  USHORT        NumUnformattedbps;      /*  5                     - Per sector*/
  USHORT        SectorsPerTrack;        /*  6 Default Translation - Sec/Trk   */
  USHORT        NumBytesISG;            /*  7 Byte Len - inter-sector gap     */
  USHORT        NumBytesSync;           /*  8          - sync field           */
  USHORT        NumWordsVUS;            /*  9 Len - Vendor Unique Info        */
  CHAR          SerialNum[20];          /* 10 Serial number                   */
  USHORT        CtrlType;               /* 20 Controller Type                 */
  USHORT        CtrlBufferSize;         /* 21 Ctrl buffer size - Sectors      */
  USHORT        NumECCBytes;            /* 21 ECC bytes -  read/write long    */
  CHAR          FirmwareRN[8];          /* 23 Firmware Revision               */
  CHAR          ModelNum[40];           /* 27 Model number                    */
  USHORT        NumSectorsPerInt;       /* 47 Multiple Mode - Sec/Blk         */
  USHORT        DoubleWordIO;           /* 48 [001] Double word IO Flag       */
  USHORT        IDECapabilities;        /* 49 [001] Capability Flags Word     */
  USHORT        Reserved2;              /* 50 [001]                           */
  USHORT        PIOCycleTime;           /* 51 Transfer Cycle Timing - PIO     */
  USHORT        DMACycleTime;           /* 52                       - DMA     */
  USHORT        AdditionalWordsValid;   /* 53 [002] Additional words valid    */
  USHORT        LogNumCyl;              /* 54 Current Translation - Num Cyl   */
  USHORT        LogNumHeads;            /* 55                       Num Heads */
  USHORT        LogSectorsPerTrack;     /* 56                       Sec/Trk   */
  ULONG         LogTotalSectors;        /* 57                       Total Sec */
  USHORT        LogNumSectorsPerInt;    /* 59                                 */
  ULONG         LBATotalSectors;        /* 60 LBA Mode - Sectors              */
  USHORT        DMASWordFlags;          /* 62                                 */
  USHORT        DMAMWordFlags;          /* 63                                 */
  USHORT        AdvancedPIOModes;       /* 64 [002] Advanced PIO modes supported */
  USHORT        MinMWDMACycleTime;      /* 65 [002] Minimum multiword DMA cycle time */
  USHORT        RecMWDMACycleTime;      /* 66 [002] Recommended MW DMA cycle time */
  USHORT        MinPIOCycleTimeWOFC;    /* 67 [002] Minimum PIO cycle time without IORDY */
  USHORT        MinPIOCycleTime;        /* 68 [002] Minimum PIO cycle time    */
  USHORT        Reserved3[88-69];       /* 69                    @V179942     */
  USHORT        UltraDMAModes;          /* 88 Ultra DMA Modes    @V179942     */
  USHORT        Reserved4[93-89];       
  USHORT        IDentWord93;            
  USHORT        Reserved5[127-94];      
  USHORT        MediaStatusWord;        /* 127 media status word @V151345 SRD */
  USHORT        Reserved6[256-128];     /*                       @V151345     */

}IDENTIFYDATA;

#define FX_SECPERINTVALID       0x8000  /* Word 47 - Valid bit                */
#define FX_LOGSECPERINTVALID    0x0100  /* Word 59 - Valid bit                */
#define FX_DMASUPPORTED         0x0100  /* [001] DMA supported bit            */
#define FX_LBASUPPORTED         0x0200  /* [001] LBA supported bit            */

#define FX_WORDS54_58VALID      0x0001  /* [002] Words 54-58 in ID valid      */
#define FX_WORDS64_70VALID      0x0002  /* Words 64-70 in ID valid    @V179942*/
#define FX_WORD88_VALID         0x0004  /* Word 88 valid ->Ultra DMA  @V179942*/

/* Hard disk parameter - control byte bit mask */

#define FDPCTRL_DISABLERETRY    0xc0    /* disable retries                    */
#define FDPCTRL_EXCEED8HEADS    0x08    /* more than 8 heads                  */

#define BIOS_GET_LEGACY_DRIVE_PARAM      0x08                       /*@V192176*/
#define BIOS_GET_ENHANCED_DRIVE_PARAM    0x48                       /*@V192176*/
#define BIOS_GET_ENHANCED_EXTENSIONS     0x41                       /*@V192176*/
#define BIOS_EXTENSIONS_SIGNATURE_IN   0x55AA                       /*@V192176*/
#define BIOS_EXTENSIONS_SIGNATURE_OUT  0xAA55                       /*@V192176*/
#define BIOS_EXTENSIONS_MIN_VERSION      0x21                       /*@V192176*/
#define BIOS_EXTENSIONS_FIXED_DISK       0x01                       /*@V192176*/
#define BIOS_EXTENSIONS_LOCK_EJECT       0x02                       /*@V192176*/
#define BIOS_EXTENSIONS_ENHANCED         0x04                       /*@V192176*/

#define TRANSLATE_A0   0x00A0   /* Translation signature                      */

typedef struct _FDPARMTABLE_XLATE {
  USHORT   FDMaxCylX;                   /* Maximum number of cylinders        */
  UCHAR    FDMaxHdX;                    /* Maximum number of heads            */
  UCHAR    FDtranslate;                 /* Translate signature                */
  UCHAR    FDpsectors;                  /* physical sectors/track             */
  USHORT   FDWritePCompX;               /* write precompensation cyl          */
  UCHAR    FDBUnUseX;                   /* Unused on an AT                    */
  UCHAR    FDControlX;                  /* Control byte                       */
  USHORT   FDpcyls;                     /* physical cylinders                 */
  UCHAR    FDpheads;                    /* physical heads                     */
  USHORT   FDLandZonX;                  /* Landing zone                       */
  UCHAR    FDSecTrkX;                   /* Number of sectors/track            */
  UCHAR    FDResX;                      /* Reserved                           */
} FDPARMTABLE_XLATE;
typedef FDPARMTABLE_XLATE far *PFDPARMTABLE_XLATE;

// Enhanced BIOS Drive Parameter Table Extension                    /*@V192176*/
typedef struct _DPT_EXTENSION {                                     /*@V192176*/
   USHORT          IOPortBaseAddress;                               /*@V192176*/
   USHORT          controlPortBaseAddress;                          /*@V192176*/
   UCHAR           BIOSVendorSpecific;                              /*@V192176*/
   UCHAR           IRQInfo;                                         /*@V192176*/
   UCHAR           RWMultipleBlockCount;                            /*@V192176*/
   UCHAR           DMAInfo;                                         /*@V192176*/
   UCHAR           PIOInfo;                                         /*@V192176*/
   USHORT          BIOSSelectedOptions;                             /*@V192176*/
   USHORT          reserved0;                                       /*@V192176*/
   UCHAR           DPTExtensionRev;                                 /*@V192176*/
   UCHAR           checksum;                                        /*@V192176*/
} DPT_EXTENSION, FAR *PDPT_EXTENSION, NEAR *NPDPT_EXTENSION;        /*@V192176*/
                                                                    /*@V192176*/
// Enhanced BIOS drive parameters buffer                            /*@V192176*/
typedef struct _ENHANCED_DRIVE_PARAMS {                             /*@V192176*/
   USHORT          bufferSize;                                      /*@V192176*/
   USHORT          infoFlags;                                       /*@V192176*/
   ULONG           physTotalCylinders;                              /*@V192176*/
   ULONG           physNumHeads;                                    /*@V192176*/
   ULONG           physSectorsPerTrack;                             /*@V192176*/
   ULONG           totalSectors[2];                                 /*@V192176*/
   USHORT          bytesPerSector;                                  /*@V192176*/
   PDPT_EXTENSION  pDPTExtension;                                   /*@V192176*/
} ENHANCED_DRIVE_PARAMS, FAR *PENHANCED_DRIVE_PARAMS,               /*@V192176*/
  NEAR *NPENHANCED_DRIVE_PARAMS;                                    /*@V192176*/

#define ATAPISIGL 0x14                                             /*@V87325*/
#define ATAPISIGH 0xEB                                             /*@V87325*/

typedef struct _GENCONFIGWORD                                      /*@V87325*/
{                                                                  /*@V87325*/
/*                       Bit Field(s)  DDD?   ZD Description         @V87325 */
/*                                      ZDAD? 3                      @V87325 */
/*                                      3   3 3                      @V87325 */

   unsigned int CmdPktSize   : 2;    /*  0- 1 Command Packet Size    @V87325 */
   unsigned int              : 3;    /*  2- 4 Reserved               @V87325 */
   unsigned int CmdDRQType   : 2;    /*  5- 6 CMD DRQ Type           @V87325 */
   unsigned int Removable    : 1;    /*   7   Removable              @V87325 */
   unsigned int DeviceType   : 5;    /*  8-12 Device Type            @V87325 */
   unsigned int              : 1;    /*  13   Reserved               @V87325 */
   unsigned int Protocol     : 2;    /* 14-15 Protocol Type          @V87325 */

}GENCONFIGWORD, NEAR *NPGENCONFIGWORD;                             /*@V87325*/

/* General Configuration defines       */                          /*@V87325*/
/*  protocols                          */                          /*@V87325*/
#define GC_PROT_ATA              ( 0x00 | 0x01 )                   /*@V87325*/
#define GC_PROT_ATAPI             0x02                             /*@V87325*/
/*  Device Types                       */                          /*@V87325*/
#define GC_DEVTYP_DIRECT_ACCESS   0x00                             /*@V87325*/
#define GC_DEVTYP_STREAMING_TAPE  0x01                             /*@V87325*/
#define GC_DEVTYP_CDROM           0x05                             /*@V87325*/
#define GC_DEVTYP_OPTICAL_MEMORY  0x07                             /*@V87325*/
#define GC_DEVTYP_UNKNOWN         0x1F                             /*@V87325*/

/* Begin [001] */

// DMA Mode register Defines

#define  DMADemandMode     0x0000
#define  DMATypeWrite      0x0004
#define  DMATypeRead       0x0008
#define  DMAStartSGCmd     0x01

/* End [001] */

//                                                                  /*@V192176*/
// Mini-VDM interface structures.                                   /*@V192176*/
typedef struct _KMREGS {                                            /*@V192176*/
  ULONG            R_EAX;                                           /*@V192176*/
  ULONG            R_EBX;                                           /*@V192176*/
  ULONG            R_ECX;                                           /*@V192176*/
  ULONG            R_EDX;                                           /*@V192176*/
  ULONG            R_EBP;                                           /*@V192176*/
  ULONG            R_ESI;                                           /*@V192176*/
  ULONG            R_EDI;                                           /*@V192176*/
  ULONG            R_DS;                                            /*@V192176*/
  ULONG            R_ES;                                            /*@V192176*/
  ULONG            R_FS;                                            /*@V192176*/
  ULONG            R_GS;                                            /*@V192176*/
  ULONG            R_CS;                                            /*@V192176*/
  ULONG            R_EIP;                                           /*@V192176*/
  ULONG            R_EFLAGS;                                        /*@V192176*/
  ULONG            R_SS;                                            /*@V192176*/
  ULONG            R_ESP;                                           /*@V192176*/
} _KMREGS;                                                          /*@V192176*/
                                                                    /*@V192176*/
#define EFLAGS_CF  0x00000001 // Carry Flag                         /*@V192176*/
#define EFLAGS_AF  0x00000010 // Auxiliary Carry Flag               /*@V192176*/
#define EFLAGS_IF  0x00000200 // Interrupt Enable Flag              /*@V192176*/
                                                                    /*@V192176*/
// See VDMINT13.Int13State                                          /*@V192176*/
                                                                    /*@V192176*/
#define VDMINT13_IDLE     0                                         /*@V192176*/
#define VDMINT13_START    1                                         /*@V192176*/
#define VDMINT13_COMPLETE 2                                         /*@V192176*/
                                                                    /*@V192176*/
//                                                                  /*@V192176*/
// See VDMINT13.Int13Functions                                      /*@V192176*/
//                                                                  /*@V192176*/
#define MAX_INT13_FUNCTIONS         5                               /*@V192176*/
#define INT13_FCN_DISKDDCALLOUT     0*8     //VDM     -> DISK DD    /*@V192176*/
#define INT13_FCN_SIMULATEIRQ       1*8     //DISK DD -> VDM        /*@V192176*/
#define INT13_FCN_SIMULATETMR       2*8     //DISK DD -> VDM        /*@V192176*/
                                                                    /*@V192176*/
typedef struct _VDMINT13CB {                                        /*@V192176*/
                                                                    /*@V192176*/
   // These vectors provide linkage between this device driver and  /*@V192176*/
   // Int 13 mini-VDM.                                              /*@V192176*/
                                                                    /*@V192176*/
   ULONG           Int13Functions[MAX_INT13_FUNCTIONS*2];           /*@V192176*/
                                                                    /*@V192176*/
   // These variables provide the address of the Linear=Real        /*@V192176*/
   // I/O buffer mapped in the VDM address space.                   /*@V192176*/
                                                                    /*@V192176*/
   UCHAR  far      *pInt13BufReal;                                  /*@V192176*/
   UCHAR  far      *pInt13BufLin;                                   /*@V192176*/
   UCHAR  far      *pInt13BufProt;                                  /*@V192176*/
   USHORT          Int13IOBufSectors;                               /*@V192176*/
                                                                    /*@V192176*/
   // This variable indicates where we are in processing an INT 13  /*@V192176*/
   // request.                                                      /*@V192176*/
   //                                                               /*@V192176*/
   // Note: It is set to START by the device driver, and to COMPLETE/*@V192176*/
   //       by the V86 code just prior to dispatching the request   /*@V192176*/
   //       to the Int 13 BIOS                                      /*@V192176*/
                                                                    /*@V192176*/
   USHORT          Int13State ;                                     /*@V192176*/
   ULONG           Int13CreateRc;                                   /*@V192176*/
                                                                    /*@V192176*/
                                                                    /*@V192176*/
   UCHAR           Int13PriClass; // These are variables used by the VDM                /*@V192176*/
   UCHAR           Int13PriLevel;                                   /*@V192176*/
   ULONG           Int13pTCB;                                       /*@V192176*/
   ULONG           Int13hvdm;                                       /*@V192176*/
   ULONG           Int13IRQCtxHook;                                 /*@V192176*/
   USHORT          Int13IRQPending;                                 /*@V192176*/
                                                                    /*@V192176*/
   ULONG           Reserved[10];                                    /*@V192176*/
                                                                    /*@V192176*/
   _KMREGS         Int13Regs;     // Register set passed to the BIOS in V86 mode        /*@V192176*/
                                                                    /*@V192176*/
} VDMINT13CB;                                                       /*@V192176*/

#endif                                                              /*@V154814*/
