/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = src/dev/dasd/cdrom/ibm1s506/s506pro.h, idskflt, c.basedd 99/01/18 */
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506PRO.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : C Function Prototype statements
 *
 * Purpose:
 *
 *
 *
*//*
 * Edit History for defect # 148406:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 05-10-95  Integrated changes Shishir Shah made to original 2.1 version
 *                 of IBM1S506 driver to implement block mode and slave DMA. In
 *                 this file it involved the addition of the CheckSystemDMA()
 *                 function that returns the system DMA type (B or F) to the
 *                 caller. /jlh
 * [002] 06-06-95  Implement Bus Master IDE DMA support. /jlh
 *      1) Add PCI function definitions required for Bus Master.
 *      2) Modify definition for CheckSystemDMAType()
 * [003] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 * [004] 03-19-96  Add function definition for GetEzDriveGeometry. /jlh
*/

#include "APMCALLS.H"                                               /*@V149971*/
#include "PCMCIA.H"                                                 /*@V155162*/


/*--------------------*/
/* Strategy 1 Router  */
/*--------------------*/

 VOID   NEAR S506Str1();
 VOID   NEAR StatusError(PRPH pRPH, USHORT ErrorCode);

/*----------------------------------------------------------------------------*
 * S506IORB.C - IORB Queueing Entry Point                                     *
 *----------------------------------------------------------------------------*/
VOID NEAR GetDeviceTable(NPACB npACB, PIORB pNewIORB);              /*@V108783*/
VOID NEAR FillUnitInfo( NPACB npACB,                               // @V178285
                        USHORT adapterIndex,                       // @V178285
                        USHORT unitIndex,                          // @V178285
                        USHORT lunIndex,                           // @V178285
                        PUNITINFO pUI );                           // @V178285
VOID NEAR CompleteInit(NPACB npACB);
VOID NEAR AllocateUnit(NPACB npACB);
VOID NEAR DeallocateUnit(NPACB npACB);
VOID NEAR ChangeUnitInfo( NPACB npACB );
VOID NEAR GetGeometry(NPACB npACB);
VOID NEAR GetUnitStatus( NPACB npACB, USHORT Status );              /*@V162789*/
VOID NEAR GetQueueStatus( NPACB npACB, PIORB pIORB );              /*@V87325*/
VOID NEAR GetUnitResources( NPACB npACB );                         /*@V87325*/
VOID NEAR CmdNotSupported(NPACB npACB);
USHORT NEAR NextIORB(NPACB npACB, NPHWRESOURCE npHWR);              /*@V147576*/
VOID FAR  _loadds ADDEntryPoint( PIORBH pNewIORB );
VOID NEAR IORBDone(NPACB npACB, PIORB pIORB );                      /*@V147576*/
VOID NEAR PreProcessedIORBDone( PIORB pIORB );                      /*@V147576*/
VOID NEAR GetChangeLine( NPACB npACB );                             /*@V149971*/
VOID NEAR GetMediaSense( NPACB npACB );                             /*@V149971*/
VOID NEAR GetLockStatus( NPACB npACB );                             /*@V149971*/
VOID NEAR LockMedia( NPACB npACB );                                 /*@V149971*/
VOID NEAR UnLockMedia( NPACB npACB );                               /*@V149971*/
VOID NEAR EjectMedia( NPACB npACB );                                /*@V149971*/

void outpd(USHORT port,ULONG val);                                  /*@V151345*/
UCHAR FindDevice(USHORT DeviceID, USHORT VendorID, USHORT Index);   /*@V151345*/
UCHAR GetBiosInfo(PPCI_DATA pPCIDataPkt);                           /*@V151345*/
BOOL PciSetReg(NPPCI_INFO npPCIInfo, UCHAR ConfigReg, ULONG val,USHORT size);
UCHAR  PciGetReg(NPPCI_INFO npPCIInfo, UCHAR ConfigReg);            /*@V151345*/

/*------------------------*/
/* Interrupt Entry Points */
/*------------------------*/

USHORT FAR  FixedIRQ0(VOID);
USHORT FAR  FixedIRQ1(VOID);
USHORT FAR  FixedIRQ2(VOID);                                       /*@V87325*/
USHORT FAR  FixedIRQ3(VOID);                                       /*@V87325*/
USHORT NEAR FixedInterrupt(NPACB npACB);


/*----------------------------------------------------------------------------*
 *      S506TIMR.C Timer Routines                                             *
 *----------------------------------------------------------------------------*/
VOID   FAR  IRQTimer( ULONG TimerHandle, PACB pACB, ULONG Unused  );
VOID   FAR  DelayedRetry(ULONG hRetryTimer, PACB pACB, ULONG Unused);
VOID   FAR  DelayedReset(ULONG hResetTimer, PACB pACB, ULONG Unused);
VOID   FAR  ElapsedTimer( ULONG hElapsedTimer, ULONG Unused1, ULONG Unused2);
VOID   NEAR IODelay( VOID );                                        /*@V149971*/

/*----------------------------------------------------------------------------*
 *      S506SM.C Procedures (State Machine)                                   *
 *----------------------------------------------------------------------------*/
VOID   NEAR StartSM(NPACB npACB);                                   /*@V147576, renamed */
VOID   NEAR StartState(NPACB npACB);
VOID   NEAR StartIO(NPACB npACB);                                   /*@V147576, renamed */
VOID   NEAR RetryState(NPACB npACB);
VOID   NEAR InterruptState(NPACB npACB);
VOID   NEAR DoneState(NPACB npACB);
VOID   NEAR ErrorState(NPACB npACB);
USHORT NEAR StartOtherIO(NPACB npACB);
USHORT NEAR InitACBRequest(NPACB npACB);
BOOL   NEAR SetupFromATA(NPACB npACB, NPUCB npUCB);                 /*@V151345 SRD*/
BOOL   NEAR SetupSeek( NPACB npACB, NPUCB npUCB );                  /*@V162789*/
VOID   NEAR InitBlockIO(NPACB npACB);
USHORT NEAR StartBlockIO(NPACB npACB);
USHORT NEAR DoBlockIO(NPACB npACB, USHORT cSec);
VOID   NEAR DoOtherIO(NPACB npACB );
VOID   NEAR SetIOAddress(NPACB npACB);
VOID   NEAR SetRetryState(NPACB npACB);
VOID   NEAR DoReset(NPACB npACB);
VOID   NEAR ResetCheck( NPACB npACB );
USHORT NEAR GetDiagResults( NPACB npACB, PUCHAR Status );           /*@V195085*/

USHORT NEAR CheckReady(NPACB npACB);
USHORT NEAR WaitDRQ(NPACB npACB);
VOID   NEAR UpdateBlockIOPtrs(NPACB npACB);
USHORT NEAR SendCmdPacket(NPACB npACB);
USHORT NEAR SendReset(NPACB npACB);
USHORT NEAR GetErrorReg(NPACB npACB, USHORT UnitID);
VOID   NEAR SelectUnit( NPACB npACB, USHORT UnitId );
USHORT NEAR GetStatusReg( NPACB npACB );
VOID        SendAckMediaChange( NPACB npACB );                      /*@V157085*/
USHORT NEAR MapError(NPACB npACB);
VOID   NEAR StopBMDMA( NPACB npACB );                               /*@V179942*/
VOID   NEAR ClearBMISTA_INT( USHORT data, NPACB npACB );            /*@V179942*/
VOID   NEAR ClearBMISTA_error( USHORT data, NPACB npACB );          /*@V179942*/
BOOL   NEAR OurPCIInterrupt( NPACB npACB );                         


VOID   NEAR EnableIDEPort();
VOID   NEAR InitializeIDEPort();

UCHAR PciGetRegMech1(USHORT regmask,UCHAR index);             /* vvv, @V151345*/
UCHAR PciGetRegMech2(USHORT regmask,UCHAR index);
void PciSetRegMech2(USHORT regmask,UCHAR index,ULONG val,USHORT size);
void PciSetRegMech1(USHORT regmask,UCHAR index,ULONG val,USHORT size);
                                                                                                                          /* ^^^, @V151345*/

/*----------------------------------------------------------------------------*
 *      S506CSUB.C Utility Functions                                          *
 *----------------------------------------------------------------------------*/
VOID   NEAR setmem( PBYTE d, USHORT c, USHORT len );
VOID   NEAR memcpy( PBYTE d, PBYTE s,  USHORT len );
VOID   NEAR strnswap( PSZ d, PSZ s, USHORT n );                     /*@V153916*/
BOOL   NEAR strncmp( PUCHAR s1, PUCHAR s2, USHORT n );              /*@V155162*/
USHORT NEAR strlen( PSZ s );                                        /*@V155162*/

                                                                   /*@V117508*/
                                                                   /*VVVVVVVV*/
/*----------------------------------------------------------------------------*
 *      S506PS2.C Utility Functions                                           *
 *----------------------------------------------------------------------------*/
#ifdef MCA
USHORT Get_IDE_LID ( NPATBL npAT, PMACHINE_CONFIG_INFO pMCHI );
USHORT NEAR MCA_IDE_Generated_IRQ ( NPACB npACB );
USHORT NEAR Lacuna_IDE_Generated_IRQ ( NPACB npACB );
VOID   NEAR MCA_IRQ_Status_Clear ( NPACB npACB );
VOID   NEAR Clear_IDE_IRQ_Status_Bit ( NPACB npACB );
#endif
BOOL NEAR SetupPS2IDEPort( USHORT BasePort, SHORT OnOff );          /*@V147576*/
VOID NEAR SetPS2DiskLight( USHORT On );
                                                                   /*AAAAAAAA*/
                                                                   /*@V117508*/

/*----------------------------------------------------------------------------*
 *      S506INIT.C Procedures                                                 *
 *----------------------------------------------------------------------------*/

typedef VOID (NEAR *NPCV)();

VOID   NEAR DriveInit(PRPINITIN pRPH );
USHORT NEAR ConfigureController( NPATBL npAT );
USHORT NEAR CheckController( NPATBL npAT );
USHORT NEAR CheckCylinderLReg( NPATBL npAT, USHORT UnitId );
USHORT NEAR CheckCylinderLRegs( NPATBL npAT );                      /*@V147576*/
VOID   NEAR CalibrateTimers( NPACB npACB );
ULONG  NEAR CalibrateWorker( NPACB npACB, NPCV npWorker );
VOID   FAR  CalibrateTimer( ULONG hCalibrateTimer, ULONG Unused1, ULONG Unused2 );
VOID   NEAR EnableIDEPort();
USHORT NEAR ConfigureATAUnit( NPATBL npAT, USHORT UnitId );        /*@V87325*/
USHORT NEAR GetReg( NPACB npACB, USHORT Reg );                     /*@V87325*/
USHORT NEAR CheckForATAPISignature( NPATBL npAT, USHORT UnitId );  /*@V87325*/
USHORT NEAR DoATAPIPresenseCheck( NPATBL npAT, USHORT UnitId );    /*@V87325*/
USHORT NEAR ATAPIReset( NPACB npACB );                             /*@V87325*/
USHORT NEAR ReadDrive( NPACB npACB, USHORT UnitId, ULONG RBA,       /*@V108555*/
                       USHORT Retry, PBYTE pBuf );                  /*@V108555*/
USHORT NEAR DoIdentify( NPATBL npAT, USHORT UnitId, NPIDENTIFYDATA npID );
VOID   NEAR ResetController( NPACB npACB );
VOID   FAR  NotifyIORBDone(PIORB pIORB);
USHORT NEAR ScanForOtherADDs(VOID);
VOID   FAR  InitPost(PIORB pIORB);
VOID   NEAR CheckACBViable( NPATBL npAT );                           /*@V90963*/
USHORT NEAR ParseCmdLine( PDDD_PARM_LIST pADDParms, NPATBL npAT, USHORT SystemDMAType );
VOID   NEAR PrintInfo( NPATBL Buf );
USHORT NEAR CheckSMSEnable(VOID);                                   /*@V108555*/
VOID   NEAR TTYWrite( PSZ Buf );
USHORT NEAR AllocAdapterResources( NPATBL npAT);                     /*@V98451*/
VOID   NEAR DeallocAdapterResources( NPATBL npAT);                   /*@V98451*/
VOID   NEAR AssignResources();                                       /*@V98451*/
BOOL   NEAR ConfigureATAPIDevice( NPATBL npAT, USHORT UnitId );     /*@V162970*/
NPATBL NEAR LocateATEntry( USHORT BasePort );                       /*@V153620*/
VOID   NEAR UpdateATTable( PRESOURCELIST pResourceList );           /*@V153620*/
VOID   NEAR FindDetected( BOOL CompatableID );                      /*@V153620*/
VOID   NEAR ProcessVerboseTimings( NPUCB npUCB, NPATBL npAT, PUCHAR s2,
                                                PUCHAR s3 );        /*@V179942*/
VOID   NEAR GetDeviceULTRAMode( NPUCB npUCB, NPIDENTIFYDATA npID ); /*@V179942*/
VOID   NEAR GetDeviceDMAMode( NPUCB npUCB, NPIDENTIFYDATA npID, NPATBL npAT); /*@V179942*/
VOID   NEAR GetDevicePIOMode( NPUCB npUCB, NPIDENTIFYDATA npID );   /*@V179942*/
VOID   NEAR UCBSetupDMAPIO( NPIDENTIFYDATA npID, NPATBL npAT, NPUCB npUCB,
                            USHORT WDIDValid);                     /*@V179942*/
USHORT NEAR IdentifyDevice( NPATBL npAT, USHORT UnitId,
                                     NPIDENTIFYDATA npID, USHORT ATAPIDevice ); /*@V179942*/
USHORT NEAR GetUltraDMAMode( USHORT CurDMAMode );                   
VOID   NEAR ChkifDPT_Present( VOID );                               
VOID   NEAR CountTheUnit( NPATBL npAT );                            
VOID   NEAR FinalReadVerify( VOID );                                
VOID   NEAR NoMasterStatusCountUnit( NPATBL npAT );                 
VOID   NEAR LoopConfigureATAPI( NPATBL npAT, UCHAR j, UCHAR CkForce );
VOID   NEAR CkAdapters4Units( USHORT DriveID );                     

/*----------------------------------------------------------------------------*
 *      S506PRTF.C Procedures                                                 *
 *----------------------------------------------------------------------------*/

VOID  NEAR  sprntf( PSZ s, PSZ fmt, ... );

/*----------------------------------------------------------------------------*
 *      S506OSM2.C Procedures                                                 *
 *----------------------------------------------------------------------------*/

typedef PIORB FAR *PPIORB;                                         /*@V87325*/

VOID   NEAR SuspendState( NPACB npACB );                            /*@V147576*/
VOID   NEAR Suspend( NPACB npACB );                                 /*@V147576*/
VOID   NEAR SuspendIORBReq( NPACB npACB, PIORB pIORB );             /*@V147576*/
VOID   NEAR ResumeIORBReq( NPACB npACB, PIORB pIORB );             /*@V87325*/
USHORT FAR  ActivateACB( NPACB npACB );                            /*@V87325*/
VOID   FAR  DeactivateACB( NPACB npACB );                          /*@V87325*/
PIORB  NEAR PreProcessIORBs( NPACB npACB, NPUCB npUCB, PPIORB ppFirstIORB );    /*@V87325*/
VOID   NEAR RemoveIORB( PIORB pIORB, PIORB pIORBPrev,              /*@V87325*/
                        PPIORB pIORBFirst );                       /*@V87325*/
USHORT NEAR AllocateHWResources( NPACB npACB );                     /*@V147576*/
NPACB  NEAR FreeHWResources( NPACB npACB );                         /*@V147576*/

/*----------------------------------------------------------------------------*
 *      S506APM.C Procedures                                                  *
 *----------------------------------------------------------------------------*/
USHORT FAR  APMEventHandler( PAPMEVENT Event );                     /*@V149971*/
USHORT NEAR APMSuspend( VOID );                                     /*@V149971*/
USHORT NEAR APMResume( VOID );                                      /*@V149971*/
USHORT NEAR ReConfigureController( NPATBL npAT );                   /*@V149971*/
USHORT NEAR ReConfigureUnit( NPATBL npAT, USHORT UnitId );          /*@V149971*/
VOID   NEAR PCMCIASetup( VOID );                                    /*@V155162*/
USHORT NEAR CardInsertion( USHORT );                                /*@V155162*/
USHORT NEAR CardRemoval( USHORT );                                  /*@V155162*/

/*----------------------------------------------------------------------------*
 *      S506OEM.C Procedures                                                  *
 *----------------------------------------------------------------------------*/

/*---------------------------------------------*/                   /*@V129765*/
/* PCI Prototypes                              */                   /*@VVVVVVV*/
/*---------------------------------------------*/

BOOL NEAR PresenseCheckPCI( NPATBL npAT, PCI_DEVICE PCIDev );
BOOL NEAR ReadPCIConfigSpace( NPPCI_INFO npPCIInfo, UCHAR ConfigReg,
                              PULONG Data, USHORT Size );
BOOL NEAR WritePCIConfigSpace( NPPCI_INFO npPCIInfo, UCHAR ConfigReg,
                               ULONG Data, UCHAR Size );            /*@V151345*/
BOOL NEAR FindPCIDevice( NPPCI_INFO npPCIInfo, PCI_DEVICE PCIDev );
VOID NEAR ScanPCIBaseRegs( NPPCI_INFO npPCIInfo,
                           USHORT BasePort, PCI_DEVICE PCIDev );    /*@VAAAAAA*/
BOOL NEAR ConfigurePCI( NPACB npACB, USHORT InPhase );              /*@V129765*/

/*---------------------------------------------*/
/* DPT Prototypes                              */
/*---------------------------------------------*/

UCHAR DPT_Present ();                                             /*@V106915*/

/*---------------------------------------------*/                   /*@V147576*/
/* CMD Prototypes                              */                   /*@V147576*/
/*---------------------------------------------*/                   /*@V147576*/
                                                                    /*@V147576*/
BOOL  FAR CMD640_0_InitComplete( NPACB npACB );                     /*@V147576*/
SHORT FAR CMD640_0_PortState( NPATBL npAT );                        /*@V147576*/
SHORT FAR CMD640_0_TurnPort( NPATBL npAT, SHORT OnOff );            /*@V147576*/

USHORT NEAR CheckSystemDMAType ( NPATBL );/* [001][002.2] get system DMA type B or F */

/* [003] delete PCI function prototypes as IBM has defined new */
/*       standard ones. */
int GetInquiryData( NPUCB npUCB, PBYTE pBuffer , USHORT Buffersize);/*@V151345*/

/*----------------------------------------------------------------*//*@V179942*/
/*      S506PIIX.C Procedures                                     *//*@VVVVVVV*/
/*----------------------------------------------------------------*/
VOID   NEAR SetupPCIChips( VOID );                                  /*@V182487*/
VOID   NEAR CalculateAdapterTiming( NPACB npACB, USHORT piix_Level,
                                                 USHORT uCable );
USHORT NEAR ProgramPIIXChip( NPACB npACB, NPATBL npAT, USHORT i,
                                          USHORT piix_Level );
VOID   NEAR SetDeviceDMAMode( USHORT j, NPATBL npAT, NPACB npACB,
                                        USHORT piix_Level );
VOID   NEAR SetDevicePIOMode( USHORT j, NPATBL npAT, NPACB npACB );
VOID   NEAR SetDMAcapableBits( NPACB npACB );

BOOL   NEAR AllocateBMSGL( NPACB npACB );                           /*@V159438*/

VOID   NEAR DeviceTimingMode( USHORT i, NPACB npACB );
VOID   NEAR TimeRegBaseValue( USHORT i, USHORT j, USHORT PIOSetting,
                                        USHORT PCIClockIndex, NPACB npACB );
VOID   NEAR SelectDeviceTiming( USHORT i, NPACB npACB, USHORT PIIXLevel );
VOID   NEAR ForceComptMode( USHORT i, NPACB npACB );                /*AAAAAAAA*/
VOID   NEAR DisableAdapterBMDMA( NPATBL npAT, NPACB npACB );        /*@V179942*/

USHORT NEAR DeterminePCIChips( USHORT SystemType );                 
VOID   NEAR Channels( UCHAR i, UCHAR PCIType );                     
VOID   NEAR Search4PCIChips();                                      
USHORT NEAR CheckIfPCIPresent( NPATBL npAT, PCI_DEVICE PCIDev, USHORT index );
VOID   NEAR CkandValidateChannels();
USHORT NEAR TurnOffPCI( NPATBL npAT );                              
VOID   NEAR CkIf2ndOR3rdController();
USHORT NEAR AdjustIfPIIXFound( USHORT SystemType );
ULONG  NEAR DriveBitsSet( USHORT i, NPACB npACB,                    
                          ULONG PCIData, USHORT UltraMode );        
VOID   NEAR AdjustUDMA( ULONG PCIData, USHORT i, NPACB npACB, USHORT piix_Level );   
VOID   NEAR AdjustDrive4PIIX4( NPACB npACB );                       
VOID   NEAR Adjustfor82801( NPACB npACB, USHORT piix_Level );       
VOID   NEAR GetCMDBaseAddress( NPATBL npAT, USHORT channel );       
UCHAR  NEAR GetPCIIntLine( NPPCI_INFO PCIInfo );                    
BOOL   NEAR NativeOrLegacyMode( NPATBL npAT, UCHAR PCIType );       
BOOL   NEAR NativePCIIDE( NPATBL npAT );                            
VOID   NEAR SetIRQ_Shared_bits( USHORT IRQLevel );                  
USHORT NEAR GetIRQSharedBit( USHORT IRQLevel );                     
BOOL   NEAR CopyChannelPCIInfo( NPATBL npAT, USHORT channel );      
VOID   NEAR GetBaseAddresses( UCHAR PCIType, USHORT channel, NPATBL npAT ); 
VOID   NEAR BusMasterBaseAddress( NPATBL npAT, USHORT channel );    
USHORT NEAR ProgramPCIChip( NPACB npACB, NPATBL npAT, USHORT i, USHORT piix_Level ); 
USHORT NEAR ProgramCMDPCI( NPACB npACB, NPATBL npAT, USHORT piix_Level);             /*@VXXXXX*/
USHORT NEAR ProgramVIAPCI( NPACB npACB, NPATBL npAT, USHORT i, USHORT piix_Level);
USHORT NEAR ProgramSISPCI( NPACB npACB, NPATBL npAT, USHORT piix_Level, USHORT i);
VOID   NEAR AdjustVIAUDMA( NPACB npACB, USHORT VIA_Level);
VOID   NEAR AdjustSiSUDMA( NPACB npACB, USHORT SiS_level);
VOID   NEAR CalculateVIATiming( NPACB npACB, USHORT i);
VOID   NEAR SetVIATimings(USHORT i, USHORT j ,NPACB npACB);
VOID   NEAR CheckUDMACableSiS( NPACB npACB, NPATBL npAT,USHORT j);
VOID   NEAR SetUDMA2UDMA33( NPACB npACB, UCHAR channel );           /*@VXXXXXX*/
VOID   NEAR CkAdj4UDMACableCMD( NPACB npACB, NPATBL npAT );         /*@VXXXXXX*/
/*---------------------------------------------------------------*   *@V192176*
 *      S506GEOM.C Procedures                                    *   *@V192176*
 *---------------------------------------------------------------*/ /*@V192176*/
                                                                    /*@V192176*/
USHORT NEAR    DetermineUnitGeometry(                               /*@V192176*/
   NPATBL         npAT,                                             /*@V192176*/
   USHORT         UnitId );                                         /*@V192176*/
BOOL NEAR      IdentifyGeometryGet(                                 /*@V192176*/
   NPATBL         npAT,                                             /*@V192176*/
   USHORT         UnitId );                                         /*@V192176*/
VOID NEAR      IDEGeomExtract(                                      /*@V192176*/
   NPGEOMETRY     npIDEGeom,                                        /*@V192176*/
   NPIDENTIFYDATA npId,                                             
   NPUCB          npUCB );                                          
BOOL NEAR      LogGeomCalculate(                                    /*@V192176*/
   NPGEOMETRY     npLogGeom,                                        /*@V192176*/
   GEOMETRY       PhysGeom );                                       /*@V192176*/
BOOL NEAR      LogGeomCalculateLBAAssist(                           /*@V192176*/
   NPGEOMETRY     npLogGeom,                                        /*@V192176*/
   GEOMETRY       PhysGeom );                                       /*@V192176*/
BOOL NEAR      LogGeomCalculateBitShift(                            /*@V192176*/
   NPGEOMETRY     npLogGeom,                                        /*@V192176*/
   GEOMETRY       PhysGeom );                                       /*@V192176*/
BOOL NEAR      Int13GeometryGet(                                    /*@V192176*/
   NPATBL         npAT,                                             /*@V192176*/
   USHORT         UnitId );                                         /*@V192176*/
VOID NEAR      GetFixedTableGeometry(                               /*@V192176*/
   NPATBL         npAT,                                             /*@V192176*/
   USHORT         UnitId );                                         /*@V192176*/
BOOL NEAR      BPBGeometryGet(                                      /*@V192176*/
   NPATBL         npAT,                                             /*@V192176*/
   USHORT         UnitId );                                         /*@V192176*/
BOOL NEAR      ReadAndExtractBPB(                                   /*@V192176*/
   NPACB          npACB,                                            /*@V192176*/
   USHORT         UnitId,                                           /*@V192176*/
   ULONG          partitionBootRecordSectorNum,                     /*@V192176*/
   NPGEOMETRY     npLogGeom );                                      /*@V192176*/
USHORT NEAR    VerifyEndOfMedia(                                    /*@V192176*/
   NPATBL         npAT,                                             /*@V192176*/
   USHORT         UnitId,                                           /*@V192176*/
   NPGEOMETRY     npGEOC,                                           /*@V192176*/
   PULONG         MaxSec );                                         /*@V192176*/
BOOL NEAR      PhysGeomValidate(                                    /*@V192176*/
   GEOMETRY       Geom );                                           /*@V192176*/
BOOL NEAR      LogGeomValidate(                                     /*@V192176*/
   GEOMETRY       Geom );                                           /*@V192176*/
BOOL NEAR      IDStringsExtract(                                    /*@V192176*/
   NPUTBL         npUT,                                             /*@V192176*/
   NPIDENTIFYDATA npID );                                           /*@V192176*/
BOOL NEAR      MediaStatusEnable(                                   /*@V192176*/
   NPACB          npACB,                                            /*@V192176*/
   NPUCB          npUCB,                                            /*@V192176*/
   USHORT         UnitId,                                           /*@V192176*/
   NPIDENTIFYDATA npID );                                           /*@V192176*/
BOOL NEAR      MultipleModeEnable(                                  /*@V192176*/
   NPACB          npACB,                                            /*@V192176*/
   NPUCB          npUCB,                                            /*@V192176*/
   NPUTBL         npUT,                                             /*@V192176*/
   NPIDENTIFYDATA npID );                                           /*@V192176*/
BOOL NEAR      LBAModeEnable(                                       /*@V192176*/
   NPACB          npACB,                                            /*@V192176*/
   NPUCB          npUCB,                                            /*@V192176*/
   NPUTBL         npUT,                                             /*@V192176*/
   NPIDENTIFYDATA npID );                                           /*@V192176*/
USHORT NEAR    CalcONTRACKGeometry(                                 /*@V192176*/
   NPUTBL         npUT,                                             /*@V192176*/
   NPUCB          npUCB );                                          /*@V192176*/
USHORT NEAR    DriveTypeToGeometry(                                 /*@V192176, moved*/
   USHORT         DriveType,                                        /*@V192176, moved*/
   NPGEOMETRY     npGEO,                                            /*@V192176, moved*/
   NPUSHORT       npWrtPreCmp );                                    /*@V192176, moved*/
                                                                    /*@V192176*/
/*---------------------------------------------------------------*   *@V192176*
 *      S506I13.C Procedures                                     *   *@V192176*
 *---------------------------------------------------------------*/ /*@V192176*/
                                                                    /*@V192176*/
BOOL NEAR VDMInt13Create( VOID );                                   /*@V192176*/
VOID NEAR VDMInt13Destroy( VOID );                                  /*@V192176*/
BOOL NEAR Int13CheckExtensionsPresent( NPUTBL npUT );               /*@V192176*/
BOOL NEAR Int13Fun08GetLogicalGeom( NPUTBL npUT );                  /*@V192176*/
BOOL NEAR Int13DoRequest( VOID );                                   /*@V192176*/
VOID NEAR _loadds VDMInt13CallBack( VOID );                         /*@V192176*/
VOID NEAR StubVDMInt13CallBack( VOID );                             /*@V192176*/
