/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = src/dev/dasd/cdrom/ibm1s506/s506oem.h, idskflt, c.basedd 98 */
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506OEM.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Locally defined equates.
 *
 * Purpose:
 *
 *
 *
 *
 *
*//*
 * Edit History for defect # 148406:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 *
 * [002] 09-30-95  Moved SMART/other IOCTL definitions to this file. /jlh
 *
 * [003] 11-14-95  Rearranged counter and unit information structures
 *                 to move all counters into counter structure. /jlh
 *
 * [004] 11-29-95  Added constants for second PIIX & PIIX3 bus master IDE
 *                 controlers. Bumped up MAX_PCI_DEVICE_DESCRIPT. /mol
 *
 * [005] 04-12-96  Add code to check for valid buffers being passed. /jlh
 *
*/


/*---------------------------------------------*/
/* EISA Defines                                */
/*---------------------------------------------*/

#define EISA_READ           0x04

#define EISA_SUCCESSFUL     0

#define MAX_EISA_SLOT       16

#define  DPT_EISA_ID     0x1412L
#define  ATT_EISA_ID     0x249406L
#define  NEC_EISA_ID     0x82A338L

#define  BUS_MCA         3                                              /*@V154573*/
#define  BUS_EISA        1                                              /*@V154573*/
#define  BUS_PCI         2                                              /*@V154573*/
#define  BUS_UNKNOWN     0                                              /*@V154573*/

/*-------------------------------*/
/* EISA Structures               */
/* -----------------             */
/*                               */
/*                               */
/*-------------------------------*/

typedef struct _EISA_PARM {
   UCHAR SubFunction;
   UCHAR SlotNumber;
   UCHAR Function;
} EISA_PARM;

typedef struct _EISA_DATA {
   UCHAR bReturn;
   UCHAR RCFlags;
   UCHAR MajorRev;
   UCHAR MinorRev;
   UCHAR CS_LSB;
   UCHAR CS_MSB;
   UCHAR NumDeviceFuncs;
   UCHAR CombinedFIB;
   ULONG CompressedID;
} EISA_DATA, FAR *PEISA_DATA;


/*---------------------------------------------*/
/* PCI Defines                                 */
/*---------------------------------------------*/

#define PCI_FUNC            0x0b                                   /*@V119250*/
#define PCI_GET_BIOS_INFO   0                                      /*@V119250*/
#define PCI_FIND_DEVICE     1                                      /*@V119250*/
#define PCI_FIND_CLASS_CODE 2                                      /*@V119250*/
#define PCI_READ_CONFIG     3                                      /*@V119250*/
#define PCI_WRITE_CONFIG    4                                      /*@V119250*/

#define PCI_SUCCESSFUL           0                                 /*@V119250*/

#define MAX_PCI_CONFIG_OPS     133          /*@V153620*//*@V156660*/
#define MAX_PCI_BASE_REGS        4                                  /*@VVVVVVV*/
#define MAX_PCI_DEVICES         32      /* max per system */
#define MAX_PCI_FUNCTIONS        8      /* max per device */


/*---------------------------------*/
/*                                 */
/* PCI Configuration Regs          */
/*                                 */
/*---------------------------------*/

#define PCIREG_VENDOR_ID        0x00
#define PCIREG_DEVICE_ID        0x02
#define PCIREG_COMMAND          0x04
#define PCIREG_STATUS           0x06
#define PCIREG_CLASS_CODE       0x08
#define PCIREG_IO_BASE          0x10
#define PCIREG_MEMORY_BASE      0x14
#define PCIREG_INT_LINE         0x3C

/*-----------------------------------*/
/* PCI Configuration Register values */
/*-----------------------------------*/

#define PCI_MASS_STORAGE        0x01    /* PCI Base Class code */
#define PCI_IDE_CONTROLLER      0x01    /* PCI Sub Class code  */
#define PCI_IDE_NATIVE_IF1      0x01
#define PCI_IDE_NATIVE_IF2      0x04

/*
** Indices into the PCIDevice[] array of supported PCI devices,
** defined in s506data.c.
*/
#define PCID_CMD640_0       0  /* First CMD640 */                   /*@VAAAAAA*/
#define PCID_RZ1000_0       1  /* First RZ1000 */                   /*@V129765*/
#define PCID_INTEL82371FB   2  /* [003] Add Intel BM PCI */
#define PCID_PIIX3          3  /* [004] Intel PIIX3 IDE */
#define PCID_SECOND_PIIX    4  /* [004] Second Intel PIIX */
#define PCID_INTEL_ORION    5                                       /*@V156660*/
#define PCID_PIIX4          6  /* Intel PIIX4 IDE */                /*@V179942*/
#define PCID_PIIX4_1        7  /* Intel PIIX4 IDE Index 1 */        /*@V182487*/
#define PCID_82801AA        8  /* Intel 82801AA IO HUB */           
#define PCID_82801AA_1      9  /* Intel 82801AA IO HUB Index 1 */   
#define PCID_82801AB       10  /* Intel 82801AB IO HUB */           
#define PCID_82801AB_1     11  /* Intel 82801AB IO HUB Index 1 */   
#define PCID_82801BA_1     12  /* Intel 82801BA IO HUB */           
#define PCID_82801BA_1_1   13  /* Intel 82801BA IO HUB Index 1 */   
#define PCID_82801BA_2     14  /* Intel 82801BA IO HUB */           
#define PCID_82801BA_2_1   15  /* Intel 82801BA IO HUB Index 1 */   
#define PCID_82801BA_3     16  /* Intel 82801BA IO HUB */           
#define PCID_82801BA_3_1   17  /* Intel 82801BA IO HUB Index 1 */   
#define PCID_82801BA_4     18  /* Intel 82801BA IO HUB ICH3Mobile*/ 
#define PCID_82801BA_4_1   19  /* Intel 82801BA IO HUB Index 1 */   
#define PCID_82801BA_5     20  /* Intel 82801BA IO HUB ICH3Desktop*/
#define PCID_82801BA_5_1   21  /* Intel 82801BA IO HUB Index 1 */   
#define PCID_CMD646        22  /* CMD646 PCI 2 IDE         */       
#define PCID_CMD646_1      23  /* CMD646 PCI 2 IDE Index 1 */       
#define PCID_CMD648        24  /* CMD648 PCI 2 IDE         */       
#define PCID_CMD648_1      25  /* CMD648 PCI 2 IDE Index 1 */       
#define PCID_VIA596        26  /* VIA596 PCI 2 IDE    */            
#define PCID_VIA596_1      27  /* VIA596 PCI 2 IDE Index 1 */       
#define PCID_SIS630        28  /* SIS630 PCI 2 IDE    */            
#define PCID_SIS630_1      29  /* SIS630 PCI 2 IDE Index 1 */       



#define MAX_PCI_DEVICE_DESCRIPT  PCID_SIS630_1+1                      /*@VXXXXXX*/

/*----------------------------------------------------------------*//*@V179942*/
/* Defines for PIIX_level            PCI Config Device IDs        *//*VVVVVVVV*/
/*                                        func0  func1            */
/*----------------------------------------------------------------*/
#define NOPIIX              0
#define PIIX                1   /* PIIX    122Eh  1230h Triton  */
#define PIIX3               2   /* PIIX3   7000h  7010h         */
#define PIIX4               3   /* PIIX4   7110h  7111h  ATA33  */  
#define I82801AA            4   /* ICH     2410h  2411h  ATA66  */  
#define I82801AB            5   /* ICH0    2420h  2421h  ATA33  */  
#define I82801BA_1          6   /* ICH2    2440h  2441h  ATA66  */  
#define I82801BA_2          7   /* Mobile  2440h  244Ah  ATA100 */  
#define I82801BA_3          8   /* HighEnd 2440h  244Bh  ATA100 */  
#define I82801BA_4          9   /* Mobile  248Ch  248Ah  ATA100 */  
#define I82801BA_5         10   /* Desktop 2480h  248Bh  ATA100 */  
#define CMD646             11   /* CMD646  0646h         ATA33  */  
#define CMD648             12   /* CMD648  0648h         ATA66  */  
#define VIA586             13   /* VIA596  0586h  0571h         */  
#define VIA596             14   /* VIA596  0596h  0571h         */  
#define VIA686             15   /* VIA596  0686h  0571h         */  
#define SIS630             16   /* SIS630         5513h         */  

#define MAXPIIXSEARCH      32   /* max # of chips 2 search 4    */  

/*----------------------------------------------------------------*/
/* PIIX PCI to IDE Bridge Device IDs                              */
/*----------------------------------------------------------------*/
#define      PIIX_PCIIDE_DEV_ID  0x1230
#define     PIIX3_PCIIDE_DEV_ID  0x7010                              /*AAAAAAAA*/
#define     PIIX4_PCIIDE_DEV_ID  0x7111                              /*@V179942*/
#define  I82801AA_PCIIDE_DEV_ID  0x2411                              
#define  I82801AB_PCIIDE_DEV_ID  0x2421                              
#define I82801BA1_PCIIDE_DEV_ID  0x2441                              
#define I82801BA2_PCIIDE_DEV_ID  0x244A                              
#define I82801BA3_PCIIDE_DEV_ID  0x244B                              
#define I82801BA4_PCIIDE_DEV_ID  0x248A                              
#define I82801BA5_PCIIDE_DEV_ID  0x248B                              
#define    CMD646_PCIIDE_DEV_ID  0x0646                              
#define    CMD648_PCIIDE_DEV_ID  0x0648                              /*@VXXXXX*/
#define    VIA596_PCIIDE_DEV_ID  0x0571                              
#define    SIS630_PCIIDE_DEV_ID  0x5513                              



/*----------------------------------------------------------------*/
/* PCI Vendor IDs                                                 */
/*----------------------------------------------------------------*/
#define INTEL_PCI_VEND_ID  0x8086                                 
#define CMD_PCI_VEND_ID    0x1095                                 
#define VIA_PCI_VEND_ID    0x1106                                 
#define SIS_PCI_VEND_ID    0x1039                                 


#define IDETIM_IDE           0x8000    /* IDE Decode Enable bit */  /*@V179942*/

/*
** Define PCI Configuration space access locations.
*/
#define PCI_CONFIG_ADDRESS   0x0CF8                                 /*@V153743*/
#define PCI_CONFIG_DATA      0x0CFC                                 /*@V153743*/

/*-------------------------------*/                                 /*VVVVVVVV*/
/* PCI Structures                */                                 /*@V119250*/
/* -----------------             */
/*                               */
/*                               */
/*-------------------------------*/

typedef struct _PCI_IDENT {                                         /*@V129765*/
   USHORT     Device;                                               /*@V129765*/
   USHORT     Vendor;                                               /*@V129765*/
   UCHAR      Index;                                                /*@V129765*/
   UCHAR      Revision;   /* Vendor's device revision  */           /*@V129765*/
   /* PCI device specific functions to call:           */           /*@V147576*/
   BOOL       (FAR *PCIFunc_Init)( struct _ACB NEAR * );            /*@V147576*/
   BOOL       (FAR *PCIFunc_InitComplete)( struct _ACB NEAR * );    /*@V147576*/
   SHORT      (FAR *PCIFunc_PortState)( struct _ATBL NEAR * );      /*@V147576*/
   SHORT      (FAR *PCIFunc_TurnPort)( struct _ATBL NEAR *, SHORT );/*@V147576*/
}PCI_IDENT, NEAR *NPPCI_IDENT;                                      /*@V129765*/

/* Discovered at initialization, run-time resident, 1 per IDE IF */ /*@V129765*/
typedef struct _PCI_INFO {
   BOOL       Present;                                              /*@V129765*/
   PCI_IDENT  Ident;                                                /*@V129765*/
   /* First element of the PCIConfigOp array for this device */     /*@V129765*/
   UCHAR      FirstConfigRec;                                       /*@V129765*/
   UCHAR      BusNum;           /* PCI address component */
   UCHAR      DevFunc;          /* PCI address component */
   UCHAR      InterruptLine;                                        
} PCI_INFO, NEAR *NPPCI_INFO;                                       /*@V119250*/

/* Identifies PCI devices, 1 per supported PCI device. */           /*@V129765*/
typedef struct _PCI_DEVICE {                                        /*@V129765*/
   PCI_IDENT  Ident;                                                /*@V129765*/
   /* Verbose mode identification string               */           /*@V129765*/
   NPSZ       npDeviceMsg;                                          /*@V129765*/
   UCHAR      FirstConfigRec[MAX_ADAPTERS];                         /*@V129765*//*@V155162*/
} PCI_DEVICE, NEAR *NPPCI_DEVICE;                                   /*@V129765*/

typedef struct {
   UCHAR      PCISubFunc;
   PCI_IDENT  Ident;                                                /*@V129765*/
}PCI_PARM_FIND_DEV;

typedef struct {
   UCHAR  PCISubFunc;
   ULONG  ClassCode;
   UCHAR  Index;
}PCI_PARM_FIND_CLASSCODE;

typedef struct {
   UCHAR  PCISubFunc;
   UCHAR  BusNum;
   UCHAR  DevFunc;
   UCHAR  ConfigReg;
   UCHAR  Size;
}PCI_PARM_READ_CONFIG;

typedef struct {
   UCHAR  PCISubFunc;
   UCHAR  BusNum;
   UCHAR  DevFunc;
   UCHAR  ConfigReg;
   UCHAR  Size;
   ULONG  Data;
}PCI_PARM_WRITE_CONFIG;

typedef struct _PCI_DATA {
   UCHAR bReturn;
   union {
      struct {
         UCHAR HWMech;
         UCHAR MajorVer;
         UCHAR MinorVer;
         UCHAR LastBus;
      } Data_Bios_Info;
      struct {
         UCHAR  BusNum;
         UCHAR  DevFunc;
      }Data_Find_Dev;
      union {
         ULONG  ulData;                                             /*@V129765*/
         USHORT usData;                                             /*@V129765*/
         UCHAR  ucData;                                             /*@V129765*/
      }Data_Read_Config;
   };
} PCI_DATA, FAR *PPCI_DATA;

typedef struct _PCI_CONFIG_OPERATION                                /*@V129765*/
{                                                                   /*@VVVVVVV*/
   USHORT Phase;
   /*
   ** Bitmask of phase(s) to perform this configuration operation.
   ** Phase is a bit mask with the definitions listed below.  If it becomes
   ** necessary to add additional initialization phases, this bit mask
   ** must be extended.  The specified PCI configuration operation executes
   ** as long as the Phase bit matching the current Phase is set.  The phase
   ** records are defined in the static, PCIConfigOp[], in S506DATA.C
   **
   ** Note: PCIC = PCI Configuration operation bits
   */
#define PCIC_SUSPEND        0x0001    /* Kernel suspend    */       /*@V153620*/
#define PCIC_RESUME         0x0002    /* Kernel resume     */       /*@V153620*/
#define PCIC_START          0x0010    /* Before driver initializes the HW, bios initialized state */
#define PCIC_START_COMPLETE 0x0020    /* After driver initializes the HW, berfore returning to bios */
#define PCIC_INIT_COMPLETE  0x0040    /* All Driver's initialization is complete, BIOS is done with HW */
   USHORT SavePhase; /* Phase(s) during which to save      */       /*@V156660*/
   USHORT RestPhase; /* Phase(s) during which to restore   */       /*@V156660*/
   UCHAR  ConfigReg; /* PCI configuration register address */
   UCHAR  Size;      /* data size ib bytes 1,2, or 4       */
   ULONG  OrOn;      /* bits verified to be set, postitive mask */
   ULONG  AndOff;    /* bits verified to be reset, negative mask */ /*@VAAAAAA*/
} PCI_CONFIG_OPERATION, NEAR *NPPCI_CONFIG_OPERATION;               /*@V129765*/


/*---------------------------------------------*/
/* ONTRACK Support                             */
/*                                             */
/* OnTrack geometry constants.                 */                                                    /*@V117435*/
/*---------------------------------------------*/                                                    /*@V117435*/
/*                                                                                                     @V117435
** The maximum number of Ontrack cylinders is:                                                         @V117435
**   1024 Cylinders * 255 Heads * 63 Sectors = 16,450,560                                              @V117435
**                                           = 0x00fb0400 Total Sectors                                @V117435
*/                                                                                                   /*@V117435*/
#define MAX_ONTRACK_CYLINDERS              1024L                                                     /*@V117435*/
#define MAX_ONTRACK_HEADS                   255L                                                     /*@V117435*/
#define MIN_ONTRACK_HEADS                     4L                                                     /*@V117435*/
#define ONTRACK_SECTORS_PER_TRACK            63L                                                     /*@V117435*/
#define MAX_ONTRACK_SECTORS_PER_HEAD      (ULONG)(ONTRACK_SECTORS_PER_TRACK * MAX_ONTRACK_CYLINDERS) /*@V117435*/
#define MAX_ONTRACK_SECTORS               (ULONG)(MAX_ONTRACK_SECTORS_PER_HEAD * MAX_ONTRACK_HEADS)  /*@V117435*/
#define ONTRACK_SECTOR_OFFSET                63

/*-------------------------------*/
/* Promise Controller Support    */
/* --------------------------    */
/*                               */
/*-------------------------------*/

#define BIOS_MEM_LOW    0x000C0000l
#define BIOS_MEM_HIGH   0x000E0000l
#define BIOS_SIZE       (16*1024l)
                                                                    /*@VAAAAAA*/
#define PROMISE_ID_STRING_OFFSET  0x10                              /*@V108555*/

/* Begin [002] Defines required for Passthru command */

typedef UCHAR   BYTE, NEAR *NPBYTE, FAR *PBYTE;
typedef USHORT  WORD, NEAR *NPWORD, FAR *PWORD;
typedef ULONG   DWORD, NEAR *NPDWORD, FAR *PDWORD;

/* Deleted structures                                               /*@V151345*/

#define STATUS_ERR_INVPAR           0x0013  /* [005] error code for invalid parameter address */

/* Begin [002] Defines required for generic IOCTL functions */

/*
 * IOCTL Function Code Definitions
 */

#define DSKSP_CAT_SMART             0x80  /* SMART IOCTL category */

#define DSKSP_SMART_ONOFF           0x20  /* turn SMART on or off */
#define DSKSP_SMART_AUTOSAVE_ONOFF  0x21  /* turn SMART autosave on or off */
#define DSKSP_SMART_SAVE            0x22  /* force save of SMART data */
#define DSKSP_SMART_GETSTATUS       0x23  /* get SMART status (pass/fail) */
#define DSKSP_SMART_GET_ATTRIBUTES  0x24  /* get SMART attributes table */
#define DSKSP_SMART_GET_THRESHOLDS  0x25  /* get SMART thresholds table */

#define SMART_CMD_ON      1               /* on value for related SMART functions */
#define SMART_CMD_OFF     0               /* off value for related SMART functions */

#define DSKSP_CAT_GENERIC           0x90  /* generic IOCTL category */

#define DSKSP_GEN_GET_COUNTERS      0x40  /* get general counter values table */

#define DSKSP_GET_UNIT_INFORMATION  0x41  /* get unit configuration and BM DMA counters */
#define DSKSP_GET_INQUIRY_DATA      0x42  /* get ATA/ATAPI inquiry data */

#define DSKSP_CAT_TEST_CALLS        0xF0  /* internal testing calls category */

#define DSKSP_TEST_CONFIGURE_UNIT   0x80  /* configure ATA/ATAPI units */


/*
 * Parameters for SMART and generic commands
 */

typedef struct _DSKSP_CommandParameters
{
  BYTE        byPhysicalUnit;             /* physical unit number 0-n */
                                          /* 0 = Pri/Mas, 1=Pri/Sla, 2=Sec/Mas, etc. */
} DSKSP_CommandParameters, NEAR *NPDSKSP_CommandParameters, FAR *PDSKSP_CommandParameters;

/*
 * SMART Attribute table item
 */

typedef struct _S_Attribute
{
  BYTE        byAttribID;                 /* attribute ID number */
  WORD        wFlags;                     /* flags */
  BYTE        byValue;                    /* attribute value */
  BYTE        byVendorSpecific[8];        /* vendor specific data */
} S_Attribute;

/*
 * SMART Attribute table structure
 */

typedef struct _DeviceAttributesData
{
  WORD        wRevisionNumber;            /* revision number of attribute table */
  S_Attribute Attribute[30];              /* attribute table */
  BYTE        byReserved[6];              /* reserved bytes */
  WORD        wSMART_Capability;          /* capabilities word */
  BYTE        byReserved2[16];            /* reserved bytes */
  BYTE        byVendorSpecific[125];      /* vendor specific data */
  BYTE        byCheckSum;                 /* checksum of data in this structure */
} DeviceAttributesData, NEAR *NPDeviceAttributesData, FAR *PDeviceAttributesData;

/*
 * SMART Device Threshold table item
 */

typedef struct _S_Threshold
{
  BYTE        byAttributeID;              /* attribute ID number */
  BYTE        byValue;                    /* threshold value */
  BYTE        byReserved[10];             /* reserved bytes */
} S_Threshold;

/*
 * SMART Device Threshold table
 */

typedef struct _DeviceThresholdsData
{
  WORD        wRevisionNumber;            /* table revision number */
  S_Threshold Threshold[30];              /* threshold table */
  BYTE        byReserved[18];             /* reserved bytes */
  BYTE        VendorSpecific[131];        /* vendor specific data */
  BYTE        byCheckSum;                 /* checksum of data in this structure */
} DeviceThresholdsData, NEAR *NPDeviceThresholdsData, FAR *PDeviceThresholdsData;

/*
 * Device Media Access Counters
 */

typedef struct _DeviceCountersData
{
  WORD        wRevisionNumber;            /* counter structure revision */
  ULONG       TotalReadOperations;        /* total read operations performed */
  ULONG       TotalWriteOperations;       /* total write operations performed */
  ULONG       TotalWriteErrors;           /* total write errors encountered */
  ULONG       TotalReadErrors;            /* total read errors encountered */
  ULONG       TotalSeekErrors;            /* total seek errors encountered */
  ULONG       TotalSectorsRead;           /* total number of sectors read */
  ULONG       TotalSectorsWritten;        /* total number of sectors written */

  ULONG       TotalBMReadOperations;      /* [003] total bus master DMA read operations */
  ULONG       TotalBMWriteOperations;     /* [003] total bus master DMA write operations */
  ULONG       ByteMisalignedBuffers;      /* [003] total buffers on odd byte boundary */
  ULONG       TransfersAcross64K;         /* [003] total buffers crossing a 64K page boundary */
  ULONG       Reserved[4];                /* [003] */
} DeviceCountersData, NEAR *NPDeviceCountersData, FAR *PDeviceCountersData;

/*
 * Unit Configuration and Counters
 */

typedef struct _UnitInformationData
{
  WORD        wRevisionNumber;            /* structure revision number */
  WORD        wTaskFileBase;              /* task file register base addr */
  WORD        wAlternateStatusAddress;    /* alternate status register addr */
  WORD        wIRQ;                       /* interrupt request level */
  WORD        wFlags;                     /* flags */
  BYTE        byPIO_Mode;                 /* PIO transfer mode programmed */
  BYTE        byDMA_Mode;                 /* DMA transfer mode programmed */

} UnitInformationData, NEAR *NPUnitInformationData, FAR *PUnitInformationData;

/*
 * Unit Information Flags Definitions
 */

#define UIF_VALID           0x8000        /* unit information valid */
#define UIF_TIMINGS_VALID   0x4000        /* timing information valid */
#define UIF_RUNNING_BMDMA   0x2000        /* running Bus Master DMA on unit */
#define UIF_RUNNING_DMA     0x1000        /* running slave DMA on unit */
#define UIF_SLAVE           0x0002        /* slave on channel */
#define UIF_ATAPI           0x0001        /* ATAPI device if 1, ATA otherwise */

/*
 * Configure ATA/ATAPI operating parameters (i.e., Bus Master DMA on/off,
 * PIO transfer mode, DMA transfer mode, etc.)
 */

typedef struct _ConfigureUnitParameters
{
  BYTE        byPhysicalUnit;             /* physical unit number 0-n */
                                          /* 0 = Pri/Mas, 1=Pri/Sla, 2=Sec/Mas, etc. */
  struct
  {
    BYTE        CommandBits;              /* indicates which supplied values to be set */
                                          /* according to CommandBits mask value. Values */
                                          /* in comments on subsequent values indicate */
                                          /* or mask for CommandBits to enable that */                                          /* value to be set */
    BYTE        OnOff;                    /* 0x0001, 0 = Bus Master disable, 1 = Bus Master enable */
    BYTE        PIO_Mode;                 /* 0x0002, PIO mode to set hardware to */
    BYTE        DMA_Mode;                 /* 0x0004, DMA mode to set hardware to */
  } BusMasterDMA;

} ConfigureUnitParameters, NEAR *NPConfigureUnitParameters, FAR *PConfigureUnitParameters;

/*
 * CommandBits values
 */

#define CUPCB_BUSMASTERENABLE   0x0001    /* enable/disable bus master DMA */
#define CUPCB_SETPIOMODE        0x0002    /* PIO_Mode contains value */
#define CUPCB_SETDMAMODE        0x0004    /* DMA_Mode contains value */

/* End [002] */

/*-------------------------------*/
/* PIIXES                        */
/* -------------                 */
/* One per driver                */                                 /*@V193287*/
/*-------------------------------*/

typedef struct _PIIXES
{
  PCI_INFO      PCIInfo ;
  USHORT        Channels;
  NPSZ          npPCIDeviceMsg;
  UCHAR         PCIType;                                            
} PIIXES;

