/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = src/dev/dasd/cdrom/ibm1s506/s506ext.h, idskflt, c.basedd 98/03/17 */
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506EXT.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Data External References
 *
 * Purpose:  This file provides external references for global
 *           data contained in S506DATA.C
 *
 *
 *
 *
*//*
 * Edit History for defect # 148406:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 05-10-95  Integrated changes from Shishir Shah's WDCIDEOS.ADD V1.01
 *                 driver into latest OS/2 Warp driver. In this file this involved
 *                 adding several references to additional messages. /jlh
 *
 * [002] 06-01-95  Add Bus Master DMA capabilities to merged driver. /jlh
 *      1) Add enhanced informational messages for DMA enabled and type.
 *      2) Add PCI Bus Master IDE DMA support.
 *
 * [003] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 *
 * [004] 10-11-95  Moved ScratchSGList and added two other structures
 *                 to area of data that remains after initialization
 *                 has completed. /jlh
 * [005] 11-14-95  Merged in latest IBM code changes. /jlh
 *
 * [006] 11-16-95  Add vars to aid in serializing IOCTL requests. /jlh
 *
 * [007] 11-29-95  Add PIIX3_SIDETIM and PIIX3Msgtxt. Remove BM_DMA_BaseAddress./mol
 *
 * [008] 12-21-95 Moved PIIX3Present to global permanent storage here. /jlh
 *
 * [009] 03-06-96  Add variables required for Micro House EzDrive support. /jlh
*/

#include "cmdphdr.h"

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Static Data                                                  */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/


 extern ACBPTRS      ACBPtrs[MAX_ADAPTERS];                         /*@V147576, modified */
 extern PFN          Device_Help;
 extern HDRIVER      hDriver;                                       /*@V98451*/
 extern USHORT       ADDHandle;
 extern USHORT       cAdapters;
 extern USHORT       cUnits;
 extern USHORT       InitActive;
 extern USHORT       InitIOComplete;
 extern USHORT       BIOSActive;
 extern USHORT       LightState;
 extern USHORT       LightCount;
 extern USHORT       MachineID;
 extern USHORT       Calibrate;
 extern USHORT       XBIOSPresent;                                  /*@V108555*/
 extern USHORT       EzDrivePresent;                                /* [009] */
 extern ULONG        WaitDRQCount;
 extern ULONG        CheckReadyCount;
 extern ULONG        IODelayCount;
 extern ULONG        ElapsedTimerHandle;
 extern ULONG        ReqBlockID;                                    /*@V149971*//* moved @V155162*/
 extern VOID         (FAR *pCardServices)(VOID);                    /*@V129765, moved */
 extern VOID         (FAR *pOEMHLPEntry)(VOID);                     /*@V129765, moved */
 extern USHORT       OemhlpDS;                                      /*@V129765, moved */
 extern HWRESOURCE   HWResource[MAX_ADAPTERS];                      /*@V147576*/

 extern UCHAR        AdapterName[17];  /* Adapter Name ASCIIZ string          */
 extern CHAR         PacRimID[];                                    /*@V155162*/
 extern USHORT       DriverBusType;                                 /*@V154573*/

/*---------------------------------------------------------------*/ /*@V129765*/
/*                                                               */ /*@V129765*/
/*      PCI Configuration Operations                             */ /*@V129765*/
/*                                                               */ /*@V129765*/
/*                                                               */ /*@V129765*/
/*---------------------------------------------------------------*/ /*@V129765*/
                                                                    /*@V129765*/
 extern PCI_CONFIG_OPERATION   PCIConfigOp[MAX_PCI_CONFIG_OPS];     /*@V129765*/
 extern UCHAR                  PCIBaseAddressReg[MAX_PCI_BASE_REGS];/*@V129765*/
 extern PCI_DEVICE             PCIDevice[MAX_PCI_DEVICE_DESCRIPT];  /*@V129765*/
 extern UCHAR                  MaxPCIBuses;                         /*@V129765*/
 extern UCHAR                  PCIMajorVer;                         /*@V129765*/
 extern UCHAR                  PCIMinorVer;                         /*@V129765*/
 extern USHORT ReqCount;                                            /* [006] */
 extern ULONG  Queue;                                               /* [006] */
 extern USHORT PIIX_ModeSets[2][4];                                 /*@V179942*/

 extern UCHAR TimerPool[TIMER_POOL_SIZE];
 extern CHAR           OEMDriverName[];                             /*@V153732*/
 extern CHAR           PCMCIA_DDName[];                             /*@V155162*/
 extern IDCTABLE       DDTable;                                     /*@V153732*/
 extern IDCTABLE       PCMIDC;                                      /*@V155162*/
#ifdef DEBUG                                                        /*@V159438*/
 extern PUSHORT        pIRQNestLevel;                               /*@V159438*/
 extern DEBUG_RECORD   debRec[MAX_DEBUG_RECORDS];                   /*@V159438*/
#endif                                                              /*@V159438*/
 extern ACB   ACBPool[];


/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Initialization Data                                          */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 extern NPACB          npACBPool;
 extern CHAR           IDEPnPID[];                                  /*@V153620*/
 extern UCHAR          PnPwork[1024];                               /*@V153620*/
 extern ATBL           AdapterTable[MAX_ADAPTERS];
 extern USHORT         IRQ_Shared_Bits;                             
 extern USHORT         First_BMIStatus;                             

 extern ULONG          CalibrateTimerHandle;
 extern USHORT         CallWorkerSync;
 extern USHORT         CallWorker;
 extern USHORT         Verbose;
 extern USHORT         ATAPISlaveChk;                               /*@V109483*/
 extern IORB_EXECUTEIO InitIORB;
 extern SCATGATENTRY   ScratchSGList;                               /*@V108555*/
 extern PDDD_PARM_LIST pDDD_Parm_List;
 // Scratch buffers used to get the BIOS Parameter Block            /*@V179486*/
 // during initializaion.                                           /*@V179486*/
 extern BOOT_RECORD           BootRecord;                           /*@V179486*/
 extern BOOT_RECORD           ExtendedBootRecord;                   /*@V179486*/
 extern PARTITION_BOOT_RECORD PartitionBootRecord;                  /*@V179486*/
 extern IDCTABLE       DDTable;
 extern ULONG          RegBlock;                                    /*@V155162*/
 extern USHORT         ClientHandle;                                /*@V155162*/
 // Kernel suspend driver request, stop queueing work flag.         /*@V153620*/
 extern BOOL           OS2Suspend;                                  /*@V153620*/
 extern USHORT         SystemFlags;     /* [002.2] PCI Bus related information flags */

 extern USHORT         LastCylinderAdjust;                          /*@V192088*/

 extern MSGTABLE       InitMsg;
 extern NPSZ           AdptMsgs[];
 extern NPSZ           UnitMsgs[];
 extern NPSZ           MsgSMSOn;
 extern NPSZ           MsgLBAOn;
 extern NPSZ           MsgDMAOn;        /* [001] DMA Enabled message */
 extern NPSZ           MsgDMAtxt;                                   /*@V179942*/
 extern NPSZ           MsgBMOn;                                     /*@V179942*/
 extern NPSZ           MsgTypeBDMAOn;   /* [002.1] DMA Enabled message */
 extern NPSZ           MsgTypeFDMAOn;   /* [002.1] DMA Enabled message */
 extern NPSZ           MsgTypeMDMAOn;   /* [002.2] Bus Master DMA Enabled message */
 extern NPSZ           MsgSGOn;         /* [001] DMA scatter/gather enabled msg */
 extern NPSZ           MsgONTrackOn;                                /*@V108555*/
 extern NPSZ           MsgEzDrive;      /* [016] EzDrive present signon text */
 extern NPSZ           MsgEzDriveFBP;   /* [016] EzDrive present and FBP enabled */
 extern NPSZ           ATAPIMsg;                                     /*@V87325*/
 extern NPSZ           MsgUnitForce;                                /*@V149971*/
 extern NPSZ           MsgACBNotVia;                                /*@V159935*/
 extern NPSZ           MsgNull;
 extern UCHAR          CMD640Msgtxt[];                              /*@V129765*/
 extern UCHAR          RZ1000Msgtxt[];                              /*@V129765*/
 extern UCHAR          IN371FBMsgtxt[];                             /* [00x] */
 extern UCHAR          PIIX3Msgtxt[];                               /* [007] */
 extern UCHAR          PIIX4Msgtxt[];                               /*@V179942*/
 extern UCHAR          I82801AAMsgtxt[];                            
 extern UCHAR          I82801ABMsgtxt[];                            
 extern UCHAR          I82801BAMsgtxt[];                            
 extern UCHAR          CMD646Msgtxt[];                              
 extern UCHAR          CMD648Msgtxt[];                              /*@VXXXXXX*/
 extern UCHAR          VIA586Msgtxt[];                              
 extern UCHAR          VIA596Msgtxt[];                              
 extern UCHAR          VIA686Msgtxt[];                              
 extern UCHAR          SIS630Msgtxt[];                              
 extern UCHAR          ParmErrMsg[];
 extern UCHAR          VersionMsg[];
 extern UCHAR          EBIOSIdString[];                             /*@V192176*/
 extern UCHAR          PromiseIdString[];                           /*@V108555*/
 extern USHORT         PromiseIdLength;                             /*@V108555*/
 extern UCHAR          EzDriveIdString[];                           /* [009] */
 extern USHORT         EzDriveIdLength;                             /* [009] */
 extern UCHAR          ScratchBuf[SCRATCH_BUF_SIZE];
#ifdef MCA                                                          /*@V117508*/
 extern USHORT         SystemType;                                  /*@V117508*/
 extern BYTE           InitABRB1[];                                 /*@V117508*/
#endif                                                              /*@V117508*/

/* Begin [001] */

 extern NPSZ           WDCModel;
 extern UCHAR          ErrMsg1[];
 extern UCHAR          ErrMsg2[];
 extern UCHAR          ErrMsg3[];
 extern UCHAR          ErrMsg4[];

/* End [001] */

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Drive Type Table                                             */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 extern DRIVETYPE      DriveTypeTable[MAX_DRIVE_TYPES];


/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 extern PSZ          pcmdline1;
 extern PSZ          pcmdline_slash;
 extern PSZ          pcmdline_start;
 extern INT          tokv_index;
 extern INT          state_index;
 extern INT          length;
 extern CHARBYTE     tokvbuf[];
 extern POPT         pend_option;
 extern POPT         ptable_option;
 extern BYTE         *poutbuf1;
 extern BYTE         *poutbuf_end;
 extern CC           cc;
 extern USHORT       outbuf_len;
 extern PBYTE        poutbuf;
 extern OPTIONTABLE  opttable;
 extern USHORT       DrvrNameSize;                                  /*@V98451*/
 extern DRIVERSTRUCT DriverStruct;                                  /*@V98451*/
 extern ADAPTERSTRUCT AdapterStruct;                                /*@V98451*/
 extern DEVICESTRUCT DevStruct;                                     /*@V98451*/
 extern UCHAR        ATAPIDescriptName[];                           /*@V98451*/
 extern UCHAR        DevDescriptNameTxt[];                          /*@V98451*/

/*----------------------------------------------------------------*//*@V192176*/
/*                                                                *//*@V192176*/
/*      Mini-VDM Data                                             *//*@V192176*/
/*                                                                *//*@V192176*/
/*                                                                *//*@V192176*/
/*----------------------------------------------------------------*//*@V192176*/
 extern BOOL         VDMInt13Created;                               /*@V192176*/
 extern BOOL         VDMInt13Active;                                /*@V192176*/
 extern VDMINT13CB   VDMInt13;                                      /*@V192176*/
 extern ULONG        VDMDskBlkID;                                   /*@V192176*/
 extern ULONG        VDMInt13BlkID;                                 /*@V192176*/

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Verbose Data                                                 */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 extern UCHAR        VPCIInfo[];                                    /*@V106915*/
 extern UCHAR        VControllerInfo[];                             /*@V106915*/
 extern UCHAR        VUnitInfo1[];                                  /*@V106915*/
 extern UCHAR        VUnitInfo2[];                                  /*@V106915*/
 extern UCHAR        VModelInfo[];                                  /*@V106915*/
 extern UCHAR        VTimingInfo[];                                 /* [002.2] */
 extern UCHAR        VModelUnknown[];                               /*@V106915*/
 extern UCHAR        VBPBInfo[];                                    /*@V179486*/
 extern UCHAR        VCMDInfo[];                                    /*@V181721*/
 extern UCHAR        VI13Info[];                                    /*@V192176*/
 extern UCHAR        VIDEInfo[];                                    /*@V192176*/
 extern UCHAR        VGeomInfo0[];                                  /*@V192176*/
 extern UCHAR        VGeomInfo1[];                                  /*@V106915*/
 extern UCHAR        VGeomInfo2[];                                  /*@V106915*/
 extern UCHAR        VGeomInfo3[];                                  /*@V106915*/
 extern UCHAR        VBlankLine[];                                  /*@V106915*/
 extern UCHAR        VString[];                                     /* [002.1] */
 extern UCHAR        VULTRADMAString[];                             /*@V179942*/
 extern UCHAR        VDMAString[];                                  /* [002.2] */
 extern UCHAR        VPIOString[];                                  /* [002.2] */
 extern UCHAR        VPauseVerbose0[];                              /*@V192545*/
 extern UCHAR        VPauseVerbose1[];                              /*@V192545*/

/* Verbose information */
#define NO_DEVICES_FOUND 6                                          /*@V179942*/

 extern PIIXES       PIIXes[];                                      /*@V193287*/

 extern BYTE         Shutdown;         /*roman16: externs for Shutdown processing. Variables defined in S506DATA.C */
 extern BYTE         SecondOpcode;     /*roman16: ends  */
 extern BYTE         MaxUDMA;          
