/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = src/dev/dasd/cdrom/ibm1s506/s506data.c, idskflt, c.basedd 99/01/18 */
/**************************************************************************
 *
 * SOURCE FILE NAME = S506DATA.C
 *
 * DESCRIPTIVE NAME = IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Static/Initialization Data
 *
 * Purpose:
 *
 *
 *
 *
 *
*/
/*
 * Edit History for defect # 148406:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 30-May-95 Modified several messages for added DMA related
 *                 information display. Also added text for new DMA
 *                 related options. All changes originated by Shishir
 *                 Shah. /jlh
 *
 *      1) Add %s as placeholder for DMA scatter/gather message to be
 *         used by PrintInfo() function in s506init.c.
 *      2) Add %s as placeholder for DMA type message to be used by
 *         PrintInfo() function in s506init.c.
 *      3) Added options for DMA, DMA Type, and DMA scatter/gather mode:
 *         /DC:x    Set DMA channel to x (x=3, 5, 6, or 7)
 *         /DT:x    Set DMA type to x (x=B or F)
 *         /DSGP:x  Set DMA scatter/gather port base to x (default is 400h)
 *         /DSG     Enable DMA scatter/gather mechanism
 *         /!DSG    Disable DMA scatter/gather mechanism
 *      4) State table value for /A: option changed from (1,E,1,1) to
 *         (1,1,1,1). Changed in revision 1.01.
 *           - /NEC Flag added
 *      5) Added miscellaneous text for WD drive model and verbose displays.
 *
 * [002] 06-01-95  Add Bus Master DMA capabilities to merged driver. /jlh
 *      1) Add enhanced informational messages for DMA enabled and type.
 *      2) Add PCI Bus Master IDE DMA support.
 *
 * [003] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 *
 * [004] 08-31-95  Modified date in driver header while in process of integrating
 *                 latest IBM changes. /jlh
 *
 * [005] 09-15-95  Deleted switch to allow user to force enabling of Bus
 *                 Master DMA. /jlh
 *
 * [006] 10-11-95  Moved ScratchSGList and added two other structures
 *                 to area of data that remains after initialization
 *                 has completed. /jlh
 * [007] 11-12-95  Merge in latest IBM changes to code. /jlh
 *
 * [008] 11-16-95  Add vars to aid in serializing IOCTL requests. /jlh
 *
 * [009] 11-20-95  Add %s to vUnitInfo1 for display of ATAPI device
 *                 timings programmed. /jlh
 *
 * [010] 11-30-95  Add Version/Copyright/Build info for SEEVER.EXE. Modified sign on message
 *                 to PIIX Bus Master IDE Driver for OS/2, Version 2.01.  Changed file name
 *                 to PIIXIDE.ADD /mol
 *
 * [011] 11-30-95  Moved ScratchBuf to permanent memory area (that isn't discarded after
 *                 init) to be used as buffer for Identify Device, Read SMART Attributes
 *                 and Read SMART Thresholds commands.  This buffer is always in a contiguous
 *                 address space, whreas the caller's buffer may not be. /mol
 *
 * [012] 11-30-95  1) Added string and structure for PIIX3 Id. /mol
 *                 2) Added structure for second PIIX Id. IBM ThinkPad has 2 PIIX devices.
 *                 3) Added PIIX3_STIMIDE for PIIX3 slave timnig register value.
 *                 4) Removed BM_DMA_BaseAddress
 *
 * [013] 12-21-95 Moved PIIX3Present to global permanent storage here. /jlh
 *
 * [014] 01-19-96 Added codes back for enable of Bus Master DMA per unit
 *                as required for ATAPI devices which default to off. /jlh
 *
 * [015] 03-01-96  Moved PIIX_SIDETIM before point at which data will be thrown away
 *                 after initialization time completes. /jlh
 *
 * [016] 03-06-96  Add variables required for Micro House EzDrive support.
 *                 Also adjusted some other strings/variables as required
 *                 to support new PrintInfo requirements. /jlh
 */

 #define INCL_NOBASEAPI
 #define INCL_NOPMAPI
 #define INCL_NO_SCB
 #define INCL_INITRP_ONLY
 #include "os2.h"
 #include "dos.h"
 #include "dskinit.h"
#ifdef MCA                                                         /*@V117508*/
 #include <scb.h>                                                  /*@V117508*/
 #include <abios.h>                                                /*@V117508*/
#endif                                                             /*@V117508*/

 #include "iorb.h"
 #include "reqpkt.h"
 #include "dhcalls.h"
 #include "addcalls.h"

 #include "s506cons.h"
 #include "s506type.h"
 #include "s506regs.h"                                              /*@V149971*/
 #include "s506ext.h"
 #include "s506pro.h"

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Static Data                                                  */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 ACBPTRS        ACBPtrs[MAX_ADAPTERS] = { { 0, &FixedIRQ0 },
                                          { 0, &FixedIRQ1 },       /*@V87325*/
                                          { 0, &FixedIRQ2 },       /*@V87325*/
                                          { 0, &FixedIRQ3 } };     /*@V87325*/

 PFN            Device_Help           = 0L;
 PFN            RM_Help               = 0L;                        /*@V98451*/
 PFN            RM_Help0              = 0l;                        /*@V98451*/
 PFN            RM_Help3              = 0l;                        /*@V98451*/
 HDRIVER        hDriver               = 0L;                        /*@V98451*/
 ULONG          RMFlags               = 0L;                        /*@V98451*/
 USHORT         ADDHandle             = 0;
 USHORT         cAdapters             = 0;
 USHORT         cUnits                = 0;
 USHORT         InitActive            = 0;
 USHORT         InitIOComplete        = 0;
 USHORT         BIOSActive            = 1;
 USHORT         LightState            = 0;
 USHORT         LightCount            = 0;
 USHORT         MachineID             = 0;
 USHORT         Calibrate             = 0;
 USHORT         XBIOSPresent          = 0;                          /*@V108555*/
 USHORT         EzDrivePresent        = 0;                          /* [016] */
 ULONG          WaitDRQCount          = 0;
 ULONG          CheckReadyCount       = 0;
 ULONG          IODelayCount          = 0;
 ULONG          ElapsedTimerHandle    = 0;
 ULONG          ReqBlockID            = 0;                          /*@V155162*/
 USHORT         ClientHandle          = 0;                          /*@V155162*/
 // Kernel suspend driver request, stop queueing work flag.         /*@V153620*/
 BOOL           OS2Suspend            = FALSE;                      /*@V153620*/
 VOID           (FAR *pCardServices)(VOID) = 0;                     /*@V155162*/
 VOID           (FAR *pOEMHLPEntry)(VOID) = 0;                      /*@V129765, moved */
 USHORT         OemhlpDS              = 0;                          /*@V129765, moved */
 HWRESOURCE     HWResource[MAX_ADAPTERS] = { 0 };                   /*@V147576*/

USHORT         DriverBusType;                                       /*@V154573*/
UCHAR AdapterName[17] = "ST506 HardDisk";      /* Adapter Name ASCIIZ string */
                                   /*Start of roman16*/
BYTE           Shutdown=1;         //@roman16:Shutdown processing enable flag
BYTE           SecondOpcode=0;     //@roman16:Second Opcode flag (in case of first one fails)
                                   /*End of roman16*/
BYTE           MaxUDMA=0;         

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      PCI Configuration Operations                                 */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

/*
**  Use *IFRecs below to define starting indices into PCIConfigOp[] for
**  each PCI controller.
*/
PCI_CONFIG_OPERATION   PCIConfigOp[] =
{/* Phase               SavePhase                RestPhase     */
 /* ConfigReg Size OrOn         AndOff                         */
  { PCIC_INIT_COMPLETE,              0,           0,
    0x51,     1,   0x000000C0L, 0xFFFFFFFFL },                      /*@V134223*/
  { 0                                       },
  { PCIC_INIT_COMPLETE,              0,           0,
    0x57,     1,   0x0000000CL, 0xFFFFFFFFL },                      /*@V134223*/
  { 0                                       },
  { PCIC_START | PCIC_INIT_COMPLETE, 0,           0,
    0x41,     1,   0x00000000L, 0xFFFFFFDFL },
  { 0                                       },
  { PCIC_START | PCIC_INIT_COMPLETE, 0,           0,
    0x49,     1,   0x00000000L, 0xFFFFFFDFL },
  { 0                                       },
  /*
  ** @V159979, the following PIIX and PIIX3 PCI configuration records
  ** were updated to remove writing PIO config values at
  ** PCIC_START_COMPLETE.  The HW must be left in DMA mode at the end
  ** of driver initialization (PCIC_START_COMPLETE) because OS2DASD
  ** sends requests through before OS/2 sends the add initialization
  ** complete request.  If the HW is setup in PIO mode and an I/O
  ** request is processed by IBM1S506 in DMA mode, the system will
  ** likely hang.
  **
  ** This creates a requirement on all supported DMA chip/BIOS pairs.
  ** The BIOS must be capable of using the chip after this driver has
  ** set it up to operate in DMA mode.
  */
  /* Start PIIX, adapter 0 */                                       /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x04,     2,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x04,     2,             0,           0 },                      /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x0D,     1,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x0D,     1,             0,           0 },                      /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x20,     4,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x20,     4,             0,           0 },                      /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x40,     4,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x40,     4,             0,           0 },                       /*@V156660*/
  { 0                                       },                       /*@V153620*/
  /* Start PIIX3, adapter 0 */                                       /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x04,     2,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x04,     2,             0,           0 },                      /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x06,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x06,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x0D,     1,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x0D,     1,             0,           0 },                      /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x20,     4,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x20,     4,             0,           0 },                      /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x40,     4,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x40,     4,             0,           0 },                      /*@V156660*/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,    // driver's value
    0x44,     1,             0,           0 },                      /*@V156660*/
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,   // bios' value
    0x44,     1,             0,           0 },                      /*@V156660*/
  { 0                                       },                      /*@V153620*/
  /**************************/                                      /*@V179942*/
  /* Start PIIX4, adapter 0 */                                      /*VVVVVVVV*/
  /**************************/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x04,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x04,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x06,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x06,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x0D,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x0D,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x20,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x20,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x40,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x40,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x44,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x44,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x48,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x48,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x4A,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x4A,     2,             0,           0 },                   // bios' value
  { 0                                       },          /* Null */  /*AAAAAAAA*/
  /****************************/                                    
  /* Start 82801AA, adapter 0 */                                    /*VVVVVVVV*/
  /****************************/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x04,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x04,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x06,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x06,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x20,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x20,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x40,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x40,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x44,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x44,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x48,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x48,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x4A,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x4A,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x54,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x54,     1,             0,           0 },                   // bios' value
  { 0                                       },          /* Null */  /*AAAAAAAA*/
  /****************************/                                    
  /* Start CMD 646, adapter 0 */                                    /*VVVVVVVV*/
  /****************************/
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x04,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x04,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x06,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x06,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x08,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x08,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x10,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x10,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x14,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x14,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x1C,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x1C,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x20,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x20,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x4F,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x4F,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x51,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x51,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x52,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x52,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x53,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x53,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x54,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x54,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x55,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x55,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x56,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x56,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x57,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x57,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x58,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x58,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x59,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x59,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x5b,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x5b,     1,             0,           0 },                   // bios' value
  { 0                                       },           /* Null */  /*AAAAAAAA*/
  
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x04,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x04,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x06,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x06,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x0D,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x0D,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x20,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x20,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x40,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x40,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x44,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x44,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x48,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x48,     1,             0,           0 },                   // bios' value
  { 0                                       },
  // SiS 5513
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x04,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x04,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x06,     2,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x06,     2,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x0D,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x0D,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x20,     4,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x20,     4,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x40,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x40,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x4A,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x4A,     1,             0,           0 },                   // bios' value
  { PCIC_START_COMPLETE | PCIC_RESUME, PCIC_START_COMPLETE, PCIC_RESUME,
    0x48,     1,             0,           0 },                // driver's value
  { PCIC_START | PCIC_SUSPEND,         PCIC_START,          PCIC_SUSPEND,
    0x48,     1,             0,           0 },                   // bios' value
  { 0                                       }
  
};                                                                  

UCHAR  PCIBaseAddressReg[MAX_PCI_BASE_REGS] =                       /*@V129765*/
{ 0x10, 0x14, 0x18, 0x1c };                                         /*@VVVVVVV*/

/*
** PCIDevice is an array of adapter specific information.  Each
** element identifies one supported PCI device.  The indexes into
** this array are defined in s506oem.h
*/
PCI_DEVICE PCIDevice[] =
{/*   Device, Vendor, Index, Revision                          */
 /*   PCIFunc_Init(),   PCIFunc_InitComplete(), - functions    */   /*@V147576*/
 /*   PCIFunc_PortState(), PCIFunc_TurnPort()   - functions    */   /*@V147576*/
 /*   npDeviceMsg, FirstConfigRec                              */
  { { 0x0640, 0x1095, 0, 0,
      NULL, CMD640_0_InitComplete,                                  /*@V147576*/
      CMD640_0_PortState, CMD640_0_TurnPort },                      /*@V147576*/
    (NPSZ)CMD640Msgtxt,   {  0,  2,  7,  7 } },
  { { 0x1000, 0x1042, 0, 0,                                         /*@V127556*/
      NULL, NULL,                                                   /*@V147576*/
      NULL, NULL },                                                 /*@V147576*/
    (NPSZ)RZ1000Msgtxt,   {  4,  6,  7,  7 } },                     /* [007] */
  { { 0x122e, 0x8086, 0, 2,                                         /* [003][007] */
      NULL, NULL,                                                   /* [007] */
      NULL, NULL },                                                 /* [007] */
    (NPSZ)IN371FBMsgtxt,  {  8,  7,  7,  7 } },                     /* [003][007] *//*@V153620*/
  { { 0x7000, 0x8086, 0, 0,                                         /*[012.1]*/
      NULL, NULL,                                                   /*[012.1]*/
      NULL, NULL },                                                 /*[012.1]*/
    (NPSZ)PIIX3Msgtxt,    { 17,  7,  7,  7 } },                     /*[012.1]*//*@V156660*/
  { { 0x122e, 0x8086, 1, 2,                                         /*[012.2]*/
      NULL, NULL,                                                   /*[012.2]*/
      NULL, NULL },                                                 /*[012.2]*/
    (NPSZ)IN371FBMsgtxt,  {  8,  7,  7,  7 } },                     /*[012.2]*//*@V156660*/
  /* Intel Orion */                                                 /*@V156660*/
  { { 0x84c4, 0x8086, 0, 0,                                         /*@V156660*/
      NULL, NULL,                                                   /*@V156660*/
      NULL, NULL },                                                 /*@V156660*/
    (NPSZ)PIIX3Msgtxt,    {  8,  7,  7,  7 } },                     /*@V156660*/
  { { 0x7110, 0x8086, 0, 0,                                         /*@V179942*/
      NULL, NULL,                                                   /*VVVVVVVV*/
      NULL, NULL },                                                 /*@V179942*/
    (NPSZ)PIIX4Msgtxt,    { 30,  7,  7,  7 } },                     /*VVVVVVVV*/
  { { 0x7110, 0x8086, 1, 0,                                         /*@V182487*/
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)PIIX4Msgtxt,    { 30, 30,  7,  7 } },                   
  { { 0x2410, INTEL_PCI_VEND_ID, 0, 0,
      NULL, NULL,
      NULL, NULL },
    (NPSZ)I82801AAMsgtxt, { 47,  7,  7,  7 } },
  { { 0x2410, INTEL_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)I82801AAMsgtxt, { 47, 47,  7,  7 } },                   
  { { 0x2420, INTEL_PCI_VEND_ID, 0, 0,
      NULL, NULL,
      NULL, NULL },
    (NPSZ)I82801ABMsgtxt, { 47,  7,  7,  7 } },
  { { 0x2420, INTEL_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)I82801ABMsgtxt, { 47, 47,  7,  7 } },                   
  { { 0x2440, INTEL_PCI_VEND_ID, 0, 0,
      NULL, NULL,
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47,  7,  7,  7 } },
  { { 0x2440, INTEL_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47, 47,  7,  7 } },                   
  { { 0x2440, INTEL_PCI_VEND_ID, 0, 0,
      NULL, NULL,
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47,  7,  7,  7 } },
  { { 0x2440, INTEL_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47, 47,  7,  7 } },                   
  { { 0x2440, INTEL_PCI_VEND_ID, 0, 0,
      NULL, NULL,
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47,  7,  7,  7 } },
  { { 0x2440, INTEL_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47, 47,  7,  7 } },                   
  { { 0x248C, INTEL_PCI_VEND_ID, 0, 0,                    
      NULL, NULL,
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47,  7,  7,  7 } },
  { { 0x248C, INTEL_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47, 47,  7,  7 } },                   
  { { 0x2480, INTEL_PCI_VEND_ID, 0, 0,                    
      NULL, NULL,
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47,  7,  7,  7 } },
  { { 0x2480, INTEL_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)I82801BAMsgtxt, { 47, 47,  7,  7 } },                   
  { { CMD646_PCIIDE_DEV_ID, CMD_PCI_VEND_ID, 0, 0,               /* CMD 646 */
      NULL, NULL,
      NULL, NULL },
    (NPSZ)CMD646Msgtxt, { 64, 7,  7,  7 } },
  { { CMD646_PCIIDE_DEV_ID, CMD_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)CMD646Msgtxt, { 64, 7,  7,  7 } },                     
  { { CMD648_PCIIDE_DEV_ID, CMD_PCI_VEND_ID, 0, 0,               /* CMD 648 */
      NULL, NULL,
      NULL, NULL },
    (NPSZ)CMD648Msgtxt, { 64, 7,  7,  7 } },
  { { CMD648_PCIIDE_DEV_ID, CMD_PCI_VEND_ID, 1, 0,
      NULL, NULL,                                /* index 1 */
      NULL, NULL },
    (NPSZ)CMD648Msgtxt, { 64, 7,  7,  7 } },                      
  { { VIA596_PCIIDE_DEV_ID, VIA_PCI_VEND_ID, 0, 0,                
     NULL, NULL,
     NULL, NULL },
    (NPSZ)VIA596Msgtxt, { 101, 7,  7, 7  } },
  { { VIA596_PCIIDE_DEV_ID, VIA_PCI_VEND_ID, 1, 0,                
     NULL, NULL,
     NULL, NULL },                                /*index 1*/
    (NPSZ)VIA596Msgtxt, { 101, 7,  7, 7  } },
  { { SIS630_PCIIDE_DEV_ID, SIS_PCI_VEND_ID, 0, 0,                
     NULL, NULL,
     NULL, NULL },
    (NPSZ)SIS630Msgtxt, { 116, 7,  7, 7  } },
  { { SIS630_PCIIDE_DEV_ID, SIS_PCI_VEND_ID, 1, 0,                
     NULL, NULL,
     NULL, NULL },                              /*index 1*/
    (NPSZ)SIS630Msgtxt, { 116, 116,  7, 7  } }

};

  /* This table stores the settings for the common timing bits in the PIIX
   * Bus Master chip. The columns are mode 0, mode 2, mode 3, and mode 4
   * PIO respectively.
   */

  USHORT PIIX_ModeSets[2][4] =
  {
    { 0x8000, 0x9000, 0xA100, 0xA300 },   /* 30/33 Mhz PCI clock timings */
    { 0x8000, 0xA100, 0xA200, 0xB300 }    /* 25 Mhz PCI clock timings */
  };                                                                /*AAAAAAAA*/
                                                                    /*@V179942*/
UCHAR          MaxPCIBuses = 0;
UCHAR          PCIMajorVer = 0;                                     /*@AAAAAAA*/
UCHAR          PCIMinorVer = 0;                                     /*@V129765*/

#ifdef MCA                                                         /*@V117508*/
 USHORT         SystemType = 0;                                    /*@V117508*/
#endif                                                             /*@V117508*/

 SCATGATENTRY   ScratchSGList        = { 0, 512 };                  /*@V108555*//* [006] */
 USHORT ReqCount = 0;                 /* [008] count of queued IOCTL reqs */
 ULONG  Queue = 0L;                   /* [008] allow one queued req */

 /* [011] - moved next line above init data discard line to use for SMART ops */
 UCHAR          ScratchBuf[SCRATCH_BUF_SIZE] = { 0 };

 UCHAR          TimerPool[TIMER_POOL_SIZE] = { 0 };
 CHAR           OEMDriverName[9] = "OEMHLP$ ";                      /*@V153732*/
 CHAR           PCMCIA_DDName[9] = "PCMCIA$ ";                      /*@V155162*/
 CHAR           PacRimID[] = "PacRim Labs";                         /*@V155162*/
 IDCTABLE       DDTable =  { { 0, 0, 0 }, 0, 0 };                   /*@V153732*/
 IDCTABLE       PCMIDC = { 0, };                                    /*@V155162*/
 ATBL           AdapterTable[MAX_ADAPTERS] =             /* moved for @V155162*/
 {
  /*----------------------------------------------------*/
  /* BasePort  StatusPort Channels IRQLevel  Flags  Status  PCIInfo.Present */
  /*                                                    */
  /*----------------------------------------------------*/
   { FX_PRIMARY  , 0, 0, IRQ_FIXED_PRIMARY  ,             0, 0, { FALSE } },     /*@V149971*//*@V153620*/
   { FX_SECONDARY, 0, 0, IRQ_FIXED_SECONDARY,             0, 0, { FALSE } },     /*@V149971*//*@V153620*/
   {            0, 0, 0,                  16, ATBF_DISABLED, 0, { FALSE } },     /* Invalid port and IRQ */ /*@V87325*//*@V153620*/
   {            0, 0, 0,                  16, ATBF_DISABLED, 0, { FALSE } }      /* Invalid port and IRQ */ /*@V87325*//*@V153620*/
 };

 USHORT IRQ_Shared_bits   = 0;     

 USHORT First_BMIStatus   = 0;     

 IORB_EXECUTEIO InitIORB                   = { 0 };      /* moved for @V155162*/
#ifdef DEBUG                                                        /*@V159438*/
 PUSHORT        pIRQNestLevel              = NULL;                  /*@V159438*/
 DEBUG_RECORD   debRec[MAX_DEBUG_RECORDS]  = { 0 };                 /*@V159438*/
#endif                                                              /*@V159438*/
 ACB            ACBPool[MAX_ADAPTERS]      = { 0 };

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Initialization Data                                          */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

 NPACB          npACBPool            = ACBPool;
 CHAR           IDEPnPID[]           = "PNP0600";                   /*@V153620*/
 UCHAR          PnPwork[1024]        = {0};                         /*@V153620*/
 ULONG          CalibrateTimerHandle = 0;
 USHORT         CallWorkerSync       = 0;
 USHORT         CallWorker           = 0;
#ifdef PRE_RELEASE
 USHORT         Verbose              = 1; /* default Verbose on for pre-release */
#else
 USHORT         Verbose              = 0;
#endif
 USHORT         ATAPISlaveChk        = 0;                           /*@V109483*/
 PDDD_PARM_LIST pDDD_Parm_List       = { 0 };

 // Scratch buffers used to get the BIOS Parameter Block            /*@V179486*/
 // during initializaion.                                           /*@V179486*/
 BOOT_RECORD           BootRecord          = { 0 };                 /*@V179486*/
 BOOT_RECORD           ExtendedBootRecord  = { 0 };                 /*@V179486*/
 PARTITION_BOOT_RECORD PartitionBootRecord = { 0 };                 /*@V179486*/

 USHORT         LastCylinderAdjust = 0;                             /*@V192088*/

 USHORT         SystemFlags = 0;  /* [002.2] Used to store PCI related flags */
// [012.4] ULONG          BM_DMA_BaseAddress = 0L;  /* [002.2] base address of BM registers */

#define MSG_REPLACEMENT_STRING  1178

MSGTABLE  InitMsg = { MSG_REPLACEMENT_STRING,
                      1,
                      0,
                          };

UCHAR     AdptMsg0[] = "OK";
UCHAR     AdptMsg1[] = "Adapter not detected";
UCHAR     AdptMsg2[] = "Ignored - Previously Initialized";
UCHAR     AdptMsg3[] = "IRQ Level Not Available";
UCHAR     AdptMsg4[] = "IRQ Resource Not Available";                /*@V98451*/
UCHAR     AdptMsg5[] = "IO Port Resource Not Available";            /*@V98451*/
UCHAR     AdptMsg6[] = "No devices found";                          /*@V179942*/

NPSZ AdptMsgs[] = { (NPSZ) AdptMsg0,
                    (NPSZ) AdptMsg1,
                    (NPSZ) AdptMsg2,
                    (NPSZ) AdptMsg3,
                    (NPSZ) AdptMsg4,                                /*@V98451*/
                    (NPSZ) AdptMsg5,                                /*@V98451*/
                    (NPSZ) AdptMsg6                                 /*@V179942*/
                  };

UCHAR     UnitMsg0[] = "OK";
UCHAR     UnitMsg1[] = "Unit not detected";
UCHAR     UnitMsg2[] = "Read Sector 0 failed";
UCHAR     UnitMsg3[] = "Unit Not Ready";                            /*@108783X*/
UCHAR     UnitMsg4[] = "No Master Device";                          /*@108783X*/

NPSZ UnitMsgs[] = { (NPSZ) UnitMsg0,
                    (NPSZ) UnitMsg1,
                    (NPSZ) UnitMsg2,
                    (NPSZ) UnitMsg3,                                /*@108783X*/
                    (NPSZ) UnitMsg4                                 /*@108783X*/
                  };

UCHAR MsgSMSOntxt[]     = " SMS Enabled";                           /*@V108555*/
UCHAR MsgLBAOntxt[]     = " LBA Enabled";                           /*@V108555*/
UCHAR MsgONTrackOntxt[] = " Ontrack DM";                            /*@V108555*/
UCHAR MsgEzDrivetxt[]   = " EzDrive";                                /* [016] */
UCHAR MsgEzDriveFBPtxt[]= " EzDrive FBP";                            /* [016] */

/* Begin [001.5] */

UCHAR MsgDMAOntxt[]     = " DMA Mode Enabled";                      /*@V179942*/
UCHAR WDCModeltxt[]     = "DW C";

/* End [001.5] */

UCHAR MsgBMOntxt[]      = " Bus Master";
UCHAR MsgDMAtxtA[]      = " DMA";
UCHAR MsgSGOntxt[]      = " Scatter/Gather";                        /*@V179942*//*@V181721*/

UCHAR MsgTypeBDMAOntxt[]= " Type B DMA";                            /* [002.1][016] */
UCHAR MsgTypeFDMAOntxt[]= " Type F DMA";                            /* [002.1][016] */
UCHAR MsgTypeMDMAOntxt[]= " Bus Master DMA";                        /* [002.2][016] */

NPSZ  MsgBMOn       = (NPSZ) MsgBMOntxt;
NPSZ  MsgDMAtxt     = (NPSZ) MsgDMAtxtA;

NPSZ  MsgSMSOn      = (NPSZ) MsgSMSOntxt;
NPSZ  MsgLBAOn      = (NPSZ) MsgLBAOntxt;
NPSZ  MsgONTrackOn  = (NPSZ) MsgONTrackOntxt;                       /*@V108555*/
NPSZ  MsgEzDrive    = (NPSZ) MsgEzDrivetxt;                         /* [016] */
NPSZ  MsgEzDriveFBP = (NPSZ) MsgEzDriveFBPtxt;                      /* [016] */

/* Begin [001.5] */

NPSZ  MsgDMAOn      = (NPSZ) MsgDMAOntxt;
NPSZ  MsgSGOn       = (NPSZ) MsgSGOntxt;
NPSZ  WDCModel      = (NPSZ) WDCModeltxt;

/* End [001.5] */

NPSZ  MsgTypeBDMAOn = (NPSZ) MsgBMOntxt;                            /*@V179942*/
NPSZ  MsgTypeFDMAOn = (NPSZ) MsgTypeFDMAOntxt;                      /* [002.1] */
NPSZ  MsgTypeMDMAOn = (NPSZ) MsgTypeMDMAOntxt;                      /* [002.2] */

UCHAR ATAPIMsgtxt[] = "ATAPI Device";                                /*@V87325*/
UCHAR MsgUnitForcetxt[] = " (FORCED)";                              /*@V149971*/
UCHAR MsgPCMCIAtxt[]    = " (PCMCIA)";                              /*@V155162*/
UCHAR MsgACBNotViatxt[] = " no attached Units";                     /*@V159935*/
UCHAR MsgNulltxt[]  = "";

NPSZ ATAPIMsg       = ATAPIMsgtxt;                                   /*@V87325*/
NPSZ MsgUnitForce   = MsgUnitForcetxt;                              /*@V149971*/
NPSZ MsgPCMCIA      = MsgPCMCIAtxt;                                 /*@V155162*/
NPSZ MsgACBNotVia   = MsgACBNotViatxt;                              /*@V159935*/
NPSZ MsgNull        = MsgNulltxt;

/*                                                                    @V129765
** Verbose mode PCI Device identification messages.                   @V129765
*/                                                                  /*@V129765*/
UCHAR  CMD640Msgtxt[]  = "CMD640 PCI to IDE IC";                    /*@V129765*/
UCHAR  RZ1000Msgtxt[]  = "RZ1000 PCI to IDE IC";                    /*@V129765*/
UCHAR  IN371FBMsgtxt[] = "Intel 82371FB PCI to IDE IC";             /* [003] */
UCHAR  PIIX3Msgtxt[]   = "Intel PIIX3 PCI to IDE IC";               /* [012.1] */
UCHAR  PIIX4Msgtxt[]   = "Intel PIIX4 PCI to IDE IC";               /*@V179942*/
UCHAR  I82801AAMsgtxt[]= "Intel 82801AA PCI ICH";                   
UCHAR  I82801ABMsgtxt[]= "Intel 82801AB PCI ICH";                   
UCHAR  I82801BAMsgtxt[]= "Intel 82801BA PCI ICH";                   
UCHAR  CMD646Msgtxt[]  = "CMD 646 PCI to IDE IC";                   
UCHAR  CMD648Msgtxt[]  = "CMD 648 PCI to IDE IC";                   
UCHAR  VIA586Msgtxt[]  = "VIA 586 PCI to IDE IC";                   
UCHAR  VIA596Msgtxt[]  = "VIA 596 PCI to IDE IC";                   
UCHAR  VIA686Msgtxt[]  = "VIA 686 PCI to IDE IC";                   
UCHAR  SIS630Msgtxt[]  = "SiS 5513 PCI to IDE IC";                  


#if defined( MCA )
   UCHAR ParmErrMsg[] = " Warning: IBM2IDE.ADD - Invalid CONFIG.SYS parameters";
#else    /* && !defined( MCA ) */
   UCHAR ParmErrMsg[] = " Warning: IBM1S506.ADD - Invalid CONFIG.SYS parameters";
#endif


#if defined( MCA ) && defined( PRE_RELEASE )                        /*@V117508*/
   UCHAR VersionMsg[] = "PRE-RELEASE!!! - IBM Corp. MCA IDE Driver for OS/2 Version 4.68";
#elif defined( PRE_RELEASE )  /* && !MCA */
   UCHAR VersionMsg[] = "PRE-RELEASE!!! - IBM Corp. Bus Master IDE Driver for OS/2 Version 4.68";
#elif defined (MCA)           /* && !PRE_RELEASE */
   UCHAR VersionMsg[] = "                 IBM Corp. MCA IDE Driver for OS/2 Version 4.68";
#else                         /* !MCA && !PRE_RELEASE */            /*@V117508*/
   UCHAR VersionMsg[] = "             IBM Corp. Bus Master IDE Driver for OS/2 Version 4.68";
#endif                                                              /*@V117508*/


UCHAR  EBIOSIdString[] = "  Drive has valid Enhanced BIOS extensions Version %d"; /*@V192176*/
                                                                    /*@V108555*/
UCHAR  PromiseIdString[] = "Promise";                               /*@V108555*/
USHORT PromiseIdLength   = sizeof(PromiseIdString) - 1;             /*@V108555*/

UCHAR  EzDriveIdString[] = "AERMH13V";                              /* [016] */
USHORT EzDriveIdLength = sizeof(EzDriveIdString) - 1;               /* [016] */

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Drive Type Table                                             */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/


DRIVETYPE DriveTypeTable[MAX_DRIVE_TYPES] =
{
/*    Cyl     Head    Sec     WPC       */

  {     0,      0,      0,      0       },             /*  0  */
  {   306,      4,     17,    128       },             /*  1  */
  {   615,      4,     17,    300       },             /*  2  */
  {   615,      6,     17,    300       },             /*  3  */
  {   940,      8,     17,    512       },             /*  4  */
  {   940,      6,     17,    512       },             /*  5  */
  {   615,      4,     17,     -1       },             /*  6  */
  {   462,      8,     17,    256       },             /*  7  */
  {   733,      5,     17,     -1       },             /*  8  */
  {   900,     15,     17,     -1       },             /*  9  */
  {   820,      3,     17,     -1       },             /* 10  */
  {   855,      5,     17,     -1       },             /* 11  */
  {   855,      7,     17,     -1       },             /* 12  */
  {   306,      8,     17,    128       },             /* 13  */
  {   733,      7,     17,     -1       },             /* 14  */
  {    -1,     -1,     -1,     -1       },             /* 15  */
  {   612,      4,     17,      0       },             /* 16  */
  {   977,      5,     17,    300       },             /* 17  */
  {   977,      7,     17,     -1       },             /* 18  */
  {  1024,      7,     17,    512       },             /* 19  */
  {   733,      5,     17,    300       },             /* 20  */
  {   733,      7,     17,    300       },             /* 21  */
  {   733,      5,     17,    300       },             /* 22  */
  {   306,      4,     17,      0       },             /* 23  */
  {    -1,     -1,     -1,     -1       },             /* 24  */
  {   615,      4,     17,      0       },             /* 25  */
  {  1024,      4,     17,     -1       },             /* 26  */
  {  1024,      5,     17,     -1       },             /* 27  */
  {  1024,      8,     17,     -1       },             /* 28  */
  {   512,      8,     17,    256       },             /* 29  */
  {   615,      2,     17,    615       },             /* 30  */
  {   989,      5,     17,      0       },             /* 31  */
  {  1020,     15,     17,     -1       },             /* 32  */
  {    -1,     -1,     -1,     -1       },             /* 33  */
  {    -1,     -1,     -1,     -1       },             /* 34  */
  {  1024,      9,     17,   1024       },             /* 35  */
  {  1024,      5,     17,    512       },             /* 36  */
  {   830,     10,     17,     -1       },             /* 37  */
  {   823,     10,     17,    256       },             /* 38  */
  {   615,      4,     17,    128       },             /* 39  */
  {   615,      8,     17,    128       },             /* 40  */
  {   917,     15,     17,     -1       },             /* 41  */
  {  1023,     15,     17,     -1       },             /* 42  */
  {   823,     10,     17,    512       },             /* 43  */
  {   820,      6,     17,    820       },             /* 44  */
  {  1024,      8,     17,     -1       },             /* 45  */
  {   925,      9,     17,     -1       },             /* 46  */
  {   699,      7,     17,    256       }              /* 47  */
};

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#define TOKVBUF_LEN 255

PSZ        pcmdline1              = 0;
PSZ        pcmdline_slash         = 0;
PSZ        pcmdline_start         = 0;
INT        tokv_index             = 0;
INT        state_index            = 0;
INT        length                 = 0;
CHARBYTE   tokvbuf[TOKVBUF_LEN]   = { 0 };
POPT       pend_option            = 0;
POPT       ptable_option          = 0;
BYTE       *poutbuf1              = 0;
BYTE       *poutbuf_end           = 0;
CC         cc                     = { 0, 0 };

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len         = OUTBUF_LEN + 1;
PBYTE    poutbuf            = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         3

/*                                  opt.state[] initialization definitions    */
/*                                                                            */
/*                                              ____ entry state              */
/*                                              |                   previous  */
/*                                              v                     opt |   */
/*  ----Command Line Option --------           ----- STATE TABLE -----    |   */
/*  token id          string   type             0   1   2   3             |   */
/*                                                                        |   */
/*                                              *  /A:  /I  /U: <-----------  */
/*                                                          /GEO:             */
/*                                                          /T:               */

UCHAR TOK_ID_Vtxt[]          = "/V";
UCHAR TOK_ID_NOT_Vtxt[]      = "/!V";
UCHAR TOK_ID_VPAUSEtxt[]     = "/W";                                /*@V192545*/
UCHAR TOK_ID_NOT_VPAUSEtxt[] = "/!W";                               /*@V192545*/
UCHAR TOK_ID_ADAPTERtxt[]    = "/A:";
UCHAR TOK_ID_PORTtxt[]       = "/PORT:";
UCHAR TOK_ID_Ptxt[]          = "/P:";
UCHAR TOK_ID_IRQtxt[]        = "/IRQ:";
UCHAR TOK_ID_IGNOREtxt[]     = "/I";
UCHAR TOK_ID_RESETtxt[]      = "/R";
UCHAR TOK_ID_NORESETtxt[]    = "/!R";
UCHAR TOK_ID_Utxt[]          = "/U:";
UCHAR TOK_ID_UNITtxt[]       = "/UNIT:";
UCHAR TOK_ID_DMtxt[]         = "/DM";
UCHAR TOK_ID_NOT_DMtxt[]     = "/!DM";
UCHAR TOK_ID_GEOtxt[]        = "/GEO:";
UCHAR TOK_ID_TIMEOUTtxt[]    = "/T:";
UCHAR TOK_ID_LBAMODEtxt[]    = "/LBA";
UCHAR TOK_ID_SMStxt[]        = "/SMS";
UCHAR TOK_ID_NOT_SMStxt[]    = "/!SMS";
UCHAR TOK_ID_ATAPItxt[]      = "/ATAPI";
UCHAR TOK_ID_NOT_ATAPItxt[]  = "/!ATAPI";
UCHAR TOK_ID_FORCEtxt[]      = "/FORCE";                            /*@V149971*/
UCHAR TOK_ID_PCMCIAtxt[]     = "/PCMCIA";                           /*@V155162*/
UCHAR TOK_ID_PS2LEDtxt[]     = "/LED";                              /*@V182291*/
UCHAR TOK_ID_NOT_CYLAtxt[]   = "/!CYLA";                            /*@V192088*/
UCHAR TOK_ID_CYLAtxt[]       = "/CYLA";                             /*@V192088*/


/* Begin [001.3] Token text definitions for DMA options */

UCHAR TOK_ID_DMACHNLtxt[]   = "/DC:";
UCHAR TOK_ID_DMATYPEtxt[]   = "/DT:";

/* Begin [002.2] Changed token to more closely match actual text and remove */
/*               conflict with new tokens */

UCHAR TOK_ID_DMASGPtxt[]    = "/DSGP:";

/* End [002.2] */

UCHAR TOK_ID_NOT_DMASGtxt[] = "/!DSG";
UCHAR TOK_ID_NECtxt[]       = "/NEC";

/* End [001.3] */

UCHAR TOK_ID_SHUTDOWNtxt[]="/!SHUTDOWN";  //@roman16: Added switch for shutdown disabling

UCHAR TOK_ID_FORCEDUDMAtxt[]="/UDMA:";    

/* Begin [002.2] Token text definitions for Bus Master DMA options */

UCHAR TOK_ID_BM_DMAtxt[]= "/BM";                                                /* [014] */
UCHAR TOK_ID_Not_BM_DMAtxt[]= "/!BM";
UCHAR TOK_ID_DMASGtxt[]     = "/DSG";

/* End [002.2] */


#ifdef BBR
UCHAR TOK_ID_BBRINT3txt[]    = "/BBRINT3:";
UCHAR TOK_ID_BBRtxt[]        = "/BBR:";
#endif

UCHAR TOK_ID_ENDtxt[]        = "\0";

OPT OPT_VERBOSE =
    {TOK_ID_V,          TOK_ID_Vtxt,          TYPE_0,        {0,  1,  2,  3}};

OPT OPT_NOT_VERBOSE =
    {TOK_ID_NOT_V,      TOK_ID_NOT_Vtxt,      TYPE_0,        {0,  1,  2,  3}};

OPT OPT_VPAUSE =
    {TOK_ID_VPAUSE,     TOK_ID_VPAUSEtxt,     TYPE_0,        {0,  1,  2,  3}};

OPT OPT_NOT_VPAUSE =
    {TOK_ID_NOT_VPAUSE, TOK_ID_NOT_VPAUSEtxt, TYPE_0,        {0,  1,  2,  3}};

OPT OPT_ADAPTER =
    {TOK_ID_ADAPTER,    TOK_ID_ADAPTERtxt,    TYPE_D,        {1,  1,  1,  1}};     /*@V75103*/

OPT OPT_PORT =
    {TOK_ID_PORT,       TOK_ID_PORTtxt,       TYPE_HHHH,     {E,  1,  2,  E}};

OPT OPT_P    =
    {TOK_ID_PORT,       TOK_ID_Ptxt,          TYPE_HHHH,     {E,  1,  2,  E}};

OPT OPT_IRQ  =
    {TOK_ID_IRQ,        TOK_ID_IRQtxt,        TYPE_DD,       {E,  1,  2,  E}};     /*@V64402*/

OPT OPT_IGNORE =
    {TOK_ID_IGNORE,     TOK_ID_IGNOREtxt,     TYPE_0,        {E,  2,  E,  E}};

OPT OPT_RESET  =
    {TOK_ID_RESET,      TOK_ID_RESETtxt,      TYPE_0,        {E,  1,  E,  E}};

OPT OPT_NORESET =
    {TOK_ID_NORESET,    TOK_ID_NORESETtxt,    TYPE_0,        {E,  1,  E,  E}};

OPT OPT_U    =
    {TOK_ID_UNIT,       TOK_ID_Utxt,          TYPE_D,        {E,  3,  E,  3}};

OPT OPT_UNIT =
    {TOK_ID_UNIT,       TOK_ID_UNITtxt,       TYPE_D,        {E,  3,  E,  3}};

OPT OPT_DM =
    {TOK_ID_DM,         TOK_ID_DMtxt,         TYPE_0,        {E,  1,  2,  3}};

OPT OPT_NOT_DM =
    {TOK_ID_NOT_DM,     TOK_ID_NOT_DMtxt,     TYPE_0,        {E,  1,  2,  3}};

OPT OPT_GEO =
    {TOK_ID_GEO,        TOK_ID_GEOtxt,        TYPE_GEOMETRY, {E,  E,  E,  3}};

OPT OPT_T =
    {TOK_ID_TIMEOUT,    TOK_ID_TIMEOUTtxt,    TYPE_DDDD,     {E,  E,  E,  3}};

OPT OPT_LBAMODE =
    {TOK_ID_LBAMODE,    TOK_ID_LBAMODEtxt,    TYPE_0,        {E,  E,  E,  3}};

OPT OPT_SMS =
    {TOK_ID_SMS,        TOK_ID_SMStxt,        TYPE_0,        {E,  E,  E,  3}};

OPT OPT_NOT_SMS =
    {TOK_ID_NOT_SMS,    TOK_ID_NOT_SMStxt,    TYPE_0,        {E,  E,  E,  3}};

OPT OPT_ATAPI =
    {TOK_ID_ATAPI,      TOK_ID_ATAPItxt,      TYPE_0,        {E,  E,  E,  3}};

OPT OPT_NOT_ATAPI =
    {TOK_ID_NOT_ATAPI,  TOK_ID_NOT_ATAPItxt,  TYPE_0,        {E,  E,  E,  3}};

OPT OPT_FORCE =                                                     /*@V149971*/
    {TOK_ID_FORCE,      TOK_ID_FORCEtxt,      TYPE_0,        {E,  E,  E,  3}};

OPT OPT_PCMCIA =                                                    /*@V155162*/
    {TOK_ID_PCMCIA,     TOK_ID_PCMCIAtxt,     TYPE_0,        {E,  1,  E,  E}};

/* Begin [001.3] Token definitions for DMA options */

OPT OPT_DMACHNL  =
    {TOK_ID_DMACHNL,   TOK_ID_DMACHNLtxt,   TYPE_HHHH,     {E,  1,  2,  E}};

OPT OPT_DMATYPE  =
    {TOK_ID_DMATYPE,   TOK_ID_DMATYPEtxt,   TYPE_HHHH,     {0,  1,  2,  3}};

/* Begin [002.2] Changed token to more closely match actual text and remove */
/*               conflict with new tokens */

OPT OPT_DMASGP  =
    {TOK_ID_DMASGP,    TOK_ID_DMASGPtxt,    TYPE_HHHH,     {E,  1,  2,  3}};

/* End [002.2] */

OPT OPT_NOT_DMASG  =
    {TOK_ID_NOT_DMASG,  TOK_ID_NOT_DMASGtxt,TYPE_0,        {0,  1,  2,  3}};

OPT OPT_ID_NEC =
    {TOK_ID_NEC,        TOK_ID_NECtxt,      TYPE_0,        {0, 1, 2, 3 }};

/* End [001.3] */

/* Begin [002.2] Token text definitions for Bus Master DMA options */

/* Begin [014] */
OPT OPT_BM_DMA  =
    {TOK_ID_BM_DMA, TOK_ID_BM_DMAtxt,TYPE_0,       {E,  1,  2,  3}};

/* End [014] */

OPT OPT_NOT_BM_DMA  =
    {TOK_ID_NOT_BM_DMA, TOK_ID_Not_BM_DMAtxt,TYPE_0,       {E,  1,  2,  3}}; /* [005] */

OPT OPT_DMASG  =
    {TOK_ID_DMASG,      TOK_ID_DMASGtxt,    TYPE_0,        {0,  1,  2,  3}};

/* End [002.2] */
OPT OPT_PS2LED =
    {TOK_ID_PS2LED,     TOK_ID_PS2LEDtxt,     TYPE_0,        {E,  1,  E,  E}};  /*@V182291*/

OPT OPT_NOT_CYLA =
    {TOK_ID_NOT_CYLA,   TOK_ID_NOT_CYLAtxt,   TYPE_0,        {0,  1,  2,  3}};  /*@V182291*/

OPT OPT_CYLA =
    {TOK_ID_CYLA,       TOK_ID_CYLAtxt,       TYPE_0,        {0,  1,  2,  3}};  /*@V182291*/

#ifdef BBR
OPT OPT_BBRINT3 =
    {TOK_ID_BBRINT3,    TOK_ID_BBRINT3txt,    TYPE_BBR,      {E,  E,  E,  3}};

OPT OPT_BBR =
    {TOK_ID_BBR,        TOK_ID_BBRtxt,        TYPE_BBR,      {E,  E,  E,  3}};
#endif
                               /*roman16: Added switch for shutdown processing*/
OPT OPT_SHUTDOWN=                                                                //@roman16
    {TOK_ID_SHUTDOWN,   TOK_ID_SHUTDOWNtxt,   TYPE_0,        {0,  1,  2,  3}};   //@roman16
                               /*roman16: Ends*/
OPT OPT_FORCEDUDMA =                                                             
    {TOK_ID_FORCEDUDMA,   TOK_ID_FORCEDUDMAtxt,   TYPE_D,    {1,  1,  1,  1}};
OPT OPT_END =
    {TOK_ID_END,        TOK_ID_ENDtxt,        TYPE_0,        {O,  O,  O,  O}};


/*                                                                      */
/*   The following is a generic OPTIONTABLE for ADDs which support disk */
/*   devices.                                                           */
/*                                                                      */
OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    { (POPT) &OPT_VERBOSE,
      (POPT) &OPT_NOT_VERBOSE,
      (POPT) &OPT_VPAUSE,                                           /*@V192545*/
      (POPT) &OPT_NOT_VPAUSE,                                       /*@V192545*/
      (POPT) &OPT_ADAPTER,
      (POPT) &OPT_PORT,
      (POPT) &OPT_P,
      (POPT) &OPT_IRQ,
      (POPT) &OPT_IGNORE,
      (POPT) &OPT_RESET,
      (POPT) &OPT_NORESET,
      (POPT) &OPT_U,
      (POPT) &OPT_UNIT,
      (POPT) &OPT_DM,
      (POPT) &OPT_NOT_DM,
      (POPT) &OPT_GEO,
      (POPT) &OPT_T,
      (POPT) &OPT_LBAMODE,
      (POPT) &OPT_SMS,
      (POPT) &OPT_NOT_SMS,
      (POPT) &OPT_ATAPI,
      (POPT) &OPT_NOT_ATAPI,
      (POPT) &OPT_DMATYPE,          /* [001.3] */
      (POPT) &OPT_DMACHNL,          /* [001.3] */
      (POPT) &OPT_NOT_DMASG,        /* [001.3] [002.2] */
      (POPT) &OPT_NOT_DMASG,        /* [001.3] */
      (POPT) &OPT_ID_NEC,           /* [001.3] */
      (POPT) &OPT_BM_DMA,           /* [014] */
      (POPT) &OPT_NOT_BM_DMA,       /* [002.2] */
      (POPT) &OPT_DMASG,            /* [002.2] */
      (POPT) &OPT_FORCE,                                            /*@V149971*/
      (POPT) &OPT_PCMCIA,                                           /*@V155162*/
      (POPT) &OPT_PS2LED,                                           /*@V182291*/
      (POPT) &OPT_NOT_CYLA,                                         /*@V192088*/
      (POPT) &OPT_CYLA,                                             /*@V192088*/
#ifdef BBR
      (POPT) &OPT_BBRINT3,
      (POPT) &OPT_BBR,
#endif
      (POPT) &OPT_SHUTDOWN,                                         //@roman16
      (POPT) &OPT_FORCEDUDMA,                                       
      (POPT) &OPT_END                                               
    }
};

#ifdef MCA                                                         /*@V117508*/
BYTE    InitABRB1[GENERIC_ABRB_SIZE] = {0};                        /*@V117508*/
#endif                                                             /*@V117508*/

/*----------------------------------------------*/                  /*@V98451*/
/* Driver Description                           */                  /*VVVVVVV*/
/*----------------------------------------------*/

/* by declaring the storage as arrays and intializing the array, we force  */
/* the compiler to store the ASCII strings in this location rather than in */
/* the text area at the beginning of the segment.  Therefore we can throw  */
/* these strings away.                                                     */

                                                                    /*@V151345*/
                                                                    /*@VVVVVVV*/
#ifdef MCA
    UCHAR DrvrNameTxt[]     = "IBM2IDE.ADD";
    USHORT DrvrNameSize     = sizeof(DrvrNameTxt);
    UCHAR DrvrDescriptTxt[] = "MCA Adapter Driver for ST506/IDE DASD";
    UCHAR VendorNameTxt[]   = "IBM Corp.";
#else
    UCHAR DrvrNameTxt[]     = "IBM1S506.ADD";
    USHORT DrvrNameSize     = sizeof(DrvrNameTxt);
    UCHAR DrvrDescriptTxt[] = "ISA DMA Adapter Driver for ST506/IDE DASD";
    UCHAR VendorNameTxt[]   = "IBM Corp.";
#endif
                                                                   /*@AAAAAAA*/
                                                                   /*@V151345*/

DRIVERSTRUCT DriverStruct =
{
   DrvrNameTxt,                              /* DrvrName                */
   DrvrDescriptTxt,                          /* DrvrDescript            */
   VendorNameTxt,                            /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   2000,2,29,                                /* Date                    */
   0,                                        /* DrvrFlags               */
   DRT_ADDDM,                                /* DrvrType                */
   DRS_ADD,                                  /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};


/*----------------------------------------------*/
/* Adapter Description                          */
/*----------------------------------------------*/
UCHAR AdaptDescriptNameTxt[] = "IDE_0 ST506/IDE Controller";

ADAPTERSTRUCT AdapterStruct =
{
  AdaptDescriptNameTxt,              /* AdaptDescriptName; */
  AS_16MB_ADDRESS_LIMIT,             /* AdaptFlags;        */
  AS_BASE_MSD,                       /* BaseType;          */
  AS_SUB_IDE,                        /* SubType;           */
  AS_INTF_GENERIC,                   /* InterfaceType;     */
  AS_HOSTBUS_ISA,                    /* HostBusType;       */
  AS_BUSWIDTH_16BIT,                 /* HostBusWidth;      */
  NULL,                              /* pAdjunctList;      */
  NULL                               /* reserved           */
};

/*----------------------------------------------*/
/* Device Description                           */
/*----------------------------------------------*/
UCHAR DevDescriptNameTxt[] = "HD_0 Hard Drive";

DEVICESTRUCT DevStruct =
{
   DevDescriptNameTxt,   /* DevDescriptName; */
   DS_FIXED_LOGICALNAME, /* DevFlags;     */
   DS_TYPE_DISK          /* DevFlags;        */
};

UCHAR ATAPIDescriptName[] = "ATAPI Device";                         /*AAAAAAA*/
                                                                    /*@V98451*/

/*----------------------------------------------------------------*//*@V192176*/
/*                                                                *//*@V192176*/
/*      Mini-VDM Data                                             *//*@V192176*/
/*                                                                *//*@V192176*/
/*                                                                *//*@V192176*/
/*----------------------------------------------------------------*//*@V192176*/
BOOL       VDMInt13Created = FALSE;                                 /*@V192176*/
BOOL       VDMInt13Active  = FALSE;                                 /*@V192176*/
VDMINT13CB VDMInt13        = { 0 };                                 /*@V192176*/
ULONG      VDMDskBlkID     = (ULONG)&ACBPtrs[0];                    /*@V192176*/
ULONG      VDMInt13BlkID   = (ULONG)&VDMInt13;                      /*@V192176*/

                                                                    /*VVVVVVVV*/
                                                                    /*@V106915*/
/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Verbose Data                                                 */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

UCHAR VPCIInfo[] = "   PCI Rev:%2x.%02x %s Rev:%02x VID:%04x DID:%04x";    /*@V129765*//*@V192176*/
UCHAR VControllerInfo[] = "Controller:%1d  Port:%04x IRQ:%04x  Status:%s%s%s%s";       /*@V181721*/
UCHAR VUnitInfo1[] = " Unit:%1d Status:%s%s%s";                     /*@V179942*/
UCHAR VUnitInfo2[] = " Unit:%1d Status:%s%s%s%s%s%s%s%s%s";         /*@V179942*//*@V108555*//*@V192176*/
UCHAR VModelInfo[] = "  Model:%-30s %s";
UCHAR VModelUnknown[] = "  <Unknown>";
UCHAR VBPBInfo[]   = " BPB";                                        /*@V179486*/
UCHAR VCMDInfo[]   = " CMD";                                        /*@V181721*/
UCHAR VI13Info[]   = " BIOS";                                       /*@V192176*/
UCHAR VIDEInfo[]   = " Identify";                                   /*@V192176*/
UCHAR VGeomInfo0[] = "   OS2:log   phys BIOS:log  BPB:log  IDE:log   phys     Total Sectors"; /*@V179942*//*@V192176*/
UCHAR VGeomInfo1[] = "  C %6ld %6ld   %6ld            %6ld %6ld   Avail %9ld";                /*@V179942*//*@V192176*/
UCHAR VGeomInfo2[] = "  H %6d %6d   %6d   %6d   %6d %6d   OS2   %9ld";                        /*@V179942*//*@V192176*/
UCHAR VGeomInfo3[] = "  S %6d %6d   %6d   %6d   %6d %6d   %% Used   %3d.%02d";                /*@V179942*//*@V192176*/
UCHAR VBlankLine[] = " ";
                                                                    /*AAAAAAAA*/
                                                                    /*@V106915*/
UCHAR VPauseVerbose0[] = "SYS    : Pausing IBM1S506.ADD output..."; /*@V192545*/
UCHAR VPauseVerbose1[] = "SYS    : End of IBM1S506.ADD output.";    /*@V192545*/
UCHAR VString[]         = "%s"; /* [002.1] used for sprntf as strcpy alternative */
UCHAR VULTRADMAString[] = " Ultra DMA%d/PIO%d";                     /*@V179942*/
UCHAR VDMAString[] = " DMA%d/PIO%d";                                 /* [003] */
UCHAR VPIOString[] = " PIO%d";                                       /* [003] */

PIIXES PIIXes[ MAXPIIXSEARCH ] = { 0 };                             
