/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/ibm/ibm1s506/s506csub.c, idsk, r207, 8.006 93/10/25";*/

/**************************************************************************
 *
 * SOURCE FILE NAME =  S506CSUB.C
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Adapter Driver miscellaneous routines.
 *
 * Purpose:
 *
 *
 *
 *
 *
*/
 #define INCL_NOBASEAPI
 #define INCL_NOPMAPI
 #define INCL_NO_SCB
 #define INCL_INITRP_ONLY
 #define INCL_DOSERRORS
 #include "os2.h"
 #include "dos.h"
 #include "bseerr.h"
 #include "dskinit.h"
 #include <scb.h>
 #include <abios.h>

 #include "iorb.h"
 #include "reqpkt.h"
 #include "dhcalls.h"
 #include "addcalls.h"

 #include "s506cons.h"
 #include "s506type.h"
 #include "s506regs.h"
 #include "s506ext.h"
 #include "s506pro.h"


/*------------------------------------*/
/*                                    */
/*                                    */
/*                                    */
/*------------------------------------*/

VOID NEAR setmem( PBYTE d, USHORT c, USHORT len )
{
  USHORT   i;

  for ( i = 0; i < len ; i++ )  d[i] = (UCHAR) c;

  return;
}

/*------------------------------------*/
/*                                    */
/*                                    */
/*                                    */
/*------------------------------------*/

VOID NEAR memcpy( PBYTE d, PBYTE s, USHORT len )
{
  USHORT   i;
  USHORT   j;

  j = len >> 1;                                                      /*@V75140*/

  for ( i = 0; i < j ; i++ ) ((PUSHORT) d)[i] = ((PUSHORT) s)[i];

  if ( j & 1 ) d[len-1] = s[len-1];


  return;
}

                                                                    /*@V151345*/
                                                                    /*@VVVVVVV*/
/****************************/                                      /*@V75103*/
/* Copy & Swap String Bytes */                                      /*@V75103*/
/****************************/                                      /*@V75103*/
                                                                    /*@V75103*/
VOID NEAR strnswap( PSZ d, PSZ s, USHORT n )                        /*@V75103*/
{                                                                   /*@V75103*/
  USHORT    j = 1;                                                  /*@V75103*/
                                                                    /*@V75103*/
  while( s[j] && n-- ) { *d++ = s[j]; j^=1; s+=(j*2); }             /*@V75103*/
  *d = 0;                                                           /*@V75103*/
                                                                    /*@V75103*/
  return;                                                           /*@V75103*/
}                                                                   /*@V75103*/
                                                                    /*@AAAAAA*/
                                                                    /*@V151345*/

/*
** Start @V155162 -
** Moved strncmp() and strlen() from static, initialization-time,
** only, resident to task-time resident.
*/
/*******************************************************************************
*                                                                              *
*   FUNCTION: Compare n number of characters in 2 strings, return TRUE if =    *
*             If s1 is in lower case, convert to upper prior to comparing.     *
*                                                                              *
*******************************************************************************/
BOOL NEAR strncmp( PUCHAR s1, PUCHAR s2, USHORT n )
{
     USHORT i;
     CHAR temp;

     for (i=0;i < n;i++,s1++,s2++)

         if (*s1 != *s2)
         {
            if ((*s1 >= 'a') && (*s1 <= 'z'))
            {
               temp = *s1 - ' ';
               if (temp == *s2)
                  continue;
            }
            return(FALSE);
         }

     return(TRUE);
}


/*******************************************************************************
*                                                                              *
*   FUNCTION: Return the length of a string                                    *
*                                                                              *
*******************************************************************************/
USHORT NEAR strlen( PSZ s )
{
     USHORT i;

     for (i = 0; *s != '\0' ; s++)
         i++;

     return(i);
}
/*
** End @V155162
*/
