/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = src/dev/dasd/cdrom/ibm1s506/s506cons.h, idskflt, c.basedd 98/03/03 */
/**************************************************************************
 *
 * SOURCE FILE NAME =  S506CONS.H
 *
 * DESCRIPTIVE NAME =  IBM1S506.ADD - Adapter Driver for ST506/IDE DASD
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Locally defined equates.
 *
 * Purpose:
 *
 *
 *
 *
 *
*//*
 * Edit History for Feature # 149178:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 06-12-95   Add support for PCI Bus Master DMA. /jlh
 *      1) Add PCI defines for use in Bus Master DMA.
 *      2) Add defines for SysDMAType and SystemType variables.
 *
 * [003] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 *
 * [004] 11-15-95  Add conditional to enable counters. /jlh
 *
 * [005] 11-29-95  Added define for PIIX3 slave IDE timing register. /mol
*/


/*---------------------------------------*/
/* Maximum Adapters/Units                */
/*---------------------------------------*/
#define MAX_ADAPTERS    4                                          /*@V87325*/
#define MAX_UNITS       2

/*-------------------*/
/* TimeOut Equates   */
/*-------------------*/

/*---------------------------------------*/
/* TimeOut for RESET to complete (30s)   */
/*                                       */
/* After a RESET the drive is checked    */
/* every 200ms.                          */
/*---------------------------------------*/
#define DELAYED_RESET_MAX       (30*1000L)
#define DELAYED_RESET_INTERVAL  200L

/*----------------------------------------------*/
/* TimeOut for IRQ from last interrupt (5s)     */
/*----------------------------------------------*/
#define IRQ_TIMEOUT_INTERVAL    (5*1000L)

/*----------------------------------------------*/
/* Retry Delay interval (200ms)                 */
/*----------------------------------------------*/
#define DELAYED_RETRY_INTERVAL  200L

/*---------------------------------------*/
/* Minimum User Timeout (5s)             */
/*---------------------------------------*/
#define MIN_USER_TIMEOUT        (IRQ_TIMEOUT_INTERVAL / 1000L)

/*---------------------------------------*/
/* Default User Timeout (30s)            */
/*---------------------------------------*/
#define DEFAULT_USER_TIMEOUT    30

/*---------------------------------------*/                          /*@V85057*/
/* Maximum Cmd/Data Error Retries        */                          /*@V85057*/
/*---------------------------------------*/                          /*@V85057*/
#define MAX_BUSY_TIMEOUTS       50                                   /*@V85057*/

/*---------------------------------------*/
/* Maximum Cmd/Data Error Retries        */
/*---------------------------------------*/
#define MAX_DATA_ERRORS         25

/*---------------------------------------*/                          /*@V77133*/
/* Maximum Reset Retries                 */                          /*@V77133*/
/*---------------------------------------*/                          /*@V77133*/
#define MAX_RESET_RETRY         10                                   /*@V77133*/

/*---------------------------------------*/
/* Initialization unit timeouts          */
/*---------------------------------------*/
#define INIT_TIMEOUT_LONG       (10*1000L)
#define INIT_TIMEOUT_SHORT      ( 2*1000L)

/*---------------------------------------*/
/* Elapsed Timer Interval (200ms)        */
/*---------------------------------------*/
#define ELAPSED_TIMER_INTERVAL  200

/*---------------------------------------*/
/* Calibrate Loop Counter                */
/*---------------------------------------*/
#define CALIBRATE_LOOP_COUNT            1024
#define CALIBRATE_TIMER_INTERVAL        (5*31L)

/*---------------------------------------*/
/* Maximum PIO Delays (ms)               */
/*---------------------------------------*/
#define MAX_WAIT_DRQ                    100
#define MAX_WAIT_READY                  100

/*---------------------------------------*/
/* Maximum Transfer - MultiBlock Mode    */
/*---------------------------------------*/
#define MAX_MULTMODE_BLK                16

/*---------------------------------------*/
/* Maximum Transfer - Overall            */
/*---------------------------------------*/
#define MAX_XFER_SEC                    256

/*---------------------------------------*/
/* Suspend Count                         */
/*---------------------------------------*/
#define DEFERRED_COUNT                    5                        /*@V87325*/
#define IMMEDIATE_COUNT                   1                        /*@V87325*/

/*-------------------------------*/
/* Miscellaneous                 */
/*-------------------------------*/
#define ENABLE  _asm{ sti }
#define DISABLE _asm{ cli }

#define SECTORSHIFT             9

#define SCRATCH_BUF_SIZE        1024

#define ATAPI_RECOVERY                   30                         /*@V108783*//*@V156545*/
/* CHL
 * Increase the retry value, this is the worst case for some CDROMs to
 * post its signature. In most case, it exits the loop much earlier, so
 * there is no performance problem.
 * Don't decrease the value, if you do so, it will cause the problem for TOSHIBA
 * CDROM.
 */
#define MAX_ATAPI_RECOVERY_TRYS  512          /* Old value 32768*//*@V156660*/
#define MAX_ATAPI_CONFIGURE_TRYS 5                                  /*@V162970*/

#define ON                      1                                   /*@V147576*/
#define OFF                     0                                   /*@V147576*/
#define INDETERMINANT          -1                                   /*@V147576*/

/*---------------------------------------------*/
/* Dummy IORB CommandModifier                  */
/*                                             */
/* To pass internal requests to state machine  */
/*---------------------------------------------*/
#define IOCM_NO_OPERATION       0

#define TASKTIME                -1L                                /*@V87325*/

/* Begin [001.1] Added to support PCI functions */

/* [003] Deleted duplicates for PCI functions */
/*       IBM now defines these in S506OEM.H */

#define PCI_CONFIG_REG_VID      0           /* vendor identification */
#define PCI_CONFIG_REG_DID      2           /* device identification */
#define PCI_CONFIG_REG_PCICMD   4           /* PCI command register */
#define PCI_CONFIG_REG_PCISTS   6           /* PCI status register */
#define PCI_CONFIG_REG_RID      8           /* revision identification */
#define PCI_CONFIG_REG_PI       9           /* programming interface */
#define PCI_CONFIG_REG_SUBC     10          /* sub-class code */
#define PCI_CONFIG_REG_BCC      11          /* base class code */
#define PCI_CONFIG_REG_MLT      13          /* master latency timer */
#define PCI_CONFIG_REG_HEDT     14          /* header type register */

#define PCI_CMD_BME             0x0005      /* Bus Master DMA Enable *//*@V179942*/

#define PCI_CR_ISA_MSTAT        0x6A        /* PCI to ISA Bridge Miscellaneous Status register */
#define PCI_CR_ISA_MSTAT_ISACLK 0x01        /* 0 = 30/33Mhz, 1 = 25Mhz */

#define PCI_CR_BM_MLT           0x0D        /* Bus Master Latency Timer Register */
#define PCI_CR_BM_IBA           32          /* Bus Master Interface Base Address */
#define PCI_CR_BM_IDETIM        64          /* 0x40-41 IDE timing */
#define PCI_CR_BM_SIDETIM       0x44        /* [005] PIIX3 slave IDE timing register */
#define PCI_CR_BM_SDMACTL       0x48        /* PIIX4 Ultra DMA Control Register */
#define PCI_CR_BM_SDMATIM       0x4A        /* PIIX4 Ultra DMA Timing Register  */
#define PCI_CR_BM_IDECONFIG     0x54        /* 82801 IDE IO Config Register  */
#define PCI_CR_BM_MRDMODE       0x71        /* CMD DMA Read Mode Select Register */
#define PCI_CR_BM_BMIDECSR      0x79        /* CMD Cable detection Register */

/* End [001.1] */

/*---------------------------------------*/
/* Defines for CMD 646/648 PCI regsiters */
/*---------------------------------------*/
#define CFR       0x50                              
#define CNTRL     0x51

#define CMDTIM0   0x52
#define ARTTIM0   0x53
#define DRWTIM0   0x54
#define ARTTIM1   0x55
#define DRWTIM1   0x56
#define ARTIM23   0x57
#define DRWTIM2   0x58
#define BRST      0x59
#define DRWTIM3   0x5B
#define UDIDETCR0 0x73
#define UDIDETCR1 0x7B                              

/*-----------------------------------*/
/* Defines for CMD 648 PCI regsiters */
/*-----------------------------------*/
#define BMIDECSR  0x79                              /*@VXXXXX*/

#define PCIREG_LATENCY          0x0D        /* SiS Latency Timer */
#define PCI_VIA_IDEENABLE       0x40        /* VIA IDE enables */
#define PCI_VIA_IDECONFIG       0x41        /* VIA IDE configuration */
#define PCI_VIA_IDEFIFOCFG      0x43        /* VIA IDE FIFO configuration */
#define PCI_VIA_IDEMISC2        0x45        /* VIA IDE misc. control */
#define PCI_VIA_IDEMISC3        0x46        /* VIA IDE FIFO flush control */
#define PCI_VIA_IDETIM          0x48        /* VIA IDE pulse timing */
#define PCI_VIA_IDEASU          0x4C        /* VIA IDE address setup time */
#define PCI_VIA_IDEULTRA        0x50        /* VIA IDE Ultra DMA timing */

#define PCI_SIS_IDEGENCTRL      0x4B        /* VIA IDE pulse timing */

//end defines for VIA  and SiS



/* Begin [001.2] Added constants for SysDMAType in AT structure */
/* also valid for SystemType global */

#define SDMA_TYPE_B     0x0B                                        /*@V179942*/
#define SDMA_TYPE_F     0x0F                                        /*@V179942*/
#define SDMA_MASK       0x0F                /* lower nibble is 0B or 0F hex */
#define SDMA_SG         0x10                /* scatter/gather flag */
#define SDMA_BusMaster  0x20                /* Bus Master IDE DMA flag */

/* Ultra DMA Mode Supported Identify Word 88 *//*xxxxx210xxxxx210*/ /*@V179942*/
                                                                    /*VVVVVVVV*/
#define ULTRADMA_5ACTIV  0x2000                                     
#define ULTRADMA_4ACTIV  0x1000             /*     Active Modes   */
#define ULTRADMA_3ACTIV  0x0800                                     
#define ULTRADMA_2ACTIV  0x0400                                     
#define ULTRADMA_1ACTIV  0x0200
#define ULTRADMA_0ACTIV  0x0100

#define ULTRADMAMASK     0x003F             /*   Supported Modes */ 
#define ULTRADMAMODE_5   0x0020                                     
#define ULTRADMAMODE_4   0x0010                                     
#define ULTRADMAMODE_3   0x0008                                     
#define ULTRADMAMODE_2   0x0004
#define ULTRADMAMODE_1   0x0002                                     /*AAAAAAAA*/
#define ULTRADMAMODE_0   0x0001                                     /*@V179942*/

#define MAXULTRADMAMODE       5                                     

#define WR_PING_PONG_ENABLE 0x0400                                  

#define WORD93_80_PIN_CABLE  0x02000        

#define IDECLK_ATA33     0                  
#define IDECLK_ATA66     1                  

/* Miscellaneous constants */

#define MR_64K_LIMIT    0x00010000L         /* 64K memory limit */
#define MR_4K_LIMIT     0x00001000L         /* 4K memory limit */

/* [001.2] */

/* Begin [001.2] SystemFlags definitions */

#define SYSFLG_HASWDC   0x8000              /* 1 = WDC drive present */
#define SYSFLG_CLK25    0x0001              /* 1 = 25Mhz clock, 0 = 30/33 Mhz */

/* End [001.2] */

/* Begin [004] Define conditional compilation symbols */

#define ENABLE_COUNTERS

/* End [004] */

#ifdef DEBUG                                                        /*@V159438*/
#define MAX_DEBUG_RECORDS 64                                        /*@V159438*/
#endif                                                              /*@V159438*/

/* IdentifyDevice Constants */

#define  ATA_DEVICE    0                   /* ATA Device   */
#define  ATAPI_DEVICE  1                   /* ATAPI Device */

// BIOS Geometry Limits                                             /*@V192176*/
#define BIOS_MAX_CYLINDERS              1024l                       /*@V192176*/
#define BIOS_MAX_NUMHEADS                255                        /*@V192176*/
#define BIOS_MAX_SECTORSPERTRACK          63                        /*@V192176*/
#define BIOS_MAX_TOTALSECTORS       16450560l // 1024 * 255 * 63    /*@V192176*/
                                                                    /*@V192176*/
// ATA Geometry Limits                                              /*@V192176*/
#define ATA_MAX_CYLINDERS              65536l                       /*@V192176*/
#define ATA_MAX_NUMHEADS                  16                        /*@V192176*/
#define ATA_MAX_SECTORSPERTRACK          255                        /*@V192176*/
#define ATA_MAX_TOTALSECTORS       267386880l // 65536 * 16 * 255   /*@V192176*/
                                                                    /*@V192176*/
// Legacy Geometry Limits                                           /*@V192176*/
#define LIMITED_MAX_CYLINDERS           1024l                       /*@V192176*/
#define LIMITED_MAX_NUMHEADS              16                        /*@V192176*/
#define LIMITED_MAX_SECTORSPERTRACK       63                        /*@V192176*/
#define LIMITED_MAX_TOTALSECTORS     1032192l // 1024 * 16 * 63     /*@V192176*/
                                                                    /*@V192176*/
#define TRANSLATED_MAX_TOTALSECTORS 15481935l // 16383 * 15 * 63    /*@V192176*/

/*     Channel Bit definitions      */
#define          PRIMARY_CHANNEL  0x01                              
#define        SECONDARY_CHANNEL  0x02                              /*@VVVVVVV*/
                                                /* MRDMODE Bit definitions */
#define   NATIVE_PRIMARY_CHANNEL  0x04
#define NATIVE_SECONDARY_CHANNEL  0x08

#define PRIMARY_BIT    PRIMARY_CHANNEL
#define SECONDARY_BIT  SECONDARY_CHANNEL

/*     IRQ Sharing definitions      */
#define IRQ_NOT_SHARED            0x00
#define IRQ_SHARED                0x01

#define LEGACY                    0x00                              /*@VAAAAAA*/
#define NATIVE                    0x01                              

