/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1TYPE.H
 *
 * DESCRIPTIVE NAME = Local Data Types for this driver
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION : Locally defined structures for this driver.
 *
 * Purpose:  Private Control Block layouts.
 *
 *
 *
 *
 *
*/#include "rmcalls.h"

typedef struct _ACB  NEAR *NPACB, FAR *PACB;
typedef struct _UCB  NEAR *NPUCB, FAR *PUCB;
typedef struct _ATBL NEAR *NPATBL;
typedef struct _UTBL NEAR *NPUTBL;

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Media Information Tables                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*---------------------------------------------*/
/*                                             */
/* MediaInfo - one per supported media type    */
/*                                             */
/*---------------------------------------------*/
typedef struct _MEDIAINFO
{
  GEOMETRY      Geo;
  USHORT        Flags;
  UCHAR         Specify[2];
  USHORT        FmtGapLength;
  USHORT        RWGapLength;
  USHORT        FmtFillByte;
  USHORT        EOT;
  USHORT        DataRate;

} MEDIAINFO, NEAR *NPMEDIAINFO;


/*----------------------------*/
/* MEDIAINFO->Flags           */
/*----------------------------*/
#define MIF_DOUBLE_STEP         0x0001


/*-----------------------------------------------*/
/*                                               */
/* Array of pointers to MediaInfo structures     */
/* indexed by FormFactor.                        */
/*                                               */
/*-----------------------------------------------*/
typedef struct _MEDIALOOKUP
{

  USHORT        Count;
  NPMEDIAINFO   npMIF[6];                                               

} MEDIALOOKUP, NEAR *NPMEDIALOOKUP, FAR *PMEDIALOOKUP;

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Hardware Resource Information                                          */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*----------------------------------------------------------*/
/*                                                          */
/* HWRESOURCE - List of ACBs sharing a hardware resources   */
/*                                                          */
/*----------------------------------------------------------*/

typedef struct _HWRESOURCE
{
  USHORT        Flags;

  NPACB         npOwnerACB;

  NPACB         npHeadACB;
  NPACB         npFootACB;

  NPACB         npFirstACBX;

  PIORB         pSuspendHead;
  PIORB         pSuspendFoot;

  PIORB         pResumeHead;

} HWRESOURCE, NEAR *NPHWRESOURCE, FAR *PHWRESOURCE;

/* HWRESOURCE->Flags definitions */

#define HWRF_SUSPEND    0x0001

/*-------------------------------*/
/*                               */
/* ACB Pointer Block             */
/*                               */
/*-------------------------------*/

typedef struct _ACBPTRS
{
  USHORT        (FAR *IRQHandler)();

  USHORT        IRQLevel;
  USHORT        HWRIndex;

  NPACB         npACB;
  USHORT        Reserved;

} ACBPTRS;

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Adapter/Unit Information                                               */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*-------------------------------*/
/* Unit Control Block            */
/* ------------------            */
/*                               */
/* One per drive on controller.  */
/*                               */
/*-------------------------------*/

typedef struct _UCB
{
  /*-----------------------------------*/
  /* Associated Control Block Pointers */
  /*-----------------------------------*/
  NPACB         npACB;
  NPUCB         npNextUCB;

  USHORT        Flags;
  USHORT        ReqFlags;

  /*--------------------*/
  /* Unit Number (0-3)  */
  /*--------------------*/
  USHORT        UnitId;
  USHORT        BIOSId;
  USHORT        IORBCount;

  /*---------------------------------------------*/
  /* Allowable Densities/Settings for this drive */
  /*---------------------------------------------*/
  USHORT        MediaInfoCount;
  USHORT        MediaInfoIndex;
  NPMEDIAINFO   npMediaInfo;
  USHORT        FormFactor;

  /*---------------------------------------------*/
  /* MotorOff countdown for this drive           */
  /*---------------------------------------------*/
  USHORT        MotorOffCount;

  /*---------------------------------------------*/
  /* MotorOn spin-up delay for this drive        */
  /*---------------------------------------------*/
  ULONG         MotorOnTimer;

  /*---------------------------------------------*/
  /* Current Cylinder position for this drive    */
  /*---------------------------------------------*/
  USHORT        CurCyl;

  /*------------------------------------------*/
  /* Replacement UNITINFO from Filter ADD     */
  /*------------------------------------------*/
  PUNITINFO     pUnitInfo;

  HDEVICE       hDevice;                /*V98451*/
  /*-Japan Only-------------------------------*/                        
  /* Japan Special Support                    */                        
  /*------------------------------------------*/                        
  USHORT        CurrDriveMode;                                          
  USHORT        RPMChangeable;                                          
} UCB;

/* UCB->Flags definitions */

#define UCBF_NO_DASD_SUPPORT    0x0001
#define UCBF_NO_CHANGELINE      0x0002
#define UCBF_CHANGELINE_INVERT  0x0004
#define UCBF_ALLOCATED          0x0008
#define UCBF_MEDIA_UNFORMATTED  0x0010
#define UCBF_MEDIA_UNCERTAIN    0x0020
#define UCBF_MOTOR_ON           0x0040
#define UCBF_MOTOR_ON_PREV      0x0080
#define UCBF_MOTOR_OK           0x0100
#define UCBF_DRIVE_LOCKED       0x0200
#define UCBF_NO_MEDIASENSE      0x0400
#define UCBF_NOT_DRIVE_AB       0x0800
#define UCBF_BIOS_SUPPORT       0x1000
#define UCBF_FORCE              0x2000                              //@V149969
#define UCBF_NOTPRESENT         0x4000                              //@V149969

/* UCB->ReqFlags definitions */

#define UCBR_RESET              0x0001
#define UCBR_FORCE_SELECT       0x0002
#define UCBR_SELECT             0x0004
#define UCBR_SPECIFY            0x0008
#define UCBR_MOTOR_ON           0x0010
#define UCBR_MOTOR_SPINUP       0x0020                               /*@V85053*/
#define UCBR_CHECK_MEDIA        0x0040
#define UCBR_RESET_CHANGE       0x0080
#define UCBR_RECAL              0x0100
#define UCBR_SEEK               0x0200
#define UCBR_MOTOR_WAIT         0x0400
#define UCBR_SETTLE             0x0800
#define UCBR_COMMAND            0x1000
#define UCBR_TRK0SIGN           0x2000                                  

/* UCB->MediaInfoIndex definitions */
#define MII_LOGICAL             0
#define MII_USER_DEFINED        1
#define MII_DEFAULT             2

/*-------------------------------*/
/* Adapter Control Block         */
/* ---------------------         */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/

typedef struct _ACB
{
  /*--------------------------------------*/
  /* IORB Queue for units on this adapter */
  /*--------------------------------------*/
  PIORBH        pHeadIORB;
  PIORBH        pFootIORB;
  PIORBH        pIORB;

  /*---------------------------------------------------*/
  /* Controller Register addresses/contents, IRQ level */
  /*---------------------------------------------------*/
  USHORT        IOPorts[FC_MAX_REGS];
  USHORT        IORegs[FC_MAX_REGS];

  USHORT        HWResourceIndex;
  NPACB         npNextHWR;
  NPACB         npNextACBX;

  USHORT        IRQLevel;
  USHORT        DMAChannel;

  USHORT        (FAR *IRQEntry)( VOID );

  USHORT        SpuriousIRQ;

  /*-------------------------------*/
  /* Current UCB Info              */
  /*-------------------------------*/
  NPUCB         npUCB;
  USHORT        UnitId;
  NPMEDIAINFO   npMIF;

  NPUCB         npFirstUCB;
  USHORT        cUnits;

  /*-------------------------------*/
  /* Current Controller Settings   */
  /*-------------------------------*/
  USHORT        CurCyl;
  USHORT        SeekFlags;
  USHORT        CurUnitId;
  USHORT        ISMRecal;

  USHORT        CurCmdLen;
  UCHAR         CurCmd[MAX_CMD_LEN];

  USHORT        CurResultsLen;
  UCHAR         CurResults[MAX_RESULTS_LEN];

  USHORT        CurStatus;

  VOID          (NEAR *IRQRoutine)( NPACB npACB );
  VOID          (NEAR *TmrRoutine)( NPACB npACB );

  /*------------------------------------------*/
  /* Command requested by Outer State Machine */
  /*------------------------------------------*/
  USHORT        ReqFlags;
  USHORT        ReqIndex;

  USHORT        ReqCyl;

  USHORT        ReqCmdLen;
  UCHAR         ReqCmd[MAX_CMD_LEN];

  USHORT        ReqResultsLen;

  USHORT        ReqDataLen;
  ULONG         ReqDataBuf;

  VOID          (FAR *ISMDoneRtn)(NPACB npACB);

  USHORT        DMABufLen;
  ULONG         DMABuf;
  LIN           DMABufLin;
  PBYTE         pDMABuf;

  /*-------------------------------*/
  /* Inner State Machine Variables */
  /*-------------------------------*/
  USHORT        UseCount;
  USHORT        Flags;
  USHORT        State;

  /*-----------------------------------*/
  /* Outer State Machine Control Vars  */
  /*-----------------------------------*/
  USHORT        OSMUseCount;
  USHORT        OState;
  USHORT        OpCode;
  USHORT        OpFlags;

  VOID          (FAR *OSMNotifyRtn)(NPACB npACB);

  /*--------------------------------*/
  /* Outer State Machine Data Vars  */
  /*--------------------------------*/
  ULONG         RBA;
  CHS_ADDR      CHSAddr;

  ULONG         SecTotal;
  ULONG         SecRemain;
  ULONG         SecCount;

  USHORT        IORBError;

  /*----------------------------------*/
  /* Error Counters                   */
  /*----------------------------------*/
  USHORT        ExecIOError;
  USHORT        ExecIORecal;

  ADD_XFER_DATA XferData;

  /*----------------------------------*/
  /* Save Area for VERIFY subcommand  */
  /*----------------------------------*/
  USHORT        VerifyReqCmdLen;
  UCHAR         VerifyReqCmd[MAX_CMD_LEN];
  USHORT        VerifyReqResultsLen;
  USHORT        VerifyReqFlags;
  USHORT        VerifyReqDataLen;
  ULONG         VerifyReqDataBuf;
  USHORT        VerifyOpFlags;

  /*--------------------------------*/
  /* Timer Flags/Values             */
  /*--------------------------------*/
  USHORT        TimerFlags;

  ULONG         SettleTime;
  ULONG         IRQTimer;

  /*----------------*/
  /* Timer Handles  */
  /*----------------*/
  ULONG         IRQTimerHandle;
  ULONG         DelayTimerHandle;
  ULONG         RETRYTimerHandle;                 /*@V90990*/

  /*------------------------*/
  /* Swap Support           */
  /*------------------------*/
  USHORT        SwapReq;
  ULONG         StateHookHandle;

} ACB;

/* ACB->Flags values */

#define ACBF_INTERRUPT          0x0001
#define ACBF_WAITSTATE          0x0002
#define ACBF_SM_ACTIVE          0x0004
#define ACBF_SM_READY           0x0008
#define ACBF_SM_IDLE            0x0020
#define ACBF_SM_BUFWAIT         0x0040
#define ACBF_MOTOR_POST         0x0080
#define ACBF_VIDEO_PAUSE        0x0100
#define ACBF_OSM_WAITSTATE      0x0200
#define ACBF_NOTPRESENT         0x0400                              //@V149969
#define ACBF_UNITSWAP           0x0800                              //@V149969

/* ACB->State values */

#define ACBS_INTERRUPT          1
#define ACBS_TIMER              2
#define ACBS_NEXT_REQUEST       3
#define ACBS_COMPLETE           4

/* ACB->ReqFlags values */

#define ACBR_RESET              UCBR_RESET
#define ACBR_FORCE_SELECT       UCBR_FORCE_SELECT
#define ACBR_SELECT             UCBR_SELECT
#define ACBR_SPECIFY            UCBR_SPECIFY
#define ACBR_MOTOR_ON           UCBR_MOTOR_ON
#define ACBR_MOTOR_SPINUP       UCBR_MOTOR_SPINUP                    /*@V85053*/
#define ACBR_CHECK_MEDIA        UCBR_CHECK_MEDIA
#define ACBR_RESET_CHANGE       UCBR_RESET_CHANGE
#define ACBR_RECAL              UCBR_RECAL
#define ACBR_SEEK               UCBR_SEEK
#define ACBR_MOTOR_WAIT         UCBR_MOTOR_WAIT
#define ACBR_SETTLE             UCBR_SETTLE
#define ACBR_COMMAND            UCBR_COMMAND
#define ACBR_TRK0SIGN           UCBR_TRK0SIGN                           

/* ACB->TimerFlags */

#define ACBT_INTERRUPT          0x0001
#define ACBT_SEND_COMMAND       0x0002
#define ACBT_READ_RESULTS       0x0004

/* ACB->OState */

#define ACBO_DETERMINE_MEDIA    1
#define ACBO_START_IORB         2
#define ACBO_ISM_COMPLETE       3
#define ACBO_COMPLETE_IORB      4
#define ACBO_CHANGE_RPM         5                                       

/* ACB->OpFlags */

#define OPF_DMA_BUF_REQD        0x0001
#define OPF_CHS_ADDRESSING      0x0002
#define OPF_FAST_PATH           0x0004
#define OPF_VERIFY_REQD         0x0008
#define OPF_VERIFY_PHASE        0x0010
#define OPF_DATA_TO_HOST        0x0020
#define OPF_DATA_TO_DSKT        0x0040
#define OPF_SYNC_ACTIVATE       0x0080

/* ACB->CurStatus */

#define REQS_NO_ERROR           0
#define REQS_RESET_FAIL         1
#define REQS_RECAL_FAIL         2
#define REQS_SEEK_FAIL          3
#define REQS_COMMAND_FAIL       4
#define REQS_MEDIA_CHANGED      5
#define REQS_NOT_READY          6
#define REQS_MEDIA_UNFORMATTED  7
#define REQS_INVALID_GEOMETRY   8
#define REQS_CTRL_TIMEOUT       9
#define REQS_TRK0_OK            10                                      
#define REQS_TRK0_FAIL          11                                      

/* ACB->SeekFlags */

#define ACBK_ISEEK_CAPABLE      0x0001
#define ACBK_ISEEK_ENABLED      0x0002
#define ACBK_NATIONAL_8477      0x0004
#define ACBK_BUTTERFLY          0x0008                                  

/* ACB->SwapReq */

#define ACBX_PENDING_STATECHG   0x8000
#define ACBX_PENDING_RESUME     0x0001
#define ACBX_PENDING_SUSPEND    0x0002
#define ACBX_PENDING_ACTIVATE   0x0004
#define ACBX_PENDING_IDLE       0x0008
#define ACBX_PENDING_GETBUF     0x0010

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Inner State Machine Commands                                           */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*-----------------------------*/
/* ACBRG_RESET                 */
/*                             */
/* - Issue controller reset    */
/*-----------------------------*/

#define ACBRG_RESET             (ACBR_RESET)


/*-----------------------------*/
/* ACBRG_CMD_START             */
/*                             */
/* - Start drive motor         */
/* - Check changeline          */
/* - Seek to requested cyl     */
/* - Issue command             */
/*-----------------------------*/       //UCC-JS07365C

#define ACBRG_CMD_START         ( ACBR_SELECT      | ACBR_MOTOR_ON   |  \
                                  ACBR_MOTOR_SPINUP|                    \
                                  ACBR_CHECK_MEDIA | ACBR_SEEK       |  \
                                  ACBR_MOTOR_WAIT  | ACBR_SETTLE     |  \
                                  ACBR_COMMAND )

/*-----------------------------*/
/* ACBRG_CMD_CONTINUE          */
/*                             */
/* - Check changeline          */
/* - Seek to requested cyl     */
/* - Issue command             */
/*-----------------------------*/
#define ACBRG_CMD_CONTINUE      ( ACBR_CHECK_MEDIA | ACBR_SEEK       |  \
                                  ACBR_SETTLE      | ACBR_COMMAND )

/*-----------------------------*/
/* ACBRG_CMD_ONLY              */
/*                             */
/* - Check changeline          */
/* - Issue command             */
/*-----------------------------*/
#define ACBRG_CMD_ONLY          ( ACBR_CHECK_MEDIA | ACBR_COMMAND )

/*-----------------------------*/
/* ACBRG_CMD_RECAL             */
/*                             */
/* - Check changeline          */
/* - Recal drive               */
/* - Seek to requested cyl     */
/* - Issue command             */
/*-----------------------------*/
#define ACBRG_CMD_RECAL         ( ACBR_CHECK_MEDIA | ACBR_RECAL      |  \
                                  ACBR_SEEK        | ACBR_SETTLE     |  \
                                  ACBR_COMMAND )


/*-----------------------------*/
/* ACBRG_DETERMINE_MEDIA       */
/*                             */
/* - Issue controller reset    */
/* - Send specify bytes        */
/* - Check changeline          */
/* - Recal drive               */
/* - Seek to requested cyl     */
/* - Issue command             */
/*-----------------------------*/       //UCC-JS07365C
#define ACBRG_DETERMINE_MEDIA   ( ACBR_RESET       | ACBR_FORCE_SELECT |  \
                                  ACBR_SPECIFY     | ACBR_MOTOR_ON     |  \
                                  ACBR_MOTOR_SPINUP|                    \
                                  ACBR_CHECK_MEDIA | ACBR_RECAL        |  \
                                  ACBR_MOTOR_WAIT  | ACBR_SETTLE       |  \
                                  ACBR_COMMAND  )

/*-----------------------------*/
/* ACBRG_CHECK_MEDIA           */
/*                             */
/* - Check changeline          */
/*-----------------------------*/       //UCC-JS07365C
#define ACBRG_CHECK_MEDIA       ( ACBR_SELECT      | ACBR_MOTOR_ON   |  \
                                  ACBR_MOTOR_SPINUP|                    \
                                  ACBR_CHECK_MEDIA  )

/*-----------------------------*/
/* ACBRG_MOTOR_ON              */
/*                             */
/* - Turn on drive motor only  */
/*-----------------------------*/
#define ACBRG_MOTOR_ON          ( ACBR_SELECT      | ACBR_MOTOR_ON )


/*-----------------------------*/
/* ACBRG_SPECIFY_ONLY          */
/*                             */
/* - Sets data rate and specify*/
/*-----------------------------*/
#define ACBRG_SPECIFY_ONLY      ( ACBR_SELECT      | ACBR_SPECIFY )

/*------------------------------------------------------------------------*/
/*                                                                        */
/* IORB Workspace Information                                             */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*-----------------------*/
/* IORB Workspace Layout */
/*-----------------------*/

typedef struct _ADDWSP
{
  USHORT        Flags;
  UCHAR         N;

} ADDWSP, FAR *PADDWSP;


/* ADDWSP->Flags */

#define WSF_DMA_BUF_REQD        OPF_DMA_BUF_REQD
#define WSF_FAST_PATH           OPF_FAST_PATH
#define WSF_DATA_TO_HOST        OPF_DATA_TO_HOST
#define WSF_DATA_TO_DSKT        OPF_DATA_TO_DSKT
#define WSF_SYNC_ACTIVATE       OPF_SYNC_ACTIVATE


/* Miscellaneous */


/* Flags for SendCommand() */

#define SCF_IRQTIMER            0x0001


/* Machine Config Packet->BusInfo */

#ifndef BUSINFO_ABIOS_PRESENT
#define BUSINFO_ABIOS_PRESENT   0x08
#endif

/*------------------------------------------------------------------------*/
/*                                                                        */
/* Adapter/Unit Parameter Information                                     */
/*                                                                        */
/*------------------------------------------------------------------------*/

/*-------------------------------*/
/* Unit Table                    */
/* ----------                    */
/*                               */
/* One per unit (drive)          */
/*                               */
/*-------------------------------*/

typedef struct _UTBL
{
  NPUCB         npUCB;

  USHORT        Flags;

  USHORT        Status;

  USHORT        FormFactor;

  UCHAR         Specify[2];

  USHORT        BIOSId;
  USHORT        BIOSCyl;
  USHORT        BIOSMediaState;

} UTBL;


/* UTBL->Flags */

#define UTBF_INSTALLED          0x0001
#define UTBF_SPECIFY            0x0002
#define UTBF_NODASDSUPPORT      0x0004
#define UTBF_USER_CHANGELINE    0x0008
#define UTBF_NO_CHANGELINE      0x0010
#define UTBF_CHANGELINE_INVERT  0x0020
#define UTBF_NOT_DRIVE_AB       0x0040
#define UTBF_BIOS_SUPPORT       0x0080
#define UTBF_DUALSPEED          0x0100
#define UTBF_USER_MEDIASENSE    0x0200                               /*@V85053*/
#define UTBF_NO_MEDIASENSE      0x0400
#define UTBF_FORCE              0x0800                              //@V149969


/* UTS->Status */
#define UTS_OK                  0
#define UTS_RECAL_FAILED        1
#define UTS_INCOMPATIBLE        2

/*-------------------------------*/
/* Adapter Table                 */
/* -------------                 */
/*                               */
/* One per controller.           */
/*                               */
/*-------------------------------*/
#define NUMRES  4                           /*V98451*/

typedef struct _ATBL
{
  USHORT        BasePort;
  USHORT        IRQLevel;
  USHORT        DMAChannel;

  USHORT        Flags;
  USHORT        Status;

  USHORT        BIOSMotorStatus;

  HADAPTER      hAdapter;                    /*V98451*/
  DSKTPARMTABLE DsktParmTbl;

  NPACB         npACB;
  USHORT        ACBIndex;                    /*@V85053*/

  USHORT        cUnits;
  UTBL          Unit[MAX_DRIVES];
  UCHAR         ResourceBuf[sizeof(AHRESOURCE)+sizeof(HRESOURCE)*NUMRES]; /*@V98451*/

} ATBL;

/* ATBL->Flags */

#define ATBF_DISABLED           0x0001
#define ATBF_DSKTPARM_OBTAINED  0x0004
#define ATBF_NO_MEDIASENSE      0x0008
#define ATBF_INSTALLED          0x0010
#define ATBF_CHANGELINE_INVERT  0x0020
#define ATBF_FIFO_SUPPORT       0x0040
#define ATBF_FORCE              0x0080                              //@V149969

/* ATBL->Status */

#define ATS_OK                  0
#define ATS_NOT_PRESENT         1
#define ATS_SKIPPED             2
#define ATS_SET_IRQ_FAILED      3
#define ATS_RESET_FAILED        4
#define ATS_ALLOC_IRQ_FAILED    5    /*V98451*/
#define ATS_ALLOC_IO_FAILED     6    /*V98451*/
#define ATS_ALLOC_DMA_FAILED    7    /*V98451*/


#define ACB_POOL_SIZE                                                 \
  (MAX_ADAPTERS *                                                     \
  (sizeof(ACB) + (MAX_DRIVES *                                        \
                 (sizeof(UCB) + MAX_MEDIA_INFO * sizeof(MEDIAINFO)))))

#define RES_IRQ_ENTRY  0
#define RES_IO1_ENTRY  1
#define RES_IO2_ENTRY  2
#define RES_DMA_ENTRY  3
