/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/

/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1REGS.H
 *
 * DESCRIPTIVE NAME = Diskette Controller hardware register defines
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 *
*/

/*---------------------------------------*/
/* Diskette Controller Registers         */
/*---------------------------------------*/

#define  FCR_SRA        0x0000
#define  FCR_SRB        0x0001
#define  FCR_DOR        0x0002
#define  FCR_TDR        0x0003
#define  FCR_DSR        0x0004
#define  FCR_MSR        0x0004
#define  FCR_DATA       0x0005
#define  FCR_DIR        0x0007
#define  FCR_CCR        0x0007


/*-------------------*/
/* Status Reqister A */
/*-------------------*/

#define  FCR_SRA_INT_PENDING            0x80            /* PS-2 Mode */
#define  FCR_SRA_DRV2                   0x40            /* PS-2 Mode */
#define  FCR_SRA_STEP                   0x20            /* PS-2 Mode */
#define  FCR_SRA_TRK0                   0x10            /* PS-2 Mode */
#define  FCR_SRA_HDSEL                  0x08            /* PS-2 Mode */
#define  FCR_SRA_IDX                    0x04            /* PS-2 Mode */
#define  FCR_SRA_WP                     0x02            /* PS-2 Mode */
#define  FCR_SRA_DIR                    0x01            /* PS-2 Mode */

/*-------------------*/
/* Status Reqister B */
/*-------------------*/

#define  FCR_SRB_DRIVE_SEL_0            0x20            /* PS-2 Mode */
#define  FCR_SRB_WRDATA                 0x10            /* PS-2 Mode */
#define  FCR_SRB_RDDATA                 0x08            /* PS-2 Mode */
#define  FCR_SRB_WE                     0x04            /* PS-2 Mode */
#define  FCR_SRB_MOTOR_ENABLES          0x03            /* PS-2 Mode */

/*-------------------------*/
/* Digital Output Register */
/*-------------------------*/

#define  FCR_DOR_MOTOR_ENABLE           0xF0
#define  FCR_DOR_MOTOR_0                0x10
#define  FCR_DOR_DMA_GATE               0x08
#define  FCR_DOR_RESET                  0x04
#define  FCR_DOR_DRIVE_SEL              0x03

/*---------------------*/
/* Tape Drive Register */
/*---------------------*/

#define  FCR_TDR_TAPE_SEL               0x03
#define  FCR_TDR_BOOT_ID                0x0C            /* PS-2 Mode */
#define  FCR_TDR_DRIVE_ID               0x30            /* PS-2 Mode */

#define  FCR_TDR_MEDIA_ID_DISABLE       0x20            /* N8734x parts only */

#define  FCR_TDR_MEDIA_ID               0xC0            /* PS-2 Mode */
#define  FCR_TDR_MEDIA_ID_4MB           0x40
#define  FCR_TDR_MEDIA_ID_2MB           0x80
#define  FCR_TDR_MEDIA_ID_1MB           0xC0
#define  FCR_TDR_MEDIA_ID_INVALID       0x00


/*---------------------*/
/* Data Rate Select    */
/*---------------------*/

#define  FCR_DSR_SOFT_RESET             0x80
#define  FCR_DSR_POWER_DOWN             0x40
#define  FCR_DSR_PRECOMP                0x1C
#define  FCR_DSR_RATE                   0x03

#define  FCR_DSR_RATE_1MB               0x03
#define  FCR_DSR_RATE_250KB             0x02
#define  FCR_DSR_RATE_300KB             0x01
#define  FCR_DSR_RATE_500KB             0x00

/*----------------------*/
/* Main Status Register */
/*----------------------*/

#define  FCR_MSR_RQM                    0x80
#define  FCR_MSR_DIO                    0x40
#define  FCR_MSR_NON_DMA                0x1C
#define  FCR_MSR_DRIVE_3_BUSY           0x08
#define  FCR_MSR_DRIVE_2_BUSY           0x04
#define  FCR_MSR_DRIVE_1_BUSY           0x02
#define  FCR_MSR_DRIVE_0_BUSY           0x01

/*------------------------*/
/* Digital Input Register */
/*------------------------*/

#define  FCR_DIR_DSK_CHG                0x80

#define  FCR_DIR_RATE                   0x06            /* PS-2 Mode */
#define  FCR_DIR_HIGH_DENSITY           0x01            /* PS-2 Mode */

/*--------------------------------*/
/* Configuration Control Register */
/*--------------------------------*/

#define  FCR_CCR_RATE_1MB               0x03
#define  FCR_CCR_RATE_250KB             0x02
#define  FCR_CCR_RATE_300KB             0x01
#define  FCR_CCR_RATE_500KB             0x00


/*--------------------------------*/
/* Result Phase Status Register 0 */
/*--------------------------------*/
#define ST0_INT_CODE                    0xC0
#define ST0_ABNORMAL_TERM               0x40
#define ST0_INVALID_COMMAND             0x80
#define ST0_READY_CHANGE                0xC0

#define ST0_SEEK_END                    0x20
#define ST0_EQUIPMENT_CHK               0x10
#define ST0_HEAD_SEL                    0x04
#define ST0_DRIVE_SEL                   0x03

/*--------------------------------*/
/* Result Phase Status Register 1 */
/*--------------------------------*/
#define ST1_END_OF_CYL                  0x80
#define ST1_DATA_ERROR                  0x20
#define ST1_OVERRUN                     0x10
#define ST1_NO_DATA                     0x04
#define ST1_WRITE_PROTECT               0x02
#define ST1_NO_ADDRESS_MARK             0x01

/*--------------------------------*/
/* Result Phase Status Register 2 */
/*--------------------------------*/
#define ST2_CONTROL_MARK                0x40
#define ST2_DATA_ERROR                  0x20
#define ST2_WRONG_CYL                   0x10
#define ST2_BAD_CYL                     0x02
#define ST2_NO_DATA_ADDRESS_MARK        0x01

/*--------------------------------*/
/* Result Phase Status Register 3 */
/*--------------------------------*/
#define ST3_WRITE_PROTECT               0x40
#define ST3_TRACK_0                     0x10
#define ST3_HEAD_SEL                    0x04
#define ST3_DRIVE_SEL                   0x03


/*---------------------------------------*/
/* Diskette Controller Commands          */
/*---------------------------------------*/

#define  FC_READ_DATA                   0x46
#define  FC_READ_DELETED_DATA           0x4C
#define  FC_WRITE_DATA                  0x45
#define  FC_WRITE_DELETED_DATA          0x49
#define  FC_READ_TRACK                  0x42
#define  FC_VERIFY                      0x46
#define  FC_VERSION                     0x10
#define  FC_FORMAT_TRACK                0x4D
#define  FC_SCAN_EQUAL                  0x51
#define  FC_SCAN_LOW_EQUAL              0x59
#define  FC_SCAN_HIGH_EQUAL             0x5D
#define  FC_RECALIBRATE                 0x07
#define  FC_SENSE_INT_STATUS            0x08
#define  FC_SPECIFY                     0x03
#define  FC_SENSE_DRIVE_STATUS          0x04
#define  FC_SEEK                        0x0F
#define  FC_CONFIGURE                   0x13
#define  FC_SEEK_RELATIVE               0x8f
#define  FC_DUMPREG                     0x0E
#define  FC_READ_ID                     0x4A
#define  FC_PERPENDICULAR_MODE          0x12
#define  FC_LOCK                        0x94


/*---------------------------------------*/
/* Diskette Controller Command Lengths   */
/*---------------------------------------*/

#define  FC_LEN_READ_DATA               9
#define  FC_LEN_READ_DELETED_DATA       9
#define  FC_LEN_WRITE_DATA              9
#define  FC_LEN_WRITE_DELETED_DATA      9
#define  FC_LEN_READ_TRACK              9
#define  FC_LEN_VERIFY                  9
#define  FC_LEN_VERSION                 1
#define  FC_LEN_FORMAT_TRACK            6
#define  FC_LEN_SCAN_EQUAL              9
#define  FC_LEN_SCAN_LOW_EQUAL          9
#define  FC_LEN_SCAN_HIGH_EQUAL         9
#define  FC_LEN_RECALIBRATE             2
#define  FC_LEN_SENSE_INT_STATUS        1
#define  FC_LEN_SPECIFY                 3
#define  FC_LEN_SENSE_DRIVE_STATUS      2
#define  FC_LEN_SEEK                    3
#define  FC_LEN_CONFIGURE               4
#define  FC_LEN_SEEK_RELATIVE           2
#define  FC_LEN_DUMPREG                 1
#define  FC_LEN_READ_ID                 2
#define  FC_LEN_PERPENDICULAR_MODE      2
#define  FC_LEN_LOCK                    1


/*---------------------------------------*/
/* Diskette Controller Result Lengths    */
/*---------------------------------------*/

#define  FR_LEN_READ_DATA               7
#define  FR_LEN_READ_DELETED_DATA       7
#define  FR_LEN_WRITE_DATA              7
#define  FR_LEN_WRITE_DELETED_DATA      7
#define  FR_LEN_READ_TRACK              7
#define  FR_LEN_VERIFY                  7
#define  FR_LEN_VERSION                 1
#define  FR_LEN_FORMAT_TRACK            7
#define  FR_LEN_SCAN_EQUAL              7
#define  FR_LEN_SCAN_LOW_EQUAL          7
#define  FR_LEN_SCAN_HIGH_EQUAL         7
#define  FR_LEN_RECALIBRATE             0
#define  FR_LEN_SENSE_INT_STATUS        2
#define  FR_LEN_SPECIFY                 0
#define  FR_LEN_SENSE_DRIVE_STATUS      1
#define  FR_LEN_SEEK                    0
#define  FR_LEN_CONFIGURE               0
#define  FR_LEN_SEEK_RELATIVE           0
#define  FR_LEN_DUMPREG                 10
#define  FR_LEN_READ_ID                 7
#define  FR_LEN_PERPENDICULAR_MODE      0
#define  FR_LEN_LOCK                    1

#define  FR_LEN_INVALID_CMD             1

/*---------------------------------------*/
/* Commands unique to National 8477,     */
/* 87311 series controllers              */
/*---------------------------------------*/
#define  FC_MODE                        0x01
#define  FC_NSC                         0x18

#define  FC_LEN_MODE                    5
#define  FC_LEN_NSC                     1

#define  FR_LEN_MODE                    0
#define  FR_LEN_NSC                     1

/*---------------------------------------*/
/* Miscellansous                         */
/*---------------------------------------*/
#define FR_VERSION_I82077               0x90    /* Results[0] - VERSION Cmd  */
#define FR_LOCK                         0x10    /* Results[0] - LOCK    Cmd  */

#define FR_VERSION_N8477A               0x72    /* Results[0] - NSC Cmd      */
#define FR_VERSION_N8477B               0x73    /* Results[0] -              */

#define FIFO_THRESHOLD_DEFAULT          0x07    /* Default FIFO Threshold    */
// @V88464 - Add FIFO_DISABLED
#define FIFO_DISABLED                   0x20    // Cmd[2] bit 5,  1 => disable
#define ENABLE_IMPLIED_SEEKS            0x40    /* Enable Implied Seeks      */

#define FC_SRT_MASK                     0xF0    /* Step Rate Index Mask      */

/*---------------------------------------*/
/* Slave DMA Commands                    */
/*---------------------------------------*/
#define DMA_READ                        0x44
#define DMA_WRITE                       0x48
#define DMA_VERIFY                      0x40


/*---------------------------------------*/
/*                                       */
/*---------------------------------------*/

#define MAX_CMD_LEN                     10
#define MAX_RESULTS_LEN                 10
#define FC_MAX_REGS                     8
