/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1PRO.H
 *
 * DESCRIPTIVE NAME = C function prototype declarations
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION : C Function Prototype statements
 *
 * Purpose: C Function prototype statements, and pragma's to
 *          include functions to the swappable segment.
 *
 *
 *
 *
*/

/*----------------------------------------------------------------------------*/
/*  FLP1ISM.C - Inner State Machine                                           */
/*----------------------------------------------------------------------------*/

VOID   FAR  StartOSMRequest( NPACB npACB, USHORT ReqFlags );
VOID   FAR  StartISM( NPACB npACB );
USHORT NEAR NextReqIndex( NPACB npACB );
VOID   NEAR InterruptState( NPACB npACB );
VOID   NEAR TimedState( NPACB npACB );
VOID   NEAR StartReset( NPACB npACB );
VOID   NEAR EndReset( NPACB npACB );
VOID   NEAR StartSelect( NPACB npACB );
VOID   NEAR StartSpecify( NPACB npACB );
VOID   NEAR CheckMediaChange( NPACB npACB );
VOID   NEAR ResetMediaChange( NPACB npACB );
VOID   NEAR EndResetMediaChange( NPACB npACB );
VOID   NEAR StartMotorOn( NPACB npACB );
VOID   NEAR MotorWait( NPACB npACB );
VOID   FAR  MotorOnAsync( ULONG TimerHandle, PACB npACB, PUCB npUCB  );
VOID   NEAR StartRecal( NPACB npACB );
VOID   NEAR EndRecal( NPACB npACB );
VOID   NEAR StartSeek( NPACB npACB );
VOID   NEAR EndSeek( NPACB npACB );
VOID   NEAR ImpliedSeekCheck( NPACB npACB );
VOID   NEAR SetSeekState( NPACB npACB, USHORT SeekState );
VOID   NEAR StartSettle( NPACB npACB );
VOID   NEAR EndSettle( NPACB npACB );
VOID   NEAR StartCommand( NPACB npACB );
VOID   NEAR EndCommand( NPACB npACB );
VOID   NEAR SendReset( NPACB npACB );
USHORT FAR  f_ReadResults( NPACB npACB );
USHORT NEAR ReadResults( NPACB npACB );
USHORT FAR  f_SendCommand( NPACB npACB, USHORT Flags );
USHORT NEAR SendCommand( NPACB npACB, USHORT Flags );
USHORT FAR  CheckMSRSend( NPACB npACB );
USHORT NEAR CheckMSRRead( NPACB npACB );

USHORT NEAR SetupDMA( NPACB npACB );

VOID   FAR  IODelay(VOID);

USHORT FAR _loadds DsktIRQ0(VOID);
USHORT FAR _loadds DsktIRQ1(VOID);

USHORT NEAR DsktInterrupt( USHORT ACBIndex );

VOID   FAR  IRQTimeOutHandler( ULONG TimerHandle, ULONG Parm1, ULONG Parm2 );
VOID   FAR  DelayTimerExpired( ULONG TimerHandle, ULONG Parm1, ULONG Parm2 );
USHORT NEAR ClearInterrupt( NPACB npACB );

/*----------------------------------------------------------------------------*/
VOID   NEAR WaitTrack0Signal( NPACB npACB);                             
/*  FLP1OSM1.C - Outer State Machine                                          */
/*----------------------------------------------------------------------------*/

typedef PIORB FAR *PPIORB;

VOID   NEAR FLP1Str1(VOID);
VOID   NEAR FlpInitComplete( PRPH pRPH );                           //@V149969
VOID   FAR  StatusError(PRPH pRPH, USHORT ErrorCode );
VOID   FAR  _loadds FLP1ADDEntry( PIORBH pFirstIORB );
PIORB  NEAR PreProcessIORBs( NPACB npACB, PPIORB ppFirstIORB );
VOID   NEAR RemoveIORB( PIORB pIORB, PIORB pIORBPrev, PPIORB pIORBFirst );
VOID   FAR  StartOSM( NPACB npACB );
VOID   NEAR CompleteIORB( NPACB npACB );
USHORT NEAR ActivateACBCheck( NPACB npACB );
USHORT NEAR ResultsToIORBError( NPACB npACB );
VOID   NEAR StartIORB( NPACB npACB );
USHORT FAR  NextIORB( NPACB npACB );
VOID   NEAR StartMediaDetermine( NPACB npACB );
VOID   FAR  DetermineMedia1( NPACB npACB );
VOID   FAR  DetermineMedia2( NPACB npACB );
VOID   FAR  DetermineMedia3( NPACB npACB );                             
VOID   NEAR CheckChangeLine( NPACB npACB );
VOID   FAR  CheckChangeLine1( NPACB npACB );
VOID   NEAR ReadMediaSense( NPACB npACB );
VOID   FAR  ReadMediaSenseDone( NPACB npACB );
VOID   NEAR GetMediaGeometry( NPACB npACB );
VOID   FAR  GetMediaGeometry1( NPACB npACB );
VOID   NEAR SetMediaGeometry( NPACB npACB );
VOID   NEAR SetLogicalGeometry( NPACB npACB );
VOID   NEAR GetDeviceGeometry( NPACB npACB );
VOID   NEAR AllocateUnit( NPACB npACB );
VOID   NEAR DeallocateUnit( NPACB npACB );
VOID   NEAR ChangeUnitInfo( NPACB npACB );
VOID   NEAR GetDeviceTable( NPACB npACB );
VOID   NEAR CompleteInit( NPACB npACB );
VOID   NEAR StartChangeRPM( NPACB npACB );                              
VOID   FAR  ChangeRPMStage0( NPACB npACB );                             
VOID   FAR  ChangeRPMStage1( NPACB npACB );                             
VOID   FAR  ChangeRPMStage2( NPACB npACB );                             
VOID   FAR  ChangeRPMStage3( NPACB npACB );                             
VOID   FAR  EndChangeRPM( NPACB npACB );                                



/*----------------------------------------------------------------------------*/
/*  FLP1OSM2.C - Outer State Machine                                          */
/*----------------------------------------------------------------------------*/

VOID   NEAR ExecuteIO( NPACB npACB );
VOID   NEAR ExecIOInit( NPACB npACB );
VOID   NEAR ExecIOStart( NPACB npACB );
VOID   NEAR ExecIOPartial( NPACB npACB );
VOID   FAR  ExecuteIODone( NPACB npACB );
VOID   NEAR ExecuteIORetry( NPACB npACB );
VOID   NEAR InitVerifyPhase( NPACB npACB );
VOID   NEAR CompleteVerifyPhase( NPACB npACB );
VOID   NEAR Format( NPACB npACB );
VOID   FAR  FormatDone( NPACB npACB );
VOID   NEAR FormatRetry( NPACB npACB );
USHORT NEAR CheckBufRequired( PIORB_EXECUTEIO pIORB );
USHORT FAR  BlkSizeToN( USHORT BlkSize );

/*----------------------------------------------------------------------------*/
/*  FLP1OSM3.C - Outer State Machine                                          */
/*----------------------------------------------------------------------------*/

USHORT NEAR SuspendIORB( NPACB npACB, PIORB pIORB );
USHORT NEAR ImmediateSuspendCheck( NPACB npACB );
USHORT NEAR DeferredSuspendCheck( NPACB npACB );
USHORT NEAR CheckACBsIdle( NPHWRESOURCE npHWR );
USHORT NEAR ResumeIORB( NPACB npACB, PIORB pIORB );
USHORT FAR  AllocateHWResources( NPACB npACB );
USHORT FAR  FreeHWResources( NPACB npACB );
USHORT FAR  StartSuspend( NPACB npACB );
USHORT FAR  StartBufferAlloc( NPACB npACB );
USHORT FAR  StartActivateACB( NPACB npACB );
USHORT FAR  StartDeActivateACB( NPACB npACB );
VOID   FAR  PASCAL StateCtxHookRtn( VOID );
VOID   FAR  CompleteStateChange( NPACB npACB );
VOID   FAR  StartStateChange( NPACB npACB );
USHORT FAR  ActivateACB( NPACB npACB );
VOID   FAR  DeactivateACB( NPACB npACB );
USHORT APIENTRY APMSendPacket( PAPMIDC_NOTIFY_PKT );              /* @V143950 */
USHORT FAR  GetDMABuffer( NPACB npACB );                          /*@V90990*/
USHORT NEAR CompleteSuspend( NPHWRESOURCE npHWR );
VOID   FAR  MotorIdleCheck(ULONG TimerHandle, ULONG Parm1, ULONG Parm2 );
VOID   FAR  TurnMotorsOff( NPACB npACB );
VOID   NEAR SetControllerState( NPACB npACB, USHORT Enable );
VOID   FAR  RETRYTimerHandler( ULONG TimerHandle, PACB pACB, ULONG Parm2 );
VOID   FAR  ResourceRetry( NPACB npACB);                          /*@V90990*/

                                                                    //@V149969
                                                                    //@VVVVVVV
/*----------------------------------------------------------------------------*/
/*  FLP1PRTF.C Procedures                                                     */
/*----------------------------------------------------------------------------*/

VOID  NEAR  sprntf( PSZ s, PSZ fmt, ... );

/*----------------------------------------------------------------------------*/
/*  FLP1APME.C - APM Callback interfaces                                      */
/*----------------------------------------------------------------------------*/
USHORT FAR APMEventHandler( PAPMEVENT Event );
USHORT NEAR APMSuspend( void );
USHORT NEAR APMResume( void );

/*----------------------------------------------------------------------------*/
/*  FLP1INI2.C - Reinitialization                                             */
/*----------------------------------------------------------------------------*/

USHORT NEAR ReConfigureController( NPATBL npAT );
USHORT NEAR ReConfigureUnit( NPATBL npAT, USHORT Unit );

VOID   NEAR CheckIfButterfly( NPATBL npAT );                        
USHORT FAR  CheckController( NPATBL npAT );
VOID   NEAR CheckFIFOSupport( NPATBL npAT );
USHORT NEAR CheckMediaIDSupport( NPATBL npAT );
USHORT NEAR CheckUnitInstalled( NPUCB npUCB );
USHORT NEAR InitControllerReset( NPACB npACB );
USHORT NEAR InitIORequest( NPUCB npUCB );
VOID   NEAR InitIOWait(VOID);                                       //@AAAAAAA
VOID   FAR  InitIODone( NPACB npACB );                              //@V149969

/*----------------------------------------------------------------------------*/
/*  FLP1INIT.C - Initialization                                               */
/*----------------------------------------------------------------------------*/

typedef VOID (FAR *PCV)();

VOID   FAR  DriveInit(PRPINITIN pRPH );
VOID   NEAR SetupADDVars( VOID );
VOID   NEAR SetupDMABuffers( VOID );
USHORT FAR  ConfigureController( NPATBL npAT );
//@@USHORT FAR  CheckController( NPATBL npAT );                     //@V149969(D)
//@@VOID   NEAR CheckFIFOSupport( NPATBL npAT );                    //@V149969(D)
USHORT NEAR Enable288Drives( VOID );
//@@USHORT NEAR CheckMediaIDSupport( NPATBL npAT );                 //@V149969(D)
USHORT NEAR ConfigureUnit( NPATBL npAT, USHORT UnitId );
//@@USHORT NEAR CheckUnitInstalled( NPUCB npUCB );                  //@V149969(D)
USHORT NEAR CheckUnitRPMChangeable( NPUCB npUCB );                      
VOID   NEAR RestoreBIOSCyl( VOID );
//@@USHORT NEAR InitControllerReset( NPACB npACB );                 //@V149969(D)
//@@USHORT NEAR InitIORequest( NPUCB npUCB );                       //@V149969(D)
//@@VOID   NEAR InitIOWait(VOID);                                   //@V149969(D)
//@@VOID   FAR  InitIODone( NPACB npACB );                          //@V149969(D)
VOID   FAR  CalibrateTimers( NPACB npACB );
ULONG  FAR  CalibrateWorker( NPACB npACB, PCV pWorker );
VOID   FAR  CalibrateTimer( ULONG hCalibrateTimer, ULONG Unused1, ULONG Unused2 );
VOID   NEAR CalcSpecifyBytes(NPUCB npUCB, USHORT Specify1, USHORT Specify2);
VOID   NEAR AdjustSpecifyBytes( NPATBL npAT );
USHORT NEAR GetInt13Info( NPUTBL npUT, USHORT DriveId );
VOID   NEAR GetBIOSDsktInfo( VOID );
USHORT NEAR GeomToFormFactor( PGEOMETRY pGeo );
VOID   NEAR StartMotorTimer( VOID );
VOID   NEAR CheckHWConflicts();
VOID   NEAR CheckACBViable( NPATBL npAT );                           /*@V85053*/
USHORT NEAR InstallCleanup( VOID );
VOID   NEAR PrintInfo( NPATBL npAT );
VOID   NEAR TTYWrite( PSZ Buf );
USHORT NEAR ParseCmdLine( PDDD_PARM_LIST pADDParms, NPATBL npAT );
NPBYTE FAR  InitAllocate( USHORT Size );
VOID   FAR  InitDeAllocate( USHORT Size );
VOID   NEAR SaveCommand( PSZ pCmd );                                //@V149969

