/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME =  FLP1MISC.H
 *
 * DESCRIPTIVE NAME = Miscellaneous Data Structures - BIOS related
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION : Miscellaneous structures
 *
 * Purpose: Contains ROMCFG and Int 1E (Diskette Parameter Table)
 *          layouts. Also contains offsets in the BIOS Data Area
 *          of various Diskette BIOS fields.
 *
 *
 *
 *
 *
*/
/*------------------------------------------*/
/*                                          */
/* Disk/Diskette Configuration Data Table   */
/* --------------------------------------   */
/*                                          */
/* A linked list of these structures is     */
/* used by the kernel to pass disk/diskette */
/* geometry obtained via INT 13 to the      */
/* device driver.                           */
/*                                          */
/*------------------------------------------*/

typedef struct _ROMCFG
{
  USHORT           ROMlink;           /* link to next table entry       */
  USHORT           ROMcyls;           /* maximum number of cylinders    */
  USHORT           ROMsecptrk;        /* maximum sectors per track      */
  UCHAR            ROMdevnbr;         /* device number                  */
  USHORT           ROMheads;          /* number of heads                */
  USHORT           ROMwpf;            /* write precompensation factor   */
  USHORT           ROMflags;          /* flag byte                      */

} ROMCFG;

typedef ROMCFG far *PROMCFG;

#define ROMfixed        0x0001
#define ROMchgline      0x0002


typedef struct _DSKTPARMTABLE
{
  UCHAR         Specify[2];             /*                              */
  UCHAR         MotorOffTicks;          /* units = 50ms/tick            */
  UCHAR         SectorN;                /* units = 2^(N+7)              */
  UCHAR         SectorsPerTrack;        /*                              */
  UCHAR         RWGapLength;            /*                              */
  UCHAR         DTL;                    /*                              */
  UCHAR         FmtGapLength;           /*                              */
  UCHAR         FmtFillByte;            /*                              */
  UCHAR         SettleTime;             /* units = mS                   */
  UCHAR         MotorOnTime;            /* units = 125mS                */

} DSKTPARMTABLE, FAR *PDSKTPARMTABLE;

#define         INT_1E                  0x1E

#define BIOS_DATA_PHYS                  0x0400

#define BIOS_DSKT_RECALSTATUS           0x3E
#define BIOS_DSKT_MOTORSTATUS           0x3F
#define BIOS_DSKT_MEDIACONTROL          0x8B
#define BIOS_DSKT_MEDIASTATE            0x90
#define BIOS_DSKT_CYL                   0x94
