/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1MIF.C
 *
 * DESCRIPTIVE NAME = Media Information defines
 *
 *
 *
 * VERSION = V2.1
 *
 * DATE = 94/03/14
 *
 * DESCRIPTION :
 *
 * Purpose: Contains sets of defines describing each type of media
 *          this driver supports.
 *
 *
 *
 *
 *
*/


#define MI_FMT_FILLBYTE 0xF6
#define BYTES_512       512
#define BYTES_1024      1024                                            

/*----------------*/
/*  360KB Media   */
/*----------------*/

#define MAX_MEDIA_0360   1

#define MI_CYLN_0360    40
#define MI_HEAD_0360     2
#define MI_SECT_0360     9

#define MI_SPEC_0360_1  0xEF
#define MI_SPEC_0360_2  0x02

#define MI_FMGL_0360    0x50
#define MI_RWGL_0360    0x2A

#define MI_RATE_0360    FCR_DSR_RATE_250KB

#define MI_FMFC_0360    1


/*----------------*/
/* 1200KB Media   */
/*----------------*/

#define MAX_MEDIA_1200   4                                              

#define MI_CYLN_1200    80
#define MI_HEAD_1200     2
#define MI_SECT_1200    15

#define MI_SPEC_1200_1  0xDF
#define MI_SPEC_1200_2  0x02

#define MI_FMGL_1200    0x54
#define MI_RWGL_1200    0x1B

#define MI_RATE_1200    FCR_DSR_RATE_500KB

#define MI_FMFC_1200    2

/*----------------------------*/
/*  360KB Media in 1.2M Drive */
/*----------------------------*/

#define MI_RATE_0362    FCR_DSR_RATE_300KB


/*----------------*/
/*  720KB Media   */
/*----------------*/

#define MAX_MEDIA_0720   1

#define MI_CYLN_0720    80
#define MI_HEAD_0720     2
#define MI_SECT_0720     9

#define MI_SPEC_0720_1  0xEF
#define MI_SPEC_0720_2  0x02

#define MI_FMGL_0720    0x50
#define MI_RWGL_0720    0x1B

#define MI_RATE_0720    FCR_DSR_RATE_250KB

#define MI_FMFC_0720    3


/*----------------*/
/* 1440KB Media   */
/*----------------*/

#define MAX_MEDIA_1440   4                                              

#define MI_CYLN_1440    80
#define MI_HEAD_1440     2
#define MI_SECT_1440    18

#define MI_SPEC_1440_1  0xDF
#define MI_SPEC_1440_2  0x02

#define MI_FMGL_1440    0x65
#define MI_RWGL_1440    0x1B

#define MI_RATE_1440    FCR_DSR_RATE_500KB

#define MI_FMFC_1440    4


/*----------------*/
/* 2880KB Media   */
/*----------------*/

#define MAX_MEDIA_2880   5                                              

#define MI_CYLN_2880    80
#define MI_HEAD_2880     2
#define MI_SECT_2880    36

#define MI_SPEC_2880_1  0xAF
#define MI_SPEC_2880_2  0x02

#define MI_FMGL_2880    0x53
#define MI_RWGL_2880    0x1B

#define MI_RATE_2880    FCR_DSR_RATE_1MB

#define MI_FMFC_2880    5

/*----------------*/                                                    
/* 1232KB Media   */    /* MF  3.5inchi */                              
/*----------------*/                                                    
                                                                        
#define MAX_MEDIA_1232MF 1                                              
                                                                        
#define MI_CYLN_1232MF  77                                              
#define MI_HEAD_1232MF   2                                              
#define MI_SECT_1232MF   8                                              
                                                                        
#define MI_SPEC_1232_1MF 0xD1                                           
#define MI_SPEC_1232_2MF 0x02                                           
                                                                        
#define MI_FMGL_1232MF  0x74                                            
#define MI_RWGL_1232MF  0x35                                            
                                                                        
#define MI_RATE_1232MF  FCR_DSR_RATE_500KB                              
                                                                        
/*----------------*/                                                    
/* 1200KB Media   */    /* MF  3.5inchi */                              
/*----------------*/                                                    
                                                                        
#define MAX_MEDIA_1200MF 1                                              
                                                                        
#define MI_CYLN_1200MF  80                                              
#define MI_HEAD_1200MF   2                                              
#define MI_SECT_1200MF  15                                              
                                                                        
#define MI_SPEC_1200_1MF 0xD1                                           
#define MI_SPEC_1200_2MF 0x02                                           
                                                                        
#define MI_FMGL_1200MF  0x54                                            
#define MI_RWGL_1200MF  0x1B                                            
                                                                        
#define MI_RATE_1200MF  FCR_DSR_RATE_500KB                              
                                                                        
/*----------------*/                                                    
/*  720KB Media   */    /* F  5.25inchi */                              
/*----------------*/                                                    
                                                                        
#define MAX_MEDIA_0720F  1                                              
                                                                        
#define MI_SPEC_0720_1F  0xDF                                           
                                                                        
#define MI_FMGL_0720F    0x50                                           
#define MI_RWGL_0720F    0x2A                                           
                                                                        
#define MI_RATE_0720F    FCR_DSR_RATE_300KB                             
                                                                        
/*----------------*/                                                    
/* 1232KB Media   */    /* F   5.25inchi */                             
/*----------------*/                                                    
                                                                        
#define MAX_MEDIA_1232F  1                                              
                                                                        
#define MI_CYLN_1232F   77                                              
#define MI_HEAD_1232F    2                                              
#define MI_SECT_1232F    8                                              
                                                                        
#define MI_SPEC_1232_1F 0xDF                                            
#define MI_SPEC_1232_2F 0x02                                            
                                                                        
#define MI_FMGL_1232F   0x74                                            
#define MI_RWGL_1232F   0x35                                            
                                                                        
#define MI_RATE_1232F   FCR_DSR_RATE_500KB                              
                                                                        
/*------------------------------------*/
/* Format GAPs for Non-standard media */
/*------------------------------------*/

#define NS_FMGL_500K_2048       0xFF
#define NS_FMGL_500K_1024       0x74
#define NS_FMGL_500K_256        0x36

#define NS_FMGL_250K_2048       0xFF
#define NS_FMGL_250K_1024       0xF0
#define NS_FMGL_250K_256        0x32
