/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLP1APME.C
 *
 * DESCRIPTIVE NAME = ISA Diskette Driver - APM callback
 *
 *
 *
 * VERSION = Vx.x
 *
 * DATE =  96/03/29
 *
 * DESCRIPTION :
 *
 * Purpose:       Contains suspend and resume code to interact with
 *                the APM driver.
 *
 *
 *
 *   03/29/96  @V149969           Add support for warm docking and warm device
 *                                swap.  (New file)
*******************************************************************************/
#define INCL_NOBASEAPI                                              //@V149969
#define INCL_NOPMAPI                                                //VVVVVVVV
#define INCL_DOSERRORS
#include "os2.h"
#include "dos.h"
#include "bseerr.h"

#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"
#include "apmcalls.h"
#include "doccalls.h"

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "flp1cons.h"
#include "flp1regs.h"
#include "flp1misc.h"
#include "flp1type.h"
#include "flp1extn.h"
#include "flp1pro.h"
#include "flp1mif.h"

/*------------------------------------*/
/* APM Suspend/Resume Support         */
/* Reinitializes adapters and units   */
/* following a resume event.          */
/*------------------------------------*/

USHORT FAR APMEventHandler(PAPMEVENT Event)
{
  USHORT Message = (USHORT)Event->ulParm1;
  USHORT PwrState;
  USHORT rc;

  rc = 0;
  if ( Message == APM_SETPWRSTATE )
  {
    PwrState = (USHORT)(Event->ulParm2 >> 16);
    if ( PwrState != APM_PWRSTATEREADY )
    {
      rc = APMSuspend();
    }
  }
  else if ( Message == APM_NORMRESUMEEVENT || Message == APM_CRITRESUMEEVENT || Message == APM_STDBYRESUMEEVENT) 
  {
    rc = APMResume();
  }
  return rc;
}

USHORT NEAR APMSuspend()
{
  NPATBL  npAT = AdapterTable;
  NPACB   npACB;
  NPUCB   npUCB;
  USHORT i;
  USHORT j;
  
  if (APMSuspended)          
  {
     return NO_ERROR;
  }

  for (i=0; i< MAX_ADAPTERS; i++, npAT++ )
  {
    if ( npAT->Flags & ATBF_DISABLED )
      continue;

    npACB = npAT->npACB;
    if ( !npACB )
      continue;

    /* Release IRQ, DMA buffer, and text/data */
    DeactivateACB( npACB );

    npUCB = npACB->npFirstUCB;
    while ( npUCB )
    {
      npUCB->Flags &= ~UCBF_NOTPRESENT;
      npUCB->Flags |= UCBF_MEDIA_UNCERTAIN;
      npUCB = npUCB->npNextUCB;
    }
  }
  APMSuspended = 1;       //when suspended, refuse any iorb's

  return NO_ERROR;
}

USHORT NEAR APMResume()
{
  NPATBL npAT = AdapterTable;
  NPACB  npACB;
  NPUTBL npUT;
  USHORT i;
  USHORT j;


  if (  APMSuspended == 0 || APMSuspended == 2 ) {
     //HCT If we are not in suspend mode or
     // we are in the process of resuming then simply return
     // ( the code down stream is not really re-entrant )
     return NO_ERROR;
  }

  // Set flag to indicate that we are in the process of resuming
  APMSuspended = 2;

  for (i=0; i< MAX_ADAPTERS; i++, npAT++ )
  {
    if ( !(npAT->Flags & ATBF_DISABLED) )
    {
      if ( !ReConfigureController( npAT ) )
      {
        for (j=0; j < MAX_DRIVES; j++)
        {
          ReConfigureUnit( npAT, j );
        }
      }
    }
  }

  // Done w resume
  APMSuspended = 0;

  return NO_ERROR;                                                         //AAAAAAAA
}                                                                   //@V149969
