
;**************************************************************************
;*
;* SOURCE FILE NAME = FLP1APM.ASM
;*
;* DESCRIPTIVE NAME = APM IDC interface module for the floppy driver
;*                    CODE/DATA segment declarations.
;*
;* Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
;*             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*             RESTRICTED MATERIALS OF IBM
;*             IBM CONFIDENTIAL
;*
;* VERSION = V3.0
;*
;* DATE = 95/11/27
;*
;* DESCRIPTION :
;*
;* Purpose:
;*
;* this routine calls the APM$ device driver entry point
;* to enable or disable APM BIOS calls
;*
;* C calling sequence:
;* if ( APMSendPacket(FARPOINTER &APMSendEventPkt) ) err
;*
;*
;*
;*
;*
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   11/27/95  @V143950   PJ20893 Initial
;*
;*
;****************************************************************************

        .286

        public  APMSENDPACKET
        extrn   _APMAdd:dword
        assume  CS:_TEXT
_TEXT   segment word public 'CODE'

APMSENDPACKET  proc far

        push    bp
        mov     bp,sp
        push    es
        push    di
        push    ds
        push    si
        les     bx,dword ptr [bp+6]; get address of pkt
        call    [_APMAdd]
        jc      error
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     bp
        retf     4             ; adjust stack and exit
error:
        mov     ax,1          ; error for C calls
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     bp
        retf     4             ;adjust stack and get out

APMSENDPACKET endp

_TEXT   ends
end
