/* dmtrc.h
 *
 * Internal trace buffer support
 */

#ifndef DMTRC_H
#define DMTRC_H

#ifdef DM_ITRACE
/* Internal trace support.
 */

#define trace(code, a1, a2, a3)  \
   iTrace((ULONG)(code), (ULONG)(a1), (ULONG)(a2), (ULONG)(a3))

/* Trace codes
 */
#define TR_CALL_DMSTRAT3           1
#define TR_CALL_EXECREQLIST        2
#define TR_CALL_QUEUERLH           3
#define TR_CALL_SUBMITRLE          4
#define TR_CALL_SETUPIORB          5
#define TR_CALL_CALLADD            6
#define TR_CALL_NOTIFYDONE         7
#define TR_CALL_NOTIFYRLE          8
#define TR_CALL_CALLBACK           9

extern VOID iTraceInit(VOID);
extern VOID iTrace(ULONG code, ULONG a1, ULONG a2, ULONG a3);

#else
/* No internal trace support.
 */
extern VOID iTraceInit(VOID);
#define trace(code, a1, a2, a3) 

#endif
#endif
