/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 *
 *   OCO Source Materials
 *
 *   Program number (when available)
 *
 *
 *   The source code for this program is not published or otherwise divested of its
 *   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
 *
 ****************************************************************************/
/**************************************************************************
 *
 * SCCSID: src/basedd/dasd/os2dasd/dmtrc.c, dsdm, w45.fs32, 20000823.1 98/09/15
 *
 * SOURCE FILE NAME = DMTRC.C
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 * DESCRIPTION  Internal trace buffer support
 *
 *
*/
#include "dmh32.h"

#ifdef DM_ITRACE

#define ITRACEBUF_SIZE     30

SpinLock_t  iTraceLock = {0};

typedef struct {
   ULONG  code;
   ULONG  a1;
   ULONG  a2;
   ULONG  a3;
} iTraceBuf_t;

iTraceBuf_t iTraceBuf[ITRACEBUF_SIZE] = {0};

ULONG iTraceNext = 1L;

VOID iTraceInit()
{
   KernAllocSpinLock(&iTraceLock);
}

VOID iTrace(ULONG code, ULONG a1, ULONG a2, ULONG a3)
{
   Lock(&iTraceLock);
   iTraceBuf[iTraceNext].code = code;
   iTraceBuf[iTraceNext].a1   = a1;
   iTraceBuf[iTraceNext].a2   = a2;
   iTraceBuf[iTraceNext].a3   = a3;
   if (++iTraceNext == ITRACEBUF_SIZE)
      iTraceNext = 0;
   Unlock(&iTraceLock);
}

#else
/* No trace support
 */
VOID iTraceInit() {}

#endif
