/*****************************************************************************
 *
 *   IBM Confidential
 *
 *   OCO Source Materials
 *
 *   Program number (when available)
 *
 *   (c) Copyright IBM Corp. 1991, 1998
 *
 *   The source code for this program is not published or otherwise divested of its
 *   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
 *
 ****************************************************************************/
/**************************************************************************
 *
 * SCCSID: src/basedd/dasd/os2dasd/dmtrace.h, dsdm, w45.fs32, 20000823.1 98/11/17
 *
 * SOURCE FILE NAME = DMTRACE.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 * DESCRIPTION : Internal data structures for System/Perfview
 *               tracing in the OS/2 DASD Manager.
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  07/28/92  @V25096     25096  Change perfview timers to ql
 *  09/18/92  @V53255     53225  Add dasd BUSY timer
 *  06/09/94  @V85908     85908  Added trace flag to differentiate between
 *                               STRAT2 RLE/RLH completion calls to Trace()
 *  02/06/95  @V111573   111573  Ported hardware error logging capability
 *                               from 1.3.
 *  09/17/98  @Trace             Adding flags for OS2DASD entry/exit and
 *                               strat3 entry/exit hooks.
 ****************************************************************************/


/*--------------------------------------------------------------------*/
/*   RAS/DEKKO/PERFVIEW trace header file for OS2DASD.DMD             */
/*--------------------------------------------------------------------*/
#include "pvwxport.h"

#define TEST_RAS_TRACING(RMT,Maj)   \
         (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))

#define TEST_TRACING(RMT,Maj)   \
        (*RMT & 0x40) && (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))

#define TEST_MAJOR(RMT,Maj)   \
        (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))

#define TEST_DEKKO(RMT)   \
        (*RMT & 0x40)

/* Trace Event flags */
#define TRACE_STRAT1            0x0001
#define TRACE_STRAT2            0x0002
#define TRACE_IORB              0x0004
#define TRACE_ENTRY             0x0008
#define TRACE_ASYNCSTART        0x0010
#define TRACE_ASYNCDONE         0x0020
#define TRACE_EXIT              0x0040
#define TRACE_READ              0x0080
#define TRACE_WRITE             0x0100
#define TRACE_FORMAT            0x0200
#define TRACE_VERIFY            0x0400
#define TRACE_PREFETCH          0x0800
#define TRACE_IOCTL             0x1000
#define TRACE_RLE               0x2000                               /*@V85908*/
#define TRACE_OS2DASD           0x4000                               /*@Trace*/
#define TRACE_STRAT3            0x8000                               /*@Trace*/

/* Global TraceFlags */
#define TF_INTERNAL             0x0001
#define TF_PERFVIEW             0x0002
#define TF_RAS                  0x0004
#define TF_DEKKO                0x0008


/* RAS Trace Major/Minor Codes */
#define DEKKO_MAJOR_DISK        0x68

#define RAS_MAJOR_DISK          0x07
#define RAS_MINOR_STRAT1_RWV    0x08
#define RAS_MINOR_IOCTL_RWVF    0x09
#define RAS_MINOR_STRAT2_RLH    0x0A
#define RAS_MINOR_STRAT2_RLE    0x0B
#define RAS_MINOR_IORB          0x0C
#define RAS_MINOR_OS2DASD       0x0E                                 /*@Trace*/
#define RAS_MINOR_STRAT3_RLH    0x1A                                 /*@Trace*/
#define RAS_MINOR_STRAT3_RLE    0x1B                                 /*@Trace*/
#define RAS_MINOR_IORB32        0x1C                                 /*@Trace*/

/* Trace Control Block */

typedef struct _TCB {

   PBYTE        pRequest;
   USHORT       Unit;
   UCHAR        Drive[2];
   UCHAR        CommandCode;
   UCHAR        CommandModifier;
   UCHAR        CmdString[3];
   UCHAR        Reserved_1;
   USHORT       RequestControl;
   UCHAR        Priority;
   UCHAR        Flags;
   USHORT       cSGList;
   ULONG        RBA;
   ULONG        BlockCount;
   union {                                                           /*@Trace*/
      USHORT       pRLH16;   /* 16 bit RLH offset */                 /*@Trace*/
      PBYTE        pRLH32;   /* 32 flat RLH address */               /*@Trace*/
   };                                                                /*@Trace*/
   ULONG        LSN;                                                 /*@Trace*  added 4 bytes */

} TCB, FAR *PTCB;

#define TCBOrgSize  (sizeof(TCB) - sizeof(ULONG))                    /*@Trace*/
#define TCBNewSize  (sizeof(TCB))                                    /*@Trace*/


typedef struct _TCBD {

   PBYTE        pRequest;
   USHORT       Status;
   USHORT       ErrorCode;
   ULONG        BlocksXferred;

} TCBD, FAR *PTCBD;


typedef struct _TRLHS {

   PBYTE        pRLH;
   USHORT       Count;
   USHORT       Unit;
   UCHAR        Drive[2];
   USHORT       Request_Control;
   PBYTE        pRQD;

} TRLHS, FAR *PTRLHS;

typedef struct _TRLHD {

   PBYTE        pRLH;
   USHORT       DoneCount;
   USHORT       Status;

} TRLHD, FAR *PTRLHD;

/* Internal Trace Control Block */

#define TRACEBUF_SIZE 256

typedef struct _ITCB {

   UCHAR        Unit;
   UCHAR        Event;
   USHORT       pIORB;
   UCHAR        CommandModifier;
   UCHAR        CommandCode;
   USHORT       Status;
   USHORT       ErrorCode;
   ULONG        rba;
   USHORT       BlockCount;

} ITCB, FAR *PITCB, NEAR *NPITCB;




typedef struct _PVDB {
   DBH          pfdbh;
   CNT          NumReads;               /* Read Counter */
   QLEN         Read;     /*   @5242 */ /* Read Queue   */
   CNT          ReadBytes;              /* Read Byte Count */
   CNT          NumWrites;              /* Write Counter */
   QLEN         Write;   /*   @5242 */  /* Write Queue */
   CNT          WriteBytes;             /* Write Byte Count */
   TIMR         Busy;                   /* BUSY timer */             /*@V53255*/
} PVDB;


typedef struct _DASDLOGDATA  /* @V111573 */
{
   LOGHEAD32 LogHeader;
   PSIDS     ProductSetId;
   GAS       GenAlertSubvector;
   GAS_PCS   GAS_Probable_Cause;
   GAS_FCS   GAS_Failure_Cause;
} DASDLOGDATA;

#define HARD_CRC  0x11111111     /* CRC value for a hard error @V111573 */
#define SOFT_CRC  0x22222222     /* CRC value for a soft error @V111573 */
