/*****************************************************************************
 *
 *   IBM Confidential
 *
 *   OCO Source Materials
 *
 *   Program number (when available)
 *
 *   (c) Copyright IBM Corp. 1998
 *
 *   The source code for this program is not published or otherwise divested of its
 *   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
 *
 ****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = DMTRAC32.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 * VERSION = V1.0
 *
 * DESCRIPTION  Interface definitions for 32 bit trace support
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR    CHANGE DESCRIPTION
 *  --------  ----------  -----   --------------------------------------
 *  mm/dd/yy  @Vnnnnn     xxxxx  xxxxxxx
 *
 ****************************************************************************/

#ifndef DMTRAC32_H
#define DMTRAC32_H

/*
 * Static trace support
 * --------------------
 */
VOID TraceStrat3Pre (PRLCB pRLCB, PVOLCB pVolCB, USHORT TraceEnabled);
VOID TraceStrat3Post (PReq_List_Header pRLH, USHORT TraceEnabled);
VOID TraceIORB32Pre (PIORB pIORB, PUNITCB pUnitCB, USHORT TraceEnabled);
VOID TraceIORB32Post (PRENODE pRENode, USHORT TraceEnabled);
VOID DoTrace32 (ULONG MinorCode, ULONG TraceSize, PBYTE pTraceBuffer, USHORT TraceEnabled);
extern ULONG _plSysInfoSeg;
extern ULONG _plSIS_perf_mec_table;
extern ULONG _plSIS_mec_table;

/*
 * Sets "flag" to indicate whether tracing (RAS or Performance) is enabled
 * and, if enabled, which one.
 * flag set to: 0          tracing is not enabled
 *              TF_DEKKO   Performance tracing (major 0x68) enabled
 *              TF_RAS     RAS tracing (major 0x07) enabled
 *
 * Performance and RAS tracing are mutually exclusive: we only handle one
 * or the other, not both.  Performance tracing is controlled by the Performance
 * MEC Table which is set via the STRACE command.  RAS tracing is controlled
 * by the RAS MEC table which is set via the TRACE command.
 */
#define SetTraceState(flag)                                                  \
   if (TEST_MAJOR((unsigned char *)_plSIS_perf_mec_table, DEKKO_MAJOR_DISK)) \
      flag = TF_DEKKO;                                                       \
   else {                                                                    \
      if (TEST_MAJOR((unsigned char *)_plSIS_mec_table, RAS_MAJOR_DISK))     \
         flag = TF_RAS;                                                      \
      else                                                                   \
         flag = 0;                                                           \
   }

#endif
