;/*****************************************************************************
;*
;* SOURCE FILE NAME =   DMTHUNK.ASM
;*
;* DESCRIPTIVE NAME =   16 to 32 bit OS2DASD thunking support
;*
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1998
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V1.0
;*
;* DATE
;*
;* DESCRIPTION :
;*
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vnnnnn     xxxxx  xxxxxxx
;*****************************************************************************/

.386p

DATA32          segment dword use32 public 'DATA'

                public pfThunkToAdd16, pfSubmitRPs
                public pvThunkDoneIORB

pfThunkToAdd16  df  _TEXT:ThunkToADD16            ; Far32 pointer to ThunkToADD16
pfSubmitRPs     df  _TEXT:SubmitRPs               ; Far32 pointer to SubmitRPs
pvThunkDoneIORB dw  offset _TEXT:ThunkDoneIORB    ; 16:16 pointer to ThunkDoneIORB
                dw  seg    _TEXT                  ;         "

DATA32          ends

_DATA           segment word use16 public 'DATA'
        extrn   _pFSD_EndofInt:dword
_DATA           ends

CONST           segment word use16 public 'CONST'
CONST           ends

_BSS            segment word use16 public 'BSS'
_BSS            ends

_TEXT           segment word use16 public 'CODE'
        extrn   _FSD_EndofInt:near
        extrn   _SubmitRequestsToAdd:near
_TEXT           ends

CODE32          segment dword use32 public 'CODE'
        extrn   _plStrat3:dword
        extrn   _plDiskInfo:dword
        extrn   _plPartInfo:dword
        extrn   DMStrat3:near
        extrn   NextPhysDiskInfo:near
        extrn   NextPhysPartInfo:near
        extrn   KernAllocSpinLock:near
        extrn   KernAcquireSpinLock:near
        extrn   KernReleaseSpinLock:near
        extrn   KernThunkStackTo32:near
        extrn   KernThunkStackTo16:near
        extrn   NotifyDoneIORB32:near
        extrn   iTraceInit:near
        extrn   Strat3Init:near
        extrn   SubmitRLERequests:near
CODE32          ends


DGROUP  GROUP   CONST, _BSS, _DATA
        ASSUME DS: DGROUP
        ASSUME SS: NOTHING

;============================================================================
; Thunk routines
;============================================================================

include thunkmac.inc                    ; Thunk support macros

_TEXT   segment word use16 public 'CODE'
        assume  CS:_TEXT, DS:_DATA

;----------------------------------------------------------------------------
; VOID IDC32_Init(VOID)
;
; Initialize 32 bit IDC information.
; Currently this entails obtaining linear addresses.
;----------------------------------------------------------------------------

ThunkPrologue _IDC32_Init,near
        mov     dword ptr _plStrat3, offset FLAT:DMStrat3
        mov     dword ptr _plDiskInfo, offset FLAT:NextPhysDiskInfo
        mov     dword ptr _plPartInfo, offset FLAT:NextPhysPartInfo
        call    KernThunkStackTo32
        call    iTraceInit
        call    Strat3Init
        call    KernThunkStackTo16
ThunkEpilogue _IDC32_Init

;----------------------------------------------------------------------------
; VOID AllocSpinLock(NPSPINLOCK)
;
; 16 to 32 thunk for KernAllocSpinLock
;
;----------------------------------------------------------------------------

ThunkPrologue _AllocSpinLock,near
        call    KernThunkStackTo32
        movzx   eax, word ptr [ebp+4]   ; ToDo: Define parm access macros
        Linear  eax
        push    eax
        call    KernAllocSpinLock
        add     esp, 04h
        call    KernThunkStackTo16
ThunkEpilogue _AllocSpinLock

;----------------------------------------------------------------------------
; VOID AcquireSpinLock(NPSPINLOCK)
;
; 16 to 32 thunk for KernAcquireSpinLock
;
;----------------------------------------------------------------------------
        public _f_AcquireSpinLock
_f_AcquireSpinLock  proc far            ; far call entry
        push    bp
        mov     bp, sp
        mov     ax, word ptr [bp+6]
        push    ax
        call    _AcquireSpinLock
        add     sp, 02h
        pop     bp
        ret
_f_AcquireSpinLock  endp

ThunkPrologue _AcquireSpinLock,near
        call    KernThunkStackTo32
        movzx   eax, word ptr [ebp+4]   ; ToDo: Define parm access macros
        Linear  eax
        push    eax
        call    KernAcquireSpinLock
        add     esp, 04h
        call    KernThunkStackTo16
ThunkEpilogue _AcquireSpinLock

;----------------------------------------------------------------------------
; VOID ReleaseSpinLock(NPSPINLOCK)
;
; 16 to 32 thunk for KernReleaseSpinLock
;
;----------------------------------------------------------------------------
        public _f_ReleaseSpinLock
_f_ReleaseSpinLock  proc far            ; far call entry
        push    bp
        mov     bp, sp
        mov     ax, word ptr [bp+6]
        push    ax
        call    _ReleaseSpinLock
        add     sp, 02h
        pop     bp
        ret
_f_ReleaseSpinLock  endp

ThunkPrologue _ReleaseSpinLock,near
        call    KernThunkStackTo32
        movzx   eax, word ptr [ebp+4]   ; ToDo: Define parm access macros
        Linear  eax
        push    eax
        call    KernReleaseSpinLock
        add     esp, 04h
        call    KernThunkStackTo16
ThunkEpilogue _ReleaseSpinLock

;----------------------------------------------------------------------------
; VOID SubmitStrat3Requests(NPUNITCB pUnitCB)
;
; Invoked by 16-bit side's redrive IO logic to redrive any Strat3 IO.
; This thunks to 32 bit and calls SubmitRLERequests().
;----------------------------------------------------------------------------

ThunkPrologue _SubmitStrat3Requests,near
        call    KernThunkStackTo32
        movzx   eax, word ptr [ebp+4]   ; ToDo: Define parm access macros
        Linear  eax
        push    eax
        call    SubmitRLERequests       ; Optilink calling conventions
        add     esp,4
        call    KernThunkStackTo16
ThunkEpilogue _SubmitStrat3Requests

;----------------------------------------------------------------------------
; VOID ThunkDoneIORB(PIORB)
;
; ADD callback routine for strat3 and flat strat2 paths.  
;
; ADD calls this routine when IORB has completed, and passes the 16:16 pointer
; to the completed IORB.  The dword immediately preceding the IORB contains
; a linear pointer to the RENODE, which is pushed on the stack as the 
; parameter to NotifyDoneIORB32.
;
; Implementation:
; The ThunkPrologue macro is expanded here to allow FSD end of interrupt
; 16 bit logic.  See thunkmac.inc for ThunkPrologue documentation.
;
;----------------------------------------------------------------------------


; Offset into IORB at which the linear address of the RENODE is saved.
; (ToDo: less fragile means of obtaining this offset)
;
RENODE_SAVE_OFFSET   equ  24h           

ThunkPrologue ThunkDoneIORB,far   

        ; Obtain saved linear pRENode from IORB dmwork area, and
        ; Call NotifyDoneIORB32(pRENode)
        ;
        les     bx, dword ptr [bp+6]    ; es:bx <- 16:16 IORB pointer
        push    dword ptr es:[bx+RENODE_SAVE_OFFSET] ; push linear pointer to RENODE
        call    NotifyDoneIORB32

        ; Switch back to 16 bit code segment
        ;
        jmp     far ptr _TEXT:tdlbl16
CODE32  ends

        align   4       

        ASSUME  CS:_TEXT
        ASSUME  DS:_DATA
        ASSUME  ES:_DATA
tdlbl16 label   far

        ; Call FSD end of interrupt routine if configured (pFSD_EndofInt != NULL)
        ;
        push    DGROUP
        pop     ds
        mov     eax, dword ptr _pFSD_EndofInt
        test    eax, eax
        jz      tdxit
        call    _FSD_EndofInt
tdxit:
        ; Restore caller's registers, restore stack, and return
        ;
        pop     es
        pop     ds
        pop     di
        pop     si
        leave
        ret
ThunkDoneIORB   endp

;----------------------------------------------------------------------------
; VOID _Far32 _Pascal ThunkToADD16( void (*pADDEntry)(PIORB), PIORB pIORB16 )
;
; Called from 32 bit strat3 (as a Far32 to 16 bit code), this routine 
; calls a given ADD entry with a given IORB.
;
;    pADDEntry    - 16:16 address of ADD entry to call
;    pIORB16      - 16:16 address of IORB to pass the ADD
;
;----------------------------------------------------------------------------

ta16_parms  struc       
                dd ?    ; saved EBP
                dd ?    ; return address offset
                dd ?    ; return address segment
   pIORB16      dd ?    ; pointer to IORB
   pADDEntry    dd ?    ; ADD entry address
ta16_parms  ends


        public  ThunkToADD16

ThunkToADD16    proc far

        ; Set up stack frame.
        ; Save registers for _Pascal calling convention (EBP, EBX, ESI, EDI) 
        ; Save ES, DS
        ;
        push    ebp
        mov     ebp, esp
        push    ebx
        push    esi
        push    edi
        push    es
        push    ds

        ; Call the ADD
        ;
        push    dword ptr [bp].pIORB16
        call    dword ptr [bp].pADDEntry
        add     sp, 4

        ; Restore saved registers
        ;
        pop     ds
        pop     es
        pop     edi
        pop     esi
        pop     ebx
        pop     ebp

        ; Return with a retfd and pop parameters
        ; 
        db      66h
        retf    8
ThunkToADD16    endp

;----------------------------------------------------------------------------
; VOID _Far32 _Pascal SubmitRPs( PUNITCB pUnitCB )
;
; Called from 32 bit strat3 (as a Far32 to 16 bit code), this routine 
; calls the 16 bit function SubmitRequestsToADD() to process queued
; Strat 1 request packets (RPs).  
;
;    pUnitCB      - Linear pointer to UnitCB whose queues are to be processed.
;
;----------------------------------------------------------------------------

surp_parms  struc       
                dd ?    ; saved EBP
                dd ?    ; return address offset
                dd ?    ; return address segment
   pUnitCB      dd ?    ; linear pointer to UnitCB
surp_parms  ends


        public  SubmitRPs

SubmitRPs       proc far

        ; Set up stack frame.
        ; Save registers for _Pascal calling convention (EBP, EBX, ESI, EDI) 
        ; Save ES, DS
        ;
        push    ebp
        mov     ebp, esp
        push    ebx
        push    esi
        push    edi
        push    es
        push    ds

        ; Setup DS for 16 bit code
        mov     ax, seg _DATA
        mov     ds, ax

        ; Call SubmitRequestsToAdd
        ;
        mov     eax, dword ptr [bp].pUnitCB
        LinToOff eax
        push    ax
        call    _SubmitRequestsToAdd
        add     sp, 2

        ; Restore saved registers
        ;
        pop     ds
        pop     es
        pop     edi
        pop     esi
        pop     ebx
        pop     ebp

        ; Return with a retfd and pop parameters
        ; 
        db      66h
        retf    4
SubmitRPs    endp


_TEXT ends

     end

