/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 *
 *   OCO Source Materials
 *
 *   Program number (when available)
 *
 *
 *   The source code for this program is not published or otherwise divested of its
 *   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
 *
 ****************************************************************************/
/**************************************************************************
 *
 * SCCSID: src/basedd/dasd/os2dasd/dmstrat1.c, dsdm, w45.fs32, 20000823.1 99/04/16
 *
 * SOURCE FILE NAME = DMSTRAT1.C
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *                    Strategy 1 interface for OS/2 DASD Manager
 *
 * DESCRIPTION   Provides validation and routing of Strategy 1 requests
 *               received from the OS/2 Kernel.
 *
 *
*/
#include "dmh.h"
#include "dmfault.h"

USHORT (near *Strat1Near[])() =
{                     /*--------------------------------------*/
   CmdErr,            /* 0x00  now an error                   */
   MediaCheck,        /* 0x01  check the media                */
   BuildBPB,          /* 0x02  build BPB                      */
   CmdErr,            /* 0x03  reserved                       */
   ReadWriteV,        /* 0x04  read                           */
   StatusDevReady,    /* 0x05  non-destructive read           */
   StatusComplete,    /* 0x06  input status                   */
   StatusComplete,    /* 0x07  input flush                    */
   ReadWriteV,        /* 0x08  write                          */
   ReadWriteV,        /* 0x09  write with verify              */
   CmdErr,            /* 0x0A  get output status              */
   CmdErr,            /* 0x0B  flush output                   */
   CmdErr,            /* 0x0C  reserved                       */
   StatusComplete,    /* 0x0D  open                           */
   StatusComplete,    /* 0x0E  close                          */
   RemovableMedia,    /* 0x0F  removable media                */
   DriveGenIOCTL,     /* 0x10  generic IOCTL                  */
   ResetMedia,        /* 0x11  reset uncertain media          */
   GetLogDriveMap,    /* 0x12  get Logical Drive Map          */
   SetLogDriveMap,    /* 0x13  set Logical Drive Map          */
   CmdErr,            /* 0x14  de-Install this device         */
   CmdErr,            /* 0x15  reserved                       */
   PartFixedDisks,    /* 0x16  get number of partitions       */
   GetUnitMap,        /* 0x17  get unit map                   */
   ReadWriteV,        /* 0x18  no caching read                */
   ReadWriteV,        /* 0x19  no caching write               */
   ReadWriteV,        /* 0x1A  no caching write/verify        */
   DriveInit,         /* 0x1B  initialize                     */
   CmdErr,            /* 0x1C  reserved for Request List code */
//   Shutdown,          /* 0x1C  reserved for Request List code */
   GetDriverCaps      /* 0x1D  Get Driver Capabilities        */
};                    /*--------------------------------------*/


// all this code is for the shutdown unlock
// of removable media devices treated as fixed
USHORT NEAR IsTraceNeeded(VOID);

static VOID FAR InitPost(PIORB pIORB)
{
}

void far DMCharStrat1()
{
  PRPH          pRPH;
  NPUNITCB      pUnitCB;
  USHORT        iUnit;
  NPIORB_CONFIGURATION pIORB;
  _asm
  {
     mov word ptr pRPH[0], bx
     mov word ptr pRPH[2], es
  }
  if(pRPH->Cmd==CMDInit || pRPH->Cmd==CMDInitBase)
    {
    PRPINITOUT pRPO = (PRPINITOUT) pRPH;   /* Output for Init RP           */

    pRPO->DataEnd =  (USHORT) pNextFreeCB;

    pRPO->CodeEnd = (DDFlags & DDF_DISCARD_TRACE)   ? (USHORT) IsTraceNeeded /*@V81586*/
                                                     : (USHORT) DriveInit;    /*@V81586*/
    pRPH->Status = STDON;
    }
  else if(pRPH->Cmd==CMDShutdown)
    {
    PRP_GENIOCTL pRP=(PRP_GENIOCTL)pRPH;
    // ending shutdown
    if(pRP->Category==1)
      {
      pIORB=(NPIORB_CONFIGURATION)ShutdownIORB;
      for (iUnit=0, pUnitCB = UnitCB_Head; iUnit < NumUnitCBs; iUnit++, pUnitCB++)
        {
        if(pUnitCB->Flags & UCF_REMOVABLE_AS_FIXED)
          {
          pIORB->iorbh.Length = sizeof(IORB_DEVICE_CONTROL);           /*@S170941*/
          pIORB->iorbh.CommandCode = IOCC_DEVICE_CONTROL;              /*@S170941*/
          pIORB->iorbh.CommandModifier = IOCM_UNLOCK_MEDIA;            /*@S170941*/
          pIORB->iorbh.UnitHandle = pUnitCB->UnitInfo.UnitHandle;      /*@S170941*/
          pIORB->iorbh.RequestControl = IORB_ASYNC_POST;               /*@S170941*/
          pIORB->iorbh.Status = 0;                                     /*@S170941*/
          pIORB->iorbh.ErrorCode = 0;                                  /*@S170941*/
          pIORB->iorbh.NotifyAddress = &InitPost;                      /*@S170941*/
                                                                       /*@S170941*/
          (*pUnitCB->AdapterDriverEP) ((PVOID) (pIORB));               /*@S170941*/
                                                                       /*@S170941*/
          while ( !(pIORB->iorbh.Status & IORB_DONE) )  /* Wait till done *//*@S170941*/
          ;                                                            /*@S170941*/
          } /* endif */
        } /* endfor */

      } /* endif */
    pRPH->Status = STDON;
    }
  else pRPH->Status = STDON + STERR + ERROR_I24_BAD_UNIT;
}

#ifdef LVM                                                           /*@LVM*/
/* os2lvm does not set up os2dasd's DS before calling, so _loadds 
 * is used to do it.  For legacy os2dasd, _loadds is not needed.
 */

VOID _loadds FAR DMStrat1()

#else
VOID FAR DMStrat1()
#endif
{
  PRPH          pRPH;
  NPVOLCB       pVolCB;
  USHORT        Cmd, Status;

  _asm
  {
     push es
     push bx
     mov word ptr pRPH[0], bx
     mov word ptr pRPH[2], es
  }

  pRPH->Status = 0;
  pRPH->Flags = 0;

  Cmd = pRPH->Cmd;

  if ((Cmd != CMDInitBase) && IsTraceOn())                           /*@Trace*/
     Trace(TRACE_OS2DASD | TRACE_ENTRY, NULL, NULL);                 /*@Trace*/

  /*-----------------------------*/
  /* Filter out invalid requests */
  /*-----------------------------*/

  if (DDFlags & DDF_NO_MEDIA)
  {
      Status = STDON + STERR + ERROR_I24_BAD_UNIT;
      goto ExitDiskDD;
  }

  if (Cmd > MAX_DISKDD_CMD)
  {
     Status = STDON + STERR + ERROR_I24_BAD_COMMAND;
     goto  ExitDiskDD;
  }
  if ( (Get_VolCB_Addr(pRPH->Unit, (NPVOLCB FAR *) &pVolCB) != NO_ERROR) &&
                     (Cmd != CMDGenIOCTL) &&
                     (Cmd != CMDInitBase) &&
                     (Cmd != CMDShutdown) &&
                     (Cmd != CMDPartfixeddisks) )
  {
#ifdef LVM                                                           /*@221316*/
      if (pRPH->Unit == 0  ||  pRPH->Unit == 1)                      /*@221316*/
         /* Return not ready for A: or B: to avoid problems */       /*@221316*/
         Status = STDON + STERR + ERROR_I24_NOT_READY;               /*@221316*/
      else                                                           /*@221316*/
#endif
         Status = STDON + STERR + ERROR_I24_BAD_UNIT;
      goto ExitDiskDD;
  }

  if ( (Cmd != CMDInitBase) && IsTraceOn() )
        Trace(TRACE_STRAT1 | TRACE_ENTRY, (PBYTE) pRPH, pVolCB);

  /*---------------------*/
  /* Call Worker Routine */
  /*---------------------*/

  Status = (*Strat1Near[Cmd])(pRPH, pVolCB);

  /*--------------------------------------------------------------------*/
  /* Finish up by setting the Status word in the Request Packet Header  */
  /*--------------------------------------------------------------------*/

ExitDiskDD:  ;

  DISABLE;

  /* Save status in Request Packet, BUT ONLY IF the status is NOT Busy.
   * If the status is Busy (STBUI) the convention is that the worker 
   * function must have set STBUI as the status in the request packet,
   * so we don't have to.  This avoids a race condition which could cause
   * a Done status to be overwritten with a Busy status.
   */
  if (Status != STBUI)
     pRPH->Status = Status;

  ENABLE;

  if ( (TraceFlags != 0) && (pRPH->Status & STDON) && (Cmd != CMDInitBase) )
     Trace(TRACE_STRAT1 | TRACE_EXIT, (PBYTE) pRPH, pVolCB);

  if ((TraceFlags != 0) && (Cmd != CMDInitBase))                     /*@Trace*/
     Trace(TRACE_OS2DASD | TRACE_EXIT, NULL, NULL);                  /*@Trace*/

  _asm
  {
     pop bx
     pop es
  }

  return;
}

/*------------------------------------------------------------------------
;
;** MediaCheck - Check the Media    (Command = 0x01)
;
;   Checks to see if the media in the drive has changed.
;
;   USHORT MediaCheck   (PRP_MEDIACHECK pRP, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:  The Return Code in the Request Packet is set to one
;             of the following:
;
;                 -1 = Media has been changed
;                  0 = Unsure if media has been changed
;                  1 = Media unchanged
;
------------------------------------------------------------------------*/
USHORT NEAR MediaCheck(pRP, pVolCB)

PRP_MEDIACHECK    pRP;
NPVOLCB           pVolCB;
{

   if (pVolCB->Flags & vf_UncertainMedia)
      pRP->rc = -1;
   else
      pRP->rc = w_MediaCheck (pRP->rph.Unit, pVolCB);

   return (pRP->rph.Status | STDON);
}

/*------------------------------------------------------------------------
;
;** BuildBPB - Build the BPB      (Command = 0x02)
;
;   Builds the BPB.  This is requested when the media has changed
;   of when the media type is uncertain.
;
;   USHORT BuildBPB   (PRP_BUILDBPB pRP, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT near BuildBPB(pRP, pVolCB)
PRP_BUILDBPB   pRP;
NPVOLCB        pVolCB;
{
   USHORT rc;

   if ((rc = BPBFromBoot (pVolCB, (PDOSBOOTREC) pRP->XferAddr)) != NO_ERROR)
      rc = BPBFromScratch (pVolCB);

   if (rc == NO_ERROR)
   {

      pRP->MediaDescr = pVolCB->MediaBPB.MediaType;
      pRP->bpb = (PVOID) &(pVolCB->MediaBPB);

      /* If removable media and sectors <= 2.88 M        */
      /* then issue SET_LOGICAL_GEOMETRY call to ADD.    */

      if ( (pVolCB->pUnitCB->UnitInfo.UnitFlags & UF_REMOVABLE) &&
           (pVolCB->MediaBPB.TotalSectors <= 5760) &&
           (pVolCB->MediaBPB.TotalSectors != 0) &&
           ( !(pVolCB->Flags & vf_ReturnFakeBPB) ) )
      {
        if (pVolCB->MediaBPB.TotalSectors <= 720)
            pVolCB->NumLogCylinders = 40;
        else if (pVolCB->MediaBPB.TotalSectors == 1232)                         
            pVolCB->NumLogCylinders = 77;                                       
        else
            pVolCB->NumLogCylinders = 80;

        rc = SetLogicalGeometry (pVolCB);
      }
      rc |= STDON;
   }
   else
      rc |= (STDON | STERR);

   return (rc);
}
/*------------------------------------------------------------------------
;
;** SetLogicalGeometry - Set Logical Geometry
;
;   Sets the logical geometry for the specified media BPB.
;
;   USHORT SetLogicalGeometry  (NPVOLCB pVolCB)
;
;   ENTRY:    pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT FAR f_SetLogicalGeometry (pVolCB)

NPVOLCB pVolCB;
{
   return(SetLogicalGeometry(pVolCB));
}


USHORT SetLogicalGeometry (pVolCB)

NPVOLCB pVolCB;
{
     PRP_INTERNAL pIRP;
     USHORT rc;

     if (DevHelp_AllocReqPacket(0, (PBYTE FAR *) &pIRP) != NO_ERROR)
         return(STDON + STERR + ERROR_I24_GEN_FAILURE);

     pIRP->rph.Unit = pVolCB->LogDriveNum;
     pIRP->rph.Flags = RPF_Internal;
     pIRP->rph.Cmd = CMDInternal;
     pIRP->Function = DISKOP_GET_MEDIA_GEOMETRY;
     pIRP->NumSectors = (USHORT) pVolCB;
     pIRP->SectorSize = pVolCB->MediaBPB.BytesPerSector;                        
     rc = DiskIO_Wait ( (PBYTE)pIRP, pVolCB );


     if ( !(rc & STERR) &&
        (pIRP->NumSectors != pVolCB->MediaBPB.TotalSectors) )
     {
        pIRP->Function = DISKOP_SET_LOGICAL_GEOMETRY;
        pIRP->NumSectors = (USHORT) pVolCB;
        rc = DiskIO_Wait ( (PBYTE)pIRP, pVolCB );
     }

     DevHelp_FreeReqPacket( (PBYTE)pIRP );

     return(rc);
}


/*------------------------------------------------------------------------
;
;** ReadWriteV - Read, Write and Write with Verify  (Commands 0x04, 0x08, 0x09)
;
;   These are the basic strategy-1 I/O routines for the driver.
;   The request is queued and sent to the adapter driver for
;   processing.
;
;   USHORT ReadWriteV   (PRP_RWV pRP, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT ReadWriteV (pRP, pVolCB)

PRP_RWV   pRP;
NPVOLCB   pVolCB;
{
   USHORT Uncertain;
   ULONG  EndSector;

   USHORT rc = NO_ERROR;

   if (pRP->NumSectors == 0)
      return (STDON);

   /* Check for a valid partition */

   if ((rc=CheckWithinPartition(pVolCB,pRP->rba,(ULONG)pRP->NumSectors)) & STERR)
      return(rc);

   /*--------------------------------------------------------------*/
   /*  If it's for a psuedo-drive which is not currently mapped to */
   /*  it's associated unit, then a disk swap is needed.           */
   /*--------------------------------------------------------------*/

   if  (pVolCB->pUnitCB->UnitInfo.UnitFlags & UF_REMOVABLE)
   {
      if (CheckPseudoChange(pRP->rph.Unit, pVolCB) == -1)
      {
         pRP->NumSectors = 0;
         return(STDON + STERR + ERROR_I24_DISK_CHANGE);
      }

      if ( (!(pVolCB->Flags & vf_ForceRdWrt)) &&
             (pVolCB->Flags & vf_UncertainMedia))
      {
         pRP->NumSectors = 0;
         return(STDON + STERR + ERROR_I24_UNCERTAIN_MEDIA);
      }
   }
   /*  Add in the partition offset and the hidden sectors and do the I/O */

   pRP->rba = pRP->rba + pVolCB->PartitionOffset+pVolCB->MediaBPB.HiddenSectors;
   pRP->sfn = 512;                      /* Use sfn field for sector size */
   if ( (&(pVolCB->pUnitCB) != 0) && (&(pVolCB->MediaBPB) != 0) ) {             
      if ((pVolCB->pUnitCB->UnitInfo.UnitFlags & UF_REMOVABLE) &&               
          (pVolCB->MediaBPB.TotalSectors == 1232)) {                            
             pRP->sfn = 1024;                                                   
      }                                                                         
   }                                                                            
   pVolCB->Flags &= ~vf_ForceRdWrt;


   rc =  DiskIO ((PBYTE)pRP, pVolCB);

   return(rc);

}
/*------------------------------------------------------------------------
;
;** RemovableMedia - Check for Removable Media    (Command = 0x0F)
;
;   USHORT RemovableMedia (PRPH pRPH, NPVOLCB pVolCB)
;
;   ENTRY:    pRPH             - Request Packet Header
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:  The busy bit of the status word is set as follows:
;
;                  1 = Media is non-removable
;                  0 = Media is removable
;
------------------------------------------------------------------------*/

USHORT RemovableMedia(pRPH, pVolCB)
PRPH    pRPH;
NPVOLCB pVolCB;
{
   if (pVolCB->pUnitCB->UnitInfo.UnitFlags & UF_REMOVABLE)           
      return (STDON);
   else
      return (STDON + STBUI);

}

/*------------------------------------------------------------------------
;
;** ResetMedia - Reset Uncertain Media  (Command = 0x11)
;
;   USHORT ResetMedia (PRPH pRPH, NPVOLCB pVolCB)
;
;   ENTRY:    pRPH             - Request Packet Header
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/

USHORT ResetMedia (pRPH, pVolCB)

PRPH    pRPH;
NPVOLCB pVolCB;
{
  if ( !(pVolCB->Flags & vf_ReturnFakeBPB) )
     pVolCB->MediaBPB = pVolCB->RecBPB;

  pVolCB->Flags &= ~(vf_UncertainMedia | vf_ChangedByFormat | vf_Changed);

  pVolCB->Flags |= vf_ForceRdWrt;

  return (STDON);

}
/*------------------------------------------------------------------------
;
;** GetLogDriveMap - Get Logical Drive Mapping  (Command = 0x12)
;
;   Returns which logical drive is currently mapped onto a particular
;   physical drive.  A zero is returned if only one logical drive is
;   mapped to the physical drive.
;
;   USHORT GetLogDriveMap (PRPH pRPH, NPVOLCB pVolCBIn)
;
;   ENTRY:    pRPH             - Request Packet Header
;             pVolCBIn         - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS: The logical drive is returned in the unit field
;            of the request packet header.  The logical drive
;            is actually LogDriveNum + 1, which represents the
;            drive letter, i.e. C: = 3.  A zero is returned
;            if only one logical drive is mapped to the physical drive.
;
------------------------------------------------------------------------*/

USHORT GetLogDriveMap (pRPH, pVolCB)

PRPH    pRPH;
NPVOLCB pVolCB;
{
   NPVOLCB pVolCBx;

   for (pVolCBx = VolCB_Head; pVolCBx != NULL; pVolCBx = pVolCBx->pNextVolCB)
   {
      if ( (pVolCBx->pUnitCB->PhysDriveNum == pVolCB->pUnitCB->PhysDriveNum) &&
           (pVolCBx->Flags & vf_OwnPhysical) )
         break;
   }

   if (pVolCBx == NULL)
      return (STDON + STERR + ERROR_I24_BAD_UNIT);  /* Unit not found */

   if (pVolCBx->Flags & vf_AmMult)
      pRPH->Unit = pVolCBx->LogDriveNum + 1;  /* ret drive letter value */
   else
      pRPH->Unit = 0;                        /* ret 0 if one drive mapped */

   return (STDON);

}
/*------------------------------------------------------------------------
;
;** SetLogDriveMap - Set Logical Drive Mapping  (Command = 0x13)
;
;   Maps the specified logical drive onto the physical drive.
;
;   USHORT SetLogDriveMap (PRPH pRPH, NPVOLCB pVolCB)
;
;   ENTRY:    pRPH             - Request Packet Header
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS: The logical drive is returned in the unit field
;            of the request packet header.  The logical drive
;            is actually LogDriveNum + 1, which represents the
;            drive letter, i.e. C: = 3.  A zero is returned
;            if only one logical drive is mapped to the physical drive.
;
------------------------------------------------------------------------*/

USHORT SetLogDriveMap (pRPH, pVolCB)

PRPH    pRPH;
NPVOLCB pVolCB;
{
   Update_Owner (pVolCB);                    /* Update vf_OwnPhysical */

   if (pVolCB->Flags & vf_AmMult)
      pRPH->Unit = pVolCB->LogDriveNum + 1;   /* If mapped, ret drive letter */
   else
      pRPH->Unit = 0;                         /* else ret 0 */

   return (STDON);
}


/*------------------------------------------------------------------------
;
;** PartFixedDisks - Get number of fixed disks  (Command = 0x16)
;
;   Returns the number of fixed disks supported by the driver.
;
;   USHORT PartFixedDisks (PRP_PARTFIXEDDISKS pRP, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/

USHORT PartFixedDisks (pRP, pVolCB)

PRP_PARTFIXEDDISKS  pRP;
NPVOLCB             pVolCB;
{
#ifdef LVM                                                           /*@LVM*/
   /* For LVM, return 0 disks; allowing OS2LVM to report it's logical view */
   pRP->NumFixedDisks = 0;
#else
   pRP->NumFixedDisks = (UCHAR) NumFixedDisks;
#endif

   return (STDON);
}

/*------------------------------------------------------------------------
;
;** GetUnitMap - Get logical units mapped to a physical unit (Command = 0x17)
;
;   Looks at all the VolCB entries and builds a double
;   word bit map that indicates what logical drives exist
;   on the given physical drive.  The low order bit of the
;   map corresponds to logical unit 0 (A:).  Bits are set for
;   those units that exist on the given physical drive.
;
;   USHORT GetUnitMap (PRP_GETUNITMAP pRP, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/

USHORT GetUnitMap (pRP, pVOLCB)

PRP_GETUNITMAP  pRP;
NPVOLCB         pVOLCB;
{
   NPVOLCB pVolCBx;
   UCHAR   PhysUnit;
   ULONG   Mask = 1;
   ULONG   UnitMap = 0;

   if (NumFixedDisks == 0 || pRP->rph.Unit >= NumFixedDisks)
      return (STDON + STERR + ERROR_I24_BAD_UNIT);

   PhysUnit = pRP->rph.Unit | 0x80;         /* Make disk 0x80 based */

   for (pVolCBx=VolCB_Head; pVolCBx->LogDriveNum != 0x80;
                                                 pVolCBx=pVolCBx->pNextVolCB)
   {
      /* Unit on specified drive ? */

      if (pVolCBx->pUnitCB->PhysDriveNum == PhysUnit)
        UnitMap |= Mask;

      Mask <<= 1;                      /* Adjust mask for next unit */
   }

   pRP->UnitMap = UnitMap;             /* Return unit mask */

   return (STDON);
}


/*------------------------------------------------------------------------
;
;** GetDriverCapabilites - Get Device Driver Capabilities  (Command = 0x1D)
;
;   Returns informations describing the functional characteristics
;   of the device driver.  The control blocks returned are the
;   Driver Capabilites Structure and the Volume Characteristics
;   structure.  This command must be supported to support the
;   Strategy-2, extended device driver interface.
;
;   USHORT GetUnitMap (PRP_GETDRIVERCAPS pRP, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/

USHORT GetDriverCaps (pRP, pVolCB)

PRP_GETDRIVERCAPS  pRP;
NPVOLCB            pVolCB;
{
   pRP->pDCS = (PVOID) &DriverCapabilities;
   pRP->pVCS = (PVOID) pVolCB->pVolChar;
   return (STDON);
}

/*-----------------------------------------------*/
/* Near Entry Point to swappable IOCTL routine.  */
/*-----------------------------------------------*/

USHORT DriveGenIOCTL(pRP, pVolCB)

PRP_GENIOCTL pRP;
NPVOLCB      pVolCB;
{
  USHORT rc;

  rc = f_DriveGenIOCTL (pRP, pVolCB);

  rc |= STDON;

  return(rc);

}


/*-----------------------------------------------------------*/
/*   Packet Status return functions:                         */
/*                                                           */
/*   CmdErr, StatusError, StatusDevReady, StatusComplete     */
/*-----------------------------------------------------------*/

USHORT near CmdErr (pRPH, pVolCB)
PRPH    pRPH;
NPVOLCB pVolCB;
{
   return (STERR + STDON + ERROR_I24_BAD_COMMAND);
}


USHORT StatusDevReady(pRPH, pVolCB)
PRPH    pRPH;
NPVOLCB pVolCB;
{
  return (STDON + STBUI);
}

USHORT StatusComplete(pRPH, pVolCB)
PRPH    pRPH;
NPVOLCB pVolCB;
{
  return (STDON);
}


USHORT StatusError( pRPH, ErrorCode )

PRPH    pRPH;
USHORT  ErrorCode;
{
  return (STDON + STERR);
}


/*------------------------------------------------------------------------
;
;** DiskIO - Common disk access routine
;
;   DiskIO is the common routine for all operations that need to
;   be performed on a device.
;
;   USHORT DiskIO (PBYTE pRP, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT DiskIO (pRP, pVolCB)

PBYTE    pRP;
NPVOLCB  pVolCB;

{
   NPUNITCB pUnitCB1 = 0;
   NPUNITCB pUnitCB2 = 0;

  /* -------------------------------------------------------------
   ; Check to see if the request is for zero sectors, and if     ;
   ; so simply return.  We must do this as the LAST check to     ;
   ; make sure that various status flags are properly set (if    ;
   ; we had a floppy change error, and the retry was for         ;
   ; zero bytes in length, we would not release the floppy       ;
   ; change semaphore).                                          ;
   --------------------------------------------------------------*/


   ((PRPFT)pRP)->ftdb.FT_Flags = 0;

   if ( (DDFlags & DDF_FT_ENABLED)  &&
        (f_FT_CheckFTSupport(pVolCB->pUnitCB, (PBYTE) pRP) == YES) 
#ifdef LVM
         // LVM partitions do not support FT
         &&  pVolCB->PartitionType != PARTITION_LVM                  /*@223823*/
#endif
      )
   {
         f_FT_PutPriorityQueue(pVolCB->pUnitCB, pRP,
                     (NPUNITCB FAR *) &pUnitCB1, (NPUNITCB FAR *) &pUnitCB2);

         if (pUnitCB1 != 0)
            SubmitRequestsToADD(pUnitCB1);

         if (pUnitCB2 != 0)
            SubmitRequestsToADD(pUnitCB2);
   }
   else
   {
      PutPriorityQueue_RP (pVolCB->pUnitCB, pRP);

      SubmitRequestsToADD (pVolCB->pUnitCB);
   }
   DISABLE;

   if ( !( ((PRPH)pRP)->Status & STDON) )
      ((PRPH)pRP)->Status = STBUI;

   return(((PRPH)pRP)->Status);

}

/*------------------------------------------------------------------------
;
;** DiskIO_Wait - Perform disk I/O, blocking until done
;
;   Calls DiskIO, and blocks this thread until the operation
;   is complete, i.e. the STDON bit is set in the request packet.
;
;   USHORT DiskIO_Wait (PBYTE pRPH, NPVOLCB pVolCB)
;
;   ENTRY:    pRP              - Request Packet
;             pVolCB           - Pointer to VolCB
;
;   RETURN:   USHORT           - Packet Status word
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT FAR f_DiskIO_Wait (pRP, pVolCB)

PBYTE pRP;
NPVOLCB pVolCB;
{

   return(DiskIO_Wait(pRP, pVolCB));
}


USHORT DiskIO_Wait (pRP, pVolCB)

PBYTE pRP;
NPVOLCB pVolCB;

{
   ((PRPH)pRP)->Status = 0;

   /* Block until I/O done.  Infinite timeout, Non interruptable. */

   if ( ( ((PRPH)pRP)->Cmd == CMDInternal ) &&
        ( ((PRP_INTERNAL)pRP)->Function == DISKOP_RESUME ) )

      SubmitImmedRequestToADD(pVolCB->pUnitCB, pRP);
   else
      DiskIO (pRP, pVolCB);


   DISABLE;
   while ( !( ((PRPH)pRP)->Status & STDON ) )
   {
      DevHelp_ProcBlock ((ULONG)pRP, -1L, 1);
      DISABLE;                          /* Block does an enable  */
   }
   ENABLE;

   return ( ((PRPH)pRP)->Status);   /* return packet status  */
}
#if 0
USHORT near Shutdown (PRPH pRPH, NPVOLCB pVolCB)
{
   PRP_GENIOCTL pRP=(PRP_GENIOCTL)pRPH;
   // ending shutdown
   if(pRP->Category==1)
     {

     } /* endif */
   return (STERR + STDON + ERROR_I24_BAD_COMMAND);
}
#endif
