/*****************************************************************************
 *
 *   IBM Confidential
 *
 *   OCO Source Materials
 *
 *   Program number (when available)
 *
 *   (c) Copyright IBM Corp. 1991, 1998
 *
 *   The source code for this program is not published or otherwise divested of its
 *   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
 *
 ****************************************************************************/
/**************************************************************************
 *
 * SCCSID: src/basedd/dasd/os2dasd/dmproto.h, dsdm, w45.fs32, 20000823.1 99/03/05
 *
 * SOURCE FILE NAME = DMPROTO.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 * DESCRIPTION : C function prototypes for OS/2 DASD Mgr
 *
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  03/24/93  @V63867     63867  Fix removable devices that dont return
 *                               geometry w/no media present
 *  04/08/93  @V64818     64818  Loosen checks for BPBs on HPFS/FT partitions
 *  10/08/93  @V74404     74404  Add Set DASD Mgr parms IOCTL
 *  04/28/95  120311      120311 Add NotifyRLH function declaration
 *  02/06/95  @V111573   111573  Added prototype for LogAnyErrors(PIORB)
 *  10/09/97  @V187707   187707  Partitioned removable media generic solution 
 *  12/02/97  @V189588   189588  Diff HW reporting diff geometry for removable media
 *  04/07/97  @LVM               LVM support
 ****************************************************************************/

/*---------------------------------------*/
/* Function declarations - Static Code   */
/*---------------------------------------*/
USHORT NEAR DriveInit (PRPINITIN, NPVOLCB);

USHORT NEAR MediaCheck (PRP_MEDIACHECK, NPVOLCB);
USHORT NEAR BuildBPB (PRP_BUILDBPB, NPVOLCB);
USHORT NEAR SetLogicalGeometry(NPVOLCB);
USHORT FAR  f_SetLogicalGeometry(NPVOLCB);
USHORT NEAR ReadWriteV (PRP_RWV, NPVOLCB);
USHORT NEAR RemovableMedia (PRPH, NPVOLCB);
USHORT NEAR DriveGenIOCTL (PRP_GENIOCTL, NPVOLCB);
USHORT NEAR ResetMedia (PRPH, NPVOLCB);
USHORT NEAR GetLogDriveMap (PRPH, NPVOLCB);
USHORT NEAR SetLogDriveMap (PRPH, NPVOLCB);
USHORT NEAR PartFixedDisks (PRP_PARTFIXEDDISKS, NPVOLCB);
USHORT NEAR GetUnitMap (PRP_GETUNITMAP, NPVOLCB);
USHORT NEAR GetDriverCaps (PRP_GETDRIVERCAPS, NPVOLCB);
USHORT NEAR CmdErr (PRPH, NPVOLCB);
USHORT NEAR StatusDevReady (PRPH, NPVOLCB);
USHORT NEAR StatusComplete (PRPH, NPVOLCB);
USHORT NEAR StatusError (PRPH, USHORT);
USHORT NEAR Shutdown (PRPH pRPH, NPVOLCB pVolCB);       /*@V170941*/

VOID   _loadds FAR  DMStrat2 (void);
USHORT _loadds FAR  DD_SetFSDInfo (void);

USHORT NEAR DiskIO (PBYTE, NPVOLCB);
USHORT NEAR DiskIO_Wait (PBYTE, NPVOLCB);
USHORT FAR  f_DiskIO_Wait (PBYTE, NPVOLCB);
USHORT NEAR Get_VolCB_Addr (USHORT, NPVOLCB FAR *);
USHORT FAR  f_Get_VolCB_Addr (USHORT, NPVOLCB FAR *);
NPVOLCB NEAR FirstLogicalVolCB(NPVOLCB pPhysVolCB);
NPVOLCB FAR  f_FirstLogicalVolCB(NPVOLCB pPhysVolCB);
VOID   NEAR SetupIORB (NPUNITCB, PBYTE, NPIORBH);
VOID   NEAR SubmitIORB (PIORBH);
ULONG  NEAR CHS_to_RBA (NPVOLCB, USHORT, UCHAR, UCHAR);
ULONG  FAR  f_CHS_to_RBA (NPVOLCB, USHORT, UCHAR, UCHAR);
USHORT NEAR ReadSecInScratch_RBA (NPVOLCB, ULONG, USHORT);
USHORT FAR  f_ReadSecInScratch_RBA (NPVOLCB, ULONG, USHORT);
USHORT NEAR ReadSecInScratch_CHS (NPVOLCB, USHORT, UCHAR, UCHAR);
USHORT FAR  f_ReadSecInScratch_CHS (NPVOLCB, USHORT, UCHAR, UCHAR);
BOOL   NEAR Read_PartitionTable(NPVOLCB, ULONG);                     /*@LVM*/
USHORT NEAR CheckPseudoChange (USHORT, NPVOLCB);
USHORT FAR  f_CheckPseudoChange (USHORT, NPVOLCB);
VOID   NEAR Update_Owner (NPVOLCB);
VOID   _loadds FAR  NotifyDoneIORB(PIORB);
/* d156878 VOID   NEAR NotifyRLE (PPB_Read_Write); */
BOOL   NEAR NotifyRLE (PPB_Read_Write, NPUNITCB);
VOID   FAR  NotifyRLH (PReq_List_Header);                            /*120311*/
USHORT NEAR AllocIORB(NPUNITCB, NPIORBH FAR *);
VOID   NEAR AllocIORB_Wait(NPUNITCB, NPIORBH FAR *);
VOID   NEAR FreeIORB(NPUNITCB, NPIORBH);
UCHAR  NEAR MapADDError(USHORT);
USHORT NEAR GetPrtyQIndex(NPUNITCB,UCHAR);                           /*@V74404*/
VOID   NEAR PutPriorityQueue (NPUNITCB, PBYTE);
VOID   FAR  f_PutPriorityQueue (NPUNITCB, PBYTE);
VOID   NEAR PutPriorityQueue_RP (NPUNITCB, PBYTE);
VOID   FAR  f_PutPriorityQueue_RLE (NPUNITCB, PPB_Read_Write);
VOID   NEAR PutPriorityQueue_RLE (NPUNITCB, PPB_Read_Write);
USHORT NEAR PullPriorityQueue (NPUNITCB, PBYTE FAR *);
USHORT NEAR RemovePriorityQueue (NPUNITCB, PPB_Read_Write);


VOID   NEAR AbortReqList (PReq_List_Header, NPUNITCB);
VOID   NEAR SubmitRequestsToADD (NPUNITCB);
VOID   FAR  f_SubmitRequestsToADD (NPUNITCB);
USHORT NEAR CheckWithinPartition (NPVOLCB, ULONG, ULONG);
ULONG  FAR  f_VirtToPhys(PBYTE);
ULONG  NEAR VirtToPhys(PBYTE);

USHORT NEAR BPBFromBoot (NPVOLCB, PDOSBOOTREC);
USHORT FAR  f_BPBFromBoot (NPVOLCB, PDOSBOOTREC);
USHORT NEAR BPBFromScratch (NPVOLCB);
USHORT FAR  f_BPBFromScratch (NPVOLCB);
VOID   NEAR BootBPB_To_MediaBPB (NPVOLCB, PDOSBOOTREC);
VOID   FAR  f_BPBFromGeom (NPVOLCB, NPBPB, PGEOMETRY);               /*@V63867*/
USHORT NEAR Is_BPB_Boot (NPVOLCB,PDOSBOOTREC);                       /*@V64818*/
BOOL   FAR  f_DiscoverPRMVolumes(NPVOLCB pPhysVolCB);
USHORT NEAR GetBootVersion (PDOSBOOTREC);
VOID   NEAR InitLogFromPhysVolCB(NPVOLCB, NPVOLCB);
#ifdef LVM
USHORT NEAR Process_Partition (NPVOLCB, PULONG, PULONG, USHORT);
USHORT NEAR Process_Boot (NPVOLCB, ULONG, USHORT);
#else
USHORT NEAR Process_Partition (NPVOLCB, PULONG, PULONG);
USHORT NEAR Process_Boot (NPVOLCB, ULONG);
#endif
USHORT NEAR Process_FloppyAsPartitioned (NPVOLCB, PULONG, PULONG);   /*@V187707*/ 
USHORT NEAR w_MediaCheck (UCHAR, NPVOLCB);
USHORT NEAR CheckChangeSignal (USHORT, NPVOLCB);
VOID   NEAR SynchPhysicalGeometry(NPVOLCB);                          /*@V189588*/
VOID   FAR  f_SynchPhysicalGeometry(NPVOLCB);

/*---------------------------*/
/* LVM specific functions    */
/*---------------------------*/
#ifdef LVM                                                           /*@LVM*/
VOID   NEAR IDC32_Init(VOID);
VOID   NEAR AllocSpinLock(NPSPINLOCK);
VOID   NEAR AcquireSpinLock(NPSPINLOCK);
VOID   FAR  f_AcquireSpinLock(NPSPINLOCK);
VOID   NEAR ReleaseSpinLock(NPSPINLOCK);
VOID   FAR  f_ReleaseSpinLock(NPSPINLOCK);
BOOL   NEAR Read_DLAT(NPVOLCB, ULONG);
VOID   NEAR SubmitStrat3Requests(NPUNITCB);
BOOL   FAR  f_DiscoverDriveVolumes(NPVOLCB pPhysVolCB);
VOID   FAR  f_DeleteDriveVolumes(NPVOLCB pPhysVolCB);
VOID   FAR  f_UpdateViewablePRMVolumes(NPVOLCB pPhysVolCB);          /*@V220075*/
NPVOLCB NEAR AllocVolCB(VOID);
VOID   NEAR FreeVolCB(NPVOLCB pVolCB);
BOOL   NEAR InsertVolCB(NPVOLCB pVolCB, NPVOLCB *ppLink);
VOID   NEAR DiscardVolCB(NPVOLCB pVolCB, NPVOLCB *ppLink);
#endif

/*-------------------------------------*/
/* Function declarations - SwapCode    */
/*-------------------------------------*/
USHORT FAR  f_DriveGenIOCTL (PRP_GENIOCTL, NPVOLCB);
#pragma alloc_text(SwapCode, f_DriveGenIOCTL)

VOID   NEAR FT_PutPriorityQueue (NPUNITCB,PBYTE,NPUNITCB FAR *,NPUNITCB FAR *);
VOID   FAR  f_FT_PutPriorityQueue (NPUNITCB,PBYTE,NPUNITCB FAR *,NPUNITCB FAR *);
#pragma alloc_text(SwapCode, FT_PutPriorityQueue)
#pragma alloc_text(SwapCode, f_FT_PutPriorityQueue)

USHORT NEAR FT_NotifyDoneIORB_RLE(NPIORB,PPB_Read_Write,PPB_Read_Write FAR *);
USHORT FAR  f_FT_NotifyDoneIORB_RLE(NPIORB,PPB_Read_Write,PPB_Read_Write FAR *);
#pragma alloc_text(SwapCode, FT_NotifyDoneIORB_RLE)
#pragma alloc_text(SwapCode, f_FT_NotifyDoneIORB_RLE)

USHORT NEAR FT_NotifyDoneIORB_RP (NPIORB, PRP_RWV, PRP_RWV FAR *);
USHORT FAR  f_FT_NotifyDoneIORB_RP (NPIORB, PRP_RWV, PRP_RWV FAR *);
#pragma alloc_text(SwapCode, FT_NotifyDoneIORB_RP)
#pragma alloc_text(SwapCode, f_FT_NotifyDoneIORB_RP)

USHORT NEAR FT_CheckFTSupport (NPUNITCB, PBYTE);
USHORT FAR  f_FT_CheckFTSupport (NPUNITCB, PBYTE);
#pragma alloc_text(SwapCode, FT_CheckFTSupport)
#pragma alloc_text(SwapCode, f_FT_CheckFTSupport)

USHORT NEAR FT_Get_VolCB_Addr (USHORT, NPVOLCB FAR *);
USHORT FAR  f_FT_Get_VolCB_Addr (USHORT, NPVOLCB FAR *);
#pragma alloc_text(SwapCode, FT_Get_VolCB_Addr)
#pragma alloc_text(SwapCode, f_FT_Get_VolCB_Addr)

VOID NEAR FT_ExecReqList (PReq_List_Header, NPUNITCB);
VOID FAR  f_FT_ExecReqList (PReq_List_Header, NPUNITCB);
#pragma alloc_text(SwapCode, FT_ExecReqList)
#pragma alloc_text(SwapCode, f_FT_ExecReqList)


/*-----------------------------------------------*/
/* Function declarations for Assembler routines  */
/*-----------------------------------------------*/
USHORT FAR  f_FSD_AccValidate (USHORT);
VOID   FAR  f_ZeroCB (PBYTE, USHORT);
VOID   FAR  f_BlockCopy (PBYTE, PBYTE, USHORT);
ULONG  FAR  f_add32(ULONG, ULONG);
VOID   FAR  f_SWait (PVOID);
VOID   NEAR SWait (PVOID);
VOID   FAR  f_SSig (PVOID);
VOID   NEAR SSig (PVOID);
VOID   NEAR SortPriorityQueue  (PRTYQ *, PBYTE);
VOID   NEAR FSD_Notify (PBYTE, PVOID, USHORT);
VOID   NEAR FSD_EndofInt (VOID);
USHORT FAR  f_FT_Request (USHORT, USHORT, PBYTE FAR *, PBYTE FAR *);
USHORT FAR  f_FT_Done (USHORT, USHORT, ULONG);
VOID   FAR  DD_ChgPriority_asm (VOID);


/*-----------------------------------*/
/* Pragma declarations - DevHelps    */
/*-----------------------------------*/
#pragma alloc_text(Code, DevHelp_VMUnLock)
#pragma alloc_text(Code, DevHelp_VMLock)
#pragma alloc_text(Code, DevHelp_VirtToLin)
#pragma alloc_text(Code, DevHelp_AllocReqPacket)
#pragma alloc_text(Code, DevHelp_FreeReqPacket)
#pragma alloc_text(Code, DevHelp_Save_Message)

VOID   NEAR LogAnyErrors(PIORB); /* @V111573 */
