/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = DMIDC.C
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Inter Device Communications support for OS/2 DASD Manager
 *
 *
*/
#include "dmh.h"
#include "dmidc.h"

#ifdef LVM

extern VOID FAR DMStrat1(void);

VOID _loadds FAR 
DM_IDC( PDASD_IDC_CMD pCmd )
{
   switch( pCmd->function ) {

      case DMIDC_GET_INTERFACE: {
         PDASD_INTERFACE pInterface = pCmd->u.pInterface;
         pInterface->pStrat1 = (PSTRAT_FUNCTION) ((PVOID) DMStrat1);
         pInterface->pStrat2 = (PSTRAT_FUNCTION) ((PVOID) DMStrat2);
         pInterface->pStrat3 = (PSTRAT_FUNCTION) plStrat3;
         pInterface->pDiskInfoFunc = plDiskInfo;
         pInterface->pPartInfoFunc = plPartInfo;
         pInterface->pDCS = (P_DriverCaps) &DriverCapabilities;
         pInterface->numPartitions = NumLogDrives;
         pInterface->numFixedDisks = NumFixedDisks;
         pInterface->pBPB_array = (PBPBS) InitBPBArray;
         pCmd->status = DMS_SUCCESS;
         break;
      }

      default:
         pCmd->status = DMS_UNKNOWN_FUNCTION;
         break;
   }
}

#else

/* Dummy IDC entry for pre-LVM code */
VOID _loadds FAR 
DM_IDC( )
{
}

#endif
