;/****************************************************************************/
;/*                                                                          */
;/*                           IBM Confidential                               */
;/*                                                                          */
;/*                 Copyright (c) IBM Corporation 1998                       */
;/*                           All Rights Reserved                            */
;/*                                                                          */
;/****************************************************************************/
;/****************************************************************************
; *
; * SOURCE FILE NAME = dmheader.asm
; *
; * DESCRIPTIVE NAME = OS2DASD DD header structure
; *
; * DESCRIPTION : Device driver header for DASD Device Manager
; *               LVM version of header.
; *
; * CHANGE ACTIVITY =
; *  DATE      FLAG        APAR   CHANGE DESCRIPTION
; *  --------  ----------  -----  --------------------------------------
; *
; ****************************************************************************/

include devhdr.inc

extrn   _DMStrat1:far 
extrn   _DMCharStrat1:far              
extrn   _DM_IDC:far

;-------------------------------------------------------------
; Device Driver Header                                   
;                                                             
; This MUST be linked at the beginning of the data segment           
;-------------------------------------------------------------
public  _DiskDDHeader

DDHeader        segment dword public 'DATA'

;----------------------------------------------------------------------------
; Primary header for this driver. 
;----------------------------------------------------------------------------

_DiskDDHeader   dd      ddCharHeader    ; FAR ptr to next device header.
                dw      DEV_NON_IBM + DEVLEV_1 + DEV_30
                dw      OFFSET _DMStrat1   ; Strategy 1 entry point.
                dw      0               ; IDC entry point.
                db      " Disk DD"      ; Device name, must be 8 chars.
                dw      0               ; reserved
                dw      0               ; reserved
                dw      0               ; reserved
                dw      0               ; reserved
                dd      0               ; Cap. strip

;----------------------------------------------------------------------------
; Alternate character DD header for this driver.
; Provides an IDC interface into OS2DASD for OS2LVM, and also allows 
; the driver to handle the Shutdown command for cleanup operations.
;----------------------------------------------------------------------------

ddCharHeader    dd      -1              ; FAR ptr to next device header.
                dw      DEV_30 + DEVLEV_3 + DEV_CHAR_DEV + DEV_IOCTL
                dw      OFFSET _DMCharStrat1 ; Strategy 1 entry point.
                dw      OFFSET _DM_IDC  ; IDC entry point.
                db      "OS2DASD$"      ; Device name, must be 8 chars.
                dw      0               ; reserved
                dw      0               ; reserved
                dw      0               ; reserved
                dw      0               ; reserved
                dd      DEV_IOCTL2 + DEV_16MB   ; Cap. strip

DDHeader        ends

        end
