/*static char *SCCSID = "src/dev/dasd/os2dasd/dmfault.h, dsdm, c.basedd 93/03/19";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = DMFAULT.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 *
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Typedefs/Defines for drive mirroring support for
 *               use with Fault Tolerant LAN Subsystem.
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  mm/dd/yy  @Vnnnnn     xxxxx  xxxxxxx
 ****************************************************************************/


/*-------------------------------------------------------*/
/*   Header file for fault tolerance support.            */
/*-------------------------------------------------------*/

#define FT_IOCTL_Cat         0x88    /* FT IOCTL Category     */
#define FT_IOCTL_Func        0x51    /* FT IOCTL Function     */
#define FT_ActivePartition   0x87    /* Active FT partition   */
#define FT_InactivePartition 0xC7    /* Inactive FT partition */

#define I24_MIN_RECOV_ERROR  0x1A    /* Error Codes > this are recoverable */

/*-------------------------------------------------------*/
/*  See file DSKIOCTL.H for Cat 88h Func 51 definitions  */
/*-------------------------------------------------------*/

/*-------------------------------------------------------*/
/*   FT_REQUEST return data                              */
/*-------------------------------------------------------*/
typedef struct _FT_RESULTS {

   USHORT       Reserved;
   USHORT       RequestHandle;
   PBYTE        pShadowReq;
   UCHAR        SecPartNum;

} FT_RESULTS;

#define ACT_PRIMARY          0x00    /* Access primary drive only     */
#define ACT_PRIMARY_FIRST    0x01    /* Access primary drive first    */
#define ACT_SECONDARY        0x02    /* Access secondary drive only   */
#define ACT_SECONDARY_FIRST  0x03    /* Access secondary drive first  */
#define ACT_BOTH             0x05    /* Acess both drives             */
#define ACT_EITHER           0x06    /* Use either drive for access   */


/*-------------------------------------------------------*/
/*   FT_DONE return codes                                */
/*-------------------------------------------------------*/
#define FT_DONE             0x00    /* Done */
#define FT_NOTDONE          0x01    /* Try again later, not finished */
#define I24_MIN_RECOV_ERROR 0x1A    /* Minimum recoverable error     */


/* Data areas used in Request Packet and Request List Entries for  */
/* tracking fault tolerant requests                                */

typedef struct _FTORIG {

   USHORT       RequestHandle;
   USHORT       Reserved;
} FTORIG;


typedef struct _FTDB {

   UCHAR        FT_Flags;
   UCHAR        AltLogDriveNum;
   union
   {
      FTORIG   OrigRequest;
      PBYTE    pOrigRequest;
   };

} FTDB, FAR *PFTDB;

/* FT_Flags defines */

#define FTF_FT_REQUEST       0x01
#define FTF_ACT_BOTH         0x02
#define FTF_SHADOW_REQUEST   0x04


#define MAXRPSIZE 32

typedef struct _RPFT {

   UCHAR        Dummy[MAXRPSIZE-6];
   FTDB         ftdb;

} RPFT, FAR *PRPFT;


typedef struct _RHFT {

   UCHAR        Dummy[sizeof(Req_Header)-8];
   FTDB         ftdb;
   UCHAR        Block_Dev_Unit;
   UCHAR        Reserved;

} RHFT, FAR *PRHFT;





