/**************************************************************************
 *
 * SOURCE FILE NAME = DMDEFS32.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1998
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION : Typedefs/Defines for OS/2 DASD Mgr 32 bit code
 *
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 ****************************************************************************/

#ifndef DMDEFS32_H
#define DMDEFS32_H

#define LINEAR_DS   ((char *) &_DiskDDHeader)    // Linear address for start of DS 

/* linear(offset)
 *
 * Given a near pointer (offset) to an item in the default data segment,
 * return it's linear address.
 */
#define linear(offset)   ((void *)(LINEAR_DS + (offset)))

#define virtual(offset)  ((void *)(_Virtual_DS + (offset)))
#define physical(offset) ((ULONG)(_Physical_DS + (offset)))

/* offset(linear)
 *
 * Given a 32 bit linear address to an item in the default data segment,
 * return it's 16:16 based offset.
 */
#define offset(linear)   ((USHORT)((ULONG)(linear) - (ULONG)LINEAR_DS))

/* pointer_add(p, n)
 *
 * Return a pointer which is incremented 'n' bytes from pointer 'p'.
 */
#define pointer_add(p, n)  ((PVOID) ((PBYTE)(p) + (n)))

#define pointer_sub(p, n)  ((PVOID) ((PBYTE)(p) - (n)))

/* 16:16 far pointer manipulation
 *
 * Far16ToSeg(p)            Return segment portion of given 16:16 far pointer
 * Far16ToOff(p)            Return offset  portion of given 16:16 far pointer
 * SegOffToFar16(seg, off)  Return 16:16 far pointer given segment and offset
 */
#define Far16ToSeg(p)  ((USHORT)((ULONG)(p) >> 16)) 
#define Far16ToOff(p)  ((USHORT)(p))                
#define SegOffToFar16(seg, off)  \
            ((PVOID) ( (((ULONG)(seg)) << 16) | (USHORT)(off) ))

/* Lock(x)
 *
 * Lock for entering a critical region.
 * KEE SpinLock services are used for locking.
 */
#define Lock(x)    KernAcquireSpinLock((SpinLock_t *)(x))

/* Unlock(x)
 *
 * Unlock for exiting a critical region.
 * KEE SpinLock services are used for locking.
 */
#define Unlock(x)  KernReleaseSpinLock((SpinLock_t *)(x))

#ifdef DM_STRICT
/* Perform an Assertion Check on a given condition.
 * If the condition is not TRUE, an int 3 is performed (for now).
 */
#define Assert(condition)  if (!(condition)) _interrupt(3)
#else
#define Assert(condition)
#endif

#endif
