/*****************************************************************************
 *
 *   IBM Confidential
 *
 *   OCO Source Materials
 *
 *   Program number (when available)
 *
 *   (c) Copyright IBM Corp. 1991, 1998
 *
 *   The source code for this program is not published or otherwise divested of its
 *   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
 *
 ****************************************************************************/
/**************************************************************************
 *
 * SCCSID: src/basedd/dasd/os2dasd/dmdefs.h, dsdm, w45.fs32 01/12/13
 *
 * SOURCE FILE NAME = DMDEFS.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 * DESCRIPTION : Typedefs/Defines for OS/2 DASD Mgr
 *
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  10/08/93  @V74404     74404  Add Set DASD Mgr parms IOCTL
 *  05/05/94  @V81576     81576  Discard System Trace/Perfview if not needed
 *  05/27/95  @V84908     84908  Move trace routing table to DMDATA.C to
 *                               prevent it from being discarded with
 *                               initialization data.
 *  02/06/95  @V111573   111573  Added typedef for PInfoSegGDT
 *  10/09/97  @V187707   187707  Partitioned removable media generic solution 
 *
 *  12/12/01  d_267592   dimir - added support of new FAT16 partition
 *                           of type 0x0E (the same as type 0x06) and
 *                           new extended partition of type 0x0F
 *                           (the same as type 0x05). Partitions of
 *                           these types are located beyond 7.875GB limit.
 *
 ****************************************************************************/

#ifndef DMDEFS_H
#define DMDEFS_H

/*------------------------------*/
/* Common typedefs              */
/*------------------------------*/
typedef struct _VolumeControlBlock FAR *PVOLCB;
typedef_NearPointer(struct _VolumeControlBlock, NPVOLCB);
typedef_NearPointer(struct _UnitControlBlock, NPUNITCB);
typedef struct _UnitControlBlock   FAR *PUNITCB;
typedef_NearPointer(struct _FaultTolCB, NPFTCB);
typedef_NearPointer(struct _VolChars, NPVOLCHARS);
typedef struct _DOSBOOTREC         FAR *PDOSBOOTREC;
typedef_NearPointer(struct _DOSBOOTREC, NPDOSBOOTREC);
typedef struct _PB_Read_Write      FAR *PPB_Read_Write;
typedef struct _Req_List_Header    FAR *PReq_List_Header;
typedef_NearPointer(struct _PVDB, NPPVDB);

typedef struct _CMDTABLE                                             /*@V84908*/
{                                                                    /*@V84908*/
   USHORT Cmd;                                                       /*@V84908*/
   USHORT CmdType;                                                   /*@V84908*/
} CMDTABLE;                                                          /*@V84908*/

typedef struct _ERROR_TABLE_ENTRY                                    /*@LVM*/
{
   USHORT   IORB_ErrorCode;
   UCHAR    I24_ErrorCode;
} ERROR_TABLE_ENTRY;

typedef struct InfoSegGDT FAR *PInfoSegGDT;  /* @V111573 */

#define MAX_FIXED_DISKS        128                                  /*@V151345*/
#ifdef LVM
#define MAX_PARTITIONS         126   // 128 - 2 for A: and B:       /*@LVM*/
#else
#define MAX_PARTITIONS          24
#endif
#define MAX_DRIVE_LETTERS       26
#define MAX_QUEUING_COUNT       16
#define NUM_DEFAULT_CWAS         4
#define MAX_ADAPTERS_PER_ADD    16
#define MAX_UNITS_PER_ADD       32

#define MAX_LOGICAL_UNITID    0x7f
        // Valid range for logical unit IDs (LogDriveNum field in a logical VolCB)
        // is 0 - 0x7f.  0x80 and above is used to identify fixed disk physical drives.

//@IBM J-d79396(D) #define INIT_POOL_SIZE          32 * 1024
#define INIT_POOL_SIZE          64 * 1024                                       //@IBM J-d79396(A)

/*** BPB Media Descriptor constants ***/
#define MEDIA_FIXED_DISK  0xF8      /* Fixed Disk                        */
#define MEDIA_720KB       0xF9      /* 3.5 inch / 720KB             2/9  */
#define MEDIA_144MB       0xF0      /* 3.5 inch / 1.44 MB          2/18  */
#define MEDIA_288MB       0xF0      /* 3.5 inch / 2.88 MB          2/36  */
#define MEDIA_12MB        0xF9      /* 96TPI hi density drive      2/15  */
#define MEDIA_180KB       0xFC      /* 48TPI 9 sector single sided  1/9  */
#define MEDIA_360KB       0xFD      /* 48TPI 9 sector double sided  2/9  */
#define MEDIA_160KB       0xFE      /* 48TPI 8 sector single sided  1/8  */
#define MEDIA_320KB       0xFF      /* 48TPI 8 sector               2/8  */
#define MEDIA_125MB       0xFE      /* 3.5 inch / 1.25 MB           2/8  */     //@IBM J-d79396(A)

/*** Device Types returned in Get Device Parms IOCTL */
#define TYPE_360KB        0x00
#define TYPE_12MB         0x01
#define TYPE_720KB        0x02
#define TYPE_FIXED_DISK   0x05
#define TYPE_144MB        0x07
#define TYPE_OTHER        0x08
#define TYPE_288MB        0x09


/* Change Media Flags */
#define MEDIA_CHANGED           0xFF
#define MEDIA_UNSURE_CHANGED    0x00
#define MEDIA_UNCHANGED         0x01


/*** Partition type constants ***/
#define PARTITION_16M         0x01
#define PARTITION_16Mto32M    0x04
#define PARTITION_EBR         0x05
#define PARTITION_32M         0x06
#define PARTITION_IFS         0x07
#define PARTITION_EXT_FAT     0x0E  //d_267592 Fat partition is located beyond 7.8 GB
#define PARTITION_EBR_NT      0x0F  // Extended Boot Record type for NT
#define PARTITION_LVM         0x35
#define PARTITION_FTACTIVE    0x87
#define PARTITION_FTINACTIVE  0xC7

/** Indices for CurIndex field **/

#define INDEX99      0x00           /* 96tpi in 96tpi drive   (5.25") */
#define INDEX49      0x01           /* 48tpi in 96tpi drive   (5.25") */
#define INDEX44      0x02           /* 48tpi in 48tpi drive   (5.25") */
#define INDEX77      0x03           /* 720 KB in 720KB        (3.5")  */
#define INDEX71      0x04           /* 720 KB in 1.44 MB      (3.5")  */
#define INDEX11      0x05           /* 1.44 MB in 1.44 MB     (3.5")  */

#define MAXINDEX     INDEX11        /* Max. index supported for AT or 7552 */


#define DISKTABLECOUNT          9


/*----------------------------------------------------*/
/* Global DDFlags defines                             */
/*----------------------------------------------------*/
#define DDF_NO_MEDIA            0x00000001    /* Medialess system */
#define DDF_INIT_TIME           0x00000002    /* Init time flag           */
#define DDF_FT_ENABLED          0x00000004    /* Fault Tolerance enabled  */
#define DDF_DMAReadBack         0x00000008    /* DMA Readback 1=on, 0=off */
#define DDF_DsktSuspended       0x00000010    /* 1=dskt suspended, 0=resumed */
#define DDF_DISCARD_TRACE       0x00000020    /* Trace Code Discarded        *//*@V81576*/
#define DDF_FT_LOCKED           0x00000080    /* FT Code locked              */


/* MACROS */

#define ENABLE  _asm {sti}
#define DISABLE _asm {cli}
#define PUSHFLAGS _asm {pushf}
#define POPFLAGS _asm {popf}

/* NextLogicalVolCB (NPVOLCB pVolCB)                                 @V187707
 *
 * Given a pointer to a logical VolCB, return a pointer to the next logical
 * VolCB belonging to the same physical device.
 */
#define NextLogicalVolCB(pVolCB) \
   ( pVolCB->pUnitCB == pVolCB->pNextVolCB->pUnitCB ? \
                        pVolCB->pNextVolCB : NULL )

/* Return TRUE if the given VolCB pointer references a fixed disk physical VolCB.
 * (note: 0xffff is the unitid given to fake A: B: VolCBs)
 */
#define isPhysicalVolCB(pVolCB) \
((pVolCB)->LogDriveNum > MAX_LOGICAL_UNITID  &&  (pVolCB)->LogDriveNum != 0xffff)

/* Defines to set and get the unit of a strat2 request list header (RLH).
 *                                                            Defect @220896
 *
 * The RLH is architected with a 'Block_Dev_Unit' field which normally contains
 * the unit number for the request.  However, under LVM, this unit must be
 * moved elsewhere for the following reason:  The OS2LVM layer may have a 
 * different unit number for the volume than OS2DASD.  OS2LVM will modify
 * 'Block_Dev_Unit' to match OS2DASD's unit when calling the strat2 entry,
 * but will restore the unit upon return.  Thus, subsequent access to
 * 'Block_Dev_Unit' by OS2DASD may yield an incorrect unit number.
 *
 * Note: This is not a concern for strat3 request lists, only strat2.
 *
 * SetStrat2Unit(pRLH, unit)
 *    For LVM, save the unit in the RLH 'Reserved_2' field.
 *    For nonLVM, do nothing, as the unit in the 'Block_Dev_Unit' field is OK.
 *
 * GetStrat2Unit(pRLH)
 *    For LVM, return the unit saved in 'Reserved_2'
 *    For nonLVM, return the unit from 'Block_Dev_Unit'
 */
#ifdef LVM

#define SetStrat2Unit(pRLH, unit) \
   ( ((PReq_List_Header)pRLH)->Reserved_2 = (unit) )

#define GetStrat2Unit(pRLH) \
   ( ((PReq_List_Header)pRLH)->Reserved_2 )

#else

#define SetStrat2Unit(pRLH, unit)

#define GetStrat2Unit(pRLH) ( ((PReq_List_Header)pRLH)->Block_Dev_Unit )

#endif

#ifdef LVM
#ifndef INCL_32    // 32 bit version of these macros are in dmdefs32.h

/* NEAR  Lock( NPSPINLOCK )
 * FAR f_Lock( NPSPINLOCK )
 *
 * Lock for entering a critical region.
 * KEE SpinLock services are used for locking.
 */
#define Lock(x)    AcquireSpinLock((NPSPINLOCK)(x))
#define f_Lock(x)  f_AcquireSpinLock((NPSPINLOCK)(x))

/* NEAR  Unlock( NPSPINLOCK )     
 * FAR f_Unlock( NPSPINLOCK )
 *
 * Unlock for exiting a critical region.
 * KEE SpinLock services are used for locking.
 */
#define Unlock(x)    ReleaseSpinLock((NPSPINLOCK)(x))
#define f_Unlock(x)  f_ReleaseSpinLock((NPSPINLOCK)(x))

#endif // #ifndef INCL_32
#endif // #ifdef LVM


#ifndef INCL_32    // 32 bit version of these macros are in dmdefs32.h

#ifdef DM_STRICT
#define Assert(condition)  if (!(condition)) _asm {int 3}
#else
#define Assert(condition) 
#endif

#endif

#endif
