/**************************************************************************
 *
 * SOURCE FILE NAME = DMDATA32.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1998
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION     Externs for data accessed by 32 bit os2dasd code.
 *
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  03/15/99  @221316    221316   Report pseudo A: and B: to OS2LVM when no floppy            
 ****************************************************************************/

extern struct SysDev  _DiskDDHeader;     /* DD header at start of DS       */

extern NPVOLCB     _VolCB_Head;          /* near ptr to first VolCB        */
extern NPUNITCB    _UnitCB_Head;         /* near ptr to first UnitCB       */
extern USHORT      _NumVolCBs;           /* number of volume control blocks*/
extern NPVOLCB     _DriveToVolCB[];      /* Drive to VolCB lookup          */
extern USHORT      _CB_FreeList;         /* Control Block free list        */
extern ERROR_TABLE_ENTRY _ErrorTable[];  /* Error mapping table            */
extern SPINLOCK    _CBLock;              /* Lock for CB pool               */
extern SPINLOCK    _VolCB_Lock;          /* Lock for VolCB list            */
extern USHORT      _NumReqsInProgress;   /* num requests in progress       */
extern USHORT      _NumReqsWaiting;      /* num requests on waiting queues */
extern USHORT      _NumRLEReqsWaiting;   /* @RAWIO - num requests on queues*/
extern ULONG       _Physical_DS;         /* Physical addr start of DS      */
extern PBYTE       _Virtual_DS;          /* Virtual addr start of DS       */
extern PVOID       pvThunkDoneIORB;      /* 16:16 address of ThunkDoneIORB */
extern NPUNITCB    _pPseudoFloppyUnitCB; /* near ptr to PseudoFloppyUnitCB */ /*@221316*/
extern void (* _Far32 _Pascal pfThunkToAdd16)(PVOID, PVOID);
                                         /* Far32 pointer to ThunkToAdd16() */
extern void (* _Far32 _Pascal pfNotifyIFS16)(PBYTE, PVOID, BOOL);
                                         /* Far32 pointer to NotifyIFS16() */
extern void (* _Far32 _Pascal pfSubmitRPs)(PUNITCB);
                                         /* Far32 pointer to SubmitRPs()   */
