/*****************************************************************************
 *
 *   IBM Confidential
 *
 *   OCO Source Materials
 *
 *   Program number (when available)
 *
 *   (c) Copyright IBM Corp. 1991, 1998
 *
 *   The source code for this program is not published or otherwise divested of its
 *   tradesecrets, irrespective of what has been deposited with the U.S. Copyright Office.
 *
 ****************************************************************************/
/**************************************************************************
 *
 * SCCSID: src/basedd/dasd/os2dasd/dmdata.h, dsdm, w45.fs32, 20000823.1 99/03/16
 *
 * SOURCE FILE NAME = DMDATA.H
 *
 * DESCRIPTIVE NAME = OS2DASD.DMD - OS/2 DASD Device Manager
 *
 * DESCRIPTION     Externs for data defined in DMDATA.C
 *
 *
 *
 * CHANGE ACTIVITY =
 *  DATE      FLAG        APAR   CHANGE DESCRIPTION
 *  --------  ----------  -----  --------------------------------------
 *  10/08/93  @V74404     74404  Add Set DASD Mgr parms IOCTL
 *  02/06/95  @V111573   111573  Ported hardware errlogging capability
 *                               from 1.3.
 *  03/12/96  @RAWIO     148343  Add seperate count for pending request list entries.
 *  09/17/98  @Trace             Add trace support.
 *  03/15/99  @221316    221316  Report pseudo A: and B: to OS2LVM when no floppy            
 ****************************************************************************/


/*--------------------------------------------*/
/* External data declarations in DMDATA.C     */
/*--------------------------------------------*/
//@IBM J-d79396(D) extern UCHAR       ScratchBuffer[512];  /* Scratch buffer for I/O         */
extern UCHAR       ScratchBuffer[1024]; /* Scratch buffer for I/O         */    //@IBM J-d79396(A)
extern PFN         Device_Help;         /* far ptr to devhelp function    */

extern PBYTE       pSysInfoSeg;         /* 16:16 addr of sys info seg     */ /*@Trace*/
extern ULONG       plSysInfoSeg;        /* linear addr of sys info seg    */ /*@Trace*/
extern PBYTE       pSIS_mec_table;      /* 16:16 addr of RAS MEC Table    */ /*@Trace*/
extern ULONG       plSIS_mec_table;     /* linear addr of RAS MEC Table   */ /*@Trace*/
extern PBYTE       pSIS_perf_mec_table; /* 16:16 addr of PERF MEC Table   */ /*@Trace*/
extern ULONG       plSIS_perf_mec_table;/* linear addr of PERF MEC Table  */ /*@Trace*/

extern PVOID       pDataSeg;            /* virt ptr of our data segment   */
extern ULONG       ppDataSeg;           /* phys addr of our data segment  */
extern ULONG       plDataSeg;           /* linear addr of our data seg    */
extern ULONG       ppScratchBuffer;     /* Phys addr of ScratchBuffer     */
extern USHORT      ScratchBufSem;       /* Semaphore for ScratchBuffer    */
extern USHORT      DDFlags;             /* Global driver flags            */
extern UCHAR FAR  *pInterruptLevel;     /* ptr to Interruptlevel d159983  */
extern USHORT      DefaultQueueMethod;  /* Queuing - priority/nopriority  */ /*@V74404*/
extern USHORT      DefaultSortMethod;   /* Sorting - fifo/elevator        */ /*@V74404*/
extern NPUNITCB    UnitCB_Head;         /* near ptr to first UnitCB       */
extern NPVOLCB     VolCB_Head;          /* near ptr to first VolCB        */
// d159983 extern NPVOLCB     VolCB_Hint;          /* hint for VolCB          154306 */
extern NPVOLCB     pVolCB_DriveA;       /* Pointer to A: VolCB            */
extern NPVOLCB     pVolCB_DriveB;       /* Pointer to B: VolCB            */
extern NPVOLCB     pVolCB_DriveC;       /* Pointer to C: VolCB            */
extern NPVOLCB     pVolCB_80;           /* Pointer to VolCB for drive 80H */
extern USHORT      NextLogDriveNum;     /* next logical drive number      */
extern NPBYTE      pNextFreeCB;         /* ptr to next free control blk   */
extern NPVOLCB     pLastLogVolCB;
extern USHORT      NextLogDriveNum;
extern USHORT      NumDrivers;          /* number of adapter drivers      */
extern USHORT      NumUnitCBs;          /* number of unit control blocks  */
extern USHORT      NumVolCBs;           /* number of volume control blocks*/
extern USHORT      NumLogDrives;        /* number of logical drives       */
extern USHORT      NumRemovableDisks;   /* number of removable disk drives*/
extern USHORT      NumFixedDisks;       /* number of fixed disk drives    */
extern BOOL        TreatAsFixed;        /* treating removables as fixed   */
extern BOOL        OpticalAsFixed;      /* treating removables as fixed   */
extern USHORT      NumPartitions;       /* number of fixed disk partitions*/
extern USHORT      NumFTPartitions;     /* number of fault tol. partitions*/
extern NPVOLCB     pExtraVolCBs;        /* pointer to extra volcbs        */
extern USHORT      NumExtraVolCBs;      /* number of extra volcbs         */
extern USHORT      NumAdapters;         /* number of adapters             */
extern USHORT      NumReqsInProgress;   /* num requests in progress       */
extern USHORT      NumReqsWaiting;      /* num requests on waiting queues */
extern USHORT      NumRLEReqsWaiting;   /* @RAWIO - num requests on queues */
extern USHORT      TraceFlags;          /* Trace Flags                    */
extern NPBYTE      pDMTraceBuf;         /* pointer to internal trace buffer*/
extern NPBYTE      pDMTraceHead;        /* pointer to head of trace buffer */
extern NPBYTE      pDMTraceEnd;         /* pointer to end of trace buffer */
extern NPBYTE      CB_FreeList;         /* Control Block Free List for    */
                                        /*  IORBs and CWAs                */
extern NPBYTE      CB_PoolStart;        /* Address of start of CB pool    */
extern USHORT      PoolSem;             /* Pool semaphore                 */
extern USHORT      PoolSize;            /* Size of control block pool     */
extern USHORT      FreePoolSpace;       /* Free space left in data segment*/
extern UCHAR       fBigFat;             /* flags for drives               */
extern UCHAR       XActPDrv;
extern PVOID       pFSD_EndofInt;       /* FSD's End of interrupt routine */
extern PVOID       pFSD_AccValidate;    /* FSD's Access Validation routine*/
extern PVOID       pDiskFT_Request;     /* DISKFT's Request routine       */
extern PVOID       pDiskFT_Done;        /* DISKFT's Done routine          */
extern USHORT      DiskFT_DS;           /* DISKFT's DS selector           */

extern PRTYQ       DeferredQRP;         /* Queue for Deferred FT Requests */
extern PRTYQ       DeferredQRLE;        /* Queue for Deferred FT Requests */
extern USHORT      NumReqsDeferred;     /* num requests on Deferred queues*/

extern DriverCaps  DriverCapabilities;  /* Driver Capabilities structure  */
extern DISKTABLE_ENTRY DiskTable[];

extern BPB         BPB_Minimum;
extern BPB         BPB_160KB;
extern BPB         BPB_180KB;
extern BPB         BPB_320KB;
extern BPB         BPB_360KB;
extern BPB         BPB_12MB;
extern BPB         BPB_720KB;
extern BPB         BPB_144MB;
extern BPB         BPB_288MB;
extern BPB         BPB_125MB;                                                   //@IBM J-d79396(A)

extern PBPB        DummyBPB;            /* Pointer to BPB for drive aliasing */
extern NPBPB       InitBPBArray[];      /* BPB array returned in INIT packet */
extern CMDTABLE    CmdTable[20];                                     /*@V84908*/

extern HDRIVER     hRMOS2DASD;

extern DASDLOGDATA GenAlert_URErr;   /* @V111573 */
extern DASDLOGDATA GenAlert_RErr;    /* @V111573 */

extern NPVOLCB     DriveToVolCB[256];   /* Drive to VolCB lookup d159983     */

extern UNITCB      FirstUnitCB[1];      /* First UnitCB allocated here       */
extern UCHAR       CBPool[];            /* Start of Pool                     */

extern UCHAR       EjectCDB[6];
extern UCHAR       EjectCDB1[6];
extern UCHAR       StartCDB[6];
extern MSGTABLE    Msginfo;
extern UCHAR       ShutdownIORB[MAX_IORB_SIZE];      /* Shutdown time IORB   */
extern PARTTABLE_INFO  PartTable;       /* Buffer to save partition table info */
extern USHORT      InitData;            /* Start of Init data                */
extern BYTE        PFV_PreviousState;   /* Was Perfview just reconfigured?   */ /*@V55646*/

extern UCHAR       RMFixed_Txt[];
extern UCHAR       RMRemovable_Txt[];
extern UCHAR       RMDskt_Txt[];
extern UCHAR       RMSysName_Txt[];

extern DRIVERSTRUCT RMDASDDesc;

#ifdef LVM                                                           /*@LVM*/
extern PVOID       plStrat3;            /* Linear address of strat3 entry */
extern PVOID       plDiskInfo;          /* Linear address of NextPhysDiskInfo */
extern PVOID       plPartInfo;          /* Linear address of NextPhysPartInfo */
extern NPVOLCB     VolCB_FreeList;      /* VolCB free list                */
extern SPINLOCK    CBLock;              /* Lock for CB pool               */ 
extern SPINLOCK    VolCB_Lock;          /* Lock for VolCB list            */
extern SPINLOCK    DeferredQ_Lock;      /* Lock for FT Deferred Queues    */
extern ULONG       Physical_DS;         /* Physical addr start of DS      */
extern PBYTE       Virtual_DS;          /* Virtual addr start of DS       */
extern DLAT_INFO   DLAT;                /* Buffer to save DLA Table info  */
extern USHORT      RediscoverSem;       /* Semaphore for Rediscover logic */
extern UNITCB      PseudoFloppyUnitCB;  /* Pseudo floppy UnitCB           */ /*@221316*/
extern NPUNITCB    pPseudoFloppyUnitCB; /* Pointer to  "                  */ /*@221316*/
#endif
