/*
** $Id: makeinf.cmd,v 1.1 1999/02/10 23:16:38 tanchs1 Exp $
**
** Convert CVS .texinfo documentation to .inf format.
**
** Prerequisites:
**  - texiconv 1.00 (available at Hobbes).
**  - IPFC (Watcom C/C++, VisualAge C++, Warp 4 Toolkit)
**
** Copyright (C) 1998  Andreas Huber <ahuber@ping.at>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; see the file COPYING. If not, write to
** the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA 02111-1307, USA.
*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

EXIT_SUCCESS = 0
EXIT_FAILURE = 1

VERSION = '../../src/version.c'
TEXI2IPF = 'texi2ipf'
IPFC = "IPFC /INF"


globals = 'EXIT_SUCCESS EXIT_FAILURE VERSION TEXI2IPF IPFC'

main:
	if stream(VERSION, 'c', 'open read') \= 'READY:' then
		call die 'makeinf: cannot open' VERSION 'for reading.'
	call SysFileDelete 'CVSvn.texi'
	do while lines(VERSION) > 0
		line = linein(VERSION)
		if pos('version_string', line) > 0 then do
			line = substr(line, verify(line, '0123456789.', 'm'))
			line = substr(line, 1, verify(line, '0123456789.')-1)
			call lineout 'CVSvn.texi', '@set CVSVN' line
			call stream 'CVSvn.texi', 'c', 'close'
			leave
		end
	end
	call stream VERSION, 'c', 'close'
	call convert '../../doc/cvs.texinfo', 'cvs.ipf', 'cvs.inf'
	call convert '../../doc/cvsclient.texi', 'cvs-client.ipf', 'cvs-client.inf'
	call convert 'intro.texi', 'intro.ipf', 'intro.inf'
	exit EXIT_SUCCESS

convert: procedure expose (globals)
	parse arg texiname, ipfname
	TEXI2IPF' 'texiname '>'ipfname
        IPFC' 'ipfname' >NUL'
	if rc \= 0 then
		call die 'makeinf: cannot convert' filename||'.'
	return

die: procedure expose (globals)
	parse arg text
	call lineout 'stderr:', text
	exit EXIT_FAILURE

