/*************************************************************/
/*                                                           */
/* CTF.S    Invokes CTFORMAT to format C/C++,                */
/*          Assembler, and WYSIWYG Text Files                */
/*                                                           */
/*          Written by Scott T Jones                         */
/*                                                           */
/* Creates command ctf_format.  When called the current file */
/* is saved as CTFORMAT.$$A, run thru the CTFORMAT filter to */
/* produce CTFORMAT.$$B, and reloaded to replace the current */
/* file.  These files are deleted at the end of the process. */
/* ctf_format allows you to reformat your file, then save it */
/* independent of the reformating.                           */
/*                                                           */
/* No keys are changed.  It is up to the user to bind this   */
/* command to a SLICK key or call it from the command line.  */
/*                                                           */
/* To use this command, CTFORMAT.EXE is required in the      */
/* execution path of your system.                            */
/*                                                           */
/*************************************************************/

defc ctf_format
    ctf_buf_name=.buf_name
    ctf_first_y=.cursor_y
    ctf_line=.line
    ctf_col=.col
    .line=0
    .line=ctf_line
    ctf_second_y=.cursor_y
    message 'Formatting with CTFORMAT'
    write_file 'ctformat.$$a'
    if rc<>0 then
       message 'Error encountered while saving'
       stop
    endif
    quiet_shell 'ctformat b <ctformat.$$a >ctformat.$$b'
    if rc<>0 then
       message 'Error encountered while formatting'
       delete_file 'ctformat.$$a'
       delete_file 'ctformat.$$b'
       stop
    endif
    'edit ctformat.$$b'
    'prev-buffer'
    .modify=0
    'quit'
    'next-buffer'
    name_file( ctf_buf_name )
    .modify=1
    .line=ctf_line + ctf_second_y - ctf_first_y
    .line=ctf_line
    .col=ctf_col
    delete_file 'ctformat.$$a'
    delete_file 'ctformat.$$b'
    message 'Formatting complete'
