{ MacPrint Spooler,  ct und C.Meyer 3/95.  Adaptierte DropShell von Leonard Rosenthol }

program DropShell;

{$IFC THINK_Pascal}
	uses
		AppleTalk, Processes, PPCToolbox, EPPC, Notification, AppleEvents, Script,
{ und die DropShell-Files }
		DSGlobals, DSUtils, DSUserProcs, DSAppleEvents;
{$ELSEC}
	uses
		MemTypes, QuickDraw, OSIntf, ToolIntf, Packages, GestaltEqu, Files, Aliases, AppleEvents,
{ und die DropShell-Files }
		DSGlobals, DSUtils, DSUserProcs, DSAppleEvents;
{$ENDC THINK_Pascal}

{$IFC THINK_Pascal}
{$ELSEC}
{ Zwecks Segment-Entladung von %A5Init fr MPW }
	procedure _DataInit;
	EXTERNAL;
{$ENDC THINK_Pascal}

{ Von InitDialogs fr den "Retten"-Knopf in Absturzmeldung installiert }
	procedure Panic;
	begin
		ExitToShell;
	end;

{$S Initialize}
{ Initialisierung der Toolboxen }
	procedure InitToolbox;
	begin
{$IFC THINK_Pascal}
{$I-}
{$ELSEC }
		UnloadSeg(@_DataInit);		{ speziell fr MPW }
{$ENDC THINK_Pascal}

		InitGraf(@thePort);
		InitFonts;
		InitWindows;
		InitMenus;
		TEInit;
		InitDialogs(@Panic);
		InitCursor;
		FlushEvents(everyEvent, 0);

{ Die blichen Masterpointer }
		MoreMasters;
		MoreMasters;
	end;

{ Der Name sagts auch hier...	}
	procedure InitGlobals;
		var
			aLong: LongInt;
	begin
		gDone := FALSE;
		gOApped := FALSE;
		gHasAppleEvents := (Gestalt(gestaltAppleEventsAttr, aLong) = noErr);
		gSplashScreen := nil;
		gDocNo := 0;
	end;

{ Mens installieren }
	procedure SetUpMenus;
	begin
		gAppleMenu := GetMenu(kAppleNum);
		AddResMenu(gAppleMenu, 'DRVR');
		InsertMenu(gAppleMenu, 0);
		gFileMenu := GetMenu(kFileNum);
		InsertMenu(gFileMenu, 0);
		gOptionsMenu := GetMenu(kOptionsNum);
		InsertMenu(gOptionsMenu, 0);
		DrawMenuBar;
	end;


{ Fenster und nichtmodale Dialoge installieren. Hier nur Status }
{ mit verankertem Bild anzeigen }
	procedure InstallWindows;
		var
			picH: PicHandle;
	begin
		if (gSplashScreen = nil) then
			begin
				picH := GetPicture(kPicID);
				if picH <> nil then
					begin
						gSplashScreen := GetNewWindow(kWindowID, nil, Pointer(-1));
						if gSplashScreen <> nil then
							begin
								SetWindowPic(gSplashScreen, picH);
{ kommt sowieso irgendwann bei 'oapp': }
{ ShowWindow(gSplashScreen); }
							end;
					end;
			end;
	end;

{$S Main}

{ Die blichen Event-gesteuerten Routinen }
	procedure ShowAbout;
		var
			itemHit: integer;
	begin
		itemHit := Alert(128, nil);
	end;

	procedure DoMenu (retVal: longint);
		var
			menuID, itemID: integer;
			itemStr: Str255;
			refNum: integer;
	begin
		menuID := HiWord(retVal);
		itemID := LoWord(retVal);

		case menuID of
			kAppleNum: 
				if itemID = 1 then	{handle the about box}
					ShowAbout
				else				{get the DA's}
					begin
						GetItem(GetMHandle(kAppleNum), itemID, itemStr);
						refNum := OpenDeskAcc(itemStr);
					end;
			kFileNum: 
				if itemID = 1 then	{Select File}
					SelectFile
				else
					SendQuitToSelf;	{send me a quit event}
			kOptionsNum: 
				case itemID of
					kDOSItem: 
						begin
							gPrefs.PCkonv := not gPrefs.PCKonv;
							CheckItem(GetMenu(kOptionsNum), itemID, gPrefs.PCKonv);
						end;
					kPrintPortItem: 
						begin
							gPrefs.Port := itemID;
							CheckItem(GetMenu(kOptionsNum), kModemPortItem, false);
							SetItemMark(GetMenu(kOptionsNum), itemID, '');	{ Raute }
						end;
					kModemPortItem: 
						begin
							gPrefs.Port := itemID;
							CheckItem(GetMenu(kOptionsNum), kPrintPortItem, false);
							SetItemMark(GetMenu(kOptionsNum), itemID, '');	{ Raute }
						end;
				end;
			otherwise
{ Hier nichts zu tun }
		end;
		HiliteMenu(0);
	end;

	procedure DoMouseDown (curEvent: EventRecord);
		var
			whichWindow: WindowPtr;
			whichPart: integer;
	begin
		whichPart := FindWindow(curEvent.where, whichWindow);
		case whichPart of
			inMenuBar: 
				DoMenu(MenuSelect(curEvent.where));
			inSysWindow: 
				SystemClick(curEvent, whichWindow);
			inDrag: 
				DragWindow(whichWindow, curEvent.where, screenBits.bounds);
			inDesk, inContent, inGrow, inGoAway, inZoomIn, inZoomOut: 
				;
{ Hier nichts zu tun }
			otherwise
{ Hier auch nicht }
		end;
	end;

	procedure DoKeyDown (curEvent: EventRecord);
		var
			ch: char;
	begin
		ch := CHR(BitAnd(curEvent.message, charCodeMask));
		if BitAnd(curEvent.modifiers, cmdKey) <> 0 then
			DoMenu(MenuKey(ch));
	end;

{ Klassische Hauptschleife }
begin
	InitToolbox;
	InitGlobals;
	InstallWindows;
{ Anwendungsspezifische Datenstrukturen erstellen }
	InitUserGlobals;
	if gHasAppleEvents then
		begin
			InitAEVTStuff;
			SetupMenus;
			while not gDone do
				begin
					gWasEvent := WaitNextEvent(everyEvent, gEvent, 0, nil);
					if gWasEvent then
						begin
							case gEvent.what of
								kHighLevelEvent: 
									DoHighLevelEvent(gEvent);
								mouseDown: 
									DoMouseDown(gEvent);
								keyDown, autoKey: 
									DoKeyDown(gEvent);
								otherwise
{ Nichts zu tun }
							end; { case }
						end;
				end; { while }
		end
	else
		ErrorAlert(kErrStringID, kCantRunErr, 0);
{ Anwendungsspezifische Datenstrukturen entfernen }
	DisposeUserGlobals;
end.