/*
$Revision: 1.4$
**
**
** Copyright M CUBED 1993, ALL RIGHTS DESERVED
** author   : Michael McDaniel
**
** This work is derived in part from public domain code, and is contributed
** back to the public domain.
**
** ===>>> please keep my credits when you add your own <<<===
**
**
** purpose  : calculates a 24 bit cyclic redundancy check of a file; original
**            crc must be known to verify integrity of file. Can also check
**            to see if two files have identical contents (the filenames are
**            not used in the crc calculation). CCITT uses a 16 bit crc for
**            data transmission, which is generally considered 'good enough'.
**            It is extremely unlikely (I do not know the percentages) that
**            two different files will have the same 24 bit crc value.
**
**            For use in batch files, this program returns a 0 if a 24 bit crc
**            value was successfully calculated for all command line arguments.
**            A 1 is returned if there is any failure.
**
**
**
** see also : crc24.h             (needs controll.lib to link, or crc24.obj)
**
**
** reference: 1)
**
*/

static char rcsid[]  = "$Id$";
static char rcsrev[] = "$Revision: 1.4 $";



# include <stdlib.h>
# include <io.h>
# include <fstream.h>
# include <iostream.h>
# include <iomanip.h>
# include <string.h>

# include "crc24.h"



int check( char * argv )
{
   int rc = 0;

   class crc24 * verify = new crc24(argv);


   if( verify->valid() )
   {
      cout << endl << setw(42) << argv << ": " << verify->value() << flush;
   }
   else
   {
      cout << endl << setw(42) << argv << ": error " << errno << flush;

      rc = 1;
   }

   delete verify;

   return rc;

} // end check()




main(int argc, char *argv[], char *envp[])
{
   char filename[132+1];
   int rc = 0;

   if( argc < 2 )                                            // help
   {

      cerr << "usage: " << argv[0]
           << " [ filename[s] | @filelist | -v ] "
           << endl
           << "       where filename[s] gives 24 bit crc of filename[s]"
           << endl
           << "             @filelist gives 24 bit crc of filenames in file"
           << " filelist"
           << endl
           << "             (filelist will contain only one filename per line,"
           << " no blank lines)" << endl
           << "             -v gives version number of this program"
           << endl
           << "              reading large files takes longer"
           << endl;

      cerr << endl
           << argv[0]
           << " Copyright M CUBED 1993, ALL RIGHTS DESERVED"
           << endl;

      return 1;
   }
   else
   if( argv[1][1] == 'v' )
   {
      cerr << argv[0] << ": " << rcsrev << endl;
      cerr << "Copyright M CUBED 1993, ALL RIGHTS DESERVED" << endl;

      return 1;
   }


                                                          // large files
                                                          // can take awhile
   cerr << "please wait (larger files take longer)..." << endl;

   cout << "24 bit crc values calculated by "
        << argv[0]
        << " "
        << rcsrev
        << endl;

                                                          // using a filelist
   if( argv[1][0] == '@' )
   {
      fstream filelist;

      if( access(argv[1]+1, 04) == 0 )
      {
         filelist.open( argv[1]+1, ios::in );

         if( !filelist.bad() )
         {
            while( !filelist.bad() && !filelist.eof() )
            {
                  filelist.getline(filename, sizeof(filename));
                  check( filename );
            }
         }
      }
   }
   else
   {
                                                          // try a crc24 on
                                                          // each command line
                                                          // argument
      for( int i = 1; i < argc; i++ )
          rc = check( argv[i] );

   }



   cout << endl;

   return rc;                            // 0 if success for every attempt
                                         // else 1

} // end main


// end $Source: e:/work2/x/jacquard/src/control/RCS/crck.cpp $$Revision: 1.3 $
