/*
$Header: e:/work2/x/jacquard/src/control/RCS/crc24.h 1.2 93/06/23 03:21:13 m3m rel $
**
** Copyright M CUBED 1993, ALL RIGHTS DESERVED
** This work is derived in part from public domain code, and is contributed
** back to the public domain.
**
** purpose  : calculates a 24 bit cyclic redundancy check to verify file
**            integrity; the value of the original file must be known to
**            check for corruption; note that you can also check files
**            with different names to check if contents are the same only
**            the contents of the file are checked, the file name has no
**            bearing on the crc value.
**
**            Certainty is 'quite high' that the files are identical if
**            the 24 bit crc value is identical (CCITT uses only a 16 bit
**            crc which is commonly considered acceptable verification of
**            accurate data transmissions). I do not know what the
**            percentages are.
**
** author   : Michael McDaniel
**
** reference: 1) pgp21, armor.c
**            2) "C Programmer's Guide to Serial Communications",
**               by Joe Campbell
**               These CRC functions are derived from code in chapter 19
**               Generalized to any CRC width by Philip Zimmermann; 24 bit
**               width used here.
**
*/

# ifdef __CRC24_CPP_
   static char crc24_h_rcsid[] = "$Header: e:/work2/x/jacquard/src/control/RCS/crc24.h 1.2 93/06/23 03:21:13 m3m rel $";
# endif


typedef unsigned long crcword;


class crc24
{
   public:
      crc24( char * file_name );
      ~crc24();

      unsigned long value();                     // returns calculated value

      int valid() { return pvalid; };


   private:
      crcword  accum;
      int      pvalid;                    // 1 if successful calculation
                                         // i.e. file could be opened, read,
                                        // enough memory for calculation

      void     mk_crctbl( crcword poly );
      crcword  crchware(unsigned char ch, crcword poly, crcword accum);
      crcword  crcupdate(unsigned char data, crcword accum);

}; // end crc24

// end $Source: e:/work2/x/jacquard/src/control/RCS/crc24.h $

