/***************************************************************************
 *
 * Name:  bsesub.h
 *
 * Function:
 *     OS/2 base include for 32 bit versions of Vio/Kbd/Mou.
 *
 * Copyright:
 *     Copyright (C) IBM Corp. 1987, 1995
 *     Modified slightly for greater legibility by JdeBP.
 *
 * Note:
 *     1. One or more of the following should be defined.
 *          INCL_KBD                KBD
 *          INCL_VIO                VIO
 *          INCL_AVIO               VIO
 *          INCL_MOU                MOU
 *          INCL_SUB                all of the above
 *
 *     2. The Vio calls from pmavio.h were moved here so that all of
 *        the Vio calls are in one place.
 *
 *     3. A number of fields have been increased from 16 bits to 32 bits.
 *        All 32 bit fields are now placed on 4 byte boundaries.
 *
 *
 ****************************************************************************/
#ifdef __IBMC__
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( suspend )
   #endif
   #pragma checkout( resume )
#else
   #ifdef __IBMCPP__
      #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( none )
      #endif
      #pragma info( restore )
   #endif
#endif
#ifdef __cplusplus
      extern "C" {
#endif

#ifndef __BSESUB__
#define __BSESUB__

#ifdef INCL_SUB
    #define INCL_KBD
    #define INCL_VIO
    #define INCL_AVIO
    #define INCL_MOU
#endif

#ifdef INCL_AVIO
    #define INCL_VIO
#endif

/*
 * Keyboard (Kbd) functions
 *
 * Notes:
 *     The keyboard handle is always required to be zero, as there is no longer
 *     an open and close.
 */
#ifdef INCL_KBD
    typedef unsigned long HKBD ;   /* keyboard handle */
    typedef HKBD        * PHKBD ;

    /*
     * Flags for KbdCharin, KbdGetConsole, and KbdStringIn
     * (IO_PEEKWAIT not available in OS/2 2.x)
     */
    #define IO_WAIT               0
    #define IO_NOWAIT             1
    #define IO_PEEK               2
    #define IO_PEEKWAIT           3
    #define IO_EXTENDED           4

    /*
     * Console Event Kinds (CK_MOUSE, and CK_NOTIFY not in OS/2 2.x)
     */
    #define CK_NONE               0
    #define CK_KEY                1
    #define CK_CHAR               2
    #define CK_MOUSE              3
    #define CK_NOTIFY             4

    /*
     * Translation status for KbdCharin and KbdXlate (fbStatus)
     */
    #define KBDTRF_SHIFT_KEY_IN        0x01
    #define KBDTRF_NOT_A_CHAR          0x02
    #define KBDTRF_CONVERSION_REQUEST  0x20
    #define KBDTRF_FINAL_CHAR_IN       0x40
    #define KBDTRF_INTERIM_CHAR_IN     0x80

    /*
     * Key structure for KbdCharIn and KbdPeek
     * (Unicode character added, change in lengths)
     */
    typedef  _Packed struct _KBDKEYINFO {
        USHORT   ucUniChar ;       /* Unicode char (added field)     */
        USHORT   chChar ;          /* Char in current codepage       */
        UCHAR    chScan ;          /* Scan code                      */
        UCHAR    fbStatus ;        /* Final/Interim bits             */
        USHORT   fsState ;         /* Shift state                    */
        USHORT   VKey ;            /* Virtual key                    */
        UCHAR    bNlsShift ;       /* Extended shift status          */
        UCHAR    resv ;            /* Reserved                       */
        ULONG    time ;            /* Time stamp                     */
    } KBDKEYINFO ;
    typedef KBDKEYINFO * PKBDKEYINFO ;

    /*
     * Definitions for usage of bNlsShift
     */
    #define  NLSS_NLS1    0x01   /* Fullwidth, National layer   */
    #define  NLSS_NLS2    0x02   /* Katakana, JAMO, phonetic    */
    #define  NLSS_NLS3    0x04   /* Hiragana, Hangeul, TsangJye */
    #define  NLSS_APPL    0x10   /* Application bit             */
    #define  NLSS_NLS4    0x40   /* Romanji, HanjaCsr           */
    #define  NLSS_KANJI   0x80   /* Kanji, Hanja                */

    /*
     * Length structure for KbdStringIn
     */
    typedef _Packed struct _STRINGINBUF {
        ULONG  cb ;           /* Size of input buffer (was ushort) */
        ULONG  cchIn ;        /* Number of bytes read (was ushort) */
    } STRINGINBUF ;
    typedef STRINGINBUF * PSTRINGINBUF ;

    /*
     * Values and layout of hardware ID for KbdGetHWID
     */
    #define KBHWID_UNKNOWN        0x0000
    #define KBHWID_AT             0x0001
    #define KBHWID_ENHANCED       0xab41
    #define KBHWID_SMALL          0xab54
    #define KBHWID_MFIOLD         0xab85
    #define KBHWID_MFI            0xab86
    typedef _Packed struct _KBDHWID {
        USHORT cb ;           /* Size of buffer           */
        USHORT idKbd ;        /* Keyboard ID (KBHWID_)    */
        USHORT idSecond ;     /* Secondary ID             */
    } KBDHWID ;
    typedef KBDHWID  * PKBDHWID ;

    /*
     * KBDINFO structure, for KbdSetStatus and KbdGetStatus
     */
    typedef _Packed struct _KBDINFO {
        USHORT cb ;
        USHORT fsMask ;
        USHORT chTurnAround ;
        USHORT fsInterim ;           /* Upper byte is NLS Shift */
        USHORT fsState ;
    } KBDINFO ;
    typedef KBDINFO * PKBDINFO ;

    /*
     * Mask bits for KBDINFO in KbdSetStatus and KbdGetStatus (fsMask)
     */
    #define KEYBOARD_ECHO_ON                0x0001
    #define KEYBOARD_ECHO_OFF               0x0002
    #define KEYBOARD_ECHO_SAME              0x0000

    #define KEYBOARD_BINARY_MODE            0x0004
    #define KEYBOARD_ASCII_MODE             0x0008
    #define KEYBOARD_TERM_MODE              0x0200
    #define KEYBOARD_SAME_MODE              0x0000

    #define KEYBOARD_MODIFY_STATE           0x0010
    #define KEYBOARD_MODIFY_INTERIM         0x0020
    #define KEYBOARD_MODIFY_TURNAROUND      0x0040
    #define KEYBOARD_2B_TURNAROUND          0x0080

    #define KEYBOARD_SHIFT_REPORT           0x0100

    /*
     * Status bits for KBDINFO in KbdSetStatus and KbdGetStatus (fsState)
     */
    #ifndef INCL_DOSDEVIOCTL           /* Also defined in bsedev.h */
        #define KBDSTF_RIGHTSHIFT           0x0001
        #define KBDSTF_LEFTSHIFT            0x0002
        #define KBDSTF_CONTROL              0x0004
        #define KBDSTF_ALT                  0x0008
        #define KBDSTF_SCROLLLOCK_ON        0x0010
        #define KBDSTF_NUMLOCK_ON           0x0020
        #define KBDSTF_CAPSLOCK_ON          0x0040
        #define KBDSTF_INSERT_ON            0x0080
        #define KBDSTF_LEFTCONTROL          0x0100
        #define KBDSTF_LEFTALT              0x0200
        #define KBDSTF_RIGHTCONTROL         0x0400
        #define KBDSTF_RIGHTALT             0x0800
        #define KBDSTF_SCROLLLOCK           0x1000
        #define KBDSTF_NUMLOCK              0x2000
        #define KBDSTF_CAPSLOCK             0x4000
        #define KBDSTF_SYSREQ               0x8000
    #endif  /* INCL_DOSDEVIOCTL */

   /*
    * Keyboard function prototypes
    */
   APIRET APIENTRY  KbdFlushBuffer (HKBD Handle) ;
   APIRET APIENTRY  KbdPeek (KBDKEYINFO * CharData, HKBD Handle) ;
   APIRET APIENTRY  KbdCharIn (KBDKEYINFO * CharData, ULONG Wait, HKBD Handle) ;
   APIRET APIENTRY  KbdGetStatus (KBDINFO * Info, HKBD Handle) ;
   APIRET APIENTRY  KbdSetStatus (KBDINFO * Info, HKBD Handle) ;
   APIRET APIENTRY  KbdGetCp (ULONG Reserved, USHORT * CodePage, HKBD Handle) ;
   APIRET APIENTRY  KbdSetCp (ULONG Reserved, USHORT CodePage, HKBD Handle) ;

   APIRET APIENTRY  KbdGetConsole(PVOID Data, PULONG Kind, ULONG Flags, HKBD Handle) ;

   APIRET APIENTRY  KbdGetHWID (PKBDHWID pkbdhwid, HKBD Handle) ;

   APIRET APIENTRY  KbdGetLayout(PSZ name, HKBD Handle) ;

   APIRET APIENTRY  KbdGetLayoutUni(USHORT * name, HKBD Handle) ;

   APIRET APIENTRY  KbdSetLayout(PSZ name, HKBD Handle) ;

   APIRET APIENTRY  KbdSetLayoutUni(USHORT * name, HKBD Handle) ;

   APIRET APIENTRY  KbdSetRate (ULONG rate, ULONG delay, HKBD Handle) ;

   APIRET APIENTRY  KbdStringIn (PCH pch, PSTRINGINBUF pchIn, ULONG Flag, HKBD Handle) ;

   APIRET APIENTRY  KbdStringInUni (USHORT * pch, PSTRINGINBUF pchIn, ULONG Flag, HKBD Handle) ;

   APIRET APIENTRY  KbdXlate (PKBDKEYINFO pkbdtrans, HKBD Handle) ;

#ifdef __UNI_REPLACE__
    #define KbdGetLayout KbdGetLayoutUni
    #define KbdSetLayout KbdSetLayoutUni
    #define KbdStringIn  KbdStringInUni
#endif

#endif /* INCL_KBD */


/*
 *  Video Input Output (Vio) functions
 */
#ifdef INCL_VIO
    /*
     * Vio handles
     */
    typedef unsigned long   HVIO ;
    typedef HVIO        *   PHVIO ;

    /*
     * VioCreatePS format constants
     */
    #define FORMAT_CGA      0x0001
    #define FORMAT_VGA      0x0001
    #define FORMAT_4BYTE    0x0003
    #define FORMAT_EXTEND   0x0003
    #define FORMAT_UNICODE  0x0002

    /*
     * options for VioQueryFonts
     */
    #define VQF_PUBLIC      0x0001L
    #define VQF_PRIVATE     0x0002L
    #define VQF_ALL         0x0003L

    /*
     * Cursor structure for VioSetCurType and VioGetCurType()
     */
    typedef _Packed struct _VIOCURSORINFO {
        USHORT   yStart ;
        USHORT   cEnd ;
        USHORT   cx ;
        USHORT   attr ;
    } VIOCURSORINFO ;
    typedef VIOCURSORINFO * PVIOCURSORINFO ;

    /*
     * Mode structure for VioSetMode and VioGetMode
     * (field added for 32 bit alignment)
     */
    typedef _Packed struct _VIOMODEINFO     /* viomi */
            {
            USHORT cb ;            /* structure length */
            UCHAR  fbType ;        /* mode type */
            UCHAR  color ;         /* number of colors */
            USHORT col ;           /* number of columns */
            USHORT row ;           /* number of rows */
            USHORT hres ;          /* horizontal size in pels */
            USHORT vres ;          /* vertical size in pels */
            UCHAR  fmt_ID ;        /* format of attributes */
            UCHAR  attrib ;        /* length of attributes */
            USHORT resvd ;         /* Reserved   (added field) */
            ULONG  buf_addr ;
            ULONG  buf_length ;
            ULONG  full_length ;
            ULONG  partial_length ;
            PCH    ext_data_addr ;
            } VIOMODEINFO ;
    typedef VIOMODEINFO *PVIOMODEINFO ;


    /*
     * VIOMODEINFO.fbType constants
     */
    #define VGMT_OTHER            1
    #define VGMT_COLOR            1
    #define VGMT_GRAPHICS         2
    #define VGMT_DISABLEBURST     4
    #define VGMT_NOTBIOS          8

    /*
     * VIOMODEINFO.color constants
     */
    #define COLORS_2              1
    #define COLORS_4              2
    #define COLORS_16             4
    #define COLORS_256            8
    #define COLORS_64K           16
    #define COLORS_16M           24

    /*
     * Return types for VioCheckCharType
     */
    #define VCC_SBCSCHAR          0
    #define VCC_DBCSFULLCHAR      1
    #define VCC_DBCS1STHALF       2
    #define VCC_DBCS2NDHALF       3

    /*
     * Values for graphics mode screen synchronization
     */
    #define VSRWI_SAVEANDREDRAW   0
    #define VSRWI_REDRAW          1

    #define VSRWN_SAVE            0
    #define VSRWN_REDRAW          1

    #define UNDOI_GETOWNER        0
    #define UNDOI_RELEASEOWNER    1

    #define UNDOK_ERRORCODE       0
    #define UNDOK_TERMINATE       1

    #define LOCKIO_NOWAIT         0
    #define LOCKIO_WAIT           1

    #define LOCK_SUCCESS          0
    #define LOCK_FAIL             1

    /*
     * Values for VioSetAnsi and VioGetAnsi
     */
    #define ANSI_ON               1
    #define ANSI_OFF              0

    /*
     * Values for VioPopup
     */
    #define VMWR_POPUP            0
    #define VMWN_POPUP            0
    #define VP_NOWAIT             0
    #define VP_WAIT               1
    #define VP_OPAQUE             0
    #define VP_TRANSPARENT        2

    /*
     * VIOCONFIGINFO.adapter constants
     */
    #define DISPLAY_MONOCHROME    0
    #define DISPLAY_CGA           1
    #define DISPLAY_EGA           2
    #define DISPLAY_VGA           3
    #define DISPLAY_8514A         7
    #define DISPLAY_IAA           8
    #define DISPLAY_XGA           9
    #define DISPLAY_SVGA         10
    #define DISPLAY_NONVGA       12

    /*
     * VIOCONFIGINFO.display constants
     */
    #define MONITOR_MONOCHROME    0
    #define MONITOR_COLOR         1
    #define MONITOR_ENHANCED      2
    #define MONITOR_8503          3
    #define MONITOR_851X_COLOR    4
    #define MONITOR_8514          9
    #define MONITOR_FLATPANEL    10
    #define MONITOR_LCD640       10
    #define MONITOR_8507_8604    11
    #define MONITOR_8515         12
    #define MONITOR_9515         15
    #define MONITOR_9517         17
    #define MONITOR_9518         18
    #define MONITOR_OEM          19
    #define MONITOR_LCD800       21
    #define MONITOR_LCD1024      22

    /*
     * Configuration structure for VioGetConfig
     * (all fields changed to ULONG)
     */
    typedef _Packed struct _VIOCONFIGINFO {
        ULONG   cb ;              /* Size of data      */
        ULONG   adapter ;         /* Adapter type      */
        ULONG   display ;         /* Display type      */
        ULONG   cbMemory ;        /* Adapter memory    */
        ULONG   Configuration ;   /* Which config      */
        ULONG   Version ;         /* Driver version    */
        ULONG   Flags ;           /*                   */
        ULONG   HWBufferSize ;    /* State save size   */
        ULONG   FullSaveSize ;    /* Buffer save size  */
        ULONG   PartSaveSize ;    /* Partial save size */
        ULONG   VideoID ;         /* Adapter ID        */
        ULONG   VideoData ;       /* Adapter user data */
    } VIOCONFIGINFO ;
    typedef VIOCONFIGINFO * PVIOCONFIGINFO ;

    #define VIO_CONFIG_CURRENT    0
    #define VIO_CONFIG_PRIMARY    1
    #define VIO_CONFIG_SECONDARY  2

    /*
     *  Structures for VioSetState and VioGetState
     */
    typedef _Packed struct _VIOPALSTATE {
        USHORT  cb ;
        USHORT  type ;
        USHORT  iFirst ;
        USHORT  acolor[1] ;
    } VIOPALSTATE ;
    typedef VIOPALSTATE * PVIOPALSTATE ;

    typedef _Packed struct _VIOOVERSCAN {
        USHORT  cb ;
        USHORT  type ;
        USHORT  color ;
    } VIOOVERSCAN ;
    typedef VIOOVERSCAN * PVIOOVERSCAN ;

    typedef _Packed struct _VIOINTENSITY {
        USHORT  cb ;
        USHORT  type ;
        USHORT  fs ;
    } VIOINTENSITY ;
    typedef VIOINTENSITY * PVIOINTENSITY ;

    typedef _Packed struct _VIOCOLORREG {
        USHORT  cb ;
        USHORT  type ;
        USHORT  firstcolorreg ;
        USHORT  numcolorregs ;
        PCH     colorregaddr ;
    } VIOCOLORREG ;
    typedef VIOCOLORREG * PVIOCOLORREG ;

    typedef _Packed struct _VIOSETULINELOC {
        USHORT  cb ;
        USHORT  type ;
        USHORT  scanline ;
    } VIOSETULINELOC ;
    typedef VIOSETULINELOC * PVIOSETULINELOC ;

    typedef _Packed struct _VIOSETTARGET {
        USHORT  cb ;
        USHORT  type ;
        USHORT  defaultalgorithm ;
    } VIOSETTARGET ;
    typedef VIOSETTARGET * PVIOSETTARGET ;

    /*
     * Vio function prototypes
     */
    #define VioScrollDn VioScrollDown
    #define VioScrollLf VioScrollLeft
    #define VioScrollRt VioScrollRight
    #define VioWrtCharStrAtt VioWrtCharStrAttr
    APIRET APIENTRY VioGetAnsi          (ULONG * Ansi, HVIO Handle) ;
    APIRET APIENTRY VioGetCp            (ULONG Reserved, USHORT * IdCodePage, HVIO Handle) ;
    APIRET APIENTRY VioGetCurPos        (ULONG * Row, ULONG * Column, HVIO Handle) ;
    APIRET APIENTRY VioGetCurType       (VIOCURSORINFO * CursorInfo, HVIO Handle) ;
    APIRET APIENTRY VioGetMode          (VIOMODEINFO * ModeInfo, HVIO Handle) ;
    APIRET APIENTRY VioReadCellStr      (char * CellStr, ULONG * Count, ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioReadCharStr      (char * CellStr, ULONG * Count, ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioScrollDown       (ULONG TopRow, ULONG LeftCol, ULONG BotRow, ULONG RightCol, ULONG Lines, BYTE * Cell, HVIO Handle) ;
    APIRET APIENTRY VioScrollLeft       (ULONG TopRow, ULONG LeftCol, ULONG BotRow, ULONG RightCol, ULONG Columns, BYTE * Cell, HVIO Handle) ;
    APIRET APIENTRY VioScrollRight      (ULONG TopRow, ULONG LeftCol, ULONG BotRow, ULONG RightCol, ULONG Columns, BYTE * Cell, HVIO Handle) ;
    APIRET APIENTRY VioScrollUp         (ULONG TopRow, ULONG LeftCol, ULONG BotRow, ULONG RightCol, ULONG Lines, BYTE * Cell, HVIO Handle) ;
    APIRET APIENTRY VioSetAnsi          (ULONG Ansi, HVIO Handle) ;
    APIRET APIENTRY VioSetCp            (ULONG Reserved, USHORT IdCodePage, HVIO Handle) ;
    APIRET APIENTRY VioSetCurPos        (ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioSetCurType       (VIOCURSORINFO * CursorInfo, HVIO Handle) ;
    APIRET APIENTRY VioSetMode          (VIOMODEINFO * ModeInfo, HVIO hvio) ;
    APIRET APIENTRY VioWrtCellStr       (char * CellStr, ULONG Count, ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioWrtCharStr       (char * Str, ULONG Count, ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioWrtCharStrAttr   (char * Str, ULONG Count, ULONG Row, ULONG Column, PBYTE pAttr, HVIO Handle) ;
    APIRET APIENTRY VioWrtNAttr         (BYTE * Attr, ULONG Count, ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioWrtNCell         (BYTE * Cell, ULONG Count, ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioWrtNChar         (char * Char, ULONG Count, ULONG Row, ULONG Column, HVIO Handle) ;
    APIRET APIENTRY VioWrtTTY           (char * Str, ULONG Count, HVIO Handle) ;

    #define VioSavRedrawUndo VioSaveRedrawUndo
    #define VioSavRedrawWait VioSaveRedrawWait
    APIRET APIENTRY  VioModeUndo (ULONG OwnerInd, ULONG KillInd, ULONG Reserved) ;
    APIRET APIENTRY  VioModeWait (ULONG ReqType, ULONG * NotifyType, ULONG Reserved) ;
    APIRET APIENTRY  VioSaveRedrawUndo (ULONG OwnerInd, ULONG KillInd, ULONG Reserved) ;
    APIRET APIENTRY  VioSaveRedrawWait (ULONG RedrawInd, ULONG * NotifyType, ULONG Reserved) ;

    APIRET APIENTRY  VioEndPopUp (HVIO hvio) ;
    APIRET APIENTRY  VioPopUp (ULONG * Wait, HVIO hvio) ;
    APIRET APIENTRY  VioScrLock (ULONG fWait, UCHAR * NotLocked, HVIO hvio) ;
    APIRET APIENTRY  VioScrUnLock (HVIO hvio) ;

    #define VioGetOrg VioGetOrigin
    #define VioSetOrg VioSetOrigin
    APIRET APIENTRY  VioCreatePS(HVIO * VioPSHandle, ULONG Rows, ULONG Columns, ULONG Format, ULONG AttrBytes, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioDestroyPS(HVIO VioPSHandle) ;
    APIRET APIENTRY  VioShowPS(ULONG Depth, ULONG Width, ULONG Cell, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioQueryFonts(PULONG Remfonts, PFONTMETRICS Metrics, ULONG MetricsLength, PULONG Fonts, PSZ Facename, ULONG Options, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioQueryFontsUni(PULONG Remfonts, PFONTMETRICS Metrics, ULONG MetricsLength, PULONG Fonts, USHORT * Facename, ULONG Options, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioQuerySetIds(PULONG lcids, PSTR8 Names, PULONG Types, ULONG count, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioAssociate(ULONG hdc, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioCreateLogFont(PFATTRS pfat, ULONG lcid, PSTR8 pstr8Name, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioDeleteSetId(ULONG lcid, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioGetOrigin(ULONG * Row, ULONG * Column, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioSetOrigin(ULONG Row, ULONG Column, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioSetDeviceCellSize(ULONG Height, ULONG Width, HVIO VioPSHandle) ;
    APIRET APIENTRY  VioGetDeviceCellSize(ULONG * Height, ULONG * Width, HVIO VioPSHandle) ;

    APIRET APIENTRY  VioGetBuf (PULONG pLVB, PULONG pcbLVB, HVIO hvio) ;
    APIRET APIENTRY  VioShowBuf (ULONG offLVB, ULONG cb, HVIO hvio) ;

    APIRET APIENTRY  VioGetState (void * State, HVIO hvio) ;
    APIRET APIENTRY  VioSetState (void * State, HVIO hvio) ;

    APIRET APIENTRY  VioCharWidthUni(USHORT uch) ;

    APIRET APIENTRY  VioCheckCharType (ULONG * Type, ULONG Row, ULONG Column, HVIO hvio) ;

    APIRET APIENTRY  VioGetConfig (ULONG ConfigId, PVIOCONFIGINFO pvioin, HVIO hvio) ;

    APIRET APIENTRY  VioPrtSc (HVIO hvio) ;

    APIRET APIENTRY  VioPrtScToggle (HVIO hvio) ;

    APIRET APIENTRY  VioWrtTTYUni (USHORT * pch, ULONG cb, HVIO hvio) ;

#ifdef __UNI_REPLACE__
    #define VioWrtTTY     VioWrtTTYUni
    #define VioQueryFonts VioQueryFontsUni
#endif

#endif /* INCL_VIO */


/*
 * Mouse (Mou) functions
 *
 * Notes:
 *     The mouse handle is always required to be zero, as there is no longer
 *     an open an close.
 */
#ifdef INCL_MOU

    typedef unsigned long   HMOU ;
    typedef HMOU        *   PHMOU ;

    APIRET APIENTRY  MouFlushQue (HMOU hmou) ;

    #define MHK_BUTTON1                0x0001
    #define MHK_BUTTON2                0x0002
    #define MHK_BUTTON3                0x0004

    /*
     * Structure for MouGetPtrPos and MouSetPtrPos
     */
    typedef _Packed struct _PTRLOC {
        ULONG  row ;               /* was USHORT */
        ULONG  col ;               /* was USHORT */
    } PTRLOC ;
    typedef PTRLOC * PPTRLOC ;

    /*
     * structure for MouRemovePtr
     * (field lengths increased)
     */
    typedef _Packed struct _NOPTRRECT {
        ULONG  row ;
        ULONG  col ;
        ULONG  cRow ;
        ULONG  cCol ;
    } NOPTRRECT ;
    typedef NOPTRRECT * PNOPTRRECT ;

    typedef _Packed struct _THRESHOLD {   /* threshold */
        USHORT Length ;            /* Length Field            */
        USHORT Level1 ;            /* First movement level    */
        USHORT Lev1Mult ;          /* First level multiplier  */
        USHORT Level2 ;            /* Second movement level   */
        USHORT lev2Mult ;          /* Second level multiplier */
    } THRESHOLD ;
    typedef THRESHOLD * PTHRESHOLD ;

    /*
     * Pointer shape function for MouGetPtrShape and MouSetPtrShape
     */
    typedef _Packed struct _PTRSHAPE {
        USHORT cb ;                /* Structure length */
        USHORT col ;               /* Horizontal size */
        USHORT row ;               /* Vertical size */
        USHORT colHot ;            /* Horizontal hot spot */
        USHORT rowHot ;            /* Vertical hot spot */
    } PTRSHAPE ;
    typedef PTRSHAPE * PPTRSHAPE ;

    /*
     * Device status for MouGetDevStatus and MouSetDevStatus
     */
    #define MOUSE_QUEUEBUSY        0x0001
    #define MOUSE_BLOCKREAD        0x0002
    #define MOUSE_FLUSH            0x0004
    #define MOUSE_UNSUPPORTED_MODE 0x0008
    #define MOUSE_DISABLED         0x0100
    #define MOUSE_MICKEYS          0x0200

    /*
     * Wait constants for MouReadEventQue
     */
    #define MOU_NOWAIT                      0x0000
    #define MOU_WAIT                        0x0001

    /*
     * structure for MouReadEventQue()
     * (all fields lengthened)
     */
    typedef _Packed struct _MOUEVENTINFO {
        ULONG  fs ;                 /* Mouse state (MOUSE_ ) */
        LONG   row ;                /* Horizontal position */
        LONG   col ;                /* Vertical position */
        ULONG  time ;               /* Timestamp */
    } MOUEVENTINFO ;
    typedef MOUEVENTINFO *PMOUEVENTINFO ;

    /*
     * structure for MouGetNumQueEl()
     * (all fields lengthened)
     */
    typedef _Packed struct _MOUQUEINFO {
        ULONG  cEvents ;
        ULONG  cmaxEvents ;
    } MOUQUEINFO ;
    typedef MOUQUEINFO *PMOUQUEINFO ;

    /*
     * Event mask constants for MouGetEventMask and MouSetEventMask
     */
    #define MOUSE_MOTION                 0x0001
    #define MOUSE_MOTION_WITH_BN1_DOWN   0x0002
    #define MOUSE_BN1_DOWN               0x0004
    #define MOUSE_MOTION_WITH_BN2_DOWN   0x0008
    #define MOUSE_BN2_DOWN               0x0010
    #define MOUSE_MOTION_WITH_BN3_DOWN   0x0020
    #define MOUSE_BN3_DOWN               0x0040

    /*
     * Structure for MouGetScaleFact and MouSetScaleFact
     */
    typedef _Packed struct _SCALEFACT {
        ULONG  rowScale ;
        ULONG  colScale ;
    } SCALEFACT ;
    typedef SCALEFACT * PSCALEFACT ;

    /*
     * Status for MouSetDevStatus
     */
    #define MOU_NODRAW                 0x0001
    #define MOU_DRAW                   0x0000
    #define MOU_MICKEYS                0x0002
    #define MOU_PELS                   0x0000

    /*
     * Mou function prototypes
     */
    APIRET APIENTRY  MouGetNumButtons (ULONG * Buttons, HMOU Handle) ;

#define MouClose(x)  0  /* Mouse close is no longer needed */

    APIRET APIENTRY  MouDrawPtr (HMOU Handle) ;

    APIRET APIENTRY  MouFlushQue (HMOU Handle) ;

    APIRET APIENTRY  MouGetDevStatus (PULONG  DevStat, HMOU Handle) ;

    APIRET APIENTRY  MouGetEventMask (PULONG  EventMask, HMOU Handle) ;

    APIRET APIENTRY  MouGetNumMickeys (PULONG  Mickeys, HMOU Handle) ;

    APIRET APIENTRY  MouGetNumQueEl (PMOUQUEINFO QElements, HMOU Handle) ;

    APIRET APIENTRY  MouGetPtrPos (PPTRLOC PtrLoc, HMOU Handle) ;

    APIRET APIENTRY  MouGetPtrShape (PVOID PtrBuf, PPTRSHAPE PtrInfo, HMOU Handle) ;

    APIRET APIENTRY  MouGetScaleFact (PSCALEFACT MouScale, HMOU Handle) ;

#define MouOpen(x, y) (*(y)=0)

    APIRET APIENTRY  MouReadEventQue (PMOUEVENTINFO EventMask, PULONG Wait,
                                      HMOU Handle) ;

    APIRET APIENTRY  MouRemovePtr (PNOPTRRECT MouseRect, HMOU Handle) ;

    APIRET APIENTRY  MouSetDevStatus (PULONG  DevStat, HMOU Handle) ;

    APIRET APIENTRY  MouSetEventMask (PULONG  EventMask, HMOU Handle) ;

    APIRET APIENTRY  MouSetPtrPos (PPTRLOC PtrLoc, HMOU Handle) ;

    APIRET APIENTRY  MouSetPtrShape (PBYTE PtrBuf, PPTRSHAPE PtrInfo, HMOU Handle) ;

    APIRET APIENTRY  MouSetScaleFact (PSCALEFACT Scale, HMOU Handle) ;

#endif /* INCL_MOU */

#endif /* __BSESUB__ */

#ifdef __cplusplus
        }
#endif

#ifdef __IBMC__
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
      #pragma checkout( resume )
   #endif
   #pragma checkout( resume )
#else
   #ifdef __IBMCPP__
      #pragma info( none )
      #ifndef __CHKHDR__
         #pragma info( restore )
      #endif
      #pragma info( restore )
   #endif
#endif
/* INC */
