/*
 *	***********************************************************************
 *							32-bit Unicode Console API
 *	(c) Copyright 1991-2000 Jonathan de Boyne Pollard. All Rights reserved.
 *	***********************************************************************
 *
 * OS/2 base include for Console API.
 *
 */
#if defined(__IBMC__)
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
	  #pragma checkout( suspend )
   #endif
   #pragma checkout( resume )
#elif defined(__IBMCPP__)
   #pragma info( none )
   #ifndef __CHKHDR__
	  #pragma info( none )
   #endif
   #pragma info( restore )
#endif

#if defined(__BORLANDC__)
#	pragma option -a1
#elif defined(__IBMCPP__)
#	pragma pack(1)
#endif

//#if !defined(___STDDEF_H_INCLUDED)
//#include <_stddef.h>
//#endif

#if defined(INCL_CONSOLE)

//
//	Shift state flags
//
enum {
	CON_KBD_LEFT_SHIFT_PRESSED		= 0x00000001 ,
	CON_KBD_RIGHT_SHIFT_PRESSED 	= 0x00000002 ,
	CON_KBD_FAKE_SHIFT_PRESSED		= 0x00000004 ,
	CON_KBD_LEFT_CTRL_PRESSED		= 0x00000010 ,
	CON_KBD_RIGHT_CTRL_PRESSED		= 0x00000020 ,
	CON_KBD_FAKE_CTRL_PRESSED		= 0x00000040 ,
	CON_KBD_LEFT_ALT_PRESSED		= 0x00000100 ,
	CON_KBD_RIGHT_ALT_PRESSED		= 0x00000200 ,
	CON_KBD_LEFT_WIN_PRESSED		= 0x00001000 ,
	CON_KBD_RIGHT_WIN_PRESSED		= 0x00002000 ,

	CON_KBD_ANY_SHIFT_PRESSED		= 0x00000007 ,
	CON_KBD_ANY_CTRL_PRESSED		= 0x00000070 ,
	CON_KBD_ANY_ALT_PRESSED 		= 0x00000300 ,
	CON_KBD_ANY_WIN_PRESSED 		= 0x00003000 ,

	CON_KBD_SCROLL_LOCK_PRESSED 	= 0x00010000 ,
	CON_KBD_NUM_LOCK_PRESSED		= 0x00020000 ,
	CON_KBD_CAPS_LOCK_PRESSED		= 0x00040000 ,

	CON_KBD_SCROLL_LOCK_ON			= 0x01000000 ,
	CON_KBD_NUM_LOCK_ON 			= 0x02000000 ,
	CON_KBD_CAPS_LOCK_ON			= 0x04000000 ,
	CON_KBD_INSERT_MODE_ON			= 0x08000000 ,
} ;

//
//	Flags for keyboard events
//
enum {
	CON_KBD_EVENT_IS_RELEASE		= 0x0001 ,
	CON_KBD_EVENT_HAS_VKEY			= 0x0002 ,
	CON_KBD_EVENT_HAS_CHAR			= 0x0008 ,
	CON_KBD_EVENT_HAS_SCAN			= 0x0004 ,
} ;

//
//	Keyboard virtual key numbers
//
enum {
	CON_KBD_KEY_SYSRQ			= 1 ,
	CON_KBD_KEY_PAUSE ,
	CON_KBD_KEY_BREAK			= 3 ,
	CON_KBD_KEY_PRINTSCREEN ,
	CON_KBD_KEY_CAPSLOCK ,
	CON_KBD_KEY_NUMLOCK ,
	CON_KBD_KEY_SCRLLOCK ,
	CON_KBD_KEY_BACKSPACE		= '\b' ,
	CON_KBD_KEY_TAB 			= '\t' ,
	CON_KBD_KEY_ENTER ,
	CON_KBD_KEY_RETURN			= '\r' ,
	CON_KBD_KEY_BACKTAB ,
	CON_KBD_KEY_CLEAR ,
	CON_KBD_KEY_HOME ,
	CON_KBD_KEY_END ,
	CON_KBD_KEY_LEFT ,
	CON_KBD_KEY_RIGHT ,
	CON_KBD_KEY_DOWN ,
	CON_KBD_KEY_UP ,
	CON_KBD_KEY_PAGEDOWN ,
	CON_KBD_KEY_PAGEUP ,
	CON_KBD_KEY_INSERT ,
	CON_KBD_KEY_DELETE ,
	CON_KBD_KEY_MENU ,
	CON_KBD_KEY_ESC 			= 27 ,
	CON_KBD_KEY_ALT ,
	CON_KBD_KEY_CTRL ,
	CON_KBD_KEY_SHIFT ,

	CON_KBD_KEY_SPACE			= ' ' ,
	CON_KBD_KEY_ASTERISK		= '*' ,
	CON_KBD_KEY_PLUS			= '+' ,
	CON_KBD_KEY_MINUS			= '-' ,
	CON_KBD_KEY_DECIMAL 		= '.' ,
	CON_KBD_KEY_DIVIDE			= '/' ,

	CON_KBD_KEY_0				= '0' ,
	CON_KBD_KEY_1 ,
	CON_KBD_KEY_2 ,
	CON_KBD_KEY_3 ,
	CON_KBD_KEY_4 ,
	CON_KBD_KEY_5 ,
	CON_KBD_KEY_6 ,
	CON_KBD_KEY_7 ,
	CON_KBD_KEY_8 ,
	CON_KBD_KEY_9 ,
	CON_KBD_KEY_PUNCT_COLON 	= ':' , // [ ;: ]
	CON_KBD_KEY_PUNCT_LESS		= '<' , // [ ;< ]
	CON_KBD_KEY_PUNCT_EQUALS	= '=' , // [ =+ ]
	CON_KBD_KEY_PUNCT_GREATER	= '>' , // [ .> ]
	CON_KBD_KEY_PUNCT_QUERY 	= '?' , // [ /? ]

	CON_KBD_KEY_PUNCT_AT			= '@' , 	// [ '@ ]
	CON_KBD_KEY_A					= 'A' ,
	CON_KBD_KEY_B ,
	CON_KBD_KEY_C ,
	CON_KBD_KEY_D ,
	CON_KBD_KEY_E ,
	CON_KBD_KEY_F ,
	CON_KBD_KEY_G ,
	CON_KBD_KEY_H ,
	CON_KBD_KEY_I ,
	CON_KBD_KEY_J ,
	CON_KBD_KEY_K ,
	CON_KBD_KEY_L ,
	CON_KBD_KEY_M ,
	CON_KBD_KEY_N ,
	CON_KBD_KEY_O ,
	CON_KBD_KEY_P ,
	CON_KBD_KEY_Q ,
	CON_KBD_KEY_R ,
	CON_KBD_KEY_S ,
	CON_KBD_KEY_T ,
	CON_KBD_KEY_U ,
	CON_KBD_KEY_V ,
	CON_KBD_KEY_W ,
	CON_KBD_KEY_X ,
	CON_KBD_KEY_Y ,
	CON_KBD_KEY_Z ,
	CON_KBD_KEY_PUNCT_LBRACKET		= '[' , 	// [ [{ ]
	CON_KBD_KEY_PUNCT_VBAR			= '|' , 	// [ `| ]
	CON_KBD_KEY_PUNCT_RBRACKET		= ']' , 	// [ }] ]
	CON_KBD_KEY_PUNCT_BACKSLASH 	= '\\' ,	// [ \ ]
	CON_KBD_KEY_PUNCT_TILDE 		= '~' , 	// [ #~ ]
	CON_KBD_KEY_PUNCT_UNDERSCORE	= '_' , 	// [ -_ ]

	CON_KBD_KEY_NUMPAD_0 = 96 ,
	CON_KBD_KEY_NUMPAD_1 ,
	CON_KBD_KEY_NUMPAD_2 ,
	CON_KBD_KEY_NUMPAD_3 ,
	CON_KBD_KEY_NUMPAD_4 ,
	CON_KBD_KEY_NUMPAD_5 ,
	CON_KBD_KEY_NUMPAD_6 ,
	CON_KBD_KEY_NUMPAD_7 ,
	CON_KBD_KEY_NUMPAD_8 ,
	CON_KBD_KEY_NUMPAD_9 ,

	CON_KBD_KEY_WINDOW1 = 112 ,
	CON_KBD_KEY_WINDOW2 ,

	CON_KBD_KEY_F1 = 128 ,
	CON_KBD_KEY_F2 ,
	CON_KBD_KEY_F3 ,
	CON_KBD_KEY_F4 ,
	CON_KBD_KEY_F5 ,
	CON_KBD_KEY_F6 ,
	CON_KBD_KEY_F7 ,
	CON_KBD_KEY_F8 ,
	CON_KBD_KEY_F9 ,
	CON_KBD_KEY_F10 ,
	CON_KBD_KEY_F11 ,
	CON_KBD_KEY_F12 ,
	CON_KBD_KEY_F13 ,
	CON_KBD_KEY_F14 ,
	CON_KBD_KEY_F15 ,
	CON_KBD_KEY_F16 ,
	CON_KBD_KEY_F17 ,
	CON_KBD_KEY_F18 ,
	CON_KBD_KEY_F19 ,
	CON_KBD_KEY_F20 ,
	CON_KBD_KEY_F21 ,
	CON_KBD_KEY_F22 ,
	CON_KBD_KEY_F23 ,
	CON_KBD_KEY_F24 ,
	CON_KBD_KEY_F25 ,
	CON_KBD_KEY_F26 ,
	CON_KBD_KEY_F27 ,
	CON_KBD_KEY_F28 ,
	CON_KBD_KEY_F29 ,
	CON_KBD_KEY_F30 ,
	CON_KBD_KEY_F31 ,
	CON_KBD_KEY_F32 ,
	CON_KBD_KEY_F33 ,
	CON_KBD_KEY_F34 ,
	CON_KBD_KEY_F35 ,
	CON_KBD_KEY_F36 ,
	CON_KBD_KEY_F37 ,
	CON_KBD_KEY_F38 ,
	CON_KBD_KEY_F39 ,
	CON_KBD_KEY_F40 ,
	CON_KBD_KEY_F41 ,
	CON_KBD_KEY_F42 ,
	CON_KBD_KEY_F43 ,
	CON_KBD_KEY_F44 ,
	CON_KBD_KEY_F45 ,
	CON_KBD_KEY_F46 ,
	CON_KBD_KEY_F47 ,
	CON_KBD_KEY_F48 ,
} ;

//
//	Console mode flags
//
enum {
	CON_DISABLE_ANSI_CSI_SEQUENCES	= 0x0001 ,
	CON_DISABLE_ANSI_CONTROL_CHARS	= 0x0002 ,
	CON_DISABLE_WRAP_AT_EOL 		= 0x0004 ,
	CON_ENABLE_UTF8_OUTPUT			= 0x0008 ,
	CON_DISABLE_EDITING_KEYS		= 0x0010 ,
	CON_DISABLE_LINE_INPUT			= 0x0020 ,
	CON_DISABLE_LINE_INPUT_ECHO 	= 0x0040 ,
	CON_ENABLE_PASSWORD_MODE		= 0x0080 ,
	CON_ENABLE_UTF8_INPUT			= 0x0100 ,
	CON_ENABLE_SHIFT_EVENTS 		= 0x1000 ,
	CON_ENABLE_MOUSE_EVENTS 		= 0x2000 ,
	CON_ENABLE_SIZE_EVENTS			= 0x4000 ,
} ;

typedef unsigned short CONSOLE_UNICHAR ;			// UCS-2 character

#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
_Packed
#endif
struct CONSOLE_INPUT_EVENT {
	enum { NONE, KEY, MOUSE, WINDOW_SIZE, MENU, FOCUS } ;
	USHORT Type ;
#if defined(__HIGHC__) || defined(__WATCOMC__)
	unsigned long long TimeStamp ;
#else
	unsigned long TimeStampLo, TimeStampHi ;
#endif

	union {
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			ULONG Flags ;
			USHORT RepeatCount ;
			USHORT VirtualKeyCode ;
			USHORT ScanCode ;
			CONSOLE_UNICHAR Character ;
			ULONG ShiftState ;
		} KeyEvent ;
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			size_t Row, Column ;
			ULONG ButtonState ;
			ULONG ShiftState ;
			enum { CLICK, DOUBLE_CLICK, MOTION } ;
			ULONG EventType ;
		} MouseEvent ;
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			size_t Width, Height ;
		} OutputBufferSizeEvent ;
#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
		_Packed
#endif
		struct {
			char reserved[32] ;
		} NullEvent ;
	} ;
} ;

#if !defined(__BORLANDC__) && !defined(__IBMCPP__)
_Packed
#endif
struct CONSOLE_CELL {
	CONSOLE_UNICHAR Char ;
	unsigned char Attr ;

	CONSOLE_CELL () {}
	CONSOLE_CELL ( CONSOLE_UNICHAR c, unsigned char a ) : Char(c), Attr(a) {}
} ;

enum {
	CON_ATTR_BLACK,
	CON_ATTR_BLUE,
	CON_ATTR_GREEN,
	CON_ATTR_CYAN,
	CON_ATTR_RED,
	CON_ATTR_MAGENTA,
	CON_ATTR_YELLOW,
	CON_ATTR_WHITE,
	CON_ATTR_BRIGHT,
} ;

extern inline
unsigned char
CONSOLE_MAKE_ATTR ( unsigned char brfg, unsigned char fg, unsigned char brbg, unsigned char bg )
{
	return (((brbg & CON_ATTR_BRIGHT) | (bg & 7)) << 4) | (brfg & CON_ATTR_BRIGHT) | (fg & 7) ;
}

extern "C" {

APIRET APIENTRY DosWriteConsoleOutputCellStr		( HFILE Handle, const CONSOLE_CELL * PtrCellStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputCharStr		( HFILE Handle, const CONSOLE_UNICHAR * PtrCharStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputAttrStr		( HFILE Handle, const unsigned char * PtrAttrStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputCharStrAttr	( HFILE Handle, const CONSOLE_UNICHAR * PtrCharStr, size_t Cells, size_t Row, size_t Col, unsigned char Attr ) ;
APIRET APIENTRY DosWriteConsoleOutputNAttr			( HFILE Handle, unsigned char Attr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputNCell			( HFILE Handle, const CONSOLE_CELL & Cell, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosWriteConsoleOutputNChar			( HFILE Handle, CONSOLE_UNICHAR Char, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosReadConsoleOutputCellStr 		( HFILE Handle, CONSOLE_CELL * PtrCellStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosReadConsoleOutputCharStr 		( HFILE Handle, CONSOLE_UNICHAR * PtrCharStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosReadConsoleOutputAttrStr 		( HFILE Handle, unsigned char * PtrAttrStr, size_t Cells, size_t Row, size_t Col ) ;
APIRET APIENTRY DosScrollConsoleUp					( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosScrollConsoleDown				( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosScrollConsoleLeft				( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosScrollConsoleRight				( HFILE Handle, size_t Top, size_t Left, size_t Height, size_t Width, size_t Delta, const CONSOLE_CELL & Space ) ;
APIRET APIENTRY DosSetConsoleCursorPos				( HFILE Handle, size_t Row, size_t Col ) ;
APIRET APIENTRY DosQueryConsoleCursorPos			( HFILE Handle, size_t & Row, size_t & Col ) ;
APIRET APIENTRY DosSetConsoleCursorSize 			( HFILE Handle, unsigned int PercentStart, unsigned int PercentEnd, BOOL Visible ) ;
APIRET APIENTRY DosQueryConsoleCursorSize			( HFILE Handle, unsigned int & PercentStart, unsigned int & PercentEnd, BOOL & Visible ) ;
APIRET APIENTRY DosSetConsoleShiftState 			( HFILE Handle, ULONG ShiftState ) ;
APIRET APIENTRY DosQueryConsoleShiftState			( HFILE Handle, ULONG & ShiftState ) ;
APIRET APIENTRY DosSetConsoleSize					( HFILE Handle, size_t Rows, size_t Cols ) ;
APIRET APIENTRY DosQueryConsoleSize 				( HFILE Handle, size_t & Rows, size_t & Cols ) ;
APIRET APIENTRY DosQueryMaximumConsoleSize			( HFILE Handle, size_t & Rows, size_t & Cols ) ;
//APIRET APIENTRY DosSetConsoleWindowSize			( HFILE Handle, size_t Rows, size_t Cols ) ;
//APIRET APIENTRY DosQueryConsoleWindowSize 		( HFILE Handle, size_t & Rows, size_t & Cols ) ;
//APIRET APIENTRY DosQueryMaximumConsoleWindowSize	( HFILE Handle, size_t & Rows, size_t & Cols ) ;
APIRET APIENTRY DosSetConsoleMode					( HFILE Handle, ULONG Flags ) ;
APIRET APIENTRY DosQueryConsoleMode 				( HFILE Handle, ULONG & Flags ) ;
APIRET APIENTRY DosSetConsoleOutputAttr 			( HFILE Handle, unsigned char OutputAttr, unsigned char ScrollAttr ) ;
APIRET APIENTRY DosSetConsoleOutputFocus			( HFILE Handle ) ;
APIRET APIENTRY DosSetConsoleInputFocus 			( HFILE Handle ) ;
APIRET APIENTRY DosSetConsoleOutputCodePage 		( HFILE Handle, unsigned int CodePage ) ;
APIRET APIENTRY DosQueryConsoleOutputCodePage		( HFILE Handle, unsigned int & CodePage ) ;
APIRET APIENTRY DosSetConsoleInputCodePage			( HFILE Handle, unsigned int CodePage ) ;
APIRET APIENTRY DosQueryConsoleInputCodePage		( HFILE Handle, unsigned int & CodePage ) ;
APIRET APIENTRY DosReadConsoleInputEvent			( HFILE Handle, CONSOLE_INPUT_EVENT * Events, size_t MaxEvents, size_t & NumEvents, BOOL remove ) ;
//APIRET APIENTRY DosWriteConsoleInputEvent 			( HFILE Handle, CONSOLE_INPUT_EVENT * Events, size_t MaxEvents, size_t & NumEvents ) ;
//APIRET APIENTRY DosQueryConsoleInputEventCount		( HFILE Handle, size_t & NumEvents ) ;
APIRET APIENTRY DosFlushConsoleInputEvents			( HFILE Handle ) ;
APIRET APIENTRY DosQueryConsoleNumberOfMouseButtons ( HFILE Handle, size_t & Buttons ) ;
//APIRET APIENTRY DosSetConsoleTitle					( HFILE Handle, const CONSOLE_UNICHAR * PtrTitleStr ) ;
//APIRET APIENTRY DosQueryConsoleTitle					( HFILE Handle, CONSOLE_UNICHAR * PtrTitleStr, size_t BufLen, size_t & Length ) ;

}

#endif /* INCL_CONSOLE */

#if defined(__BORLANDC__)
#	pragma option -a.
#elif defined(__IBMCPP__)
#	pragma pack()
#endif

#if defined(__IBMC__)
   #pragma checkout( suspend )
   #ifndef __CHKHDR__
	  #pragma checkout( resume )
   #endif
   #pragma checkout( resume )
#elif defined(__IBMCPP__)
   #pragma info( none )
   #ifndef __CHKHDR__
	  #pragma info( restore )
   #endif
   #pragma info( restore )
#endif
