/*static char *SCCSID = "@(#)stdlib.h	6.1 90/11/16";*/
/***
*stdlib.h - declarations/definitions for commonly used library functions
*
*	Copyright (c) 1985-1990, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	This include file contains the function declarations for
*	commonly used library functions which either don't fit somewhere
*	else, or, like toupper/tolower, can't be declared in the normal
*	place for other reasons.
*	[ANSI]
*
****/

#ifndef	CALLTYPE
#define	CALLTYPE	_cdecl
#endif	/* CALLTYPE */


#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif


/* define NULL pointer value */

#define NULL	0


/* definition of the return type for the onexit() function */

#define EXIT_SUCCESS	0
#define EXIT_FAILURE	1


#ifndef _ONEXIT_T_DEFINED
typedef int (CALLTYPE * CALLTYPE onexit_t)();
#define _ONEXIT_T_DEFINED
#endif


/* Data structure definitions for div and ldiv runtimes. */

#ifndef _DIV_T_DEFINED

typedef struct _div_t {
	int quot;
	int rem;
} div_t;

typedef struct _ldiv_t {
	long quot;
	long rem;
} ldiv_t;

#define _DIV_T_DEFINED
#endif

/* Maximum value that can be returned by the rand function. */

#define RAND_MAX 0x7fff


/* min and max macros */

#define max(a,b)	(((a) > (b)) ? (a) : (b))
#define min(a,b)	(((a) < (b)) ? (a) : (b))


/* sizes for buffers used by the _makepath() and _splitpath() functions.
 * note that the sizes include space for 0-terminator
 */

#define _MAX_PATH	260	/* max. length of full pathname */
#define _MAX_DRIVE	3	/* max. length of drive component */
#define _MAX_DIR	256	/* max. length of path component */
#define _MAX_FNAME	256	/* max. length of file name component */
#define _MAX_EXT	256	/* max. length of extension component */

/* external variable declarations */

#ifdef	_MT
extern unsigned * CALLTYPE _errno(void);
extern unsigned * CALLTYPE __doserrno(void);
#define errno	    (*_errno())
#define _doserrno   (*__doserrno())
#else
extern int CALLTYPE errno;		/* XENIX style error number */
extern int CALLTYPE _doserrno;		/* MS-DOS system error value */
#endif
extern char * CALLTYPE sys_errlist[];	/* perror error message table */
extern int CALLTYPE sys_nerr;		/* # of entries in sys_errlist table */

extern char ** CALLTYPE environ;		/* pointer to environment table */
extern int CALLTYPE _fmode;		/* default file translation mode */
extern int CALLTYPE _fileinfo;		/* open file info mode (for spawn) */

extern unsigned int CALLTYPE _psp;	/* Program Segment Prefix */


/* DOS major/minor version numbers */

extern unsigned int CALLTYPE _osmajor;
extern unsigned int CALLTYPE _osminor;

#define DOS_MODE	0	/* Real Address Mode */
#define OS2_MODE	1	/* Protected Address Mode */

extern unsigned char CALLTYPE _osmode;


/* function prototypes */

void   CALLTYPE abort(void);
int    _stdcall abs(int);
int    CALLTYPE atexit(void (CALLTYPE *)(void));
double CALLTYPE atof(const char *);
int    CALLTYPE atoi(const char *);
long   CALLTYPE atol(const char *);
void * CALLTYPE bsearch(const void *, const void *, size_t, size_t,
	int (CALLTYPE *)(const void *, const void *));
void * CALLTYPE calloc(size_t, size_t);
div_t  CALLTYPE div(int, int);
char * CALLTYPE ecvt(double, int, int *, int *);
void   CALLTYPE exit(int);
void   CALLTYPE _exit(int);
char * CALLTYPE fcvt(double, int, int *, int *);
void   CALLTYPE free(void *);
char * CALLTYPE  _fullpath(char *, const char *, size_t);
char * CALLTYPE gcvt(double, int, char *);
char * CALLTYPE getenv(const char *);
char * CALLTYPE itoa(int, char *, int);
long   _stdcall labs(long);
ldiv_t CALLTYPE ldiv(long, long);
unsigned long _stdcall _lrotl(unsigned long, int);
unsigned long _stdcall _lrotr(unsigned long, int);
char * CALLTYPE ltoa(long, char *, int);
void   CALLTYPE _makepath(char *, const char *, const char *, const char *,
	const char *);
void * CALLTYPE malloc(size_t);
onexit_t CALLTYPE onexit(onexit_t);
void   CALLTYPE perror(const char *);
int    CALLTYPE putenv(const char *);
void   CALLTYPE qsort(void *, size_t, size_t, int (CALLTYPE *)(const void *,
	const void *));
unsigned int _stdcall _rotl(unsigned int, int);
unsigned int _stdcall _rotr(unsigned int, int);
int    CALLTYPE rand(void);
void * CALLTYPE realloc(void *, size_t);
void   CALLTYPE _searchenv(const char *, const char *, char *);
void   CALLTYPE _splitpath(const char *, char *, char *, char *, char *);
void   CALLTYPE srand(unsigned int);
double CALLTYPE strtod(const char *, char **);
long   CALLTYPE strtol(const char *, char **, int);
unsigned long CALLTYPE strtoul(const char *, char **, int);
void   CALLTYPE swab(char *, char *, int);
int    CALLTYPE system(const char *);
char * CALLTYPE ultoa(unsigned long, char *, int);

#ifndef tolower 	/* tolower has been undefined - use function */
int CALLTYPE tolower(int);
#endif	/* tolower */

#ifndef toupper 	/* toupper has been undefined - use function */
int    CALLTYPE toupper(int);
#endif	/* toupper */
