/*static char *SCCSID = "@(#)stdio.h	6.1 90/11/16";*/
/***
*stdio.h - definitions/declarations for standard I/O routines
*
*	Copyright (c) 1985-1990, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the structures, values, macros, and functions
*	used by the level 2 I/O ("standard I/O") routines.
*	[ANSI/System V]
*
****/

#ifndef	CALLTYPE
#define	CALLTYPE	_cdecl
#endif	/* CALLTYPE */


/* ensure proper alignment of struct fields */

#pragma pack(4)


#ifndef _SIZE_T_DEFINED
typedef unsigned int size_t;
#define _SIZE_T_DEFINED
#endif

#ifndef _VA_LIST_DEFINED
typedef char *va_list;
#define _VA_LIST_DEFINED
#endif


/* buffered I/O macros */

#define BUFSIZ	512
#ifdef	_MT
#define _NFILE	40
#else
#define _NFILE	20
#endif
#define EOF	(-1)

#ifndef _FILE_DEFINED
struct _iobuf {
	char *_ptr;
	int   _cnt;
	char *_base;
	char  _flag;
	char  _file;
	};
typedef struct _iobuf FILE;
#define _FILE_DEFINED
#endif

/* P_tmpnam: Directory where temporary files may be created.
 * L_tmpnam size =  size of P_tmpdir
 *	+ 1 (in case P_tmpdir does not end in "\\")
 *	+ 6 (for the temp number string)
 *	+ 1 (for the null terminator)
 */

#define P_tmpdir "\\"
#define L_tmpnam sizeof(P_tmpdir)+8

#define SEEK_CUR 1
#define SEEK_END 2
#define SEEK_SET 0

#define FILENAME_MAX 63
#define FOPEN_MAX 20
#define SYS_OPEN 20
#define TMP_MAX 32767


/* define NULL pointer value */

#define NULL	0


/* declare _iob[] array */

#ifndef _STDIO_DEFINED
extern FILE CALLTYPE _iob[];
#endif


/* define file position type */

#ifndef _FPOS_T_DEFINED
typedef long fpos_t;
#define _FPOS_T_DEFINED
#endif


#define stdin  (&_iob[0])
#define stdout (&_iob[1])
#define stderr (&_iob[2])
#define stdaux (&_iob[3])
#define stdprn (&_iob[4])

#define _IOREAD 	0x01
#define _IOWRT		0x02

#define _IOFBF		0x0
#define _IOLBF		0x40
#define _IONBF		0x04

#define _IOMYBUF	0x08
#define _IOEOF		0x10
#define _IOERR		0x20
#define _IOSTRG 	0x40
#define _IORW		0x80


/* function prototypes */

#ifndef _STDIO_DEFINED
int CALLTYPE _filbuf(FILE *);
int CALLTYPE _flsbuf(int, FILE *);
FILE * CALLTYPE _fsopen(const char *, const char *, int);
void CALLTYPE clearerr(FILE *);
int CALLTYPE fclose(FILE *);
int CALLTYPE fcloseall(void);
FILE * CALLTYPE fdopen(int, const char *);
int CALLTYPE feof(FILE *);
int CALLTYPE ferror(FILE *);
int CALLTYPE fflush(FILE *);
int CALLTYPE fgetc(FILE *);
int CALLTYPE fgetchar(void);
int CALLTYPE fgetpos(FILE *, fpos_t *);
char * CALLTYPE fgets(char *, int, FILE *);
int CALLTYPE fileno(FILE *);
int CALLTYPE flushall(void);
FILE * CALLTYPE fopen(const char *, const char *);
int CALLTYPE fprintf(FILE *, const char *, ...);
int CALLTYPE fputc(int, FILE *);
int CALLTYPE fputchar(int);
int CALLTYPE fputs(const char *, FILE *);
size_t CALLTYPE fread(void *, size_t, size_t, FILE *);
FILE * CALLTYPE freopen(const char *, const char *, FILE *);
int CALLTYPE fscanf(FILE *, const char *, ...);
int CALLTYPE fsetpos(FILE *, const fpos_t *);
int CALLTYPE fseek(FILE *, long, int);
long CALLTYPE ftell(FILE *);
size_t CALLTYPE fwrite(const void *, size_t, size_t, FILE *);
int CALLTYPE getc(FILE *);
int CALLTYPE getchar(void);
char * CALLTYPE gets(char *);
int CALLTYPE getw(FILE *);
void CALLTYPE perror(const char *);
int CALLTYPE _pclose(FILE *);
FILE * CALLTYPE _popen(const char *, const char *);
int CALLTYPE printf(const char *, ...);
int CALLTYPE putc(int, FILE *);
int CALLTYPE putchar(int);
int CALLTYPE puts(const char *);
int CALLTYPE putw(int, FILE *);
int CALLTYPE remove(const char *);
int CALLTYPE rename(const char *, const char *);
void CALLTYPE rewind(FILE *);
int CALLTYPE rmtmp(void);
int CALLTYPE scanf(const char *, ...);
void CALLTYPE setbuf(FILE *, char *);
int CALLTYPE setvbuf(FILE *, char *, int, size_t);
int CALLTYPE sprintf(char *, const char *, ...);
int CALLTYPE sscanf(const char *, const char *, ...);
char * CALLTYPE tempnam(char *, char *);
FILE * CALLTYPE tmpfile(void);
char * CALLTYPE tmpnam(char *);
int CALLTYPE ungetc(int, FILE *);
int CALLTYPE unlink(const char *);
int CALLTYPE vfprintf(FILE *, const char *, va_list);
int CALLTYPE vprintf(const char *, va_list);
int CALLTYPE vsprintf(char *, const char *, va_list);
#define _STDIO_DEFINED
#endif


/* macro definitions */

#define feof(_stream)	  ((_stream)->_flag & _IOEOF)
#define ferror(_stream)   ((_stream)->_flag & _IOERR)
#define fileno(_stream)   ((int)(unsigned char)(_stream)->_file)
#define getc(_stream)	  (--(_stream)->_cnt >= 0 ? 0xff & *(_stream)->_ptr++ \
	: _filbuf(_stream))
#define putc(_c,_stream)  (--(_stream)->_cnt >= 0 \
	? 0xff & (*(_stream)->_ptr++ = (char)(_c)) :  _flsbuf((_c),(_stream)))
#define getchar()	  getc(stdin)
#define putchar(_c)	  putc((_c),stdout)

#ifdef _MT
#undef	getc
#undef	putc
#undef	getchar
#undef	putchar
#endif


/* restore default alignment */

#pragma pack()
