/*static char *SCCSID = "@(#)process.h	6.1 90/11/16";*/
/***
*process.h - definition and declarations for process control functions
*
*	Copyright (c) 1985-1990, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	This file defines the modeflag values for spawnxx calls.
*	Only P_WAIT and P_OVERLAY are currently implemented on MS-DOS.
*	Also contains the function argument declarations for all
*	process control related routines.
*
****/

#ifndef	CALLTYPE
#define	CALLTYPE	_cdecl
#endif	/* CALLTYPE */


/* modeflag values for spawnxx routines */

#ifndef _MT
extern int CALLTYPE _p_overlay;
#endif

#define P_WAIT		0
#define P_NOWAIT	1
#ifdef	_MT
#define P_OVERLAY	2
#else
#define P_OVERLAY	_p_overlay
#endif
#define OLD_P_OVERLAY	2
#define P_NOWAITO	3
#define P_DETACH	4


/* Action Codes used with Cwait() */

#define WAIT_CHILD 0
#define WAIT_GRANDCHILD 1


/* function prototypes */

#ifdef _MT
int CALLTYPE _beginthread (void (CALLTYPE *) (void *), unsigned, void *);
void CALLTYPE _endthread(void);
#endif
void CALLTYPE abort(void);
void CALLTYPE _cexit(void);
void CALLTYPE _c_exit(void);
int CALLTYPE cwait(int *, int, int);
int CALLTYPE execl(const char *, const char *, ...);
int CALLTYPE execle(const char *, const char *, ...);
int CALLTYPE execlp(const char *, const char *, ...);
int CALLTYPE execlpe(const char *, const char *, ...);
int CALLTYPE execv(const char *, const char * const *);
int CALLTYPE execve(const char *, const char * const *, const char * const *);
int CALLTYPE execvp(const char *, const char * const *);
int CALLTYPE execvpe(const char *, const char * const *, const char * const *);
void CALLTYPE exit(int);
void CALLTYPE _exit(int);
int CALLTYPE getpid(void);
int CALLTYPE spawnl(int, const char *, const char *, ...);
int CALLTYPE spawnle(int, const char *, const char *, ...);
int CALLTYPE spawnlp(int, const char *, const char *, ...);
int CALLTYPE spawnlpe(int, const char *, const char *, ...);
int CALLTYPE spawnv(int, const char *, const char * const *);
int CALLTYPE spawnve(int, const char *, const char * const *,
	const char * const *);
int CALLTYPE spawnvp(int, const char *, const char * const *);
int CALLTYPE spawnvpe(int, const char *, const char * const *,
	const char * const *);
int CALLTYPE system(const char *);
int CALLTYPE wait(int *);
