/*static char *SCCSID = "@(#)excpt.h	6.2 91/07/11";*/
//
// The following is a subtly different defintion than that in the LRT
// file EXCEPT.H in that it uses the OS/2 typedefs.
//

/*
 * structure used by SEH support function and intrinsics. the information
 * passed by the exception dispatcher is repackaged in this form by the
 * runtime (_except_handler()).
 */

#ifdef INCL_DOSEXCEPTIONS

typedef struct _EXCEPTION_INFO_PTRS {
   PEXCEPTIONREPORTRECORD preport;
   PCONTEXTRECORD pcontext;
} EXCEPTION_INFO_PTRS;

typedef struct _EXCEPTION_INFO_PTRS * PEXCEPTION_INFO_PTRS;

#else

typedef struct _EXCEPTION_INFO_PTRS {
   void *preport;
   void *pcontext;
} EXCEPTION_INFO_PTRS;

typedef struct _EXCEPTION_INFO_PTRS * PEXCEPTION_INFO_PTRS;

#endif

//
// The return from the exception filter is a tri-state value
//    > 0       Jump to except body (UNWIND)
//    = 0       Try enclosing try-except (XCPT_CONTINUE_SEARCH)
//    < 0       Ignore exception (XCPT_CONTINUE_EXECUTION)
//

#define FILTER_EXECUTE_EXCEPT           1       // Goto except body
#define FILTER_CONTINUE_SEARCH          0       // Try enclosing try-except
#define FILTER_IGNORE_EXCEPTION   (-1)  // Resume execution

// defs of keywords and intrinsic function names

#define try                         _try
#define except                      _except
#define finally                     _finally
#define exception_code              _exception_code
#define exception_info              (PEXCEPTION_INFO_PTRS)_exception_info
#define abnormal_termination        _abnormal_termination

