/*static char *SCCSID = "@(#)except.h	6.2 91/03/29";*/
/***
*except.h - defines exception values, types and routines
*
*       Copyright (c) 1990, Microsoft Corporation. All rights reserved.
*
*Purpose:
*       This file defines the exception values, types and declares the
*       associated functions.
*
*Revision History:
*       05-09-90  GJF   Module created, based on text of Cruiser DCR 1024
*       06-01-90  GJF   Added (int) cast to exception code definitions (note
*                       that _exception_code() is of return type int).
*       06-11-90  GJF   Changed to more closely conform with bsexcept.h (taken
*                       from \\kylep\d!drv6\h, dated 6-7-90).
*       06-15-90  GJF   New values for _XCPT_CONTINUE_[SEARCH|EXECUTION]
*       03-29-91  DEB   Changed to conform with BSEXCPT.H
*
****/

#ifndef _INC_EXCEPT

#ifndef _INTERNAL_IFSTRIP_
#include <cruntime.h>
#endif  /* _INTERNAL_IFSTRIP_ */


/*
 * exception codes defined by the host OS
 *
 * NOTE: THE EXCEPTION CODE VALUES ARE TAKEN FROM VOL1.TXT, WHICH HAS
 * DIFFERENT VALUES THAN DOES DCR1024.TXT. CHANCES ARE, BOTH ARE WRONG!
 *
 * NOTE: THE UNDERSCORE PREFIX IN THE FOLLOWING NAMES WAS ADDED TO CONFORM
 * WITH ANSI NAMESPACE REQUIREMENTS.
 */

#define _XCPT_GUARD_PAGE_VIOLATION              (int)0x80000001
#define _XCPT_UNABLE_TO_GROW_STACK              (int)0x80010001
#define _XCPT_UNWIND                            (int)0xC0000026
#define _XCPT_DATATYPE_MISALIGNMENT             (int)0xC000009E
#define _XCPT_BREAKPOINT                        (int)0xC000009F
#define _XCPT_SINGLE_STEP                       (int)0xC00000A0
#define _XCPT_ACCESS_VIOLATION                  (int)0xC0000005
#define _XCPT_INTEGER_DIVIDE_BY_ZERO            (int)0xC000009B
#define _XCPT_FLOAT_DIVIDE_BY_ZERO              (int)0xC0000095
#define _XCPT_FLOAT_INVALID_OPERATION           (int)0xC0000097
#define _XCPT_ILLEGAL_INSTRUCTION               (int)0xC000001C
#define _XCPT_PRIVILEGED_INSTRUCTION            (int)0xC000009D
#define _XCPT_INTEGER_OVERFLOW                  (int)0xC000009C
#define _XCPT_FLOAT_OVERFLOW                    (int)0xC0000098
#define _XCPT_FLOAT_UNDERFLOW                   (int)0xC000009A
#define _XCPT_FLOAT_DENORMAL_OPERAND            (int)0xC0000094
#define _XCPT_FLOAT_INEXACT_RESULT              (int)0xC0000096
#define _XCPT_FLOAT_STACK_CHECK                 (int)0xC0000099
#define _XCPT_IN_PAGE_ERROR                     (int)0xC0000006
#define _XCPT_PROCESS_TERMINATE                 (int)0xC0010001
#define _XCPT_ASYNC_PROCESS_TERMINATE           (int)0xC0010002
#define _XCPT_NONCONTINUABLE_EXCEPTION          (int)0xC0000024
#define _XCPT_INVALID_DISPOSITION               (int)0xC0000025
#define _XCPT_INVALID_LOCK_SEQUENCE             (int)0xC000001D
#define _XCPT_ARRAY_BOUNDS_EXCEEDED             (int)0xC0000093
#define _XCPT_SIGNAL                            (int)0xC0010003
#define _XCPT_INVALID_UNWIND_TARGET             (int)0xC0000028
#define _XCPT_BAD_STACK                         (int)0xC0000027
#define _XCPT_B1NPX_ERRATA_02                   (int)0xC0010004

/*
 * exception codes defined by the C runtime
 */

#define _XCPT_SIGABRT                           (int)0x08000000
#define _XCPT_SIGUSR1                           (int)0x08000001
#define _XCPT_SIGUSR2                           (int)0x08000002
#define _XCPT_SIGUSR3                           (int)0x08000003
#define _XCPT_FLOATING_EXPLICITGEN              (int)0x08000004


/*
 * constants, structs and types used in exception handling at the OS level
 *
 * NOTE: MANY OF IDENTIFIERS DEFINED BELOW ARE FROM DCR 1024. HOWEVER, THEY
 * HAVE BEEN CHANGED TO CONFORM WITH ANSI NAMESPACE RESTRICTIONS.
 */

#define _EXCEPTION_MAXIMUM_PARAMETERS   4

struct __EXCEPTIONREPORTRECORD {
        unsigned long ExceptionNum;
        unsigned long fHandlerFlags;
        struct __EXCEPTIONREPORTRECORD * NestedExceptionReportRecord;
        void * ExceptionAddress;
        unsigned long cParameters;
        unsigned long ExceptionInfo[_EXCEPTION_MAXIMUM_PARAMETERS];
};

typedef struct __EXCEPTIONREPORTRECORD _EXCEPTIONREPORTRECORD;
typedef struct __EXCEPTIONREPORTRECORD * _PEXCEPTIONREPORTRECORD;

/*
 * values of ExceptionInfo[0] for _XCPT_SIGNAL.
 */

#define _XCPT_SIGNAL_INTR        1      /* corresponds to SIGINT */
#define _XCPT_SIGNAL_KILLPROC    3      /* corresponds to SIGTERM */
#define _XCPT_SIGNAL_BREAK       4      /* corresponds to SIGBREAK */

/*
 * NOTE: THE FOLLOWING DEFINITION FOR _PCONTEXTRECORD IS INCORRECT, BUT I
 * DON'T ACTUALLY USE IT FOR ANYTHING AND REAL DEFINITION WOULD TAKE A GOOD
 * TWO PAGES. SEE PAGES 16 AND 17 OF VOL1.TXT FOR THE CORRECT DEFINITION.
 */

typedef void * _PCONTEXTRECORD;

/*
 * structure used by SEH support function and intrinsics. the information
 * passed by the exception dispatcher is repackaged in this form by the
 * runtime (_except_handler()).
 */

struct __EXCEPTION_INFO_PTRS {
        _PEXCEPTIONREPORTRECORD preport;
        _PCONTEXTRECORD pcontext;
};

typedef struct __EXCEPTION_INFO_PTRS * _PEXCEPTION_INFO_PTRS;

/*
 * the following structure is the element type of the linked list of exception
 * handlers. that is, each element of the linked list is a structure of this
 * type. the first two fields are defined and required by the host OS. the
 * remaining fields are defined and required by the implementation of SEH.
 */

struct __EXCEPTIONREGISTRATIONRECORD {
        struct __EXCEPTIONREGISTRATIONRECORD * prev_structure;
        unsigned long (*ExceptionHandler)();
        int (*ExceptionFilter)();
        unsigned long FilterFrame;
        _PEXCEPTION_INFO_PTRS PExceptionInfoPtrs;
};

typedef struct __EXCEPTIONREGISTRATIONRECORD _EXCEPTIONREGISTRATIONRECORD;
typedef struct __EXCEPTIONREGISTRATIONRECORD * _PEXCEPTIONREGISTRATIONRECORD;

/*
 * the following is the type of the fourth parameter passed to the exception
 * handler by the OS. this parameter is reserved by the OS and not used either
 * by user code or the runtime code. the definition of the type given below is
 * not the real one.
 */

typedef void * _PDISPATCHERCONTEXT;

/*
 * legal return values from an exception handler.
 */

#define _XCPT_CONTINUE_SEARCH           0
#define _XCPT_CONTINUE_EXECUTION        -1

/*
 * prototype for SEH support functions.
 */

int _except_handler(_PEXCEPTIONREPORTRECORD, _PEXCEPTIONREGISTRATIONRECORD,
        _PCONTEXTRECORD, _PDISPATCHERCONTEXT);

/*
 * prototypes for intrinsic SEH functions
 *
 * COMMENTED OUT UNTIL I FIND OUT WHAT THEY ARE (THE ONES BELOW GIVE ERRORS).
 */

int _CALLTYPE1 _exception_code(void);
void * _CALLTYPE1 _exception_info(void);

/*
 * for convenience, define a type name for a pointer to signal-handler
 */

typedef void (_CALLTYPE1 * _PHNDLR)(int);

/*
 * table used by the C runtime to identify and dispose of exceptions
 */

struct _XCPT_ACTION {

        /*
         * exception code or number. defined by the host OS.
         */
        unsigned XcptNum;

        /*
         * signal code or number. defined by the C runtime.
         */
        int SigNum;

        /*
         * exception action code. either a special code or the address of
         * a handler function. always determines how the exception filter
         * should dispose of the exception.
         */
        _PHNDLR XcptAction;

        /*
         * signal action code. similar to the exception action code though
         * the disposition of a C signal is not identical to the disposition
         * of the corresponding exception (e.g., a SigAction of SIG_DFL for
         * SIGABRT corresponds to a XcptAction of SIG_DIE for XCPT_SIGABRT).
         */
        _PHNDLR SigAction;
};

extern struct _XCPT_ACTION _XcptActTab[];

/*
 * prototype for the exception filter used in the C startup
 */

int _XcptFilter(unsigned long, _PEXCEPTION_INFO_PTRS);


#define _INC_EXCEPT

#endif  /* _INC_EXCEPT */
