/*static char *SCCSID = "@(#)ctype.h	6.1 90/11/16";*/
/***
*ctype.h - character conversion macros and ctype macros
*
*	Copyright (c) 1985-1990, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*	Defines macros for character classification/conversion.
*	[ANSI/System V]
*
****/


/*
 * This declaration allows the user access to the ctype look-up
 * array _ctype defined in ctype.obj by simply including ctype.h
 */

#ifndef	CALLTYPE
#define	CALLTYPE	_cdecl
#endif	/* CALLTYPE */

extern unsigned char CALLTYPE _ctype[];


/* set bit masks for the possible character types */

#define _UPPER		0x1	/* upper case letter */
#define _LOWER		0x2	/* lower case letter */
#define _DIGIT		0x4	/* digit[0-9] */
#define _SPACE		0x8	/* tab, carriage return, newline, */
				/* vertical tab or form feed */
#define _PUNCT		0x10	/* punctuation character */
#define _CONTROL	0x20	/* control character */
#define _BLANK		0x40	/* space char */
#define _HEX		0x80	/* hexadecimal digit */


/* character classification function prototypes */

#ifndef _CTYPE_DEFINED
int CALLTYPE  isalpha(int);
int CALLTYPE  isupper(int);
int CALLTYPE  islower(int);
int CALLTYPE  isdigit(int);
int CALLTYPE  isxdigit(int);
int CALLTYPE  isspace(int);
int CALLTYPE  ispunct(int);
int CALLTYPE  isalnum(int);
int CALLTYPE  isprint(int);
int CALLTYPE  isgraph(int);
int CALLTYPE  iscntrl(int);
int CALLTYPE  toupper(int);
int CALLTYPE  tolower(int);
int CALLTYPE  _tolower(int);
int CALLTYPE  _toupper(int);
int CALLTYPE  isascii(int);
int CALLTYPE  toascii(int);
int CALLTYPE  iscsymf(int);
int CALLTYPE  iscsym(int);
#define _CTYPE_DEFINED
#endif

/* the character classification macro definitions */

#define isalpha(_c)	( (_ctype+1)[_c] & (_UPPER|_LOWER) )
#define isupper(_c)	( (_ctype+1)[_c] & _UPPER )
#define islower(_c)	( (_ctype+1)[_c] & _LOWER )
#define isdigit(_c)	( (_ctype+1)[_c] & _DIGIT )
#define isxdigit(_c)	( (_ctype+1)[_c] & _HEX )
#define isspace(_c)	( (_ctype+1)[_c] & _SPACE )
#define ispunct(_c)	( (_ctype+1)[_c] & _PUNCT )
#define isalnum(_c)	( (_ctype+1)[_c] & (_UPPER|_LOWER|_DIGIT) )
#define isprint(_c)	( (_ctype+1)[_c] & (_BLANK|_PUNCT|_UPPER|_LOWER|_DIGIT) )
#define isgraph(_c)	( (_ctype+1)[_c] & (_PUNCT|_UPPER|_LOWER|_DIGIT) )
#define iscntrl(_c)	( (_ctype+1)[_c] & _CONTROL )
#ifndef NO_EXT_KEYS
#define toupper(_c)	( (islower(_c)) ? _toupper(_c) : (_c) )
#define tolower(_c)	( (isupper(_c)) ? _tolower(_c) : (_c) )
#endif
#define _tolower(_c)	( (_c)-'A'+'a' )
#define _toupper(_c)	( (_c)-'a'+'A' )
#define isascii(_c)	( (unsigned)(_c) < 0x80 )
#define toascii(_c)	( (_c) & 0x7f )

/* MS C version 2.0 extended ctype macros */

#define iscsymf(_c)	(isalpha(_c) || ((_c) == '_'))
#define iscsym(_c)	(isalnum(_c) || ((_c) == '_'))
