/*static char *SCCSID = "@(#)cruntime.h	6.1 90/11/16";*/
/***
*cruntime.h - definitions specific to the target operating system and
*	hardware
*
*	Copyright (c) 1990, Microsoft Corporation. All rights reserved.
*
*Purpose:
*	This header file contains widely used definitions specific to the
*	host operating system and hardware. It is included by every C source
*	and most every other header file.
*
*Revision History:
*	02-27-90   GJF	File created
*	03-06-90   GJF	Added register macros (REG1,...,etc.)
*	04-11-90   GJF	Set _CALLTYPE1 and _CALLTYPE4 to _stdcall.
*
****/

#ifndef _INC_CRUNTIME

#ifdef	M_I386

/*
 * Macros defining the calling type of a function
 */

#define _CALLTYPE1	_stdcall	/* user visible functions */
#define _CALLTYPE2	_cdecl		/* user visible functions */
#define _CALLTYPE3	_syscall	/* OS API functions */
#define _CALLTYPE4	_stdcall	/* internal (static) functions */

/*
 * Macros for defining the naming of a public variable
 */

#define _VARTYPE1	_cdecl

/*
 * Macros for register variable declarations
 */

#define REG1	register
#define REG2	register
#define REG3	register
#define REG4
#define REG5
#define REG6
#define REG7
#define REG8
#define REG9

#else

#define _CALLTYPE1
#define _CALLTYPE2
#define _CALLTYPE3
#define _CALLTYPE4

#define _VARTYPE1

#define REG1	register
#define REG2	register
#define REG3
#define REG4
#define REG5
#define REG6
#define REG7
#define REG8
#define REG9

#endif

#define _INC_CRUNTIME

#endif	/* _INC_CRUNTIME */
