/* REXX Preprocessor to fill in MRI strings into resource numbers for *.DSC files */

ARG DSCFile DSCHoldFile DSCMRIFile AppendResourceId

SELECT
    WHEN DSCFile = "" THEN
        CALL USAGE
    WHEN DSCHoldFile = "" THEN
        CALL USAGE
    WHEN DSCMRIFile = "" THEN
        CALL USAGE
    OTHERWISE
        SAY 'Changing ' DSCFile
        SAY " "
END

  call RxFuncAdd 'SysLoadFuncs' , 'REXXUTIL', 'SysLoadFuncs'
  call SysLoadFuncs
  call SysFileDelete DSCHoldFile


  if pos('.', DSCHoldFile) \= 0
     then tmpMask = overlay('???', DSCHoldFile, pos('.', DSCHoldFile) + 1)
     else tmpMask = DSCHoldFile || '.???'

  DSCTmpFile = SysTempFileName(tmpMask)


TitleResourceId=0

DO WHILE LINES(DSCFile) > 0
    DSCLine =  LINEIN(DSCFile)
    DSCOutLine = DSCLine
    PARSE VAR DSCLine DSCChar DSCLine

    IF DSCChar = '^' THEN
        DO
            SAY 'Replacing resource number' DSCLine

            DO WHILE LINES(DSCMRIFile) > 0
                DSCMRILine = LINEIN(DSCMRIFile)
                PARSE VAR DSCMRILine DSCMRIChar DSCMRILine
                SAME = COMPARE(DSCMRIChar, DSCLine)

                IF SAME = 0 THEN
                    DO
                        IF TitleResourceId = 0 THEN TitleResourceId = DSCLine

                        IF AppendResourceId \= "" THEN
                          DO
                            IF AppendResourceId = 1 & TitleResourceId = DSCLine THEN
                              DSCMRILine = INSERT(" [IBM BBS]",DSCMRILine,LENGTH(DSCMRILine)-1)
                          END

                        DUMMY = LINEOUT(DSCTmpFile, DSCMRILine )
                        DUMMY = STREAM(DSCMRIFile,'c','close')
                        LEAVE
                    END
             END

             IF TitleResourceId = 0 THEN Say "  Resource was not found, check the DSC MRI file"
        END

    ELSE
        DO
            DUMMY = LINEOUT(DSCTmpFile, DSCOutLine )
        END

END

DUMMY = LINEOUT(DSCTmpFile)                                   /* CLOSE FILE */
DUMMY = STREAM(DSCFile,'c','close')
'COPY 'DSCTmpFile DSCHoldFile
call SysFileDelete DSCTmpFile
/* DEL DSCHoldFile */
EXIT

/*****************************************************************************/

USAGE: PROCEDURE
    SAY " "
    SAY "Usage: "
    SAY " "
    SAY "FILLRES SOURCE_FILE HOLD_FILE MRI_FILE [APPEND_LINE]"
    SAY " "
    SAY "  WHERE: "
    SAY " "
    SAY "   SOURCE_FILE is the *.dsc file in the source tree"
    SAY "   HOLD_FILE   is the intermediate file that is used by FILLRES.CMD"
    SAY "   MRI_FILE    is the *.dsc file in the mri tree where the resources are found"
    SAY "   APPEND_LINE(optional) is id of string to append to DSC title"
    SAY " "
    SAY "   NOTE: HOLD_FILE must be unique (i.e. it must not exist)"
    SAY " "
    SAY " Syntax of SOURCE_FILE:"
    SAY " ^ <Resource Number>"
    SAY " "
    EXIT








