/********************************************************************
*                                                                   *
* Name: GETMONID.CMD                                                *
*                                                                   *
* OS/2 REXX command file to return index of particular displays     *
* in a monitor "DIF" file                                           *
********************************************************************/

  MRI_USAGE_1 = '   Dabei ist "schlssel" Teil einer OEM-Zeichenfolge von '
  MRI_USAGE_2 = '   und "Diff-Datei" ist ein wahlfreier qualifizierter Pfadname einer Diff-Datei.'
  MRI_USAGE_3 = '   Ist diff-Datei nicht angegeben, sucht getmonid den Pfad von'
  MRI_USAGE_4 = '   gibt eine Liste mit IBM Monitoren und ihren Indexwert zurck.'

/*****************************************
* Intialize Rexxutil Functions
******************************************/

  call RxFuncAdd 'SysSearchPath', 'REXXUTIL' , 'SysSearchPath'
  call RxFuncAdd 'SysFileSearch', 'REXXUTIL' , 'SysFileSearch'

  call RxFuncAdd 'SysLoadFuncs' , 'REXXUTIL', 'SysLoadFuncs'

  signal on syntax name MsgExit

  call SysLoadFuncs

  numeric digits 12

/******************************************
* Define message ids from *mid*.h
*******************************************/
  MSG_SYSINIT_BOOT_NOT_FD    = 1475
  MSG_INCORRECT_DOSVER       = 1210
  MSG_NO_META_MATCH          =  257
  MSG_PRINT_FILE_NOT_FOUND   = 1533
  MSG_COMP_INVALID_PATH      = 1171
  MSG_BOOT_MUST_RESTART      = 1716
  MSG_INSTALL_UNSUCCESSFUL   = 1975
  MSG_INSTALL_HY_HDR         = 1976
  MSG_PROC_NOT_FOUND         =  127
  MSG_REP_SOUR_PATH_REQ      = 1137
  MSG_SYS_INV_DRIVE          = 1461
  MSG_CHCP_INVALID_PARAMETER = 1761
  MSG_UNP_INSERT_PI          = 1218
  MSG_ERR_PROC_ARG           = 1249
  MSG_MBS_INVALID_COMMAND    =  872
  SPTReboot                  = x2d('FE00',4)
  SPTRebootErr               = x2d('FE08',4)
  SPTWithErr                 = x2d('0008',4)

/*****************************************
* Initialized globals
******************************************/

  lang = value('LANG', ,'OS2ENVIRONMENT')
  nlv = SubStr(lang,4)
  parse source one two me
  if arg() == 0
  then cmdline = ''
  else cmdline = arg(1)
  srcPath = filespec('Drive', me) || filespec('Path', me)
  files = srcPath || nlv || '\*.*'
  if stream(files, 'c', 'query exists') = ''
  then nlv = 'en'
  if nlv == 'cn' or nlv == 'jp' or nlv == 'kr' or nlv = 'tw'
  then cs = 'dbcs'
  else cs = 'sbcs'
  cidInst = ''

  DefaultDiff = 'MONITOR.DIF'
  DiffFilePattern = 'OEMSTRING'

/*****************************************
* Set up Source and Target Paths
******************************************/

  srcName = filespec('Name', me)
  os2bootPath = SysSearchPath('PATH', 'os2boot')
  if os2bootpath \= ''
   then bootDrive = filespec('drive', os2bootPath)
   else call MsgExit SysGetMessage(MSG_SYSINIT_BOOT_NOT_FD)

/******************************************
* Verify options if any
*******************************************/

parse upper arg argString

if argString \= ''
  then parse var argString begin '-D' DiffFileName end
  else call usage

if DiffFileName \= '' then key = strip(begin) || ' ' || strip(end)
                      else key = argString

if key = '' then call usage


if DiffFileName = ''
then do
   DiffFile = SysSearchPath('DPATH',DefaultDiff)
   if DiffFile = ''
   then call MsgExit FileNotFound( DefaultDiff )
end
else do
   DiffFile = stream(DiffFileName, 'c', 'query exists')
   if DiffFile = ''
   then call MsgExit FileNotFound( DiffFileName )
end

call SysFileSearch DiffFilePattern, DiffFile, 'monitors'

if result \= 0
then call MsgExit 'Error 'result' searching file 'DiffFile

if monitors.0 = 0
then call MsgExit 'No monitor information found in file 'DiffFile

do i = 1 to monitors.0
  if words(key) > 1
  then do
     count = 0
     do j = 1 to words(key)
       if pos(word(key,j), translate(monitors.i)) \= 0 then count = count + 1
     end
     if count = words(key) then say 'Index: 'monitors.0 - i monitors.i
  end
  else
     if pos(key, translate(monitors.i)) \= 0 then say 'Index: 'monitors.0 - i  monitors.i
end
exit 0

/******************************************************
* Error message processing and exit
*******************************************************/

MsgExit:

   parse arg errmsg

   result = rc
   if rc == 43
    then do
        say sigl'  +++      'SourceLine(sigl)
        say 'REX0043: 'ErrorText(43)
    end
    else do
      if errmsg == '' then errmsg = 'REXX' || right(rc,4,'0') || ': 'ErrorText(rc)
      say errmsg
      if ( (rc \= 0) & ((cidInst \= '') & ( rc \= SPTReboot)) )
        then do
           exitmsg = MyGetMsg(SysGetMessage(MSG_INSTALL_UNSUCCESSFUL))
           say exitmsg
        end

      if symbol('logfile') == 'VAR'
        then do
           if symbol('exitmsg') == 'VAR'
             then do
               call LogIt errmsg
               call LogIt exitmsg
               say MyGetMsg(SysGetMessage(MSG_INSTALL_HY_HDR)) || ' ' || logfile
             end
        end
    end
   if rc == 1210 then '@pause && e  'srcPath || 'readme.txt'
   if symbol('oldPath') == 'VAR' then call value 'PATH' , oldPath, 'OS2ENVIRONMENT'
   exit result

/******************************************************
* Log File Not Found
*******************************************************/

LogFileNotFound:

  call LogIt FileNotFound( arg(1) )
  return

/******************************************************
* File Not Found
*******************************************************/

FileNotFound:

  return MyGetMsg(SysGetMessage(MSG_PRINT_FILE_NOT_FOUND,, '"' || arg(1) || '"'))

/******************************************************
* Safely write to logfile
*******************************************************/

LogIt: Procedure expose logfile

  parse arg message
  call lineout logfile, message
  call stream logfile, 'c', 'close'
  return

/******************************************************
* Remove SYSXXXX: from messages
*******************************************************/

MyGetMsg: Procedure

  parse arg message
  if pos('SYS', word(message, 1)) == 1
    then parse arg . message
  return message

/*****************************************************
* Print usage and exit
******************************************************/

Usage:

   me = 'getmonid'
   msg = MyGetMsg(SysGetMessage(734,,srcName))
   cmd = 'parse value(msg) with msg '''srcName''' .'
   interpret cmd
   say msg
   say me || ' <schlssel> [<schlssel>...] [-d Diff-Datei]'
   say
   say MRI_USAGE_1 || DefaultDiff
   say MRI_USAGE_2
   say MRI_USAGE_3
   say '   ' || DefaultDiff || '.'
   say
   say me || ' IBM'
   say
   say MRI_USAGE_4
   say
   exit 1

