/****************************** Module Header ******************************\
*
* Module Name: PMP.H
*
* OS/2 Presentation Manager top level include file.
*
* Copyright (c) International Business Machines Corporation 1981, 1988-1992
*
* PRIVATE VERSION - IBM CONFIDENTIAL
*
* ===========================================================================
*
* The following symbols are used in this file for conditional sections.
*
*   #define:                To include:
*
*   INCL_PMP    -  ALL of OS/2 PRIVATE Presentation Manager
*   INCL_WINP   -  OS/2 PRIVATE Window Manager
*   INCL_SHLP   -  OS/2 PRIVATE Shell
*   INCL_DEVP   -  OS/2 PRIVATE Device Context
*   INCL_GPIP   -  OS/2 PRIVATE GPI
*   INCL_AVIOP  -  OS/2 PRIVATE Avio
*   INCL_SPLP   -  OS/2 PRIVATE Spooler
*   INCL_HELP   -  OS/2 PRIVATE Help
*   INCL_TKTP   -  OS/2 PRIVATE Toolkit
*
* ===========================================================================
*
* Comments at the end of each typedef line give the name tags used in
* the assembler include version of this file.
*
* The assembler include version of this file excludes lines between NOINC
* and INC comments.
*
\***************************************************************************/

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
   #ifndef __CHKHDR__
      #pragma info( none )
   #endif
   #pragma info( restore )
#endif
/* INC */

#define PMP_INCLUDED


/* if INCL_PMP defined then define all the symbols */
#ifdef INCL_PMP
   #define INCL_WINP
   #define INCL_SHLP
   #define INCL_DEVP
   #define INCL_GPIP
   #define INCL_AVIOP
   #define INCL_SPLP
   #define INCL_HELP
   #define INCL_TKTP
#endif /* INCL_PMP*/

#ifdef INCL_WINP
   #include <pmwinp.h>    /* PRIVATE OS/2 Window Manager definitions */
#endif

#ifdef INCL_SHLP
   #include <pmshlp.h>    /* PRIVATE OS/2 Shell definitions */
#endif

#ifdef INCL_DEVP
   #include <pmdevp.h>    /* PRIVATE OS/2 Device Context definitions */
#endif

#ifdef INCL_GPIP
   #include <pmgpip.h>    /* PRIVATE OS/2 GPI definitions */
#endif

#ifdef INCL_AVIOP
   #include <pmaviop.h>   /* PRIVATE OS/2 AVIO definitions */
#endif

#ifdef INCL_SPLP
   #include <pmsplp.h>    /* PRIVATE OS/2 Spooler definitions */
#endif

#if (defined(INCL_HELP) || defined(INCL_TKTP))
   #include <pmtktp.h>    /* PRIVATE OS/2 Toolkit definitions */
#endif

/* NOINC */
#if __IBMC__ || __IBMCPP__
   #pragma info( none )
   #ifndef __CHKHDR__
      #pragma info( restore )
   #endif
   #pragma info( restore )
#endif
/* INC */

/**************************** end of file **********************************/
