;***	Virtual Timer Device Driver VDD/PDD Communication Interface
;
;
;	IBM/Microsoft Confidential
;
;	Copyright (c) IBM Corporation 1987, 1989
;	Copyright (c) Microsoft Corporation 1987, 1989
;
;	All Rights Reserved
;
;	DESCRIPTION
;	Timer VDD/PDD shared structures/constants
;
;	MODIFICATION HISTORY
;	10/07/90 MTS	Created.
;

;Floppy PDD component definitions

PTD_NAME	EQU	"TIMER$"


;***	PDD function commands
;
;   Format:
;	(*fpfnPTimerProc)(PTDCMD_*, ul1, ul2)
;
;   PTDCMD_REGISTER:
;	ENTRY
;	    ul1 == segment of 16:32 VDD entry point
;	    ul2 ==  offset of 16:32 VDD entry point
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    Init-time
;
;   PTDCMD_DEREGISTER:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    Task-time
;
;   PTDCMD_ENABLETICK:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    VDM Task-time
;
;   PTDCMD_DISABLETICK:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    VDM Task-time
;

PDDCMD_REGISTER	      EQU     0

PTDCMD_REGISTER		EQU	<PDDCMD_REGISTER>		;register VDD
PTDCMD_DEREGISTER	EQU	(PTDCMD_REGISTER+1)	;de-register of VDD
PTDCMD_ENABLETICK	EQU	(PTDCMD_REGISTER+2)	;enable tick int.
PTDCMD_DISABLETICK	EQU	(PTDCMD_REGISTER+3)	;disable tick int.

PTDCMD_LASTEVENT	EQU	<PTDCMD_DISABLETICK>


;***	VDD function commands
;
;   Format:
;	(*fpfnVTimerProc)(VTDCMD_*, ul1, ul2)
;
;   VTDCMD_TICKEVENT:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    Interrupt-time
;
;   VTDCMD_PREEMPTT0:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    Task-time
;
;   VTDCMD_RELEASET0:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    Task-time
;
;   VTDCMD_PREEMPTT2:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    Task-time
;
;   VTDCMD_RELEASET2:
;	ENTRY
;	    ul1 == 0			;not used
;	    ul2 == 0			;not used
;	EXIT
;	    returns TRUE
;	CONTEXT
;	    Task-time
;

VTDCMD_TICKEVENT	EQU	000h
VTDCMD_PREEMPTT0	EQU	001h
VTDCMD_RELEASET0	EQU	002h
VTDCMD_PREEMPTT2	EQU	003h
VTDCMD_RELEASET2	EQU	004h

VTDCMD_LASTEVENT	EQU	<VTDCMD_RELEASET2>
