;***	VMD.INC
;
;
;	MVDM Virtual Mouse Exported Definitions
;	Copyright (c) 1988,1989 Microsoft Corporation
;
;	For include file hierarchy, see MVDM.INC
;
;
;	MODIFICATION HISTORY
;	11/15/88    JTP	    Created.
;	07/19/90    T.Sobue Japanese version created.			;@IBMJ
;	05/05/93    RAR	    Version 9.00 updates
;


ifndef INCL_NONE		       ;include everything by default
INCL_VMOUSE	EQU 1
endif

ifdef  INCL_VMOUSE
INCL_VMOUSEINT	EQU 1
INCL_VMOUSESYSREQ	EQU 1
INCL_VMOUSEDEVREQ	EQU 1
endif


ifdef  INCL_VMOUSEINT

;***	VMD _INT 33h constants
;

INT_MOUSE	EQU	033h	   ;mouse software interrupt

INT33_RESET	EQU	0	;mouse reset and status
INT33_SHOWPOINTER	EQU	1	;show pointer
INT33_HIDEPOINTER	EQU	2	;hide pointer
INT33_QUERYSTATUS	EQU	3	;query button status and mouse pos.
INT33_SETPOSITION	EQU	4	;set mouse position
INT33_GETPRESSINFO	EQU	5	;get button press information
INT33_GETRELEASEINFO	EQU	6	;get button release information
INT33_SETHORIZONTAL	EQU	7	;set horizontal min/max boundaries
INT33_SETVERTICAL	EQU	8	;set vertical min/max boundaries
INT33_DEFINEGRPOINTER	EQU	9	;define graphics pointer
INT33_DEFINETEXTPOINTER		EQU	10	;define text/hardware pointer
INT33_GETMOTIONCOUNTS	EQU	11	;get mouse motion counters
INT33_SETUSERSUB	EQU	12	;set user call mask/address
INT33_ENABLELIGHTPEN	EQU	13	;enable lightpen emulation
INT33_DISABLELIGHTPEN	EQU	14	;disable lightpen emulation
INT33_SETMICKEYRATIO	EQU	15	;set mickeys-to-8-pixels ratio
INT33_SETCONDITIONAL	EQU	16	;set conditional-off area
INT33_FUNCTION17	EQU	17	;UNDEFINED (points to function 19)
INT33_DEFINEVARPOINTER	EQU	18	;define variable-size graphics pointer
INT33_SETDBLSPEED	EQU	19	;set dbl-speed threshold
INT33_SWAPUSERSUB	EQU	20	;swap user call mask/address
INT33_QUERYSTATESIZE	EQU	21	;query save-state storage req.
INT33_SAVESTATE		EQU	22	;save driver state
INT33_RESTORESTATE	EQU	23	;restore driver state
INT33_SETALTUSERSUB	EQU	24	;set alternate call mask/address
INT33_QUERYALTUSERSUB	EQU	25	;query alternate call mask/address
INT33_SETSENSITIVITY	EQU	26	;set mickeys/pixel, dbl-speed thres.
INT33_QUERYSENSITIVITY	EQU	27	;query mickeys/pixel, dbl-speed thres.
INT33_SETINTERRUPTRATE	EQU	28	;set interrupt rate (inport only)
INT33_SETPOINTERCOLOR	EQU	28	;set pointer color	      ;@IBMJ
INT33_SETCRTPAGE	EQU	29	;set CRT page #
INT33_QUERYCRTPAGE	EQU	30	;query CRT page #
INT33_DISABLEDRIVER	EQU	31	;disable driver
INT33_ENABLEDRIVER	EQU	32	;enable driver
INT33_SOFTWARERESET	EQU	33	;more complete mouse reset
INT33_SETLANGUAGE	EQU	34	;set language #
INT33_QUERYLANGUAGE	EQU	35	;query language #
INT33_QUERYMOUSEVERSION		EQU	36	;query mouse version, type, and IRQ

INT33_GETSWITCHSETTINGS		EQU	51	;get switch settings
INT33_GETMOUSEINI	EQU	52	;get MOUSE.INI
INT33_MAXFUNC	EQU	<INT33_GETMOUSEINI>

INT33_ERROR	EQU	-1	;error return in AX of _INT 33 function

MAX_PTRWIDTH	EQU	2	;maximum # bytes across
MAX_PTRHEIGHT	EQU	16	;maximum # bytes in height

BUTTON_LEFT	EQU	0	;button ordinals
BUTTON_RIGHT	EQU	1
BUTTON_CENTER	EQU	2

BUTBIT_LEFT	EQU	00001h	;button bit positions
BUTBIT_RIGHT	EQU	00002h
BUTBIT_CENTER	EQU	00004h

CALLMASK_MOTION		EQU	00001h	;motion
CALLMASK_LEFTDOWN	EQU	00002h	;LEFT button down
CALLMASK_LEFTUP		EQU	00004h	;LEFT button up
CALLMASK_RIGHTDOWN	EQU	00008h	;RIGHT button down
CALLMASK_RIGHTUP	EQU	00010h	;RIGHT button up
CALLMASK_SHIFTBUTTON	EQU	00020h	;SHIFT key held while button up/down
CALLMASK_CTRLBUTTON	EQU	00040h	;CTRL key held while button up/down
CALLMASK_ALTBUTTON	EQU	00080h	;ALT key held while button up/down
CALLMASK_CENTERDOWN	EQU	00100h	;CENTER button down
CALLMASK_CENTERUP	EQU	00200h	;CENTER button up
CALLMASK_ALLOWED	EQU	003FFh
CALLMASK_BUTTONSHIFTS	EQU	(CALLMASK_SHIFTBUTTON  OR  \
				 CALLMASK_CTRLBUTTON   OR  \
				 CALLMASK_ALTBUTTON)

CALL12MASK_CENTERDOWN	EQU	00020h	;CENTER button down (SETUSERSUB only)
CALL12MASK_CENTERUP	EQU	00040h	;CENTER button up (SETUSERSUB only)
CALL12MASK_ALLOWED	EQU	0007Fh


DEF_XMICKEYS	EQU	8		;(x_pixel)
DEF_YMICKEYS	EQU	16		;(y_pixel)
DEF_XMICKEYS_J	EQU	4		;(x_pixel) J-DOS	      ;@IBMJ
DEF_YMICKEYS_J	EQU	4		;(y_pixel) J-DOS	      ;@IBMJ

DEF_XMICSSCALE	EQU	50		;range 0-100
DEF_YMICSSCALE	EQU	50		;range 0-100
DEF_THRESHOLDSCALE	EQU	50	;range 0-100

DEF_TEXTANDMASK		EQU	0ffffh		;(DfltTextAndMask)
DEF_TEXTXORMASK		EQU	07700h		;(DfltTextXorMask)

DEF_THRESHOLD	EQU	64	 ;BUGBUG JeffPar - What is correct???
					;PDD wants 4, doc says 64, MS src says 128
DEF_THRESHOLD_J		EQU	07fffh		;disable threshold	      ;@IBMJ
					;function in J-DOS.	      ;@IBMJ
DEF_COLOR	EQU	15		;pointer color		      ;@IBMJ
endif


ifdef  INCL_VMOUSESYSREQ

;***	VMSE constants
;

VMD_NAME	EQU	"VMOUSE$"	       ;name of VMD

;***	VMSE functions for use by PMVDMP
;

VMSESYSREQ_SETACCESS	EQU	1	;obtain exclusive access for VDM
VMSESYSREQ_SETFOCUS	EQU	2	;notify VDM is gaining/losing focus
VMSESYSREQ_POSTMOUSE	EQU	3	;send mouse events to a VDM
VMSESYSREQ_MAX	EQU	3

endif


ifdef  INCL_VMOUSEDEVREQ

;***	VMD constants
;

VMDEVREQ_REGISTER	EQU	1	;VMD-defined functions for
VMDEVREQ_SETSIZE	EQU	2	;communication from VVD to VMD
VMDEVREQ_SEAMLESS	EQU	3	;Seamless notification
VMDEVREQ_PROTINT33	EQU	4	;VDPX to VMD for Pmode Int 33h calls
VMDEVREQ_DPMITASK	EQU	5	;DPMI program start/stop notification



;***	VMD VDHRequestVDD communication structures
;
;   VMREG is the input packet passed with the VMDEVREQ_REGISTER request
;   from a VVD, and contains all the functions required by VMD of every
;   supported VVD, which are:
;
;	Show pointer
;	Hide pointer
;	Define text pointer
;	Define graphics pointer
;	Enable/disable light pen emulation
;
;   VMFUNC is the output packet filled in on the same (VMDEVREQ_REGISTER)
;   request.  It points to the following functions:
;
;	VDM Light pen request (to call only when light pen emulation enabled)
;
;   VMSSIZE is the input packet passed with the VMDEVREQ_SETSIZE request
;   from a VVD, and defines the current video mode (or -1 if unknown),
;   physical screen dimensions, and cell size.  There is no output packet
;   for this request.
;

DefType PFNSHOWPTR,dd
DefType PFNHIDEPTR,dd
DefType PFNDEFTEXT,dd
DefType PFNDEFGRAPH,dd
DefType PFNSETPAGE,dd
DefType PFNSETLPEN,dd
DefType PFNSETCOLOR,dd			;@IBMJ

DefStruc ,vmreg_s			;vmreg
    ULONG	vmreg_nb	       ;size of structure, in bytes (24)
    PFNSHOWPTR	vmreg_pfnShowPtr       ;ptr to show pointer fn.
    PFNHIDEPTR	vmreg_pfnHidePtr       ;ptr to hide pointer fn.
    PFNDEFTEXT	vmreg_pfnDefTextPtr    ;ptr to define text pointer fn.
    PFNDEFGRAPH vmreg_pfnDefGraphPtr   ;ptr to define graphics pointer fn.
    PFNSETPAGE	vmreg_pfnSetVideoPage  ;ptr to set video page fn.
    PFNSETLPEN	vmreg_pfnSetLPenEm     ;ptr to enable/disable lpen fn.
    PFNSETCOLOR vmreg_pfnSetPtrColor   ;ptr to set pointer color fn. ;@IBMJ
EndStruc VMREG

DefType PVMREG,dd


DefStruc ,vmstat_s
    BOOL    vmstat_fPtrHidden	       ;visual pointer status
    ULONG   vmstat_x		       ;current virtual position
    ULONG   vmstat_y
    ULONG   vmstat_flButtons	       ;current button status (see BUTBITs)
EndStruc VMSTAT

DefType PVMSTAT,dd

DefType PFNQUERYSTAT,dd

DefStruc ,vmfunc_s			;vmfunc
    ULONG	 vmfunc_nb	       ;size of structure, in bytes (8)
    PFNQUERYSTAT vmfunc_pfnQueryStatus ;ptr to query virtual status proc.
EndStruc VMFUNC

DefType PVMFUNC,dd

DefStruc ,vmss_s			;vmss
    ULONG   vmss_nb		       ;size of structure, in bytes (36)
    LONG    vmss_lMode		       ;video mode (eg, 00h-13h, or -1)
    ULONG   vmss_ulWidth	       ;width of screen, in pixels
    ULONG   vmss_ulHeight	       ;height of screen, in pixels
    ULONG   vmss_ulCellWidth	       ;width of screen cells, in pixels
    ULONG   vmss_ulCellHeight	       ;height of screen cells, in pixels
    ULONG   vmss_ulPtrWidth	       ;width of pointer drawing size, in pixels
    ULONG   vmss_ulPtrHeight	       ;height of pointer drawing size, in pixels
    ULONG   vmss_ulPtrUnitWidth	       ;width of pointer drawing unit, in pixels
EndStruc VMSSIZE

DefType PVMSSIZE,dd


endif  ;INCL_VMOUSEDEVREQ
