;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHCTL.INC
;*
;* DESCRIPTIVE NAME = flags definitions for base video
;*
;* COPYRIGHT    COPYRIGHT IBM CORPORATION, 1991, 1992
;*              Copyright Microsoft Corporation, 1990
;*              LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
;*              REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
;*              RESTRICTED MATERIALS OF IBM
;*              IBM CONFIDENTIAL
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  flags definitions for base video 
;*
;* FUNCTIONS    NONE
;*              
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   12/19/88 @V2.0TPL06  P3250 Allow set border color for CGA compatible modes
;*   04/14/89 @V2.0STJ04  B701111 Remove negative logic and synch with .H file
;*
;*****************************************************************************/

;/*
;**        Define flags not set on command line
;*/

IFNDEF VDHINIT
        VDHINIT         equ     0
ENDIF
IF VDHINIT
        VDHVGA          equ     1
ENDIF
IFNDEF VDHVGA
        VDHVGA          equ     0
ENDIF
IFNDEF VDHEGA
        VDHEGA          equ     0
ENDIF
IFNDEF VDHCGA
        VDHCGA          equ     0
ENDIF
IFNDEF VDHMPA
        VDHMPA          equ     0
ENDIF
IFNDEF VDH8514A
        VDH8514A        equ     0
ENDIF
IFNDEF CGA_ALWAYS_FAST
        CGA_ALWAYS_FAST equ     0
ENDIF
IFNDEF DEBUG
        DEBUG           equ     0
ENDIF

;/*
;**        Check switch combinations (on first pass only)
;*/
 
IF1
IF     ( (VDHVGA + VDHEGA + VDHCGA + VDHMPA + VDH8514A) NE 1)
%out Error in assembly command line parameters
%err No valid video device specified
ENDIF
ENDIF

;/*
;**        Set feature switches
;*/

BLINK_SUPPORT           equ     ( VDHVGA OR VDHEGA OR VDHCGA )
FONT_SUPPORT            equ     ( VDHVGA OR VDHEGA )
OVERSCAN_SUPPORT        equ     ( VDHVGA OR VDHEGA OR VDHCGA )
PALETTE_SUPPORT         equ     ( VDHVGA OR VDHEGA )
ROMFONT_SUPPORT         equ     ( VDHVGA OR VDHEGA OR VDHCGA )
UNDERSCORE_SUPPORT      equ     ( VDHVGA OR VDHEGA )

